/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.util.Vector;
import jet.JResource;
import jet.connect.DbValue;
import jet.exception.FormulaSyntaxErrorException;
import jet.formula.AggDesc;
import jet.formula.Aggregation;
import jet.formula.CompondAggregation;
import jet.formula.DataTypeDef;
import jet.formula.FormulaContainer;
import jet.formula.FormulaInfo;
import jet.formula.FormulatoJava;
import jet.formula.JavaFormula;
import jet.formula.JetRptFormula;
import jet.formula.SymbolInfo;
import jet.formula.formula;

public class JetRptSummary
extends JetRptFormula {
    AggDesc aggdesc = null;
    private String GroupbyNames;
    private String I;
    private String SEDU;
    private String Z = null;

    public JetRptSummary() {
    }

    public JetRptSummary(String string, String string2, FormulaContainer formulaContainer, FormulaInfo formulaInfo) {
        this(string, string2, formulaContainer);
        this.formulainfo = formulaInfo;
    }

    public JetRptSummary(String string, String string2, FormulaContainer formulaContainer) {
        this.name.set(string);
        this.expr.set(string2);
        this.datasource = formulaContainer;
    }

    @Override
    public void exec(JavaFormula javaFormula) {
        DbValue dbValue;
        try {
            dbValue = javaFormula.rec.getCell(this.coldesc);
        }
        catch (Exception exception) {
            dbValue = javaFormula.rec.getCell(this.name.get());
            this.coldesc.setColIndex(dbValue.getColDesc().getColIndex());
        }
        if (this.formulainfo.aggdesc == null) {
            dbValue.bNull = true;
        } else if (this.GroupbyNames.equalsIgnoreCase("NONE")) {
            dbValue.set(javaFormula.rec.getCell(this.formulainfo.aggdesc.fieldname));
        } else {
            dbValue.set(javaFormula.agg.getAggValue(this.formulainfo.aggdesc, javaFormula.rec));
        }
        if (this.isDenied) {
            dbValue.setNull();
        }
    }

    public void setExpression(String string, String string2, String string3) {
        this.GroupbyNames = string.toUpperCase();
        this.I = string2.toUpperCase();
        this.SEDU = string3 == null ? null : string3.toUpperCase();
    }

    public void setExpression(String string, String string2, String string3, String string4) {
        this.setExpression(string, string2, string3);
        this.Z = string4;
    }

    @Override
    public Vector getFullGroup() {
        if (this.Z != null) {
            Vector<String> vector = new Vector<String>(this.formulainfo.GroupbyNames.size());
            for (int i = 0; i < this.formulainfo.GroupbyNames.size(); ++i) {
                vector.addElement(this.formulainfo.GroupbyNames.elementAt(i) + AggDesc.delim + this.Z);
            }
            return vector;
        }
        return (Vector)this.formulainfo.GroupbyNames.clone();
    }

    @Override
    public void parseFormula(FormulatoJava formulatoJava) throws FormulaSyntaxErrorException {
        if (this.parsed) {
            return;
        }
        if (this.parsing) {
            throw new FormulaSyntaxErrorException(this.getName(), JResource.getMessage("FML_38", (Object)this.getName()));
        }
        try {
            SymbolInfo symbolInfo;
            SymbolInfo symbolInfo2;
            block13: {
                this.formulainfo = new FormulaInfo();
                symbolInfo2 = this.GroupbyNames(this.I, formulatoJava);
                symbolInfo = null;
                try {
                    symbolInfo = this.GroupbyNames(this.SEDU, formulatoJava);
                }
                catch (Exception exception) {
                    if (this.SEDU == null || this.SEDU.length() <= 0) break block13;
                    this.parsed = false;
                    this.parsing = false;
                    this.aggdesc = null;
                    throw new FormulaSyntaxErrorException(this.getName(), exception.getMessage());
                }
            }
            this.formulainfo.formulatype = this.I(symbolInfo2, symbolInfo);
            String string = this.SEDU == null || this.SEDU.equals("") ? "REPORT" : (symbolInfo == null ? this.SEDU.toUpperCase() : symbolInfo.getSymName().toUpperCase());
            if (!this.formulainfo.GroupbyNames.contains(string)) {
                this.formulainfo.GroupbyNames.addElement(string);
            }
            boolean bl = false;
            try {
                Integer.parseInt(this.SEDU);
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
            if (DataTypeDef.isArray(symbolInfo2.type)) {
                throw new FormulaSyntaxErrorException(this.getName(), JResource.getMessage("FML_43", new Object[]{this.GroupbyNames, symbolInfo2.getSymName()}));
            }
            Aggregation[] aggregationArray = this.Z != null ? Aggregation.mapCode(this.GroupbyNames, symbolInfo2.getSymName().toUpperCase(), string, symbolInfo2.getAttr() == 6, this.Z, bl) : Aggregation.mapCode(this.GroupbyNames, symbolInfo2.getSymName().toUpperCase(), string, symbolInfo2.getAttr() == 6, bl);
            AggDesc aggDesc = aggregationArray[0].getAggDesc();
            int n = -1;
            for (int i = aggregationArray.length - 1; i >= 0; --i) {
                n = this.formulainfo.refAggregation.indexOf(aggregationArray[i]);
                if (n == -1) {
                    this.formulainfo.refAggregation.addElement(aggregationArray[i]);
                    if (!(aggregationArray[i] instanceof CompondAggregation)) continue;
                    Aggregation[] aggregationArray2 = ((CompondAggregation)aggregationArray[i]).getUsedAggs();
                    for (int j = 1; j < aggregationArray2.length; ++j) {
                        aggregationArray2[j].getAggDesc().aggidx = this.formulainfo.refAggregation.indexOf(aggregationArray2[j]);
                    }
                    continue;
                }
                aggregationArray[i] = (Aggregation)this.formulainfo.refAggregation.elementAt(n);
            }
            this.formulainfo.isGroupby = true;
            this.formulainfo.aggdesc = this.Z != null ? new AggDesc(aggDesc.fieldname, aggDesc.groupname, aggDesc.aggCode, this.Z) : new AggDesc(aggDesc.fieldname, aggDesc.groupname, aggDesc.aggCode);
            this.parsed = true;
            this.parsing = false;
            this.formulainfo.parseOK = this.parsed;
        }
        catch (Exception exception) {
            this.parsed = false;
            this.parsing = false;
            this.aggdesc = null;
            throw new FormulaSyntaxErrorException(this.getName(), exception.getMessage());
        }
    }

    private SymbolInfo GroupbyNames(String string, FormulatoJava formulatoJava) throws Exception {
        SymbolInfo symbolInfo = null;
        if (string != null && string.equalsIgnoreCase(this.getName())) {
            throw new Exception(JResource.getMessage("FML_44", new Object[]{string}));
        }
        try {
            FormulaInfo formulaInfo = this.getFormula(string).getFormulaInfo(formulatoJava);
            symbolInfo = formulaInfo.formulatype;
            this.formulainfo.refFormula.addElement(string);
            this.formulainfo.isGlobal = this.formulainfo.isGlobal ? true : formulaInfo.isGlobal;
            this.formulainfo.isGroupby = this.formulainfo.isGroupby ? true : formulaInfo.isGroupby;
            int n = formulaInfo.GroupbyNames.size();
            for (int i = 0; i < n; ++i) {
                this.formulainfo.GroupbyNames.addElement((String)formulaInfo.GroupbyNames.elementAt(i));
            }
        }
        catch (Exception exception) {
            try {
                symbolInfo = this.getDbFieldInfo(string);
                this.formulainfo.refDBfield.addElement(string);
            }
            catch (Exception exception2) {
                try {
                    symbolInfo = this.getParameterInfo(string);
                    this.formulainfo.refParameter.addElement(string);
                }
                catch (Exception exception3) {
                    try {
                        Integer.parseInt(string);
                        symbolInfo = new SymbolInfo(string, null, 5, -1, 1, -1, true);
                    }
                    catch (Exception exception4) {
                        throw new Exception(JResource.getMessage("FML_31", new Object[]{string}));
                    }
                }
            }
        }
        return symbolInfo;
    }

    private SymbolInfo I(SymbolInfo symbolInfo, SymbolInfo symbolInfo2) {
        Object object;
        int n;
        block4: {
            int[] nArray = new int[symbolInfo2 == null ? 1 : 2];
            nArray[0] = symbolInfo.getDataType();
            if (symbolInfo2 != null) {
                nArray[1] = 5;
            }
            n = 0;
            try {
                object = new formula();
                n = (Integer)formula.checkFuncnames(this.GroupbyNames, nArray, ((formula)object).summaryFuncs)[0];
                n = DataTypeDef.isVariance(n) ? nArray[0] : n;
            }
            catch (Exception exception) {
                if (!this.GroupbyNames.equalsIgnoreCase("NONE")) break block4;
                n = symbolInfo.getDataType();
            }
        }
        object = new SymbolInfo(this.getName().toUpperCase(), null, n, -1, 6, -1, true);
        if (this.isRunningTotal()) {
            this.formulainfo.setRefRunningTotal(true);
            ((SymbolInfo)object).setIsRunningTotal(true);
        }
        return object;
    }

    @Override
    public boolean isRunningTotal() {
        if (null != this.aggdesc) {
            return Aggregation.isRunningTotal(this.aggdesc.aggCode);
        }
        if (null != this.GroupbyNames) {
            String string = "running";
            return this.GroupbyNames.toLowerCase().startsWith(string);
        }
        return false;
    }

    @Override
    public JetRptSummary clone() {
        JetRptSummary jetRptSummary = new JetRptSummary(this.name.get(), this.expr.get(), this.datasource);
        this.copyTo(jetRptSummary);
        if (this.aggdesc != null) {
            jetRptSummary.aggdesc = (AggDesc)this.aggdesc.clone();
        }
        jetRptSummary.I = this.I;
        jetRptSummary.SEDU = this.SEDU;
        jetRptSummary.Z = this.Z;
        jetRptSummary.GroupbyNames = this.GroupbyNames;
        return jetRptSummary;
    }

    @Override
    public void resetAggDesc() {
        super.resetAggDesc();
        if (this.aggdesc != null) {
            this.aggdesc.reset();
        }
    }
}

