/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.math.BigDecimal;
import jet.connect.DbBigInt;
import jet.connect.DbChar;
import jet.connect.DbDouble;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.formula.AggDesc;
import jet.formula.Aggregation;
import jet.formula.DataTypeDef;
import jet.formula.fCurrency;

class Maximum
extends Aggregation {
    public Maximum() {
    }

    public Maximum(AggDesc aggDesc) {
        super(aggDesc);
    }

    @Override
    public DbValue getValue() {
        if (null == this.agg) {
            return null;
        }
        int n = DataTypeDef.SqlToFml(this.agg.getSqlType(), this.agg.isCurrency());
        DbValue dbValue = DataTypeDef.makeData(n);
        dbValue.bNull = this.agg.bNull;
        if (!dbValue.bNull) {
            switch (n) {
                case 1: {
                    ((DbBigInt)dbValue).value = ((DbNumber)this.agg).longValue();
                    break;
                }
                case 2: {
                    ((DbDouble)dbValue).value = ((DbNumber)this.agg).doubleValue();
                    break;
                }
                case 3: {
                    ((fCurrency)dbValue).value = new BigDecimal(this.agg.toString());
                    break;
                }
                case 5: {
                    ((DbChar)dbValue).value = this.agg.toString();
                    break;
                }
                default: {
                    dbValue.set(this.agg);
                }
            }
        }
        return dbValue;
    }

    @Override
    public void exec(Record record) {
        DbValue dbValue;
        if (this.isDenied) {
            if (this.agg == null) {
                DbValue dbValue2 = record.getCell(this.desc.fieldname);
                this.agg = (DbValue)dbValue2.clone();
            }
            return;
        }
        try {
            dbValue = record.getCell(this.agg.getColDesc());
        }
        catch (NullPointerException nullPointerException) {
            dbValue = record.getCell(this.desc.fieldname);
            if (this.agg == null) {
                this.agg = (DbValue)dbValue.clone();
            }
            this.agg.getColDesc().setColIndex(dbValue.getColDesc().getColIndex());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        if (!dbValue.bNull && this.agg.compareTo(dbValue) < 0) {
            this.agg.set(dbValue);
        }
        if (!dbValue.bNull && this.agg.bNull) {
            this.agg.set(dbValue);
            this.agg.bNull = false;
        }
    }

    @Override
    public void exec(DbValue dbValue) {
        if (null == this.agg) {
            this.agg = this.createDbValue(dbValue);
        }
        if (this.isDenied) {
            return;
        }
        if (!dbValue.bNull && this.agg.compareTo(dbValue) < 0) {
            this.agg.set(dbValue);
        }
        if (!dbValue.bNull && this.agg.bNull) {
            this.agg.set(dbValue);
            this.agg.bNull = false;
        }
    }

    @Override
    public void reset() {
        if (this.agg != null) {
            this.agg = null;
        }
    }

    @Override
    protected DbValue createDbValue() {
        return this.agg;
    }
}

