/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import com.jinfonet.util.JRLog;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import jet.JResource;
import jet.connect.DbBigInt;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDateTime;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbNumber;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.exception.InvalidParameterException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.DataType;
import jet.formula.DataTypeDef;
import jet.formula.JetOperation;
import jet.formula.SymbolInfo;
import jet.formula.fArray;
import jet.formula.fBoolArray;
import jet.formula.fStrArray;
import jet.formula.formulaExecutor.ExecFormulaFailedException;
import jet.formula.formulaExecutor.ExternalInfoProvider;
import jet.formula.formulaExecutor.FormulaContainerImpl;
import jet.parameter.UserInput;
import jet.parameter.definition.BindColumn;
import jet.parameter.definition.Definition;
import jet.parameter.definition.valuelist.UnevaluatedValueListItem;
import jet.parameter.runtime.ExternalInfoProviderImpl;
import jet.parameter.runtime.ParameterRuntime;
import jet.parameter.runtime.valuelist.IValueListFetcherContext;
import jet.parameter.runtime.valuelist.item.EvalueatedValueListItem;
import jet.parameter.runtime.valuelist.item.ValueListItem;
import jet.parameter.util.ValueListItemUtil;
import jet.universe.JetUParameter;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.util.JFieldValueNLSManager;
import jet.util.StringFormatCheck;
import jet.util.StringToolKit;
import jet.util.nls.NLSApplyParam;
import jet.util.nls.meta.MetaNLSKit;
import toolkit.db.version2.CallTrace;

public class ParamDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_INTEGER = "Integer";
    public static final String TYPE_NUMBER = "Number";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_CURRENCY = "Currency";
    public static final String TYPE_BOOLEAN = "Boolean";
    public static final String TYPE_DATE = "Date";
    public static final String TYPE_TIME = "Time";
    public static final String TYPE_DATETIME = "DateTime";
    public static final String TYPE_PARAMETER = "Parameters";
    public static final String TYPE_PARAMETER_SEPARATOR1 = "@";
    public static final String TYPE_PARAMETER_SEPARATOR2 = ",";
    public String type;
    public static final Locale defaultLocale = Locale.getDefault();
    public static final int dateStyle = 1;
    public static final int timeStyle = 2;
    public static final String DATETIMEFMT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATEFMT = "yyyy-MM-dd z";
    public static final int NORMAL = 0;
    public static final int GROUPSORT = 1;
    public static final int AUTO = 2;
    public static final int IMPORT = 3;
    public static final int PSEUDO = 4;
    public static final int SORTORDER = 5;
    public String name;
    public String promptText;
    private String value;
    public boolean isStringNull;
    public String stringFormat;
    private String inValue;
    private SymbolInfo parameter = new SymbolInfo();
    private DbColDesc desc = null;
    private DbValue paramvalue = null;
    private int isColumn = 0;
    String column;
    Vector columns;
    private boolean isDis;
    private boolean isReq;
    private Vector vDbLimit = new Vector(2);
    private int operation = -1;
    private Vector vDbValue = new Vector(6);
    private Vector vShowValue = new Vector(6);
    private Vector removeIndex = new Vector(6);
    private int index = 0;
    private boolean useCurrentDate = false;
    private boolean useCurrentDateWhenBlank = false;
    private String dynamicTemplate = "";
    private boolean hideParameterWhenSingleValueReturn = false;
    private String userFormat = "";
    private String binding = null;
    private static String D = System.getProperty("file.encoding");
    private String encoding = D;
    private Vector vStrValue = new Vector();
    private String importSql = null;
    String srcName;
    private Vector importParams = new Vector();
    private String securityEntry;
    public final Definition def;
    public final ParameterRuntime rt;
    private TimeZone defaultZone = TimeZone.getDefault();
    private boolean needLoadValueList = true;
    private Vector lowerLevels = null;
    private Vector upperLevels = null;
    private boolean isMultipleValue = false;
    private Vector selectedValues;
    protected boolean isCascading = false;
    protected String previousLevel;
    protected String nextLevel;
    protected String chainID = "";
    protected boolean isSetAsParameter;
    protected boolean isAllSelected = true;
    private boolean isAllowAll = false;
    protected boolean allowTypeIn = true;
    public static final int ADOPT_DIRECTLY = 1;
    public static final int USE_DEFAULT = 2;
    public static final int WARN = 3;
    protected int whenOutOfRange;
    private boolean allowUseExpression;
    private boolean isGetValueFromAPI;
    private NLSApplyParam nls;
    private boolean isDynamicParam = false;
    private String bvName;
    private String queryName;
    private String dataMapping;

    public String getInternalValue() {
        return this.inValue;
    }

    public void setSecurityEntry(String string) {
        this.securityEntry = string;
    }

    public String getSecurityEntry() {
        return this.securityEntry;
    }

    public Definition getDefinition() {
        return this.def;
    }

    public ParameterRuntime getParameterRuntime() {
        return this.rt;
    }

    public ParamDesc() {
        this.def = new Definition(this);
        this.rt = new ParameterRuntime(this);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2) {
        this(string, string2, string3, vector, vector2, string4, n, n2, null);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, String string5) {
        this(string, string2, string3, vector, vector2, string4, n, n2, 0, null, null, new Vector(6), string5);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, int n3) {
        this(string, string2, string3, vector, vector2, string4, n, n2, n3, null, null, new Vector(6), null);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, int n3, String string5, Vector vector3, Vector vector4, String string6) {
        this(string, string2, string3, vector, vector2, string4, n, n2, n3, string5, vector3, vector4, string6, false, false);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, int n3, String string5, Vector vector3, Vector vector4, String string6, boolean bl, boolean bl2) {
        this(string, string2, string3, vector, vector2, string4, n, n2, n3, string5, vector3, vector4, string6, bl, bl2, false);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, boolean bl) {
        this(string, string2, string3, vector, vector2, string4, n, n2, null, bl);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, String string5, boolean bl) {
        this(string, string2, string3, vector, vector2, string4, n, n2, 0, null, null, new Vector(6), string5, bl);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, int n3, boolean bl) {
        this(string, string2, string3, vector, vector2, string4, n, n2, n3, null, null, new Vector(6), null, bl);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, int n3, String string5, Vector vector3, Vector vector4, String string6, boolean bl) {
        this(string, string2, string3, vector, vector2, string4, n, n2, n3, string5, vector3, vector4, string6, false, false, bl);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, int n3, String string5, Vector vector3, Vector vector4, String string6, boolean bl, boolean bl2, boolean bl3) {
        this.def = new Definition(this);
        this.rt = new ParameterRuntime(this);
        this.type = string2;
        this.name = string;
        this.promptText = string3;
        this.operation = n;
        this.binding = string6;
        this.isColumn = n3;
        this.isMultipleValue = bl3;
        this.checkString(string2);
        this.vStrValue = vector2;
        this.desc.setColName(string);
        this.isDis = bl;
        this.isReq = bl2;
        String string7 = "";
        if (string4 == null || string4.length() <= 0) {
            this.userFormat = "";
        } else {
            this.userFormat = string4;
            if (this.type.equalsIgnoreCase(TYPE_STRING)) {
                this.desc.setEncodingName(this.userFormat);
            }
        }
        if (vector != null && vector.size() > 0) {
            try {
                this.setLimit(vector, null);
            }
            catch (InvalidParameterException invalidParameterException) {
                string7 = string7 + invalidParameterException.getMessage();
            }
        }
        if (vector2 != null && vector2.size() > 0) {
            try {
                this.setValues(vector2, null);
            }
            catch (InvalidParameterException invalidParameterException) {
                string7 = string7 + invalidParameterException.getMessage();
            }
        }
        this.setDefaultIndex(n2);
        this.inValue = this.getDefaultValue();
        this.value = this.vDbValue.size() > 0 && !this.isMultipleValue ? this.getDisplayValue(this.getValue(), defaultLocale) : "";
        this.column = string5;
        this.columns = vector3 == null ? new Vector() : vector3;
        this.vShowValue = vector4;
        if (string7.length() > 0 && JRLog.isError(2)) {
            JRLog.error(2, "init Parameter\n" + string + ": " + string7);
        }
    }

    public Vector getDefaultValues() {
        Vector<String> vector = new Vector<String>();
        if (null != this.vStrValue) {
            String string = null;
            for (Object e : this.vStrValue) {
                string = e instanceof UserInput ? ((UserInput)e).getUserInput() : e.toString();
                vector.add(string);
            }
        }
        return vector;
    }

    public SymbolInfo getInfo() {
        return this.parameter;
    }

    private DbValue D(boolean bl) {
        if (this.isMultipleValue && this.isAllSelected()) {
            fArray fArray2 = fArray.getInstance(this.parameter.type, this.desc);
            fArray2.setIsAll(true);
            fArray2.bNull = false;
            return fArray2;
        }
        if (this.paramvalue == null) {
            try {
                if (bl) {
                    this.column();
                }
                this.initParam(defaultLocale);
            }
            catch (InvalidParameterException invalidParameterException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, invalidParameterException);
                }
                return null;
            }
        }
        return this.paramvalue;
    }

    public DbValue getValue() {
        return this.D(true);
    }

    public String getStrValue() {
        if (this.isMultipleValue) {
            if (JRLog.isError(2)) {
                JRLog.error(2, new Exception("Do not call this method on a multiple value parameter!"));
            }
            return null;
        }
        if (this.paramvalue == null) {
            try {
                this.column();
                this.initParam(defaultLocale);
            }
            catch (InvalidParameterException invalidParameterException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, invalidParameterException);
                }
                return "";
            }
        }
        return this.clear(this.paramvalue);
    }

    private DbValue Operation(DbValue dbValue, UserInput userInput) {
        EvalueatedValueListItem evalueatedValueListItem = ValueListItemUtil.toValueListItem(dbValue);
        evalueatedValueListItem.setUserInput(userInput.getUserInput(), userInput.isExpression(), userInput.getExpressionName(), userInput.getSelectedDate(), ValueListItemUtil.getLocale(userInput));
        return (DbValue)((Object)evalueatedValueListItem);
    }

    private DbValue SEDU(DbValue dbValue) {
        if (dbValue.getSqlType() == this.desc.getSqlType()) {
            return dbValue;
        }
        DbValue dbValue2 = DbValue.makeDbValue(this.desc);
        switch (this.parameter.type) {
            case 5: {
                dbValue2 = (DbChar)dbValue;
                return dbValue2;
            }
            case 4: {
                dbValue2 = (DbBit)dbValue;
                return dbValue2;
            }
            case 1: 
            case 2: 
            case 3: {
                ((DbNumber)dbValue2).setValue((DbNumber)dbValue);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                ((DbDateTime)dbValue2).set((DbDateTime)dbValue);
            }
        }
        if (dbValue instanceof UserInput) {
            dbValue2 = this.Operation(dbValue2, (UserInput)((Object)dbValue));
        }
        return dbValue2;
    }

    private DbValue SqlToFml(fArray fArray2) {
        fArray fArray3 = null;
        int n = fArray2.value == null ? 0 : fArray2.value.length;
        DbValue[] dbValueArray = null;
        switch (this.parameter.type) {
            case 16: {
                fArray3 = (fStrArray)fArray2;
                return fArray3;
            }
            case 15: {
                fArray3 = (fBoolArray)fArray2;
                return fArray3;
            }
            case 12: 
            case 13: 
            case 14: {
                if (n == 0) {
                    DbNumber dbNumber = (DbNumber)DbValue.makeDbValue(fArray2.getColDesc());
                }
                dbValueArray = new DbNumber[n];
                for (int i = 0; i < n; ++i) {
                    dbValueArray[i] = DbValue.makeDbValue(this.desc);
                    ((DbNumber)dbValueArray[i]).setValue((DbNumber)fArray2.value[i]);
                    if (!(fArray2.value[i] instanceof UserInput)) continue;
                    dbValueArray[i] = this.Operation(dbValueArray[i], (UserInput)((Object)fArray2.value[i]));
                }
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                DbDateTime dbDateTime;
                if (n == 0) {
                    dbDateTime = (DbDateTime)DbValue.makeDbValue(fArray2.getColDesc());
                }
                dbValueArray = new DbDateTime[n];
                dbDateTime = null;
                for (int i = 0; i < n; ++i) {
                    dbValueArray[i] = (DbDateTime)DbValue.makeDbValue(this.desc);
                    dbValueArray[i].set((DbDateTime)fArray2.value[i]);
                    if (!(fArray2.value[i] instanceof UserInput)) continue;
                    dbValueArray[i] = this.Operation(dbValueArray[i], (UserInput)((Object)fArray2.value[i]));
                }
                break;
            }
        }
        fArray3 = fArray.getInstance(this.parameter.type, this.desc);
        fArray3.set(dbValueArray);
        fArray3.setIsAll(fArray2.isAll());
        fArray3.bNull = fArray2.bNull;
        return fArray3;
    }

    private DbValue convert(DbValue dbValue) {
        if (this.isMultipleValue) {
            return this.SqlToFml((fArray)dbValue);
        }
        return this.SEDU(dbValue);
    }

    private DbValue add(DbValue dbValue) throws InvalidParameterException {
        DbValue dbValue2 = null;
        try {
            dbValue2 = this.convert(dbValue);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidParameterException("PARAM_UNABLETO_INPUT_TYPE", new Object[]{dbValue.getClass().getName(), this.type});
        }
        return dbValue2;
    }

    public void set(DbValue dbValue) throws InvalidParameterException {
        DbValue dbValue2 = dbValue;
        if (this.isMultipleValue) {
            fArray fArray2 = null;
            if (dbValue instanceof fArray) {
                fArray2 = (fArray)dbValue;
                if (fArray2.isAll()) {
                    this.setAllSelected(true);
                    return;
                }
                this.setAllSelected(false);
            } else {
                fArray2 = fArray.getInstance(this.parameter.type, this.desc);
                fArray2.set(new DbValue[]{dbValue});
            }
            this.setAllSelected(false);
            dbValue2 = fArray2;
        } else {
            this.setAllSelected(false);
        }
        dbValue = this.add(dbValue2);
        if (this.paramvalue == null) {
            this.D(false);
        }
        if (this.paramvalue == null || !dbValue.equals(this.paramvalue)) {
            this.columns();
        }
        if (this.paramvalue != null) {
            this.paramvalue.setValue(dbValue);
        } else {
            this.paramvalue = (DbValue)dbValue.clone();
        }
        if (!this.isMultipleValue) {
            this.inValue = this.clear(this.paramvalue);
            this.value = this.getDisplayValue(dbValue, defaultLocale);
        }
    }

    public String getValueMeaning() {
        return this.getDisplayValue(this.paramvalue, defaultLocale);
    }

    public DbColDesc getColDesc() {
        if (null != this.desc) {
            return this.desc;
        }
        try {
            DbValue dbValue = this.bvName("", defaultLocale, false);
            return dbValue.getColDesc();
        }
        catch (InvalidParameterException invalidParameterException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, invalidParameterException);
            }
            return null;
        }
    }

    public void initParam(Locale locale) throws InvalidParameterException {
        if (this.name.equals("")) {
            throw new InvalidParameterException("FML_ERRNAME", new Object[0]);
        }
        if (this.type.equals("")) {
            throw new InvalidParameterException("FML_ERRTYPE", new Object[0]);
        }
        if (this.vDbValue.size() > 0) {
            DbValue dbValue = null;
            dbValue = this.index == -1 ? (DbValue)this.vDbValue.lastElement() : (DbValue)this.vDbValue.elementAt(this.index);
            if (this.isMultipleValue) {
                String string = this.getDisplayValue(dbValue, locale);
                this.setValue(new String[]{string}, locale);
            } else {
                this.paramvalue = (DbValue)dbValue.clone();
                this.inValue = this.clear(this.paramvalue);
                this.value = this.getDisplayValue(this.paramvalue, locale);
            }
        } else if (this.isMultipleValue) {
            this.setValue(new String[0], locale);
        } else {
            this.paramvalue = this.bvName("", locale, false);
            this.paramvalue = (DbValue)((Object)ValueListItemUtil.toValueListItem(this.paramvalue));
            ((EvalueatedValueListItem)((Object)this.paramvalue)).setUserInput("", false, null, null, locale);
            this.value = "";
            this.inValue = "";
        }
        this.columns();
    }

    public void setBeColumn(int n) {
        this.isColumn = n;
    }

    public int getBeColumn() {
        return this.isColumn;
    }

    public boolean isColumn() {
        return this.isColumn != 0;
    }

    public boolean isColumnCal() {
        return this.isColumn > 0;
    }

    public void setLimit(Vector vector, Locale locale) throws InvalidParameterException {
        int n;
        boolean bl = locale == null;
        int n2 = vector.size();
        Locale locale2 = bl ? defaultLocale : locale;
        Vector vector2 = (Vector)this.vDbLimit.clone();
        this.vDbLimit.removeAllElements();
        String string = "";
        for (n = 0; n < n2; ++n) {
            String string2 = (String)vector.elementAt(n);
            if (string2 != null && string2.length() > 0) {
                try {
                    DbValue dbValue = this.bvName(string2, locale2, !bl);
                    this.vDbLimit.addElement(dbValue);
                }
                catch (InvalidParameterException invalidParameterException) {
                    string = "\n\"" + string2 + "\": " + invalidParameterException.getMessage();
                }
                continue;
            }
            this.vDbLimit.addElement(null);
        }
        if (string.length() > 0) {
            this.vDbLimit = vector2;
            throw new InvalidParameterException("FML_INVALIDLIMIT", new Object[]{string});
        }
        n = JetOperation.judgeLimit(1, this.vDbLimit);
        if (n == -1) {
            this.vDbLimit = new Vector(6);
        } else if (n == 1) {
            this.vDbLimit = vector2;
            throw new InvalidParameterException("FML_INVALIDLIMIT", new Object[]{JResource.getMessage("FML_LIMITMATCH", new Object[0], locale)});
        }
        this.vDbValue.removeAllElements();
    }

    public void setLimit(String string, Locale locale, int n) throws InvalidParameterException {
        String string2 = "";
        Vector vector = (Vector)this.vDbLimit.clone();
        if (string.length() > 0) {
            try {
                this.vDbLimit.setElementAt(null, n);
                DbValue dbValue = this.parseValue(string, locale, true);
                this.vDbLimit.setElementAt(dbValue, n);
            }
            catch (InvalidParameterException invalidParameterException) {
                this.vDbLimit = vector;
                throw invalidParameterException;
            }
        } else {
            this.vDbLimit.setElementAt(null, n);
        }
        int n2 = JetOperation.judgeLimit(1, this.vDbLimit);
        if (n2 == -1) {
            this.vDbLimit = new Vector(6);
        } else if (n2 == 1) {
            this.vDbLimit = vector;
            throw new InvalidParameterException("FML_INVALIDLIMIT", new Object[]{JResource.getMessage("FML_LIMITMATCH", new Object[0], locale)});
        }
        this.vDbValue.removeAllElements();
    }

    private Number addAll(String string, Locale locale, boolean bl) throws InvalidParameterException {
        Number number = null;
        ParsePosition parsePosition = new ParsePosition(0);
        if (bl && !this.userFormat.equals("")) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
            DecimalFormat decimalFormat = new DecimalFormat(this.userFormat, decimalFormatSymbols);
            decimalFormat.setParseBigDecimal(true);
            number = (Number)decimalFormat.parseObject(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                throw new InvalidParameterException("FML_USERFORMAT", new Object[]{string, decimalFormat.toLocalizedPattern()});
            }
        } else {
            DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(locale);
            DecimalFormat decimalFormat2 = (DecimalFormat)DecimalFormat.getCurrencyInstance(locale);
            decimalFormat.setParseBigDecimal(true);
            decimalFormat2.setParseBigDecimal(true);
            parsePosition = new ParsePosition(0);
            number = decimalFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                parsePosition = new ParsePosition(0);
                number = decimalFormat2.parse(string, parsePosition);
                if (parsePosition.getIndex() != string.length()) {
                    number = null;
                }
            }
            if (number == null) {
                throw new InvalidParameterException("FML_VALIDFORMAT", new Object[]{string, decimalFormat.toLocalizedPattern(), decimalFormat2.toLocalizedPattern()});
            }
        }
        return number;
    }

    private Number addElement(String string, Locale locale, boolean bl) throws InvalidParameterException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = null;
        if (bl && !this.userFormat.equals("")) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
            DecimalFormat decimalFormat = new DecimalFormat(this.userFormat, decimalFormatSymbols);
            number = (Number)decimalFormat.parseObject(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                throw new InvalidParameterException("FML_USERFORMAT", new Object[]{string, decimalFormat.toLocalizedPattern()});
            }
        } else {
            DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(locale);
            parsePosition = new ParsePosition(0);
            decimalFormat.setParseIntegerOnly(true);
            number = decimalFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
                String string2 = decimalFormatSymbols.getDigit() + "" + decimalFormatSymbols.getGroupingSeparator() + "" + decimalFormatSymbols.getDigit() + "" + decimalFormatSymbols.getDigit() + "" + decimalFormatSymbols.getDigit() + "";
                char[] cArray = new char[5];
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = decimalFormatSymbols.getDigit();
                }
                throw new InvalidParameterException("FML_VALIDFORMAT", new String[]{string, string2, String.valueOf(cArray)});
            }
        }
        return number;
    }

    private Number addReferParamToVsortParams(String string, Locale locale, boolean bl) throws InvalidParameterException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = null;
        if (string.equals(String.valueOf(Double.NaN))) {
            number = Double.NaN;
        } else if (string.equals(String.valueOf(Double.POSITIVE_INFINITY))) {
            number = Double.POSITIVE_INFINITY;
        } else if (string.equals(String.valueOf(Double.NEGATIVE_INFINITY))) {
            number = Double.NEGATIVE_INFINITY;
        } else if (bl && !this.userFormat.equals("")) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
            DecimalFormat decimalFormat = new DecimalFormat(this.userFormat, decimalFormatSymbols);
            number = (Number)decimalFormat.parseObject(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                throw new InvalidParameterException("FML_USERFORMAT", new Object[]{string, decimalFormat.toLocalizedPattern()});
            }
        } else {
            parsePosition = new ParsePosition(0);
            DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(locale);
            number = decimalFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                throw new InvalidParameterException("FML_VALIDFML", new Object[]{string, decimalFormat.toLocalizedPattern()});
            }
        }
        return number;
    }

    private String[] allowTypeIn(String string) {
        String string2;
        String string3;
        int n = string.indexOf("/");
        if (n != -1) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = string;
            string2 = "false";
        }
        return new String[]{string3, string2};
    }

    private Boolean allowUseExpression(String string, String[] stringArray, String[] stringArray2) {
        String string2;
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            string2 = stringArray[n];
            if (!string.equalsIgnoreCase(string2)) continue;
            return new Boolean(true);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            string2 = stringArray2[n];
            if (!string.equalsIgnoreCase(string2)) continue;
            return new Boolean(false);
        }
        return null;
    }

    public String[][] getBooleanLiteral() {
        String string;
        String string2;
        String[] stringArray;
        if (!this.userFormat.equals("")) {
            stringArray = this.allowTypeIn(this.userFormat);
            string2 = stringArray[0];
            string = stringArray[1];
        } else {
            string2 = "true";
            string = "false";
        }
        stringArray = new String[2][2];
        stringArray[0][0] = string2;
        stringArray[0][1] = "1";
        stringArray[1][0] = string;
        stringArray[1][1] = "0";
        return stringArray;
    }

    private boolean append(String string, Locale locale, boolean bl) throws InvalidParameterException {
        String string2;
        String string3;
        String[] stringArray;
        boolean bl2 = true;
        if (bl && !this.userFormat.equals("")) {
            stringArray = this.allowTypeIn(this.userFormat);
            string3 = stringArray[0];
            string2 = stringArray[1];
        } else {
            string3 = "true";
            string2 = "false";
        }
        stringArray = new String[]{string3, "1"};
        String[] stringArray2 = new String[]{string2, "0"};
        Boolean bl3 = this.allowUseExpression(string, stringArray, stringArray2);
        if (bl3 == null) {
            if (this.userFormat.equals("")) {
                throw new InvalidParameterException("FML_VALIDFORMAT", new String[]{string, "true", "false"});
            }
            throw new InvalidParameterException("FML_USERFORMAT", new Object[]{string, "TRUE = \"" + string3 + "\" , FALSE = \"" + string2 + "\""});
        }
        bl2 = bl3;
        return bl2;
    }

    private String applyLocalizedPattern(String string) throws InvalidParameterException {
        if (this.stringFormat != null && this.stringFormat.length() != 0 || !this.isColumn()) {
            if (this.isStringNull && string.equals("")) {
                return string;
            }
            boolean bl = StringFormatCheck.checkString(this.stringFormat, string);
            if (bl) {
                return string;
            }
            String string2 = JResource.getMessage("FML_USERFORMAT", new Object[]{string, this.stringFormat});
            InvalidParameterException invalidParameterException = new InvalidParameterException("FML_USERFORMAT", new Object[]{string, this.stringFormat});
            if (JRLog.isError(2)) {
                JRLog.error(2, invalidParameterException);
            }
            throw invalidParameterException;
        }
        return string;
    }

    private java.util.Date bNull(String string, int n, Locale locale, TimeZone timeZone, boolean bl) throws InvalidParameterException {
        java.util.Date date = null;
        if (bl && !this.userFormat.equals("")) {
            Object object;
            ParsePosition parsePosition = new ParsePosition(0);
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.userFormat, dateFormatSymbols);
            simpleDateFormat.setTimeZone(timeZone);
            date = (java.util.Date)simpleDateFormat.parseObject(string, parsePosition);
            if (date != null && parsePosition.getIndex() != string.length()) {
                date = null;
            }
            if (date == null && n == 6) {
                parsePosition = new ParsePosition(0);
                object = new SimpleDateFormat(DATEFMT, dateFormatSymbols);
                ((DateFormat)object).setTimeZone(timeZone);
                date = (java.util.Date)((DateFormat)object).parseObject(string, parsePosition);
            }
            if (date == null) {
                object = JResource.getMessage("FML_USERFORMAT", new Object[]{string, simpleDateFormat.toLocalizedPattern()}, locale);
                String string2 = (String)object + "\n Locale = " + locale + "; TimeZone = " + timeZone;
                if (JRLog.isError(2)) {
                    JRLog.error(2, string2);
                }
                throw new InvalidParameterException("FML_USERFORMAT", new Object[]{string, simpleDateFormat.toLocalizedPattern()});
            }
        } else {
            SimpleDateFormat[] simpleDateFormatArray = null;
            switch (n) {
                case 6: {
                    simpleDateFormatArray = new SimpleDateFormat[]{(SimpleDateFormat)SimpleDateFormat.getDateInstance(3, locale), (SimpleDateFormat)SimpleDateFormat.getDateInstance(2, locale), (SimpleDateFormat)SimpleDateFormat.getDateInstance(1, locale), (SimpleDateFormat)SimpleDateFormat.getDateInstance(0, locale), new SimpleDateFormat(DATEFMT, defaultLocale)};
                    for (SimpleDateFormat object : simpleDateFormatArray) {
                        object.setTimeZone(timeZone);
                    }
                    break;
                }
                case 7: {
                    simpleDateFormatArray = new SimpleDateFormat[]{(SimpleDateFormat)SimpleDateFormat.getTimeInstance(3, locale), (SimpleDateFormat)SimpleDateFormat.getTimeInstance(2, locale), (SimpleDateFormat)SimpleDateFormat.getTimeInstance(1, locale), (SimpleDateFormat)SimpleDateFormat.getTimeInstance(0, locale)};
                    for (SimpleDateFormat simpleDateFormat : simpleDateFormatArray) {
                        simpleDateFormat.setTimeZone(timeZone);
                    }
                    break;
                }
                case 8: {
                    simpleDateFormatArray = new SimpleDateFormat[]{(SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 3, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 2, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 1, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 0, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 3, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 2, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 1, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 0, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 3, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 2, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 1, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 0, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 3, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 2, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 1, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 0, locale), new SimpleDateFormat(DATETIMEFMT, defaultLocale)};
                    if (!bl) {
                        simpleDateFormatArray[16].setTimeZone(TimeZone.getTimeZone("GMT"));
                    }
                    for (int i = 0; i < simpleDateFormatArray.length - 1; ++i) {
                        simpleDateFormatArray[i].setTimeZone(timeZone);
                    }
                    break;
                }
            }
            for (int i = 0; date == null && i < simpleDateFormatArray.length; ++i) {
                block25: {
                    String string3 = simpleDateFormatArray[i].toLocalizedPattern();
                    if (!this.encoding.equals(D)) {
                        try {
                            string3 = new String(string3.getBytes(this.encoding));
                            simpleDateFormatArray[i].applyLocalizedPattern(string3);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            if (!JRLog.isTrace(6)) break block25;
                            JRLog.trace(6, unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
                        }
                    }
                }
                simpleDateFormatArray[i].setLenient(false);
                DateFormatSymbols dateFormatSymbols = simpleDateFormatArray[i].getDateFormatSymbols();
                dateFormatSymbols.setZoneStrings(new String[0][0]);
                if (!locale.getCountry().equals("JP") && !locale.getVariant().equals("JP")) {
                    simpleDateFormatArray[i].setDateFormatSymbols(dateFormatSymbols);
                }
                ParsePosition parsePosition = new ParsePosition(0);
                date = simpleDateFormatArray[i].parse(string.trim(), parsePosition);
                if (date != null && parsePosition.getIndex() != string.length()) {
                    date = null;
                }
                if (date == null || parsePosition.getIndex() != string.length() || !JRLog.isTrace(6)) continue;
                JRLog.trace(6, "Parse Date Time Parameter with Format[" + i + "]\nValue: " + string + "\nDataType: " + n + "\ntimeZone = " + simpleDateFormatArray[i].getTimeZone() + "\nLocale: " + locale + "\nReturn: " + date);
            }
            if (date == null) {
                String string4 = JResource.getMessage("FML_VALIDFML1", (Object[])new String[]{string}, locale);
                string4 = "Parameter: " + this.name + "; locale: " + locale + "; TimeZone = " + timeZone + "\n" + string4;
                for (int i = 0; i < simpleDateFormatArray.length; ++i) {
                    string4 = string4 + "\n    " + simpleDateFormatArray[i].toLocalizedPattern();
                }
                this.binding(simpleDateFormatArray);
                if (JRLog.isError(2)) {
                    JRLog.error(2, string4);
                }
                throw new InvalidParameterException("FML_VALIDFML1", new String[]{string});
            }
            this.binding(simpleDateFormatArray);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Parse Date Time Parameter with Format\nValue: " + string + "\nDataType: " + n + "\nLocale: " + locale + "\n TimeZone = " + timeZone + "\nReturn (on default timezon): " + date + "\ndefault timezon: " + TimeZone.getDefault() + "; long value = " + date.getTime());
        }
        return date;
    }

    private void binding(SimpleDateFormat[] simpleDateFormatArray) {
        for (int i = 0; i < simpleDateFormatArray.length; ++i) {
            simpleDateFormatArray[i] = null;
        }
    }

    public void clearMem() {
        this.vDbLimit.removeAllElements();
        this.vDbValue.removeAllElements();
        this.vShowValue.removeAllElements();
    }

    private DbValue booleanValue(String string, Locale locale, TimeZone timeZone, boolean bl) throws InvalidParameterException {
        int n = this.parameter.type;
        if (DataTypeDef.isArray(n)) {
            n -= 11;
        }
        if (n != 5) {
            string = string.trim();
        }
        DbValue dbValue = null;
        switch (n) {
            case 3: {
                dbValue = new DbDecimal(this.desc);
                if (string.equals("")) {
                    dbValue.bNull = true;
                    break;
                }
                dbValue.value = (BigDecimal)this.addAll(string, locale, bl);
                dbValue.bNull = false;
                break;
            }
            case 1: {
                dbValue = new DbBigInt(this.desc);
                if (string.equals("")) {
                    dbValue.bNull = true;
                    break;
                }
                ((DbBigInt)dbValue).value = this.addElement(string, locale, bl).longValue();
                dbValue.bNull = false;
                break;
            }
            case 2: {
                dbValue = new DbDouble(this.desc);
                if (string.equals("")) {
                    dbValue.bNull = true;
                    break;
                }
                ((DbDouble)dbValue).value = this.addReferParamToVsortParams(string, locale, bl).doubleValue();
                dbValue.bNull = false;
                break;
            }
            case 5: {
                dbValue = new DbChar(this.desc);
                ((DbChar)dbValue).value = string;
                if (this.isStringNull && string.equals("")) {
                    dbValue.bNull = true;
                    break;
                }
                dbValue.bNull = false;
                break;
            }
            case 4: {
                dbValue = new DbBit(this.desc);
                if (string.equals("")) {
                    dbValue.bNull = true;
                    break;
                }
                ((DbBit)dbValue).value = this.append(string, locale, bl);
                dbValue.bNull = false;
                break;
            }
            case 6: {
                dbValue = new DbDate(this.desc);
                if (string.equals("")) {
                    dbValue.bNull = true;
                    break;
                }
                java.util.Date date = null;
                if (!bl) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFMT);
                        DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
                        dateFormatSymbols.setZoneStrings(new String[0][0]);
                        simpleDateFormat.setDateFormatSymbols(dateFormatSymbols);
                        simpleDateFormat.setTimeZone(timeZone);
                        date = simpleDateFormat.parse(string);
                    }
                    catch (Exception exception) {
                        date = null;
                    }
                    if (date == null) {
                        try {
                            date = Date.valueOf(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            date = null;
                        }
                    }
                }
                if (date == null) {
                    date = this.bNull(string, n, locale, timeZone, bl);
                }
                ((DbDate)dbValue).value = date.getTime();
                dbValue.bNull = false;
                break;
            }
            case 7: {
                if (dbValue == null) {
                    dbValue = new DbTime(this.desc);
                }
                if (string.equals("")) {
                    dbValue.bNull = true;
                    break;
                }
                Time time2 = null;
                if (!bl) {
                    try {
                        time2 = Time.valueOf(string);
                    }
                    catch (Exception exception) {
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, "Parse Time Parameter\n" + string + "\n" + exception.getMessage());
                        }
                        time2 = null;
                    }
                }
                if (time2 == null) {
                    time2 = new Time(this.bNull(string, n, locale, timeZone, bl).getTime());
                }
                ((DbTime)dbValue).value = time2.getTime();
                dbValue.bNull = false;
                break;
            }
            case 8: {
                if (dbValue == null) {
                    dbValue = new DbTimestamp(this.desc);
                }
                if (string.equals("")) {
                    dbValue.bNull = true;
                    break;
                }
                Timestamp timestamp = null;
                if (!bl) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATETIMEFMT);
                        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                        timestamp = new Timestamp(simpleDateFormat.parse(string).getTime());
                    }
                    catch (Exception exception) {
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, "Parse Time Parameter\n" + string + "\n" + exception.getMessage());
                        }
                        timestamp = null;
                    }
                }
                if (timestamp == null) {
                    timestamp = new Timestamp(this.bNull(string, n, locale, timeZone, bl).getTime());
                }
                ((DbTimestamp)dbValue).set(timestamp);
                break;
            }
            default: {
                throw new InvalidParameterException("PARAM_INVALID_TYPE", new Object[]{this.type});
            }
        }
        return dbValue;
    }

    private DbValue bvName(String string, Locale locale, boolean bl) throws InvalidParameterException {
        return this.booleanValue(string, locale, this.defaultZone, bl);
    }

    public DbValue parseValue(String string, Locale locale, TimeZone timeZone, boolean bl) throws InvalidParameterException {
        DbValue dbValue = this.booleanValue(this.applyLocalizedPattern(string), locale, timeZone, bl);
        if (!dbValue.isNull()) {
            this.chainID(dbValue, locale);
        }
        return dbValue;
    }

    public DbValue parseValue(String string, Locale locale, boolean bl) throws InvalidParameterException {
        return this.parseValue(string, locale, TimeZone.getDefault(), bl);
    }

    private void chainID(DbValue dbValue, Locale locale) throws InvalidParameterException {
        int n;
        if (!dbValue.bNull && (n = JetOperation.Operation(this.operation, this.vDbLimit, dbValue)) != 0) {
            String string = JResource.getMessage(n == -1 ? "FML_CMPMIN" : "FML_CMPMAX", (Object)this.getDisplayValue((DbValue)this.vDbLimit.elementAt(n == -1 ? 0 : 1), locale));
            throw new InvalidParameterException("FML_CMPBEYOND", new Object[]{string});
        }
    }

    private void checkString(String string) {
        int n = 0;
        if (string.equalsIgnoreCase(TYPE_INTEGER)) {
            n = 1;
        } else if (string.equalsIgnoreCase(TYPE_NUMBER)) {
            n = 2;
        } else if (string.equalsIgnoreCase(TYPE_STRING)) {
            n = 5;
        } else if (string.equalsIgnoreCase(TYPE_CURRENCY)) {
            n = 3;
        } else if (string.equalsIgnoreCase(TYPE_BOOLEAN)) {
            n = 4;
        } else if (string.equalsIgnoreCase(TYPE_DATE)) {
            n = 6;
        } else if (string.equalsIgnoreCase(TYPE_TIME)) {
            n = 7;
        } else if (string.equalsIgnoreCase(TYPE_DATETIME)) {
            n = 8;
        } else if (string.equalsIgnoreCase(TYPE_PARAMETER)) {
            n = 5;
        } else if (JRLog.isError(2)) {
            JRLog.error(2, "Invalid parameter type " + string + "!");
        }
        this.type = string;
        this.desc = DataType.toDbColDesc(n, -1, -1);
        if (this.isMultipleValue) {
            n += 11;
        }
        this.parameter.setInfo(this.name, null, n, -1, 7, -1, true);
    }

    public String getDefaultValue() {
        this.column();
        String string = "";
        if (this.vDbValue.size() > 0) {
            DbValue dbValue = null;
            dbValue = this.index == -1 ? (DbValue)this.vDbValue.lastElement() : (DbValue)this.vDbValue.elementAt(this.index);
            if (dbValue != null) {
                string = this.clear(dbValue);
            }
        }
        return string;
    }

    private String clear(DbValue dbValue) {
        String string = "";
        if (dbValue != null && !dbValue.isNull()) {
            int n = DataTypeDef.SqlToFml(dbValue.getSqlType(), dbValue.isCurrency());
            switch (n) {
                case 3: {
                    string = new String(NumberFormat.getCurrencyInstance(defaultLocale).format(((DbDecimal)dbValue).value));
                    break;
                }
                case 1: {
                    string = new String(NumberFormat.getNumberInstance(defaultLocale).format(((DbNumber)dbValue).longValue()));
                    break;
                }
                case 2: {
                    string = new String(NumberFormat.getNumberInstance(defaultLocale).format(((DbNumber)dbValue).doubleValue()));
                    break;
                }
                case 5: {
                    string = ((DbChar)dbValue).value;
                    break;
                }
                case 4: {
                    string = new String(((DbBit)dbValue).value ? "TRUE" : "FALSE");
                    break;
                }
                case 6: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFMT);
                    DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
                    dateFormatSymbols.setZoneStrings(new String[0][0]);
                    simpleDateFormat.setDateFormatSymbols(dateFormatSymbols);
                    string = simpleDateFormat.format(((DbDate)dbValue).getDate());
                    break;
                }
                case 7: {
                    string = new Time(((DbTime)dbValue).value).toString();
                    break;
                }
                case 8: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATETIMEFMT);
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    string = simpleDateFormat.format(((DbTimestamp)dbValue).toUtilDate());
                    break;
                }
                default: {
                    if (!JRLog.isError(2)) break;
                    JRLog.error(2, dbValue + " Unknow parameter type!");
                }
            }
        }
        return string;
    }

    public String getDisplayValue(DbValue dbValue, Locale locale) {
        return this.getDisplayValue(dbValue, locale, TimeZone.getDefault());
    }

    public String getDisplayValue(DbValue dbValue, Locale locale, TimeZone timeZone) {
        int n;
        if (dbValue instanceof fArray) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "Do not call getDisplayValue(...) on a multipple value parameter: " + this.name + ". Please call getMultiDisplayValue(....).", (Throwable)new CallTrace());
            }
            return null;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "getDisplayValue/ locale=" + locale + "; timeZone = " + timeZone);
        }
        if (DataTypeDef.isArray(n = this.parameter.type)) {
            n -= 11;
        }
        String string = "";
        if (dbValue != null && !dbValue.isNull()) {
            switch (n) {
                case 3: {
                    BigDecimal bigDecimal = ((DbDecimal)dbValue).value;
                    if (!this.userFormat.equals("")) {
                        string = new DecimalFormat(this.userFormat).format(bigDecimal);
                        break;
                    }
                    NumberFormat numberFormat = NumberFormat.getCurrencyInstance(locale);
                    string = numberFormat.format(bigDecimal);
                    break;
                }
                case 1: {
                    string = !this.userFormat.equals("") ? new DecimalFormat(this.userFormat).format(new Long(((DbNumber)dbValue).longValue())) : NumberFormat.getNumberInstance(locale).format(((DbNumber)dbValue).longValue());
                    break;
                }
                case 2: {
                    if (!this.userFormat.equals("")) {
                        Double d = new Double(((DbNumber)dbValue).doubleValue());
                        string = new DecimalFormat(this.userFormat).format(d);
                        break;
                    }
                    string = NumberFormat.getNumberInstance(locale).format(((DbNumber)dbValue).doubleValue());
                    break;
                }
                case 6: {
                    SimpleDateFormat simpleDateFormat = !this.userFormat.equals("") ? new SimpleDateFormat(this.userFormat, locale) : (SimpleDateFormat)DateFormat.getDateInstance(1, locale);
                    DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
                    dateFormatSymbols.setZoneStrings(new String[0][0]);
                    if (!locale.getCountry().equals("JP") && !locale.getVariant().equals("JP")) {
                        simpleDateFormat.setDateFormatSymbols(dateFormatSymbols);
                    }
                    simpleDateFormat.setTimeZone(timeZone);
                    string = simpleDateFormat.format(new java.util.Date(((DbDate)dbValue).value));
                    break;
                }
                case 7: {
                    if (!this.userFormat.equals("")) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.userFormat, locale);
                        simpleDateFormat.setTimeZone(timeZone);
                        string = simpleDateFormat.format(new java.util.Date(((DbTime)dbValue).value));
                        break;
                    }
                    DateFormat dateFormat = DateFormat.getTimeInstance(2, locale);
                    dateFormat.setTimeZone(timeZone);
                    string = dateFormat.format(new java.util.Date(((DbTime)dbValue).value));
                    break;
                }
                case 8: {
                    java.util.Date date = ((DbTimestamp)dbValue).toUtilDate();
                    if (!this.userFormat.equals("")) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.userFormat, locale);
                        simpleDateFormat.setTimeZone(timeZone);
                        string = simpleDateFormat.format(date);
                        break;
                    }
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 2, locale);
                    dateFormat.setTimeZone(timeZone);
                    string = dateFormat.format(date);
                    break;
                }
                case 5: {
                    string = ((DbChar)dbValue).value;
                    break;
                }
                case 4: {
                    if (this.userFormat.equals("")) {
                        string = dbValue.toString();
                        break;
                    }
                    String[] stringArray = this.allowTypeIn(this.userFormat);
                    string = ((DbBit)dbValue).value ? stringArray[0] : stringArray[1];
                    break;
                }
                default: {
                    string = dbValue.toString();
                }
            }
        }
        return string;
    }

    public Vector getDisplayValues(Locale locale) {
        this.column();
        int n = this.vDbValue.size();
        Vector<String> vector = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            vector.addElement(this.getDisplayValue((DbValue)this.vDbValue.elementAt(i), locale));
        }
        return vector;
    }

    private void clone(boolean bl) {
        this.needLoadValueList = bl;
    }

    public boolean needLoadValueList() {
        return this.needLoadValueList;
    }

    public boolean isBindColumn() {
        BindColumn bindColumn = this.def.getBindColumn();
        return this.column != null && this.column.length() > 0 || bindColumn != null && bindColumn.getQueryName() != null && bindColumn.getQueryName().length() > 0;
    }

    private void column() {
        block4: {
            if (this.isBindColumn() && this.needLoadValueList) {
                try {
                    if (this.rt.loadValueList()) {
                        this.needLoadValueList = false;
                    }
                }
                catch (Exception exception) {
                    if (!JRLog.isError(2)) break block4;
                    JRLog.error(2, "Met exception when loading parameter value list: ", (Throwable)exception);
                }
            }
        }
    }

    public Vector getValues() {
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "getValues()/" + this.hashCode() + ";needLoad: " + this.needLoadValueList, (Throwable)new CallTrace());
        }
        this.column();
        int n = this.vDbValue.size();
        Vector<String> vector = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            vector.addElement(this.clear((DbValue)this.vDbValue.elementAt(i)));
        }
        return vector;
    }

    public Vector getValues(Locale locale, TimeZone timeZone) {
        this.column();
        Vector<DbValue> vector = new Vector<DbValue>(this.vDbValue.size());
        for (Object object : this.vDbValue) {
            if (!this.isExpression(object)) {
                object = ValueListItemUtil.toValueListItem((DbValue)object);
                String string = null;
                string = null == locale ? this.clear((DbValue)object) : this.getDisplayValue((DbValue)object, locale, timeZone);
                ((EvalueatedValueListItem)object).setUserInput(string, false, null, null, locale);
            }
            vector.addElement((DbValue)object);
        }
        return vector;
    }

    public Vector getValues(Locale locale) {
        return this.getValues(locale, this.defaultZone);
    }

    public boolean isValuesNotEmpty() {
        return this.vDbValue.size() > 0;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getPrompt() {
        return this.promptText;
    }

    public Vector getLimit() {
        Vector vector = this.vDbLimit;
        int n = vector.size();
        Vector<String> vector2 = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            vector2.addElement(this.containsKey((DbValue)vector.elementAt(i)));
        }
        return vector2;
    }

    public Vector getDisplayLimit(Locale locale) {
        int n = this.vDbLimit.size();
        Vector<String> vector = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            vector.addElement(this.getDisplayValue((DbValue)this.vDbLimit.elementAt(i), locale));
        }
        return vector;
    }

    public String getFormat() {
        return this.userFormat;
    }

    public String getDefaultDateFormat(Locale locale) {
        SimpleDateFormat simpleDateFormat = null;
        switch (this.parameter.type) {
            case 6: 
            case 17: {
                simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(1, locale);
                break;
            }
            case 7: 
            case 18: {
                simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getTimeInstance(2, locale);
                break;
            }
            case 8: 
            case 19: {
                simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 2, locale);
                break;
            }
            default: {
                simpleDateFormat = null;
            }
        }
        if (simpleDateFormat == null) {
            return null;
        }
        return simpleDateFormat.toPattern();
    }

    public int getDefaultIndex() {
        return this.index;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setFormat(String string) {
        this.userFormat = string.length() > 0 ? string : "";
    }

    public void setPrompt(String string) {
        this.promptText = string;
    }

    private boolean isExpression(Object object) {
        if (object instanceof UserInput) {
            return ((UserInput)object).isExpression();
        }
        return false;
    }

    public void setValues(Vector vector, Locale locale) throws InvalidParameterException {
        int n;
        if (this.isBindColumn()) {
            this.removeIndex.clear();
            this.vDbValue.clear();
        }
        int n2 = vector.size();
        int n3 = this.vDbValue.size();
        boolean bl = locale == null;
        Locale locale2 = bl ? defaultLocale : locale;
        String string = "";
        long l = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(l);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "setValues: baseLine = " + l + "==" + timestamp + "; locale = " + locale + "; timezone = " + TimeZone.getDefault());
        }
        for (n = 0; n < n2; ++n) {
            String string2 = null;
            Object e = vector.elementAt(n);
            if (e != null) {
                UserInput userInput = null;
                userInput = e instanceof UserInput ? (UserInput)e : new UnevaluatedValueListItem(e.toString(), false, null, null);
                try {
                    Object object;
                    string2 = userInput.getUserInput();
                    DbValue dbValue = null;
                    if (userInput.isExpression()) {
                        object = new FormulaContainerImpl();
                        ExternalInfoProviderImpl externalInfoProviderImpl = new ExternalInfoProviderImpl(userInput, timestamp);
                        dbValue = (DbValue)((Object)ValueListItemUtil.toValueListItem(userInput, this.type, (FormulaContainerImpl)object, externalInfoProviderImpl));
                    } else {
                        dbValue = this.parseValue(string2, locale2, !bl);
                        dbValue = (DbValue)((Object)ValueListItemUtil.toValueListItem(dbValue));
                        if (bl) {
                            object = this.getDisplayValue(dbValue, defaultLocale);
                            dbValue = this.parseValue((String)object, locale2, true);
                            dbValue = (DbValue)((Object)ValueListItemUtil.toValueListItem(dbValue));
                            userInput = new UnevaluatedValueListItem(this.getDisplayValue(dbValue, defaultLocale), false, null, null);
                        }
                    }
                    ((EvalueatedValueListItem)((Object)dbValue)).setUserInput(userInput.getUserInput(), userInput.isExpression(), userInput.getExpressionName(), userInput.getSelectedDate(), locale);
                    if (n < n3) {
                        this.vDbValue.setElementAt(dbValue, n);
                        continue;
                    }
                    if (this.isColumn == 4) {
                        this.vDbValue.addElement(dbValue);
                        continue;
                    }
                    if (this.vDbValue.contains(dbValue)) continue;
                    this.vDbValue.addElement(dbValue);
                }
                catch (Exception exception) {
                    this.removeIndex.addElement(new Integer(n));
                    string = string + "\n\"" + string2 + "\": " + exception.getMessage();
                }
                continue;
            }
            this.removeIndex.addElement(new Integer(n));
        }
        if (this.isColumn != 4) {
            n = this.vDbValue.size();
            while (--n >= n2) {
                this.vDbValue.removeElementAt(n);
            }
        }
        if (string.length() > 0) {
            throw new InvalidParameterException(new Exception(string));
        }
        this.needLoadValueList = false;
    }

    public void setValues(Vector vector, Locale locale, DbValue dbValue) throws InvalidParameterException {
        this.setValues(vector, locale);
        this.setValue(dbValue, locale);
    }

    public void setDefaultValue(int n) {
        this.column();
        this.setDefaultIndex(n);
    }

    public void setShowValues(Vector vector) {
        this.vShowValue = vector;
        int n = this.removeIndex.size();
        while (--n >= 0) {
            this.vShowValue.removeElementAt((Integer)this.removeIndex.elementAt(n));
        }
    }

    public Vector getShowValues() {
        this.column();
        if (this.isBindColumn()) {
            return this.vShowValue;
        }
        return this.vShowValue == null || this.vShowValue.size() == 0 ? this.vDbValue : this.vShowValue;
    }

    private void columns() {
        Vector vector;
        String string = "Value changed: this: " + this.name + "; hash = " + this.hashCode();
        if (this.lowerLevels != null && this.lowerLevels.size() > 0) {
            for (int i = 0; i < this.lowerLevels.size(); ++i) {
                ParamDesc paramDesc = (ParamDesc)this.lowerLevels.elementAt(i);
                super.clone(true);
                string = string + "\nlowerLevelParam: " + paramDesc.name + "; " + paramDesc.hashCode();
            }
        }
        if (null == (vector = this.rt.getLowerLevelsByQuery()) || vector.size() == 0) {
            return;
        }
        for (ParamDesc paramDesc : vector) {
            paramDesc.clone(true);
            string = string + "\nlowerLevelParam(by query): " + paramDesc.name + "; " + paramDesc.hashCode();
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, string, (Throwable)new CallTrace());
        }
    }

    public Object clone() {
        Vector<String> vector = new Vector<String>();
        vector.add("paramvalue");
        vector.add("rt");
        vector.add("def");
        vector.add("vDbValue");
        vector.add("vShowValue");
        ParamDesc paramDesc = new ParamDesc();
        Class<ParamDesc> clazz = ParamDesc.class;
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string;
            boolean bl = Modifier.isStatic(fieldArray[i].getModifiers());
            boolean bl2 = Modifier.isFinal(fieldArray[i].getModifiers());
            if (bl || bl2 || vector.contains(string = fieldArray[i].getName())) continue;
            try {
                Vector vector2 = fieldArray[i].get(this);
                if (null != vector2 && vector2 instanceof Vector) {
                    Vector vector3 = vector2;
                    vector2 = new Vector();
                    for (Object e : vector3) {
                        vector2.add(e);
                    }
                }
                fieldArray[i].set(paramDesc, vector2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.paramvalue != null) {
            paramDesc.paramvalue = (DbValue)this.paramvalue.clone();
        }
        if (this.rt != null) {
            this.rt.copyTo(paramDesc.getParameterRuntime());
        }
        if (this.def != null) {
            this.def.copyTo(paramDesc.getDefinition());
        }
        paramDesc.vDbValue.addAll(this.vDbValue);
        paramDesc.vShowValue.addAll(this.vShowValue);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ParamDesc.clone()/" + this.hashCode() + ";needLoad=" + this.needLoadValueList + "values: " + this.vDbValue + "\nthat:" + paramDesc.hashCode() + ";nthat.needLoad = " + paramDesc.needLoadValueList + "\nvalues = " + paramDesc.vDbValue);
        }
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ParamDesc.clone()/" + this.hashCode() + "\nthat:" + paramDesc.hashCode(), (Throwable)new CallTrace());
        }
        paramDesc.lowerLevels = null;
        paramDesc.upperLevels = null;
        return paramDesc;
    }

    public void setDefaultIndex(int n) {
        int n2 = this.vDbValue.size() - 1;
        this.index = n <= -1 || n > n2 ? -1 : n;
        if (n2 == -1) {
            this.inValue = "";
            this.value = "";
        } else {
            DbValue dbValue = this.index == -1 ? (DbValue)this.vDbValue.lastElement() : (DbValue)this.vDbValue.elementAt(this.index);
            this.value = this.getDisplayValue(dbValue, defaultLocale);
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "who setDefaultIndex( ): " + n + ";value = " + dbValue + ";" + this.hashCode(), (Throwable)new CallTrace());
            }
            if (this.isMultipleValue) {
                if (!this.isAllSelected()) {
                    fArray fArray2 = fArray.getInstance(this.getInfo().getDataType(), this.getColDesc());
                    fArray2.set(new DbValue[]{(DbValue)dbValue.clone()});
                    this.paramvalue = fArray2;
                }
            } else {
                this.inValue = this.getDefaultValue();
                this.paramvalue = (DbValue)dbValue.clone();
            }
        }
        this.columns();
    }

    public boolean equals(ParamDesc paramDesc) {
        boolean bl;
        boolean bl2 = bl = this.getPrompt().equalsIgnoreCase(paramDesc.getPrompt()) && this.getType().equalsIgnoreCase(paramDesc.getType()) && this.getFormat().equalsIgnoreCase(paramDesc.getFormat()) && this.getDefaultIndex() == paramDesc.getDefaultIndex() && this.getOperation() == paramDesc.getOperation();
        if (bl) {
            int n;
            Vector vector = paramDesc.getLimit();
            Vector vector2 = this.getLimit();
            if (vector.size() == vector2.size()) {
                for (n = 0; bl && n < vector.size(); ++n) {
                    bl = ((String)vector.elementAt(n)).equalsIgnoreCase((String)vector2.elementAt(n));
                }
            } else {
                bl = false;
            }
            if (bl) {
                vector = paramDesc.getValues();
                vector2 = this.getValues();
                if (vector.size() == vector2.size()) {
                    for (n = 0; bl && n < vector.size(); ++n) {
                        bl = vector2.contains(vector.elementAt(n));
                    }
                }
            }
        }
        return bl;
    }

    public DbValue parseInternalValue(String string) throws InvalidParameterException {
        DbValue dbValue = this.parseValue(string, defaultLocale, false);
        return dbValue;
    }

    protected boolean isOutOfRange(DbValue dbValue) {
        boolean bl;
        this.column();
        if (this.getWhenOutOfRange() == 1) {
            return false;
        }
        if (dbValue != null) {
            if (dbValue.bNull) {
                return false;
            }
            if (dbValue instanceof DbChar && "".equals(((DbChar)dbValue).value)) {
                return false;
            }
        }
        boolean bl2 = bl = this.vDbValue.size() > 0 && !this.vDbValue.contains(dbValue);
        if (bl) {
            String string = "";
            for (DbValue dbValue2 : this.vDbValue) {
                string = string + ((Object)dbValue2).toString();
                string = string + ";";
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "parameter " + this.name + " out of rang!" + "; input value: " + dbValue + "; value list: [" + string + "]");
            }
        }
        return bl;
    }

    public String setValue(String string, Locale locale) throws InvalidParameterException {
        this.setValue(new UnevaluatedValueListItem(string), new Timestamp(System.currentTimeMillis()), locale);
        return this.value;
    }

    public String setValue(DbValue dbValue, Locale locale) throws InvalidParameterException {
        boolean bl;
        if (this.isMultipleValue) {
            fArray fArray2 = null;
            if (dbValue instanceof fArray) {
                fArray2 = (fArray)dbValue;
            } else {
                fArray2 = fArray.getInstance(this.parameter.type, this.desc);
                fArray2.set(new DbValue[]{dbValue});
            }
            return this.setValue(fArray2, locale)[0];
        }
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = defaultLocale;
        }
        DbValue dbValue2 = this.add(dbValue);
        this.chainID(dbValue, locale2);
        if (this.paramvalue == null || !dbValue2.equals(this.paramvalue)) {
            this.columns();
        }
        if ((bl = this.isOutOfRange(dbValue2)) && this.getWhenOutOfRange() == 2) {
            String string = this.getDefaultValue();
            this.paramvalue = this.parseInternalValue(string);
        } else {
            if (bl && this.getWhenOutOfRange() == 3) {
                String string = null;
                string = dbValue2 instanceof UserInput && ((UserInput)((Object)dbValue2)).isExpression() ? ((UserInput)((Object)dbValue2)).getUserInput() : this.getDisplayValue(dbValue2, locale2);
                throw new InvalidParameterException("PARAM_OUT_OF_RANGE", new Object[]{string});
            }
            this.paramvalue = dbValue2;
        }
        this.inValue = this.clear(this.paramvalue);
        this.value = this.getDisplayValue(this.paramvalue, locale2);
        if (!ValueListItemUtil.contains(this.vDbValue, this.paramvalue)) {
            this.vDbValue.addElement(this.paramvalue);
            if (this.isBindColumn()) {
                if (this.paramvalue instanceof UserInput) {
                    this.vShowValue.add(((UserInput)((Object)this.paramvalue)).getUserInput());
                } else {
                    this.vShowValue.add(this.value);
                }
            }
            this.index = 0;
        } else {
            this.index = ValueListItemUtil.indexOf(this.vDbValue, this.paramvalue);
        }
        return this.value;
    }

    protected DbValue evaluate(DbValue dbValue, FormulaContainerImpl formulaContainerImpl, Timestamp timestamp) {
        UserInput userInput;
        block7: {
            if (dbValue == null) {
                return dbValue;
            }
            Object object = dbValue;
            if (!(object instanceof UserInput)) {
                object = ValueListItemUtil.toValueListItem((DbValue)object);
            }
            if (!(userInput = (UserInput)object).isExpression()) {
                return dbValue;
            }
            ExternalInfoProviderImpl externalInfoProviderImpl = new ExternalInfoProviderImpl(userInput, timestamp);
            DbValue dbValue2 = null;
            try {
                dbValue2 = formulaContainerImpl.executeFormulaByExp(userInput.getUserInput(), externalInfoProviderImpl);
                ((DbValue)((Object)userInput)).set(dbValue2);
            }
            catch (ExecFormulaFailedException execFormulaFailedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, "paramDesc.evaluateItems() met exception:", (Throwable)execFormulaFailedException);
                }
            }
            catch (ParseFormulaFailedException parseFormulaFailedException) {
                if (!JRLog.isError(2)) break block7;
                JRLog.error(2, "paramDesc.evaluateItems() met exception:", (Throwable)parseFormulaFailedException);
            }
        }
        return (DbValue)((Object)userInput);
    }

    protected void evaluateItems(FormulaContainerImpl formulaContainerImpl, Timestamp timestamp) {
        for (int i = 0; i < this.vDbValue.size(); ++i) {
            DbValue dbValue = (DbValue)this.vDbValue.elementAt(i);
            DbValue dbValue2 = this.evaluate(dbValue, formulaContainerImpl, timestamp);
            this.vDbValue.setElementAt(dbValue2, i);
        }
    }

    public void resetTimeBaseLine(Timestamp timestamp) {
        FormulaContainerImpl formulaContainerImpl = new FormulaContainerImpl();
        if (this.isMultipleValue) {
            if (this.isAllSelected) {
                return;
            }
            DbValue[] dbValueArray = ((fArray)this.paramvalue).value;
            if (dbValueArray == null) {
                return;
            }
            for (int i = 0; i < dbValueArray.length; ++i) {
                dbValueArray[i] = this.evaluate(dbValueArray[i], formulaContainerImpl, timestamp);
            }
        } else {
            this.paramvalue = this.evaluate(this.paramvalue, formulaContainerImpl, timestamp);
        }
    }

    private String contains(String string, Locale locale) {
        IValueListFetcherContext iValueListFetcherContext;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "searchNLSKey()/paramDesc: " + this + "locale = " + locale + "; input value = " + string);
        }
        if ((iValueListFetcherContext = this.rt.getValueListFetcherContext()) == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "searchNLSKey()/paramDesc: " + this + "; IValueListFetcherContext is NULL!!");
            }
            return string;
        }
        JetUUniverse jetUUniverse = iValueListFetcherContext.getUniverse(this);
        JFieldValueNLSManager jFieldValueNLSManager = jetUUniverse.getNLSManager(locale);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "searchNLSKey()/NLSManager = " + jFieldValueNLSManager);
        }
        if (jFieldValueNLSManager == null) {
            return string;
        }
        String string2 = this.dataMapping;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "searchNLSKey()/paramDesc: " + this + "locale = " + locale + "; prefix = " + string2);
        }
        if (string2 != null && string2.length() > 0) {
            String string3 = jFieldValueNLSManager.searchNLSKeyByValue(string2, string);
            if (string3 == null) {
                return string;
            }
            return string3;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "searchNLSKey()/paramDesc: " + this + "; datamapping prefix is null or empty String.");
        }
        return string;
    }

    public void setValue(UserInput userInput, Timestamp timestamp, Locale locale, TimeZone timeZone) throws InvalidParameterException {
        if (this.isMultipleValue) {
            throw new InvalidParameterException("PARAM_DO_NOT_CALL_ON_MULTI", new Object[0]);
        }
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = defaultLocale;
        }
        FormulaContainerImpl formulaContainerImpl = new FormulaContainerImpl();
        ExternalInfoProviderImpl externalInfoProviderImpl = new ExternalInfoProviderImpl(userInput, timestamp);
        DbValue dbValue = null;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Input parameter: " + this.name + ";hash=" + this.hashCode() + "; baselime = " + timestamp + "; locale = " + locale + "; TimeZone = " + timeZone + "; input = [" + ValueListItemUtil.toString(userInput) + "]" + "\nneedload: " + this.needLoadValueList + "\nvalues:" + this.vDbValue, (Throwable)new CallTrace());
        }
        this.evaluateItems(formulaContainerImpl, timestamp);
        String string = userInput.getUserInput();
        if (userInput.isExpression() && !"".equalsIgnoreCase(string)) {
            dbValue = (DbValue)((Object)ValueListItemUtil.toValueListItem(userInput, this.type, formulaContainerImpl, externalInfoProviderImpl));
            dbValue.setColDesc(this.desc);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Parameter expresson '" + string + "' evalueated: " + dbValue);
            }
        } else {
            String string2 = this.contains(string, locale2);
            dbValue = this.parseValue(string2, locale2, true);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Input value '" + string + "'; nlsKey = '" + string2 + "' parsed: " + dbValue);
            }
            dbValue = (DbValue)((Object)ValueListItemUtil.toValueListItem(dbValue));
        }
        ((EvalueatedValueListItem)((Object)dbValue)).setUserInput(userInput.getUserInput(), userInput.isExpression(), userInput.getExpressionName(), userInput.getSelectedDate(), locale2);
        this.setValue(dbValue, locale2);
    }

    public void setValue(UserInput userInput, Timestamp timestamp, Locale locale) throws InvalidParameterException {
        this.setValue(userInput, timestamp, locale, TimeZone.getDefault());
    }

    public void setValue(UserInput[] userInputArray, Timestamp timestamp, Locale locale, TimeZone timeZone) throws InvalidParameterException {
        if (!this.isMultipleValue) {
            throw new InvalidParameterException("PARAM_DO_NOT_CALL_ON_SINGLE", new Object[0]);
        }
        Locale locale2 = locale;
        if (null == locale2) {
            locale2 = defaultLocale;
        }
        fArray fArray2 = fArray.getInstance(this.getInfo().getDataType(), this.getColDesc());
        if (userInputArray.length == 0) {
            fArray2.setNull();
        } else {
            FormulaContainerImpl formulaContainerImpl = new FormulaContainerImpl();
            DbValue[] dbValueArray = new DbValue[userInputArray.length];
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "Input multivalue parameter: " + this.name + "; baselime = " + timestamp + "; locale = " + locale + "; inputed value: " + userInputArray, (Throwable)new CallTrace());
            }
            this.evaluateItems(formulaContainerImpl, timestamp);
            int n = 0;
            for (UserInput userInput : userInputArray) {
                Object object;
                String string = userInput.getUserInput();
                if (userInput.isExpression() && !"".equalsIgnoreCase(string)) {
                    object = new ExternalInfoProviderImpl(userInput, timestamp);
                    EvalueatedValueListItem evalueatedValueListItem = ValueListItemUtil.toValueListItem(userInput, this.type, formulaContainerImpl, (ExternalInfoProvider)object);
                    dbValueArray[n] = (DbValue)((Object)evalueatedValueListItem);
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "Input parameter[" + n + "]: " + "; input = [" + ValueListItemUtil.toString(userInput) + "]" + "; evaluated value = " + evalueatedValueListItem);
                    }
                } else {
                    object = this.contains(string, locale2);
                    dbValueArray[n] = (DbValue)((Object)ValueListItemUtil.toValueListItem(this.parseValue((String)object, locale2, true)));
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "Input parameter[" + n + "]: " + "; input = [" + ValueListItemUtil.toString(userInput) + "]" + "; nlssKey = " + (String)object + "; parsed value = " + dbValueArray[n]);
                    }
                }
                ((EvalueatedValueListItem)((Object)dbValueArray[n])).setUserInput(userInput.getUserInput(), userInput.isExpression(), userInput.getExpressionName(), userInput.getSelectedDate(), locale2);
                ++n;
            }
            fArray2.set(dbValueArray);
        }
        this.setValue(fArray2, locale2);
    }

    public void setValue(UserInput[] userInputArray, Timestamp timestamp, Locale locale) throws InvalidParameterException {
        this.setValue(userInputArray, timestamp, locale, this.defaultZone);
    }

    public void check(String string, Locale locale) throws InvalidParameterException {
        this.setValue(string, locale);
    }

    public boolean isSimilar(ParamDesc paramDesc) {
        boolean bl;
        boolean bl2 = bl = this.getPrompt().equalsIgnoreCase(paramDesc.getPrompt()) && this.getType().equalsIgnoreCase(paramDesc.getType()) && this.getFormat().equalsIgnoreCase(paramDesc.getFormat()) && this.getOperation() == paramDesc.getOperation() && this.getBeColumn() == paramDesc.getBeColumn();
        if (bl) {
            int n;
            if (this.isColumn == 4) {
                if (!this.column.equals(paramDesc.column) || this.columns.size() != paramDesc.columns.size()) {
                    return false;
                }
                int n2 = this.columns.size();
                while (--n2 >= 0) {
                    if (this.columns.elementAt(n2).equals(paramDesc.columns.elementAt(n2))) continue;
                    return false;
                }
            }
            Vector vector = paramDesc.getLimit();
            Vector vector2 = this.getLimit();
            if (vector.size() == vector2.size()) {
                for (n = 0; bl && n < vector.size(); ++n) {
                    if (((String)vector.elementAt(n)).equalsIgnoreCase((String)vector2.elementAt(n))) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = false;
            }
            if (bl) {
                vector2 = paramDesc.getValues();
                vector = this.getValues();
                if (this.isColumn == 0) {
                    if (vector.size() <= vector2.size()) {
                        for (n = 0; bl && n < vector.size(); ++n) {
                            bl = vector2.contains(vector.elementAt(n));
                        }
                    }
                } else if (vector.size() == vector2.size()) {
                    for (n = 0; bl && n < vector.size(); ++n) {
                        if (vector2.contains(vector.elementAt(n))) continue;
                        bl = false;
                        break;
                    }
                } else {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String string) {
        this.binding = string;
    }

    public String getColumn() {
        return this.column;
    }

    public Vector getColumns() {
        return this.columns;
    }

    public void setColumn(String string) {
        this.column = string;
    }

    public void setColumns(Vector vector) {
        this.columns = vector;
    }

    public void setDistinct(boolean bl) {
        this.isDis = bl;
    }

    public boolean isDistinct() {
        return this.isDis;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setRequired(boolean bl) {
        this.isReq = bl;
    }

    public boolean isRequired() {
        return this.isReq;
    }

    public void setDataSource(String string) {
        this.srcName = string;
    }

    public String getDataSource() {
        return this.srcName;
    }

    public String getImportSql() {
        return this.importSql;
    }

    public void setImportSql(String string) {
        this.importSql = string;
    }

    public static void getRelatedParamDescsByParam(Hashtable hashtable, Vector vector, ParamDesc paramDesc) {
        if (paramDesc.type.equals(TYPE_PARAMETER)) {
            Vector vector2 = paramDesc.getValues();
            for (int i = 0; i < vector2.size(); ++i) {
                String[] stringArray = ParamDesc.splitValue(vector2.get(i).toString());
                for (int j = 0; j < stringArray.length; ++j) {
                    ParamDesc paramDesc2 = (ParamDesc)hashtable.get(stringArray[j].toString().toUpperCase());
                    if (paramDesc2 == null || vector.contains(paramDesc2)) continue;
                    vector.add(paramDesc2);
                    ParamDesc.getRelatedParamDescsByParam(hashtable, vector, paramDesc2);
                }
            }
        }
    }

    public static Vector getFirstLevelRelatedParamByValue(Hashtable hashtable, ParamDesc paramDesc, Object object) {
        Vector<ParamDesc> vector = new Vector<ParamDesc>();
        if (paramDesc.type.equals(TYPE_PARAMETER)) {
            String[] stringArray = ParamDesc.splitValue(object.toString());
            for (int i = 0; i < stringArray.length; ++i) {
                ParamDesc paramDesc2 = (ParamDesc)hashtable.get(stringArray[i].toString().toUpperCase());
                if (paramDesc2 == null || vector.contains(paramDesc2)) continue;
                vector.add(paramDesc2);
            }
        }
        return vector;
    }

    public static void getFirstShowParamDescs(Hashtable hashtable, Vector vector, ParamDesc paramDesc, Object object) {
        if (paramDesc.type.equals(TYPE_PARAMETER)) {
            String[] stringArray = ParamDesc.splitValue(object.toString());
            for (int i = 0; i < stringArray.length; ++i) {
                ParamDesc paramDesc2 = (ParamDesc)hashtable.get(stringArray[i].toString().toUpperCase());
                if (paramDesc2 == null || vector.contains(paramDesc2)) continue;
                vector.add(paramDesc2);
                ParamDesc.getFirstShowParamDescs(hashtable, vector, paramDesc2, paramDesc2.getDefaultValue());
            }
        }
    }

    public static void getFirstLevelParam(Hashtable hashtable) {
        Vector vector = ParamDesc.getReferPara(hashtable);
        for (int i = 0; i < vector.size(); ++i) {
            ParamDesc paramDesc = (ParamDesc)vector.get(i);
            if (!hashtable.containsKey(paramDesc.getName().toUpperCase())) continue;
            hashtable.remove(paramDesc.getName().toUpperCase());
        }
    }

    public static void getAllRelatedParamByValue(Hashtable hashtable, Vector vector, ParamDesc paramDesc, Object object) {
        if (paramDesc.type.equals(TYPE_PARAMETER)) {
            String[] stringArray = ParamDesc.splitValue(object.toString());
            for (int i = 0; i < stringArray.length; ++i) {
                ParamDesc paramDesc2 = (ParamDesc)hashtable.get(stringArray[i].toString().toUpperCase());
                if (paramDesc2 == null || vector.contains(paramDesc2)) continue;
                vector.add(paramDesc2);
                Vector vector2 = paramDesc2.getValues();
                for (int j = 0; j < vector2.size(); ++j) {
                    String string = vector2.get(j).toString();
                    ParamDesc.getAllRelatedParamByValue(hashtable, vector, paramDesc2, string);
                }
            }
        }
    }

    public static boolean hasNestedPara(Hashtable hashtable) {
        boolean bl = false;
        if (hashtable == null) {
            return bl;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ParamDesc paramDesc = (ParamDesc)hashtable.get(enumeration.nextElement());
            if (!paramDesc.type.equals(TYPE_PARAMETER)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static Vector getReferPara(Hashtable hashtable) {
        Vector vector = new Vector();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ParamDesc paramDesc = (ParamDesc)hashtable.get(enumeration.nextElement());
            ParamDesc.getRelatedParamDescsByParam(hashtable, vector, paramDesc);
        }
        return vector;
    }

    public static String[] splitValue(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, TYPE_PARAMETER_SEPARATOR1);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.endsWith(TYPE_PARAMETER_SEPARATOR2)) {
                string2 = string2.substring(0, string2.length() - TYPE_PARAMETER_SEPARATOR2.length());
            }
            stringArray[i] = string2;
        }
        return stringArray;
    }

    public boolean IsParameters() {
        return this.type.equals(TYPE_PARAMETER);
    }

    public Vector getImportParams() {
        return this.importParams;
    }

    public void setImportParams(Vector vector) {
        this.importParams = vector;
    }

    public static boolean hasImportParam(Vector vector) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            ParamDesc paramDesc = (ParamDesc)vector.get(i);
            if (paramDesc.getImportParams() == null || paramDesc.getImportParams().size() == 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isImportByPara(ParamDesc paramDesc, ParamDesc paramDesc2, Vector vector) {
        if (vector == null) {
            return false;
        }
        boolean bl = false;
        ParamDesc paramDesc3 = null;
        if (paramDesc2 == null) {
            for (int i = 0; i < vector.size(); ++i) {
                paramDesc3 = (ParamDesc)vector.get(i);
                if (!paramDesc3.getImportParams().contains(paramDesc.name) || !vector.contains(paramDesc)) continue;
                bl = true;
                break;
            }
        } else if (vector.contains(paramDesc) && paramDesc2.importParams.contains(paramDesc.name)) {
            bl = true;
        }
        return bl;
    }

    public Vector getReferedBy() {
        return this.lowerLevels;
    }

    public Vector getUpperLevels() {
        return this.upperLevels;
    }

    public boolean isReferedBy() {
        boolean bl = this.lowerLevels != null && this.lowerLevels.size() > 0;
        bl = bl || this.rt.getLowerLevelsByQuery().size() > 0;
        return bl;
    }

    public void clearReferedBy() {
        if (this.lowerLevels != null) {
            this.lowerLevels.clear();
            this.lowerLevels = null;
        }
    }

    public boolean isReferOther() {
        boolean bl = this.importParams != null && this.importParams.size() > 0;
        bl = bl || this.rt.getParamsUsedInQuery() != null && this.rt.getParamsUsedInQuery().size() > 0;
        return bl;
    }

    public void addReferParamToVsortParams(Hashtable hashtable, Hashtable hashtable2, Vector vector) {
        if (this.importParams.size() != 0) {
            boolean bl = false;
            ParamDesc paramDesc = null;
            Enumeration enumeration = this.importParams.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                String string = ((String)e).toUpperCase();
                paramDesc = (ParamDesc)hashtable.get(string);
                if (!vector.contains(e)) {
                    int n = vector.indexOf(this.name);
                    if (n == -1) {
                        n = 0;
                    }
                    vector.insertElementAt(e, n);
                }
                if (paramDesc == null) {
                    if (!JRLog.isError(2)) continue;
                    JRLog.error(2, "Unable to find the upper level parameter'" + paramDesc + "' in allParam.");
                    continue;
                }
                if (hashtable2.get(string) == null) {
                    hashtable2.put(string, paramDesc);
                }
                if (paramDesc.lowerLevels == null) {
                    paramDesc.lowerLevels = new Vector();
                }
                if (!paramDesc.lowerLevels.contains(this)) {
                    paramDesc.lowerLevels.add(this);
                }
                if (this.upperLevels == null) {
                    this.upperLevels = new Vector();
                }
                if (!this.upperLevels.contains(paramDesc)) {
                    this.upperLevels.add(paramDesc);
                }
                if (paramDesc == null || paramDesc.importParams.size() == 0) continue;
                paramDesc.addReferParamToVsortParams(hashtable, hashtable2, vector);
            }
        }
    }

    public static Vector changedHashToVector(Hashtable hashtable) {
        Vector<ParamDesc> vector = new Vector<ParamDesc>();
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                ParamDesc paramDesc = (ParamDesc)hashtable.get(enumeration.nextElement());
                if (paramDesc == null) continue;
                vector.add(paramDesc);
            }
        }
        return vector;
    }

    public static Hashtable changedVectorToHash(Vector vector) {
        Hashtable<String, ParamDesc> hashtable = new Hashtable<String, ParamDesc>();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ParamDesc paramDesc = (ParamDesc)vector.get(i);
                if (paramDesc == null) continue;
                hashtable.put(paramDesc.getName().toUpperCase(), paramDesc);
            }
        }
        return hashtable;
    }

    public void transferValues(ParamDesc paramDesc) {
        if (this.isReferOther()) {
            this.vDbValue.clear();
            this.vShowValue.clear();
            this.vDbValue.addAll(paramDesc.vDbValue);
            this.vShowValue.addAll(paramDesc.vShowValue);
        }
        this.setDefaultIndex(paramDesc.index);
    }

    public String toString() {
        String string = "(" + this.name + " [hashCode=" + this.hashCode() + "], ";
        if (this.isMultipleValue) {
            return string + this.paramvalue + ")";
        }
        return string + this.value + ")";
    }

    private String containsKey(DbValue dbValue) {
        String string = "";
        if (dbValue != null && !dbValue.isNull()) {
            int n = DataTypeDef.SqlToFml(dbValue.getSqlType(), dbValue.isCurrency());
            switch (n) {
                case 3: {
                    string = dbValue.toString();
                    break;
                }
                case 1: {
                    string = new String(NumberFormat.getNumberInstance(defaultLocale).format(((DbNumber)dbValue).longValue()));
                    string = StringToolKit.replaceAll(string, TYPE_PARAMETER_SEPARATOR2, "");
                    break;
                }
                case 2: {
                    string = new String(NumberFormat.getNumberInstance(defaultLocale).format(((DbNumber)dbValue).doubleValue()));
                    string = StringToolKit.replaceAll(string, TYPE_PARAMETER_SEPARATOR2, "");
                    break;
                }
                case 5: {
                    string = ((DbChar)dbValue).value;
                    break;
                }
                case 4: {
                    string = new String(((DbBit)dbValue).value ? "TRUE" : "FALSE");
                    break;
                }
                case 6: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFMT);
                    DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
                    dateFormatSymbols.setZoneStrings(new String[0][0]);
                    simpleDateFormat.setDateFormatSymbols(dateFormatSymbols);
                    string = simpleDateFormat.format(((DbDate)dbValue).getDate());
                    break;
                }
                case 7: {
                    string = new Time(((DbTime)dbValue).value).toString();
                    break;
                }
                case 8: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATETIMEFMT);
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    string = simpleDateFormat.format(((DbTimestamp)dbValue).toUtilDate());
                    break;
                }
                default: {
                    if (!JRLog.isError(2)) break;
                    JRLog.error(2, dbValue + " Unknow parameter type!");
                }
            }
        }
        return string;
    }

    public boolean isUseCurrentDate() {
        return this.useCurrentDate;
    }

    public boolean setUseCurrentDate(boolean bl) {
        if (bl && this.parameter.type != 6 && this.parameter.type != 7 && this.parameter.type != 8) {
            return false;
        }
        this.useCurrentDate = bl;
        return true;
    }

    public boolean isUseCurrentDateWhenBlank() {
        return this.useCurrentDateWhenBlank;
    }

    public boolean setUseCurrentDateWhenBlank(boolean bl) {
        if (bl && this.parameter.type != 6 && this.parameter.type != 7 && this.parameter.type != 8) {
            return false;
        }
        this.useCurrentDateWhenBlank = bl;
        return true;
    }

    public DbValue getDynamicValue(long l, Locale locale) {
        if (!this.useCurrentDate && !this.useCurrentDateWhenBlank) {
            return null;
        }
        String string = this.dynamicTemplate;
        DbDateTime dbDateTime = null;
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTimeInMillis(l);
        switch (this.parameter.type) {
            case 6: {
                if (string.length() == 0 && this.useCurrentDateWhenBlank) {
                    string = "yyyy-MM-dd";
                } else if (string.length() == 0) {
                    dbDateTime = new DbDate(this.desc);
                    dbDateTime.bNull = true;
                    break;
                }
                int n = string.indexOf(45);
                int n2 = string.indexOf(45, n + 1);
                if (string.indexOf("yyyy") == -1) {
                    calendar.set(1, Integer.parseInt(string.substring(0, n)));
                }
                if (string.indexOf("MM") == -1) {
                    calendar.set(2, Integer.parseInt(string.substring(n + 1, n2)) - 1);
                }
                if (string.indexOf("dd") == -1) {
                    calendar.set(5, Integer.parseInt(string.substring(n2 + 1)));
                }
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                dbDateTime = new DbDate(this.desc);
                dbDateTime.set(calendar.getTimeInMillis() - calendar.getTimeInMillis() % 1000L);
                break;
            }
            case 7: {
                if (string.length() == 0 && this.useCurrentDateWhenBlank) {
                    string = "H:mm:ss";
                } else if (string.length() == 0) {
                    dbDateTime = new DbTime(this.desc);
                    dbDateTime.bNull = true;
                    break;
                }
                int n = string.indexOf(58);
                int n3 = string.indexOf(58, n + 1);
                if (string.indexOf("H") == -1) {
                    calendar.set(11, Integer.parseInt(string.substring(0, n)));
                }
                if (string.indexOf("mm") == -1) {
                    calendar.set(12, Integer.parseInt(string.substring(n + 1, n3)));
                }
                if (string.indexOf("ss") == -1) {
                    calendar.set(13, Integer.parseInt(string.substring(n3 + 1)));
                }
                dbDateTime = new DbTime(this.desc);
                dbDateTime.set(calendar.getTimeInMillis() % 86400000L - calendar.getTimeInMillis() % 1000L);
                break;
            }
            case 8: {
                if (string.length() == 0 && this.useCurrentDateWhenBlank) {
                    string = "yyyy-MM-dd-H:mm:ss";
                } else if (string.length() == 0) {
                    dbDateTime = new DbTimestamp(this.desc);
                    dbDateTime.bNull = true;
                    break;
                }
                int n = string.indexOf(45);
                int n4 = string.indexOf(45, n + 1);
                int n5 = string.indexOf(45, n4 + 1);
                int n6 = string.indexOf(58, n5 + 1);
                int n7 = string.indexOf(58, n6 + 1);
                if (string.indexOf("yyyy") == -1) {
                    calendar.set(1, Integer.parseInt(string.substring(0, n)));
                }
                if (string.indexOf("MM") == -1) {
                    calendar.set(2, Integer.parseInt(string.substring(n + 1, n4)) - 1);
                }
                if (string.indexOf("dd") == -1) {
                    calendar.set(5, Integer.parseInt(string.substring(n4 + 1, n5)));
                }
                if (string.indexOf("H") == -1) {
                    calendar.set(11, Integer.parseInt(string.substring(n5 + 1, n6)));
                }
                if (string.indexOf("mm") == -1) {
                    calendar.set(12, Integer.parseInt(string.substring(n6 + 1, n7)));
                }
                if (string.indexOf("ss") == -1) {
                    calendar.set(13, Integer.parseInt(string.substring(n7 + 1)));
                }
                dbDateTime = new DbTimestamp(this.desc);
                dbDateTime.set(calendar.getTimeInMillis() - calendar.getTimeInMillis() % 1000L);
            }
        }
        EvalueatedValueListItem evalueatedValueListItem = ValueListItemUtil.toValueListItem(dbDateTime);
        evalueatedValueListItem.setUserInput(this.getDisplayValue(dbDateTime, locale), false, null, null, locale);
        return (DbValue)((Object)evalueatedValueListItem);
    }

    public boolean setDynamicTemplate(String string) {
        if (string == null || string.length() == 0) {
            this.dynamicTemplate = "";
            return true;
        }
        switch (this.parameter.type) {
            case 6: {
                if (string.matches("((y{4}|\\d{2,4})-(M{2}|\\d{1,2})-(d{2}|\\d{1,2}))") && !string.matches("(\\d{2,4}-\\d{1,2}-\\d{1,2})")) {
                    this.dynamicTemplate = string;
                    return true;
                }
            }
            case 7: {
                if (string.matches("((H|\\d{1,2}):(m{2}|\\d{1,2}):(s{2}|\\d{1,2}))") && !string.matches("(\\d{1,2}:\\d{1,2}:\\d{1,2})")) {
                    this.dynamicTemplate = string;
                    return true;
                }
            }
            case 8: {
                if (!string.matches("((y{4}|\\d{2,4})-(M{2}|\\d{1,2})-(d{2}|\\d{1,2}))-((H|\\d{1,2}):(m{2}|\\d{1,2}):(s{2}|\\d{1,2}))") || string.matches("(\\d{2,4}-\\d{1,2}-\\d{1,2})-(\\d{1,2}:\\d{1,2}:\\d{1,2})")) break;
                this.dynamicTemplate = string;
                return true;
            }
        }
        return false;
    }

    public String getDynamicTemplate() {
        return this.dynamicTemplate;
    }

    public void setHideParameterWhenSingleValueReturn(boolean bl) {
        this.hideParameterWhenSingleValueReturn = bl;
    }

    public boolean isHideParameterWhenSingleValueReturn() {
        return this.hideParameterWhenSingleValueReturn;
    }

    public void setIsMultipleValue(boolean bl) {
        this.isMultipleValue = bl;
    }

    public boolean isMultipleValue() {
        return this.isMultipleValue;
    }

    public String[] getMultiDisplayValue(fArray fArray2, Locale locale, TimeZone timeZone) {
        if (!this.isMultipleValue) {
            return null;
        }
        if (fArray2.bNull) {
            return new String[0];
        }
        if (this.isAllSelected()) {
            return new String[]{"ALL"};
        }
        DbValue[] dbValueArray = fArray2.value;
        String[] stringArray = new String[dbValueArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getDisplayValue(dbValueArray[i], locale, timeZone);
        }
        return stringArray;
    }

    public String[] getMultiDisplayValue(fArray fArray2, Locale locale) {
        return this.getMultiDisplayValue(fArray2, locale, TimeZone.getDefault());
    }

    public String[] setValue(String[] stringArray, Locale locale) throws InvalidParameterException {
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = defaultLocale;
        }
        int n = stringArray.length;
        UserInput[] userInputArray = new UnevaluatedValueListItem[n];
        for (int i = 0; i < n; ++i) {
            userInputArray[i] = new UnevaluatedValueListItem(stringArray[i]);
        }
        this.setValue(userInputArray, new Timestamp(System.currentTimeMillis()), locale2);
        return this.getMultiDisplayValue((fArray)this.getValue(), locale2);
    }

    public String[] setValue(fArray fArray2, Locale locale) throws InvalidParameterException {
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = defaultLocale;
        }
        if (fArray2.isAll()) {
            this.setAllSelected(true);
            if (this.paramvalue == null) {
                this.paramvalue = fArray.getInstance(this.parameter.type, this.desc);
                ((fArray)this.paramvalue).setIsAll(true);
                this.paramvalue.bNull = false;
            }
        } else {
            this.isAllSelected = false;
            DbValue[] dbValueArray = fArray2.value;
            DbValue dbValue = null;
            boolean bl = false;
            if (dbValueArray != null) {
                for (int i = 0; i < dbValueArray.length; ++i) {
                    this.chainID(dbValueArray[i], locale);
                    if (!this.isOutOfRange(dbValueArray[i])) continue;
                    bl = true;
                    dbValue = dbValueArray[i];
                    break;
                }
            }
            if (bl && this.getWhenOutOfRange() == 2) {
                String string = this.getDefaultValue();
                fArray fArray3 = fArray.getInstance(this.parameter.type, this.desc);
                DbValue dbValue2 = this.parseInternalValue(string);
                fArray3.set(new DbValue[]{dbValue2});
                if (dbValue2.bNull) {
                    fArray3.bNull = true;
                }
                this.paramvalue = fArray3;
            } else {
                if (bl && this.getWhenOutOfRange() == 3) {
                    String string = null;
                    string = dbValue instanceof UserInput && ((UserInput)((Object)dbValue)).isExpression() ? ((UserInput)((Object)dbValue)).getUserInput() : this.getDisplayValue(dbValue, locale2);
                    throw new InvalidParameterException("PARAM_OUT_OF_RANGE", new Object[]{string});
                }
                this.paramvalue = this.add(fArray2);
                if (!this.paramvalue.bNull) {
                    for (DbValue dbValue3 : ((fArray)this.paramvalue).value) {
                        if (!ValueListItemUtil.contains(this.vDbValue, dbValue3)) {
                            this.vDbValue.addElement(dbValue3);
                            if (this.isBindColumn()) {
                                if (dbValue3 instanceof UserInput) {
                                    this.vShowValue.add(((UserInput)((Object)dbValue3)).getUserInput());
                                } else {
                                    this.vShowValue.add(this.getDisplayValue(dbValue3, locale2));
                                }
                            }
                            this.index = 0;
                            continue;
                        }
                        this.index = ValueListItemUtil.indexOf(this.vDbValue, dbValue3);
                    }
                }
            }
            this.columns();
        }
        return this.getMultiDisplayValue((fArray)this.paramvalue, locale2);
    }

    public String[] getMultiStrValue() {
        if (!this.isMultipleValue) {
            return null;
        }
        if (this.isAllSelected()) {
            return new String[]{"ALL"};
        }
        if (this.paramvalue == null) {
            try {
                this.initParam(defaultLocale);
            }
            catch (InvalidParameterException invalidParameterException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, invalidParameterException);
                }
                return new String[0];
            }
        }
        if (this.paramvalue.isNull()) {
            return new String[0];
        }
        DbValue[] dbValueArray = ((fArray)this.paramvalue).value;
        String[] stringArray = new String[dbValueArray.length];
        for (int i = 0; i < dbValueArray.length; ++i) {
            stringArray[i] = this.clear(dbValueArray[i]);
        }
        return stringArray;
    }

    public void setSelectedValues(Vector vector) {
        this.selectedValues = vector;
    }

    public Vector getSelectedValues() {
        return this.selectedValues;
    }

    public boolean isCascading() {
        return this.isCascading;
    }

    public void setIsCascading(boolean bl) {
        this.isCascading = bl;
    }

    public void setCascadingInfo(String string, String string2, String string3, boolean bl) {
        this.previousLevel = string2;
        this.nextLevel = string3;
        this.chainID = string;
        this.isSetAsParameter = bl;
    }

    public String getChainID() {
        return this.chainID;
    }

    public String getPreviousLevel() {
        return this.previousLevel;
    }

    public String getNextLevel() {
        return this.nextLevel;
    }

    public boolean isSetAsParameter() {
        return this.isSetAsParameter;
    }

    public void setAllSelected(boolean bl) {
        if (!this.isMultipleValue) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Do not call setAllSelected(...) on a single value parameter: " + this.name + "; " + this.hashCode());
            }
            return;
        }
        boolean bl2 = this.isAllSelected;
        this.isAllSelected = bl;
        if (bl2 != bl) {
            this.columns();
        }
    }

    public boolean isAllSelected() {
        boolean bl = false;
        if (!this.isMultipleValue) {
            return false;
        }
        bl = !this.isAllowAll ? false : this.isAllSelected;
        return bl;
    }

    public void setAllowAll(boolean bl) {
        this.isAllowAll = !this.isMultipleValue ? false : bl;
    }

    public boolean isAllowAll() {
        if (!this.isMultipleValue) {
            return false;
        }
        return this.isAllowAll;
    }

    public void setAllowTypeIn(boolean bl) {
        this.allowTypeIn = bl;
    }

    public boolean isAllowTypeIn() {
        return this.allowTypeIn;
    }

    public void setWhenOutOfRange(int n) {
        this.whenOutOfRange = n;
    }

    public int getWhenOutOfRange() {
        return this.whenOutOfRange;
    }

    public void setValueList(Vector vector) throws InvalidParameterException {
    }

    public void setValueList(Vector vector, Vector vector2) {
        this.vDbValue.clear();
        this.vDbValue.addAll(vector);
        this.vShowValue.clear();
        this.vShowValue.addAll(vector2);
    }

    public String[] detectInvalidValues(String[] stringArray, Locale locale) throws InvalidParameterException {
        if (this.isAllSelected()) {
            return new String[0];
        }
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = defaultLocale;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            DbValue dbValue = this.parseValue(stringArray[i], locale2, true);
            if (this.vDbValue.size() <= 0 || this.vDbValue.contains(dbValue)) continue;
            vector.add(stringArray[i]);
        }
        String[] stringArray2 = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray2[i] = (String)vector.elementAt(i);
        }
        return stringArray2;
    }

    public void setAllowUseExpression(boolean bl) {
        this.allowUseExpression = bl;
    }

    public boolean allowUseExpression() {
        return this.allowUseExpression;
    }

    public String getLocalizedUserFormat(Locale locale) {
        if (this.userFormat == null || this.userFormat.length() == 0) {
            return this.userFormat;
        }
        String string = null;
        int n = this.parameter.type;
        if (DataTypeDef.isArray(n)) {
            n -= 11;
        }
        switch (n) {
            case 6: 
            case 7: 
            case 8: {
                DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.userFormat, dateFormatSymbols);
                string = simpleDateFormat.toLocalizedPattern();
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
                DecimalFormat decimalFormat = new DecimalFormat(this.userFormat, decimalFormatSymbols);
                string = decimalFormat.toLocalizedPattern();
                break;
            }
            default: {
                string = this.userFormat;
            }
        }
        return string;
    }

    public Vector[] getValueList() {
        return new Vector[]{(Vector)this.vDbValue.clone(), (Vector)this.vShowValue.clone()};
    }

    public boolean isGetValueFromAPI() {
        Vector vector;
        if (this.isGetValueFromAPI) {
            return true;
        }
        ParamDesc paramDesc = null;
        if (this.lowerLevels != null) {
            for (int i = 0; i < this.lowerLevels.size(); ++i) {
                paramDesc = (ParamDesc)this.lowerLevels.elementAt(i);
                if (!paramDesc.isGetValueFromAPI) continue;
                return true;
            }
        }
        if (null != (vector = this.rt.getLowerLevelsByQuery())) {
            for (ParamDesc paramDesc2 : vector) {
                if (!paramDesc2.isGetValueFromAPI) continue;
                return true;
            }
        }
        return false;
    }

    public void setGetValueFromAPI(boolean bl) {
        this.isGetValueFromAPI = bl;
    }

    public void copy(ParamDesc paramDesc) {
        if (!paramDesc.name.equalsIgnoreCase(this.name)) {
            return;
        }
        if (paramDesc.paramvalue != null) {
            this.paramvalue = (DbValue)paramDesc.paramvalue.clone();
        }
        this.isAllSelected = paramDesc.isAllSelected;
        this.vDbValue.clear();
        this.vDbValue.addAll(paramDesc.vDbValue);
        this.vShowValue.clear();
        this.vShowValue.addAll(paramDesc.vShowValue);
        this.index = paramDesc.index;
        this.inValue = paramDesc.inValue;
        this.value = paramDesc.value;
        this.needLoadValueList = paramDesc.needLoadValueList;
        if (paramDesc.def != null) {
            paramDesc.def.copyTo(this.getDefinition());
        }
    }

    public void setIsDynamicParam(boolean bl) {
        this.isDynamicParam = bl;
    }

    public boolean isDynamicParam() {
        return this.isDynamicParam;
    }

    public void setBVName(String string) {
        this.bvName = string;
    }

    public String getBVName() {
        return this.bvName;
    }

    public void setDataMappingFile(String string) {
        this.dataMapping = string;
    }

    public void setQueryName(String string) {
        this.queryName = string;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public String format(DbValue dbValue, String string, Locale locale, TimeZone timeZone) {
        int n;
        if (this.paramvalue instanceof fArray) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "Do not call format(...) on a multipple value parameter: " + this.name + ". Please call formatMultiple(....).");
            }
            return null;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "format/ locale=" + locale + "; timeZone = " + timeZone + "; pattern = " + string);
        }
        if (DataTypeDef.isArray(n = this.parameter.type)) {
            n -= 11;
        }
        String string2 = "";
        DateFormat dateFormat = null;
        if (dbValue != null && !dbValue.isNull()) {
            switch (n) {
                case 3: {
                    BigDecimal bigDecimal = ((DbDecimal)this.paramvalue).value;
                    if (string != null && !string.equals("")) {
                        string2 = new DecimalFormat(string).format(bigDecimal);
                        break;
                    }
                    NumberFormat numberFormat = NumberFormat.getCurrencyInstance(locale);
                    string2 = numberFormat.format(bigDecimal);
                    break;
                }
                case 1: {
                    Long l = new Long(((DbNumber)dbValue).longValue());
                    if (string != null && !string.equals("")) {
                        string2 = new DecimalFormat(string).format(l);
                        break;
                    }
                    string2 = NumberFormat.getNumberInstance(locale).format(l);
                    break;
                }
                case 2: {
                    Double d = new Double(((DbNumber)dbValue).doubleValue());
                    if (string != null && !string.equals("")) {
                        string2 = new DecimalFormat(string).format(d);
                        break;
                    }
                    string2 = NumberFormat.getNumberInstance(locale).format(d);
                    break;
                }
                case 6: {
                    dateFormat = string != null && !string.equals("") ? new SimpleDateFormat(string, locale) : DateFormat.getDateInstance(1, locale);
                    dateFormat.setTimeZone(timeZone);
                    string2 = dateFormat.format(((DbDate)dbValue).toUtilDate());
                    break;
                }
                case 7: {
                    dateFormat = string != null && !string.equals("") ? new SimpleDateFormat(string, locale) : DateFormat.getTimeInstance(2, locale);
                    dateFormat.setTimeZone(timeZone);
                    string2 = dateFormat.format(((DbTime)dbValue).toUtilDate());
                    break;
                }
                case 8: {
                    java.util.Date date = ((DbTimestamp)dbValue).toUtilDate();
                    dateFormat = string != null && !string.equals("") ? new SimpleDateFormat(string, locale) : DateFormat.getDateTimeInstance(1, 2, locale);
                    dateFormat.setTimeZone(timeZone);
                    string2 = dateFormat.format(date);
                    break;
                }
                case 5: {
                    string2 = ((DbChar)dbValue).value;
                    break;
                }
                case 4: {
                    if (string.equals("") || string == null) {
                        string2 = dbValue.toString();
                        break;
                    }
                    String[] stringArray = this.allowTypeIn(string);
                    string2 = ((DbBit)dbValue).value ? stringArray[0] : stringArray[1];
                    break;
                }
                default: {
                    string2 = this.paramvalue.toString();
                }
            }
        }
        return string2;
    }

    public String[] formatMultiple(fArray fArray2, String string, Locale locale, TimeZone timeZone) {
        if (!this.isMultipleValue) {
            return null;
        }
        if (this.isAllSelected()) {
            return new String[]{"ALL"};
        }
        DbValue[] dbValueArray = fArray2.value;
        String[] stringArray = new String[dbValueArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.format(dbValueArray[i], string, locale, timeZone);
        }
        return stringArray;
    }

    public void setNLSApplyParam(NLSApplyParam nLSApplyParam) {
        this.nls = nLSApplyParam;
    }

    private Vector copyTo(Locale locale, boolean bl) {
        DbValue dbValue;
        Object object;
        String string = null;
        JFieldValueNLSManager jFieldValueNLSManager = null;
        boolean bl2 = bl;
        if (bl && !this.isDynamicParam) {
            JetUUniverse jetUUniverse;
            object = this.rt.getValueListFetcherContext();
            if (object == null) {
                bl2 = false;
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "getValueList()/Unable to translate because IValueListFetcherContext is null");
                }
            }
            JetUUniverse jetUUniverse2 = jetUUniverse = object == null ? null : object.getUniverse(this);
            if (jetUUniverse == null) {
                bl2 = false;
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "getValueList()/Unable to translate because JetUUniverse is null");
                }
            }
            JFieldValueNLSManager jFieldValueNLSManager2 = jFieldValueNLSManager = jetUUniverse == null ? null : jetUUniverse.getNLSManager(locale);
            if (jFieldValueNLSManager == null) {
                bl2 = false;
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "getValueList()/Unable to translate because NLSManager is null");
                }
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, "getValueList()/NLSManager = " + jFieldValueNLSManager);
            }
            DbValue dbValue2 = dbValue = jetUUniverse == null ? null : (JetUParameter)jetUUniverse.getResourceByName(this.getDataSource(), null, this.name);
            if (dbValue == null) {
                bl2 = false;
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "getValueList()/Unable to translate because JetUParameter is null");
                }
            }
            String string2 = string = dbValue == null ? null : ((JetUResourceEntity)((Object)dbValue)).getDataMappingFile();
            if (string == null) {
                bl2 = false;
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "getValueList()/Unable to translate because Data Mapping File name is null");
                }
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "getValueList()/paramDesc: " + this + "locale = " + locale + "; prefix = " + string);
            }
        } else {
            bl2 = false;
        }
        object = new Vector();
        this.column();
        for (int i = 0; i < this.vDbValue.size(); ++i) {
            String string3;
            dbValue = (DbValue)this.vDbValue.elementAt(i);
            String string4 = null;
            if (bl2 && !this.isDynamicParam) {
                string3 = dbValue.toString();
                if (string != null && jFieldValueNLSManager != null) {
                    string4 = jFieldValueNLSManager.getFieldBindNLSValue(string, string3);
                }
            }
            string3 = null;
            string3 = this.getDisplayValue(dbValue, locale);
            String string5 = null;
            if (this.isBindColumn() && this.vShowValue.size() > i) {
                string5 = (String)this.vShowValue.elementAt(i);
            }
            ValueListItem valueListItem = new ValueListItem(dbValue, string3, string5, string4);
            ((Vector)object).add(valueListItem);
        }
        return object;
    }

    private Vector countTokens(Locale locale, boolean bl) {
        Vector<ValueListItem> vector = new Vector<ValueListItem>();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "translateGroupBy()/" + this.name + ";hash = " + this.hashCode() + "; Locale = " + locale + "; needTranslate = " + bl + "; nls = " + this.nls);
        }
        for (int i = 0; i < this.vDbValue.size(); ++i) {
            DbValue dbValue = (DbValue)this.vDbValue.elementAt(i);
            String string = dbValue.toString();
            String string2 = null;
            if (bl) {
                string2 = MetaNLSKit.getMetaDataNLS(string, this.nls);
            }
            String string3 = null;
            string3 = this.getDisplayValue(dbValue, locale);
            String string4 = string;
            ValueListItem valueListItem = new ValueListItem(dbValue, string3, string4, string2);
            vector.add(valueListItem);
        }
        return vector;
    }

    public void setDatamapping(String string) {
        this.dataMapping = string;
    }

    public Vector getValueList(Locale locale, boolean bl) {
        Vector vector = null;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "getValueList()/" + this.name + ";hash = " + this.hashCode() + "; getBeColumn = " + this.getBeColumn() + "; needTranslate = " + bl);
        }
        vector = this.getBeColumn() == 1 || this.getBeColumn() == 2 ? this.countTokens(locale, bl) : this.copyTo(locale, bl);
        return vector;
    }

    public Vector getValueList(Locale locale) {
        return this.getValueList(locale, true);
    }
}

