/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import jet.connect.DbDouble;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.formula.AggDesc;
import jet.formula.Aggregation;
import jet.formula.DataTypeDef;

public class SQRSUM
extends Aggregation {
    public SQRSUM() {
    }

    public SQRSUM(AggDesc aggDesc) {
        super(aggDesc);
        this.agg = DataTypeDef.makeData(2);
        this.agg.bNull = true;
    }

    @Override
    public void exec(Record record) {
        DbValue dbValue;
        if (this.isDenied) {
            return;
        }
        try {
            dbValue = record.getCell(this.agg.getColDesc());
        }
        catch (Exception exception) {
            dbValue = record.getCell(this.desc.fieldname);
            this.agg.getColDesc().setColIndex(dbValue.getColDesc().getColIndex());
        }
        if (!dbValue.bNull) {
            if (this.agg.bNull) {
                this.agg.bNull = false;
            }
            double d = ((DbNumber)dbValue).doubleValue();
            ((DbDouble)this.agg).value += d * d;
        }
    }

    @Override
    public void exec(DbValue dbValue) {
        if (this.isDenied) {
            return;
        }
        if (!dbValue.bNull) {
            if (this.agg.bNull) {
                this.agg.bNull = false;
            }
            double d = ((DbNumber)dbValue).doubleValue();
            ((DbDouble)this.agg).value += d * d;
        }
    }

    public void setValue(DbValue dbValue) {
        if (null == dbValue) {
            return;
        }
        if (dbValue.bNull) {
            return;
        }
        ((DbDouble)this.agg).value = ((DbDouble)dbValue).value;
        this.agg.bNull = false;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.agg != null) {
            this.agg.bNull = true;
        }
    }

    @Override
    protected DbValue createDbValue() {
        return DataTypeDef.makeData(2);
    }
}

