/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.math.BigDecimal;

public class SpecFormulaIntervalChecker {
    private static final String SEDU = "success";
    private static final String append = "The input is illgeal or out of bound. ";
    private static final int isInfinite = 254;
    String msg;
    Number result;

    public boolean check(int n, String string) {
        boolean bl = true;
        try {
            switch (n) {
                case -6: {
                    this.msg = "The input is illgeal or out of bound. interval must > 0 and <= 127";
                    byte by = Byte.parseByte(string);
                    if (by > 0 && by <= 127) {
                        this.result = new Byte(by);
                        this.msg = SEDU;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 5: {
                    this.msg = "The input is illgeal or out of bound. interval must > 0 and <= 32767";
                    short s = Short.parseShort(string);
                    if (s > 0 && s <= Short.MAX_VALUE) {
                        this.result = new Short(s);
                        this.msg = SEDU;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    this.msg = "The input is illgeal or out of bound. interval must > 0 and <= 2147483647";
                    int n2 = Integer.parseInt(string);
                    if (n2 > 0 && n2 <= Integer.MAX_VALUE) {
                        this.result = new Integer(n2);
                        this.msg = SEDU;
                        break;
                    }
                    bl = false;
                    break;
                }
                case -5: 
                case 91: 
                case 92: 
                case 93: {
                    this.msg = "The input is illgeal or out of bound. interval must > 0 and <= 9223372036854775807";
                    long l = Long.parseLong(string);
                    if (l > 0L && l <= Long.MAX_VALUE) {
                        this.result = new Long(l);
                        this.msg = SEDU;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 7: {
                    this.msg = "The input is illgeal or out of bound. interval must >= 1.4E-45 and <= 3.4028235E38";
                    float f = Float.parseFloat(string);
                    if (f >= Float.MIN_VALUE && f <= Float.MAX_VALUE && !Float.isInfinite(f) && !Float.isNaN(f)) {
                        this.result = new Float(f);
                        this.msg = SEDU;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 6: 
                case 8: {
                    this.msg = "The input is illgeal or out of bound. interval must >= 4.9E-324 and <= 1.7976931348623157E308";
                    double d = Double.parseDouble(string);
                    if (d >= Double.MIN_VALUE && d <= Double.MAX_VALUE && !Double.isInfinite(d) && !Double.isNaN(d)) {
                        this.result = new Double(d);
                        this.msg = SEDU;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: 
                case 3: {
                    this.msg = append;
                    this.result = new BigDecimal(string);
                    this.msg = SEDU;
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    this.msg = "The input is illgeal or out of bound. interval must > 0 and <= 254";
                    short s = Short.parseShort(string);
                    if (s > 0 && s <= 254) {
                        this.result = new Short(s);
                        this.msg = SEDU;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new RuntimeException("unsupport dataType :[" + n + "]");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.result = null;
            bl = false;
        }
        return bl;
    }

    public String getMsg() {
        return this.msg;
    }

    public Number getResult() {
        return this.result;
    }
}

