/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import jet.connect.DbBigInt;
import jet.connect.DbDouble;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.formula.AggDesc;
import jet.formula.CompondAggregation;
import jet.formula.DataTypeDef;
import jet.log.JRLogger;

class Variance
extends CompondAggregation {
    private static JRLogger SEDU = JRLogger.getLogger(Variance.class.getName());

    public Variance() {
    }

    public Variance(AggDesc aggDesc) {
        super(aggDesc);
    }

    @Override
    DbValue calculate() {
        DbValue dbValue;
        block8: {
            dbValue = DataTypeDef.makeData(2);
            if (this.isDenied) {
                return dbValue;
            }
            try {
                double d = ((DbNumber)this.usedAggs[3].agg).doubleValue();
                double d2 = ((DbNumber)this.usedAggs[2].agg).doubleValue();
                long l = ((DbNumber)this.usedAggs[1].agg).longValue();
                double d3 = d - d2 / (double)l * d2;
                if (l == 1L) {
                    dbValue.bNull = true;
                } else {
                    ((DbDouble)dbValue).set(d3 /= (double)(l - 1L));
                }
                int n = ((DbBigInt)this.usedAggs[1].agg).intValue();
                if (n == 0) {
                    dbValue.bNull = true;
                } else if (n != 1) {
                    dbValue.bNull = false;
                }
            }
            catch (ArithmeticException arithmeticException) {
                if (!SEDU.isDebugEnabled()) break block8;
                SEDU.debug(arithmeticException.getMessage(), arithmeticException);
            }
        }
        return dbValue;
    }
}

