/*
 * Decompiled with CFR 0.152.
 */
package jet.formula.aggarray;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import jet.connect.DbColDesc;
import jet.connect.DbDecimal;
import jet.connect.DbValue;
import jet.formula.aggarray.CountAggArray;
import jet.formula.aggarray.MaxMinAggArray;
import jet.formula.aggarray.MaxMinBigDecimal;
import jet.formula.aggarray.MaxMinBoolean;
import jet.formula.aggarray.MaxMinChar;
import jet.formula.aggarray.MaxMinDatetime;
import jet.formula.aggarray.MaxMinDouble;
import jet.formula.aggarray.MaxMinLong;
import jet.formula.aggarray.MaxMinTimestamp;
import jet.formula.aggarray.SqrsumAggArray;
import jet.formula.aggarray.SumCurrency;
import jet.formula.aggarray.SumDouble;
import jet.formula.aggarray.SumLong;

public abstract class BaseAggArray
implements Externalizable {
    private static final long serialVersionUID = 62019791101L;
    public static final int BITS_LENGTH = 11;
    public static final int SUBARRAYLENGTH = 2048;
    public static final int SUBARRAYFLAGLENGTH = 32;
    public static final int SUBARRAY_MASK = 2047;
    private int SEDU;
    private String add;
    private int createNew = 0;
    ArrayList nullFlags = new ArrayList();

    public int getAggCode() {
        return this.SEDU;
    }

    public String getBaseColName() {
        return this.add;
    }

    public void setSize(int n) {
        this.createNew = n;
    }

    public int size() {
        return this.createNew;
    }

    public void setNullFlag(int n, boolean bl) {
        ((boolean[])this.nullFlags.get((int)(n >> 11)))[n & 0x7FF] = bl;
    }

    boolean getNullFlag(int n) {
        return ((boolean[])this.nullFlags.get(n >> 11))[n & 0x7FF];
    }

    public void increaseCapacity() {
        boolean[] blArray = new boolean[2048];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
        this.nullFlags.add(blArray);
    }

    public static BaseAggArray createBaseAggArray(String string, int n, DbValue dbValue, DbColDesc dbColDesc) {
        BaseAggArray baseAggArray = null;
        switch (n) {
            case 1: {
                baseAggArray = new CountAggArray(false);
                break;
            }
            case 2: {
                if (dbColDesc.getSqlType() == -5) {
                    baseAggArray = new SumLong();
                    break;
                }
                if (dbColDesc.getSqlType() == 8) {
                    baseAggArray = new SumDouble();
                    break;
                }
                if (dbColDesc.getSqlType() != 3) break;
                baseAggArray = new SumCurrency();
                break;
            }
            case 7: {
                baseAggArray = new SqrsumAggArray(false);
                break;
            }
            case 3: 
            case 4: {
                baseAggArray = BaseAggArray.SEDU(dbValue);
                ((MaxMinAggArray)baseAggArray).setMax(n == 4);
                break;
            }
            default: {
                throw new RuntimeException("illeagal arg");
            }
        }
        baseAggArray.add = string;
        baseAggArray.SEDU = n;
        baseAggArray.setSourceValue(dbValue);
        return baseAggArray;
    }

    public static BaseAggArray createBaseAggArray(String string, int n, DbValue dbValue) {
        BaseAggArray baseAggArray = null;
        switch (n) {
            case 1: {
                baseAggArray = new CountAggArray(true);
                break;
            }
            case 2: {
                DbColDesc dbColDesc = dbValue.getColDesc();
                if (dbColDesc.getSqlType() == -5) {
                    baseAggArray = new SumLong();
                    break;
                }
                if (dbColDesc.getSqlType() == 8) {
                    baseAggArray = new SumDouble();
                    break;
                }
                if (dbColDesc.getSqlType() != 3) break;
                baseAggArray = new SumCurrency();
                break;
            }
            case 7: {
                baseAggArray = new SqrsumAggArray(true);
                break;
            }
            case 3: 
            case 4: {
                baseAggArray = BaseAggArray.SEDU(dbValue);
                ((MaxMinAggArray)baseAggArray).setMax(n == 4);
                break;
            }
            default: {
                throw new RuntimeException("illeagal arg");
            }
        }
        baseAggArray.add = string;
        baseAggArray.SEDU = n;
        baseAggArray.setSourceValue(dbValue);
        return baseAggArray;
    }

    public static BaseAggArray createBaseAggArray(BaseAggArray baseAggArray) {
        BaseAggArray baseAggArray2 = baseAggArray.createNew();
        if (baseAggArray.SEDU == 4 || baseAggArray.SEDU == 3) {
            ((MaxMinAggArray)baseAggArray2).setMax(baseAggArray.SEDU == 4);
        }
        baseAggArray2.setSourceBaseAggArray(baseAggArray);
        return baseAggArray2;
    }

    public BaseAggArray createNew() {
        BaseAggArray baseAggArray = null;
        try {
            baseAggArray = (BaseAggArray)this.getClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        baseAggArray.add = this.add;
        baseAggArray.SEDU = this.SEDU;
        return baseAggArray;
    }

    public abstract void setSourceValue(DbValue var1);

    public abstract void setSourceBaseAggArray(BaseAggArray var1);

    private static MaxMinAggArray SEDU(DbValue dbValue) {
        int n = dbValue.getSqlType();
        MaxMinAggArray maxMinAggArray = null;
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                maxMinAggArray = new MaxMinLong();
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                maxMinAggArray = new MaxMinDouble();
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                maxMinAggArray = new MaxMinChar();
                break;
            }
            case -7: {
                maxMinAggArray = new MaxMinBoolean();
                break;
            }
            case 91: 
            case 92: {
                maxMinAggArray = new MaxMinDatetime();
                break;
            }
            case 93: {
                maxMinAggArray = new MaxMinTimestamp();
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                throw new IllegalArgumentException("data type is Binary, can not be use as measure,since it can not be compared ");
            }
        }
        if (dbValue.isCurrency() || dbValue instanceof DbDecimal) {
            maxMinAggArray = new MaxMinBigDecimal();
        }
        return maxMinAggArray;
    }

    public abstract void append(int var1);

    public abstract void merge(int var1);

    public abstract void append(int var1, int var2);

    public abstract void merge(int var1, int var2);

    public abstract DbValue getValue(int var1);

    public abstract void readData(int var1, int var2, ObjectInput var3) throws IOException, ClassNotFoundException;

    public abstract void writeData(int var1, int var2, ObjectOutput var3) throws IOException;

    public abstract void clearValueBlock(int var1);

    public abstract void initValueBlock(int var1);

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.createNew);
        objectOutput.writeInt(this.SEDU);
        objectOutput.writeObject(this.add);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.createNew = objectInput.readInt();
        this.SEDU = objectInput.readInt();
        this.add = (String)objectInput.readObject();
    }
}

