/*
 * Decompiled with CFR 0.152.
 */
package jet.formula.aggarray;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import jet.connect.DbInteger;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.formula.aggarray.BaseAggArray;

public class CountAggArray
extends BaseAggArray {
    private static final long serialVersionUID = 62019791102L;
    private boolean SEDU = false;
    private ArrayList add = new ArrayList();
    private DbValue get;
    private CountAggArray increaseCapacity;
    private DbInteger intValue = new DbInteger();

    public CountAggArray() {
    }

    public CountAggArray(boolean bl) {
        this.SEDU = !bl;
    }

    @Override
    public void setSourceValue(DbValue dbValue) {
        this.get = dbValue;
    }

    @Override
    public void setSourceBaseAggArray(BaseAggArray baseAggArray) {
        this.increaseCapacity = (CountAggArray)baseAggArray;
    }

    @Override
    public void increaseCapacity() {
        this.add.add(new int[2048]);
    }

    @Override
    public void append(int n) {
        if (this.SEDU) {
            int[] nArray = (int[])this.add.get(n >> 11);
            int n2 = n & 0x7FF;
            nArray[n2] = nArray[n2] + 1;
        } else {
            ((int[])this.add.get((int)(n >> 11)))[n & 0x7FF] = ((DbNumber)this.get).intValue();
        }
    }

    @Override
    public void merge(int n) {
        if (this.SEDU) {
            int[] nArray = (int[])this.add.get(n >> 11);
            int n2 = n & 0x7FF;
            nArray[n2] = nArray[n2] + 1;
        } else {
            int n3 = n >> 11;
            int[] nArray = (int[])this.add.get(n3);
            int n4 = n & 0x7FF;
            nArray[n4] = nArray[n4] + ((DbNumber)this.get).intValue();
        }
    }

    @Override
    public void append(int n, int n2) {
        ((int[])this.add.get((int)(n2 >> 11)))[n2 & 0x7FF] = ((int[])this.increaseCapacity.add.get(n >> 11))[n & 0x7FF];
    }

    @Override
    public void merge(int n, int n2) {
        int[] nArray = (int[])this.increaseCapacity.add.get(n >> 11);
        int n3 = n & 0x7FF;
        int[] nArray2 = (int[])this.add.get(n2 >> 11);
        int n4 = n2 & 0x7FF;
        nArray2[n4] = nArray2[n4] + nArray[n3];
    }

    @Override
    public DbValue getValue(int n) {
        this.intValue.set(((int[])this.add.get(n >> 11))[n & 0x7FF]);
        return this.intValue;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeBoolean(this.SEDU);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.SEDU = objectInput.readBoolean();
    }

    @Override
    public void readData(int n, int n2, ObjectInput objectInput) throws IOException {
        int n3;
        int n4 = n >> 11;
        int n5 = n + n2 >> 11;
        for (n3 = n4; n3 <= n5; ++n3) {
            if (n3 >= this.add.size()) {
                this.increaseCapacity();
            }
            if (this.add.get(n3) != null) continue;
            this.add.set(n3, new int[2048]);
        }
        for (n3 = n; n3 < n + n2; ++n3) {
            ((int[])this.add.get((int)(n3 >> 11)))[n3 & 0x7FF] = objectInput.readInt();
        }
    }

    @Override
    public void writeData(int n, int n2, ObjectOutput objectOutput) throws IOException {
        for (int i = n; i < n + n2; ++i) {
            objectOutput.writeInt(((int[])this.add.get(i >> 11))[i & 0x7FF]);
        }
    }

    @Override
    public void clearValueBlock(int n) {
        this.add.set(n, null);
    }

    @Override
    public void initValueBlock(int n) {
        this.add.set(n, new int[2048]);
    }
}

