/*
 * Decompiled with CFR 0.152.
 */
package jet.formula.application.cm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jet.formula.application.cm.Member;

public class Dimension {
    public static final int CURRENT = 0;
    public static final int ROW = 1;
    public static final int COLUMN = 2;
    public static final int CATEGORY = 3;
    public static final int SERIES = 4;
    public static final int NAME = 5;
    private String SEDU;
    private int abs;
    private String append;
    private int dimensionName = 0;
    private Member m;

    public Dimension() {
    }

    public Dimension(int n) {
        this(n, null);
    }

    public Dimension(int n, Member member) {
        this.abs = n;
        this.m = member;
    }

    public Dimension(int n, int n2) {
        this(n, n2, null);
    }

    public Dimension(int n, int n2, Member member) {
        this.abs = n;
        this.dimensionName = n2;
        this.m = member;
    }

    public Dimension(String string) {
        this(string, null);
    }

    public Dimension(String string, String string2) {
        this(string, string2, null);
    }

    public Dimension(String string, String string2, Member member) {
        this.abs = 5;
        this.append = string;
        this.SEDU = string2;
        this.m = member;
    }

    public int getDimensionType() {
        return this.abs;
    }

    public String name() {
        return this.append;
    }

    public String mappingName() {
        return this.append;
    }

    public String expName() {
        return this.SEDU;
    }

    public int getOffset() {
        switch (this.abs) {
            case 0: 
            case 1: 
            case 2: {
                return this.dimensionName;
            }
        }
        return 0;
    }

    public void setOffset(int n) {
        this.dimensionName = n;
    }

    public Member getMember() {
        return this.m;
    }

    public void setMember(Member member) {
        this.m = member;
    }

    public String dimensionName() {
        String string = "";
        switch (this.abs) {
            case 0: {
                string = "CURRENT";
                break;
            }
            case 1: {
                string = "ROW";
                break;
            }
            case 2: {
                string = "COLUMN";
                break;
            }
            case 3: {
                string = "CATEGORY";
                break;
            }
            case 4: {
                string = "SERIES";
                break;
            }
            case 5: {
                string = this.SEDU;
                break;
            }
            default: {
                string = "unkown";
            }
        }
        return string;
    }

    public int hashCode() {
        int n;
        int n2 = 17;
        int n3 = n = 37;
        n3 *= n2;
        n3 += this.abs;
        switch (this.abs) {
            case 0: 
            case 1: 
            case 2: {
                n3 *= n2;
                n3 += this.dimensionName;
                break;
            }
            case 5: {
                n3 *= n2;
                n3 += this.append.hashCode();
                break;
            }
        }
        if (this.m != null) {
            n3 *= n2;
            n3 += this.m.hashCode();
        }
        return n3;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Dimension)) {
            return false;
        }
        Dimension dimension = (Dimension)object;
        if (dimension.abs != this.abs) {
            return false;
        }
        boolean bl = true;
        switch (this.abs) {
            case 0: 
            case 1: 
            case 2: {
                if (dimension.dimensionName == this.dimensionName) break;
                bl = false;
                break;
            }
            case 5: {
                if (dimension.append.equalsIgnoreCase(this.append)) break;
                bl = false;
                break;
            }
        }
        if (!bl) {
            return false;
        }
        if (this.m != null) {
            return this.m.equals(dimension.m);
        }
        return dimension.m == null;
    }

    public String toString() {
        String string = this.dimensionName();
        if (this.getOffset() != 0) {
            int n = this.getOffset();
            string = string + (n > 0 ? "+" : "-");
            string = string + Math.abs(n);
        }
        if (this.m != null) {
            string = string + ":" + this.m.toString();
        }
        return string;
    }

    public String toJavaCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("new Dimension(");
        switch (this.abs) {
            case 0: 
            case 1: 
            case 2: {
                stringBuffer.append(this.abs).append(", ").append(this.dimensionName);
                break;
            }
            case 5: {
                stringBuffer.append('\"').append(this.append).append("\", \"").append(this.SEDU).append('\"');
                break;
            }
            case 3: 
            case 4: {
                stringBuffer.append(this.abs);
            }
        }
        stringBuffer.append(",");
        if (this.m != null) {
            stringBuffer.append(this.m.getConstructor());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.abs);
        switch (this.abs) {
            case 0: 
            case 1: 
            case 2: {
                dataOutputStream.writeInt(this.dimensionName);
                break;
            }
            case 5: {
                dataOutputStream.writeUTF(this.append);
                dataOutputStream.writeUTF(this.SEDU);
            }
        }
        boolean bl = this.m != null;
        dataOutputStream.writeBoolean(bl);
        if (bl) {
            this.m.write(dataOutputStream);
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.abs = dataInputStream.readInt();
        switch (this.abs) {
            case 0: 
            case 1: 
            case 2: {
                this.dimensionName = dataInputStream.readInt();
                break;
            }
            case 5: {
                this.append = dataInputStream.readUTF();
                this.SEDU = dataInputStream.readUTF();
            }
        }
        boolean bl = dataInputStream.readBoolean();
        if (bl) {
            this.m = new Member();
            this.m.read(dataInputStream);
        }
    }
}

