/*
 * Decompiled with CFR 0.152.
 */
package jet.formula.application.cm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import jet.formula.AggDesc;
import jet.formula.Aggregation;
import jet.formula.CompondAggregation;
import jet.formula.FormulatoJava;
import jet.formula.application.cm.Dimension;

public class MeasureExpression {
    private Vector SEDU = new Vector();
    public static final int MEASURE_TYPE_AGGREGATION = 0;
    public static final int MEASURE_TYPE_MEASURE = 1;
    public static final int MEASURE_TYPE_CTF = 2;
    public static final int MEASURE_TYPE_DETAIL = 3;
    private int addElement;
    private boolean aggCode;
    private Aggregation append;
    private String createAggDesc;
    private MeasureExpression deepClone = null;
    public static final String ASSIGN = "meName";
    public static final String VECTOR_VAR = "vectorName";
    public static final String DIMENSION_VAR = "dimensionName";
    public static final String MEMBER_VAR = "memberName";
    public static final String AGG_VAR = "aggName";
    public static final String AGG_ARRAY = "aggArray";
    public static final String DESC_VAR = "descName";
    public static final String INDENT = "indent";

    public Vector getDimensionCollection() {
        return this.SEDU;
    }

    public int getMeasureType() {
        return this.addElement;
    }

    public MeasureExpression() {
    }

    public MeasureExpression(int n, String string) {
        this(null, n, string);
    }

    public MeasureExpression(Aggregation aggregation) {
        this(null, aggregation);
    }

    public boolean isCurrentCell() {
        return this.aggCode;
    }

    public MeasureExpression(Vector vector, int n, String string) {
        this.SEDU = vector;
        this.addElement = n;
        this.createAggDesc = string;
        this.aggCode = vector == null ? true : vector.size() == 0;
    }

    public MeasureExpression(Vector vector, Aggregation aggregation) {
        this.SEDU = vector;
        this.addElement = 0;
        this.append = aggregation;
        this.aggCode = vector == null ? true : vector.size() == 0;
    }

    public Aggregation getAggregation() {
        return this.append;
    }

    public String getMeasureName() {
        return this.createAggDesc;
    }

    public MeasureExpression getRuntimeMe() {
        if (this.deepClone == null) {
            this.deepClone = new MeasureExpression();
            if (this.addElement == 0) {
                this.deepClone.append = Aggregation.makeAgg(this.append.getAggDesc());
                if (this.append instanceof CompondAggregation) {
                    Aggregation[] aggregationArray = ((CompondAggregation)this.append).getUsedAggs();
                    Aggregation[] aggregationArray2 = new Aggregation[aggregationArray.length];
                    aggregationArray2[0] = this.deepClone.append;
                    for (int i = 1; i < aggregationArray2.length; ++i) {
                        aggregationArray2[i] = Aggregation.makeAgg(aggregationArray[i].getAggDesc());
                    }
                    ((CompondAggregation)this.deepClone.append).setUsedAggs(aggregationArray2);
                }
            }
            this.deepClone.SEDU = this.SEDU;
            this.deepClone.aggCode = this.aggCode;
            this.deepClone.addElement = this.addElement;
            this.deepClone.createAggDesc = this.createAggDesc;
        }
        return this.deepClone;
    }

    public void setMeasure(String string) {
        this.createAggDesc = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@(");
        if (!this.aggCode) {
            for (Dimension dimension : this.SEDU) {
                stringBuffer.append(dimension.toString());
            }
            stringBuffer.append(", ");
        }
        switch (this.addElement) {
            case 0: {
                AggDesc aggDesc = this.append.getAggDesc();
                stringBuffer.append(Aggregation.getFunctionName(aggDesc.aggCode)).append("(").append(aggDesc.fieldname).append("[").append(aggDesc.qualifiedFieldName()).append("])");
                break;
            }
            case 1: 
            case 2: {
                stringBuffer.append("@" + this.getMeasureName());
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toJavaCode(Hashtable hashtable) {
        Object object;
        String string = (String)hashtable.get(INDENT);
        String string2 = (String)hashtable.get(ASSIGN);
        String string3 = (String)hashtable.get(VECTOR_VAR);
        String string4 = (String)hashtable.get(AGG_VAR);
        String string5 = (String)hashtable.get(AGG_ARRAY);
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.aggCode) {
            object = "";
            stringBuffer.append(string3).append(" = new Vector();\n");
            for (Aggregation[] aggregationArray : this.SEDU) {
                object = aggregationArray.toJavaCode();
                stringBuffer.append("\t\t").append(string3).append(".addElement(").append((String)object).append(");\n");
            }
        } else {
            stringBuffer.append(string3).append(" = null;\n");
        }
        switch (this.addElement) {
            case 0: {
                object = this.append.getAggDesc();
                Object object2 = FormulatoJava.createAggDesc(string, (AggDesc)object);
                stringBuffer.append("\t\t").append(string4).append(" = Aggregation.makeAgg(").append((String)object2).append(");\n");
                if (this.append instanceof CompondAggregation) {
                    Aggregation[] aggregationArray;
                    aggregationArray = ((CompondAggregation)this.append).getUsedAggs();
                    stringBuffer.append("\t\t").append(string5).append(" = new Aggregation[").append(aggregationArray.length).append("];\n");
                    stringBuffer.append("\t\t").append(string5).append("[0] = ").append(string4).append(";\n");
                    for (int i = 1; i < aggregationArray.length; ++i) {
                        object = aggregationArray[i].getAggDesc();
                        object2 = FormulatoJava.createAggDesc(string, (AggDesc)object);
                        stringBuffer.append("\t\t").append(string5).append("[").append(i).append("] = ").append("Aggregation.makeAgg(").append((String)object2).append(");\n");
                    }
                    stringBuffer.append("\t\t((CompondAggregation)").append(string4).append(").setUsedAggs(").append(string5).append(");\n");
                }
                stringBuffer.append("\t\t").append(string2);
                stringBuffer.append("new MeasureExpression(").append(string3).append(", ").append(string4).append(");\n");
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                stringBuffer.append("\t\t").append(string2);
                stringBuffer.append("new MeasureExpression(").append(string3).append(", ").append(this.addElement).append(", \"").append(this.createAggDesc).append("\");\n");
            }
        }
        return stringBuffer.toString();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.addElement);
        dataOutputStream.writeBoolean(this.aggCode);
        if (!this.aggCode) {
            int n = this.SEDU.size();
            dataOutputStream.writeInt(n);
            for (Dimension dimension : this.SEDU) {
                dimension.write(dataOutputStream);
            }
        } else {
            dataOutputStream.writeInt(0);
        }
        switch (this.addElement) {
            case 0: {
                AggDesc aggDesc = this.append.getAggDesc();
                aggDesc.writeToStream(dataOutputStream);
                if (!(this.append instanceof CompondAggregation)) break;
                Aggregation[] aggregationArray = ((CompondAggregation)this.append).getUsedAggs();
                dataOutputStream.writeInt(aggregationArray.length);
                for (int i = 1; i < aggregationArray.length; ++i) {
                    aggDesc = aggregationArray[i].getAggDesc();
                    aggDesc.writeToStream(dataOutputStream);
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                dataOutputStream.writeUTF(this.createAggDesc);
            }
        }
    }

    public void read(DataInputStream dataInputStream, int n, int n2) throws IOException {
        this.addElement = dataInputStream.readInt();
        this.aggCode = dataInputStream.readBoolean();
        int n3 = 0;
        if (!this.aggCode) {
            n3 = dataInputStream.readInt();
            for (int i = 0; i < n3; ++i) {
                Dimension dimension = new Dimension();
                dimension.read(dataInputStream);
                this.SEDU.addElement(dimension);
            }
        } else {
            n3 = dataInputStream.readInt();
        }
        switch (this.addElement) {
            case 0: {
                AggDesc aggDesc = new AggDesc();
                aggDesc.readFromStream(dataInputStream, n, n2);
                this.append = Aggregation.makeAgg(aggDesc);
                if (!(this.append instanceof CompondAggregation)) break;
                int n4 = dataInputStream.readInt();
                Aggregation[] aggregationArray = new Aggregation[n4];
                aggregationArray[0] = this.append;
                for (int i = 1; i < n4; ++i) {
                    aggDesc = new AggDesc();
                    aggDesc.readFromStream(dataInputStream, n, n2);
                    aggregationArray[i] = Aggregation.makeAgg(aggDesc);
                }
                ((CompondAggregation)this.append).setUsedAggs(aggregationArray);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.createAggDesc = dataInputStream.readUTF();
            }
        }
    }

    public Object clone() {
        MeasureExpression measureExpression = new MeasureExpression();
        if (this.addElement == 0) {
            measureExpression.append = this.append.deepClone();
        }
        measureExpression.SEDU = this.SEDU;
        measureExpression.aggCode = this.aggCode;
        measureExpression.addElement = this.addElement;
        measureExpression.createAggDesc = this.createAggDesc;
        return measureExpression;
    }
}

