/*
 * Decompiled with CFR 0.152.
 */
package jet.formula.formulaExecutor;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDateTime;
import jet.connect.DbValue;
import jet.exception.FormulaSyntaxErrorException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.DataTypeDef;
import jet.formula.FormulaContainer;
import jet.formula.FormulatoJava;
import jet.formula.JetRptFormula;
import jet.formula.ParserOption;
import jet.formula.SymbolInfo;
import jet.formula.VarsTable;
import jet.formula.formulaExecutor.ExecFormulaFailedException;
import jet.formula.formulaExecutor.ExternalInfoProvider;
import jet.formula.syntaxtree.FormulaSymbol;
import jet.log.JRLogger;
import jet.parameter.runtime.TimeLineBasedFunctions;
import toolkit.db.version2.CallTrace;

public class FormulaContainerImpl
implements FormulaContainer {
    private static JRLogger IsDateTime = JRLogger.getLogger(FormulaContainerImpl.class.getName());
    private transient VarsTable SEDU = new VarsTable();
    private transient HashMap Z = new HashMap();
    private FormulatoJava addElement = new FormulatoJava("", null);
    private ParserOption currentTimeMillis;
    private TimeLineBasedFunctions equalsIgnoreCase;
    private static final String error = "Expression";
    Hashtable gVars = new Hashtable();

    public FormulaContainerImpl() {
        this.currentTimeMillis = new ParserOption();
        this.currentTimeMillis.setSupportGlobal(false);
        this.equalsIgnoreCase = new TimeLineBasedFunctions(new Timestamp(System.currentTimeMillis()));
    }

    public void addFormula(String string, String string2) {
        JetRptFormula jetRptFormula = null;
        if (this.Z.get(string) == null) {
            jetRptFormula = new JetRptFormula(string, string2, this);
            this.Z.put(string, jetRptFormula);
        }
    }

    @Override
    public VarsTable getGVarTable() {
        return this.SEDU;
    }

    @Override
    public void parseFormulas(boolean bl) throws ParseFormulaFailedException {
        this.parseFormulas();
    }

    public void parseFormulas() throws ParseFormulaFailedException {
        Vector<FormulaSyntaxErrorException> vector = new Vector<FormulaSyntaxErrorException>();
        int n = this.Z.size();
        JetRptFormula[] jetRptFormulaArray = (JetRptFormula[])this.Z.values().toArray();
        for (int i = 0; i < n; ++i) {
            try {
                jetRptFormulaArray[i].parseFormula(this.addElement);
                continue;
            }
            catch (FormulaSyntaxErrorException formulaSyntaxErrorException) {
                vector.addElement(formulaSyntaxErrorException);
            }
        }
        if (vector.size() > 0) {
            throw new ParseFormulaFailedException(vector);
        }
    }

    public boolean parseFormulaByName(String string) throws ParseFormulaFailedException {
        Vector<FormulaSyntaxErrorException> vector = new Vector<FormulaSyntaxErrorException>();
        JetRptFormula jetRptFormula = null;
        if (string != null) {
            jetRptFormula = (JetRptFormula)this.Z.get(string);
        }
        if (jetRptFormula == null) {
            return false;
        }
        try {
            jetRptFormula.parseFormula(this.addElement);
        }
        catch (FormulaSyntaxErrorException formulaSyntaxErrorException) {
            vector.addElement(formulaSyntaxErrorException);
        }
        if (vector.size() > 0) {
            throw new ParseFormulaFailedException(vector);
        }
        return true;
    }

    public boolean isDatetimeConstant(String string) {
        DbBit dbBit = this.equalsIgnoreCase.IsDateTime(new DbChar(string));
        return dbBit.value;
    }

    public boolean parseFormulaByExp(String string) throws ParseFormulaFailedException {
        Vector<FormulaSyntaxErrorException> vector = new Vector<FormulaSyntaxErrorException>();
        if (null == string) {
            IsDateTime.error("Call parseFormulaByExp(..) with wrong argument: strExpression = null!", new CallTrace());
        }
        JetRptFormula jetRptFormula = new JetRptFormula(error, string, this);
        try {
            if (null == string) {
                throw new FormulaSyntaxErrorException("", "Expression should not be null!");
            }
            jetRptFormula.parseFormula(this.addElement);
        }
        catch (FormulaSyntaxErrorException formulaSyntaxErrorException) {
            vector.addElement(formulaSyntaxErrorException);
        }
        if (vector.size() > 0) {
            throw new ParseFormulaFailedException(vector);
        }
        return true;
    }

    public DbValue executeFormulaByName(String string, ExternalInfoProvider externalInfoProvider) throws ParseFormulaFailedException, ExecFormulaFailedException {
        JetRptFormula jetRptFormula = null;
        if (string != null) {
            jetRptFormula = (JetRptFormula)this.Z.get(string);
        }
        if (jetRptFormula == null) {
            return null;
        }
        Vector<FormulaSyntaxErrorException> vector = new Vector<FormulaSyntaxErrorException>();
        try {
            FormulaSymbol formulaSymbol = (FormulaSymbol)jetRptFormula.getFormulaInfo(this.addElement).getSyntaxTree();
            if (null != this.equalsIgnoreCase) {
                if (null != externalInfoProvider) {
                    this.equalsIgnoreCase.setTimeBaseLine(externalInfoProvider.getTimeBaseLine());
                    this.equalsIgnoreCase.setSelectedDate(externalInfoProvider.getSelectedDate());
                }
                formulaSymbol.setBuiltInFunctions(this.equalsIgnoreCase);
            }
            return formulaSymbol.evaluate();
        }
        catch (FormulaSyntaxErrorException formulaSyntaxErrorException) {
            vector.addElement(formulaSyntaxErrorException);
        }
        catch (ExecFormulaFailedException execFormulaFailedException) {
            throw execFormulaFailedException;
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[]{jetRptFormula.getExpression()};
            throw new ExecFormulaFailedException(76304, objectArray, throwable);
        }
        if (vector.size() > 0) {
            throw new ParseFormulaFailedException(vector);
        }
        return null;
    }

    public DbValue executeFormulaByName(String string) throws ParseFormulaFailedException, ExecFormulaFailedException {
        return this.executeFormulaByName(string, null);
    }

    public DbValue executeFormulaByExp(String string) throws ParseFormulaFailedException, ExecFormulaFailedException {
        return this.executeFormulaByExp(string, null);
    }

    public DbValue executeFormulaByExp(String string, ExternalInfoProvider externalInfoProvider) throws ParseFormulaFailedException, ExecFormulaFailedException {
        if (null == string) {
            IsDateTime.error("Call executeFormulaByExp(..) with wrong argument: strExpression = null!", new CallTrace());
        }
        JetRptFormula jetRptFormula = new JetRptFormula(error, string, this);
        Vector<FormulaSyntaxErrorException> vector = new Vector<FormulaSyntaxErrorException>();
        try {
            if (null == string) {
                throw new FormulaSyntaxErrorException("", "Expression should not be null!");
            }
            FormulaSymbol formulaSymbol = (FormulaSymbol)jetRptFormula.getFormulaInfo(this.addElement).getSyntaxTree();
            if (null != this.equalsIgnoreCase) {
                if (null != externalInfoProvider) {
                    this.equalsIgnoreCase.setTimeBaseLine(externalInfoProvider.getTimeBaseLine());
                    this.equalsIgnoreCase.setSelectedDate(externalInfoProvider.getSelectedDate());
                }
                formulaSymbol.setBuiltInFunctions(this.equalsIgnoreCase);
            }
            return formulaSymbol.evaluate();
        }
        catch (FormulaSyntaxErrorException formulaSyntaxErrorException) {
            vector.addElement(formulaSyntaxErrorException);
        }
        catch (ExecFormulaFailedException execFormulaFailedException) {
            throw execFormulaFailedException;
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[]{string};
            throw new ExecFormulaFailedException(225020, objectArray, throwable);
        }
        if (vector.size() > 0) {
            throw new ParseFormulaFailedException(vector);
        }
        return null;
    }

    public DbValue executeFormulaByExp(String string, ExternalInfoProvider externalInfoProvider, String string2) throws ParseFormulaFailedException, ExecFormulaFailedException {
        DbValue dbValue = this.executeFormulaByExp(string, externalInfoProvider);
        DbDateTime dbDateTime = null;
        if (string2.equalsIgnoreCase("Date")) {
            dbDateTime = (DbDateTime)DataTypeDef.makeData(6);
        } else if (string2.equalsIgnoreCase("DateTime")) {
            dbDateTime = (DbDateTime)DataTypeDef.makeData(8);
        } else if (string2.equalsIgnoreCase("Time")) {
            dbDateTime = (DbDateTime)DataTypeDef.makeData(7);
        } else {
            return dbValue;
        }
        if (!(dbValue instanceof DbDateTime)) {
            throw new ExecFormulaFailedException(76304, (Object[])new String[]{string}, null);
        }
        dbDateTime.set(dbValue);
        dbValue = dbDateTime;
        return dbValue;
    }

    @Override
    public JetRptFormula getFormula(String string) {
        return (JetRptFormula)this.Z.get(string);
    }

    @Override
    public SymbolInfo getParameterType(String string) {
        return null;
    }

    @Override
    public DbColDesc getDbSQLType(String string) {
        return null;
    }

    @Override
    public ParserOption getParserOption() {
        return this.currentTimeMillis;
    }

    @Override
    public SymbolInfo getMeasure(String string) {
        return null;
    }

    @Override
    public Hashtable getGlobalVarContainer() {
        return this.gVars;
    }
}

