/*
 * Decompiled with CFR 0.152.
 */
package jet.formula.javacompiler;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import jet.ReportEnv;
import jet.formula.javacompiler.JavaCompiler;
import jet.formula.javacompiler.StreamGobbler;
import jet.log.JRLogger;
import jet.universe.exception.GenerateFormulasCodeException;

public class CommandLineJavaCompiler
implements JavaCompiler {
    private static JRLogger SEDU = JRLogger.getLogger(CommandLineJavaCompiler.class.getName());
    private String add = System.getProperty("javac_path");
    private String append;

    protected String scanDir4Javac(String string) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        String[] stringArray = new File(string).list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            String string3 = stringArray[i];
            File file = new File(string + string3);
            if (file.isDirectory()) {
                string2 = this.scanDir4Javac(file.getAbsolutePath());
                if (string2 == null) continue;
                return string2;
            }
            if (string3.indexOf(46) <= 0 || !(string2 = string3.substring(0, string3.indexOf(46))).equalsIgnoreCase("javac")) continue;
            return string + string3;
        }
        return null;
    }

    protected String scan4Javac() {
        String string = System.getProperty("java.home");
        String string2 = "";
        if (SEDU.isDebugEnabled()) {
            SEDU.info("scan4Javac #1: java.home = " + string);
        }
        if (!string.endsWith("java")) {
            try {
                if (string.endsWith("jre")) {
                    string = string.substring(0, string.length() - 3);
                    string2 = string + "bin" + File.separator;
                }
                if (string.indexOf("java") == -1) {
                    if (SEDU.isDebugEnabled()) {
                        SEDU.info("scan4Javac #2: Java Home get error.");
                    }
                    throw new Exception("Java Home get error");
                }
                int n = string.indexOf("java");
                string = string.substring(0, n + 4);
                string2 = string + File.separator + "bin" + File.separator;
            }
            catch (Exception exception) {
                SEDU.error(exception);
                return null;
            }
        } else {
            string2 = string + File.separator + "bin" + File.separator;
        }
        string2 = string2 + "javac";
        if (SEDU.isDebugEnabled()) {
            SEDU.info("scan4Javac #3: javacPath = " + string2);
        }
        return string2;
    }

    public CommandLineJavaCompiler(String string) {
        if (this.add == null) {
            this.add = this.scan4Javac();
        }
        this.append = string;
    }

    public CommandLineJavaCompiler() {
        this(ReportEnv.getTemporaryPath());
    }

    @Override
    public String[] compileJavaFile(String[] stringArray) throws GenerateFormulasCodeException {
        String[] stringArray2 = null;
        if (this.add == null) {
            stringArray2 = new String[]{"Unable to find command line compiler 'javac'."};
            return stringArray2;
        }
        String[] stringArray3 = new String[stringArray.length + 1];
        stringArray3[0] = this.add;
        System.arraycopy(stringArray, 0, stringArray3, 1, stringArray.length);
        String string = "The compile cmd:";
        for (int i = 0; i < stringArray3.length; ++i) {
            string = string + " " + stringArray3[i];
        }
        SEDU.debug(string);
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(stringArray3);
        }
        catch (IOException iOException) {
            throw new GenerateFormulasCodeException(iOException.getMessage());
        }
        Vector<String> vector = new Vector<String>();
        try {
            StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream(), vector);
            StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream(), vector);
            streamGobbler.start();
            streamGobbler2.start();
            int n = process.waitFor();
            SEDU.info("Compiling process returns: " + n);
        }
        catch (Exception exception) {
            SEDU.error("Get exception when compiling java: ", exception);
            vector.add(exception.getMessage());
        }
        if (vector.size() > 0) {
            stringArray2 = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray2[i] = (String)vector.elementAt(i);
            }
        }
        return stringArray2;
    }
}

