/*
 * Decompiled with CFR 0.152.
 */
package jet.formula.syntaxtree;

import java.util.ArrayList;
import jet.connect.DbValue;
import jet.formula.fArray;
import jet.formula.fBoolArray;
import jet.formula.fCurArray;
import jet.formula.fDateArray;
import jet.formula.fDateTimeArray;
import jet.formula.fIntArray;
import jet.formula.fNumArray;
import jet.formula.fStrArray;
import jet.formula.fTimeArray;
import jet.formula.formulaExecutor.ExecFormulaFailedException;
import jet.formula.syntaxtree.ArrayElements;
import jet.formula.syntaxtree.Expression;
import jet.formula.syntaxtree.NonterminalSymbol;
import jet.formula.syntaxtree.Symbol;

public class ArraySymbol
extends NonterminalSymbol {
    private ArrayElements I;

    public ArraySymbol() {
        this.symbolType = 13;
        this.I = new ArrayElements();
    }

    public ArraySymbol(ArrayElements arrayElements) {
        this.symbolType = 13;
        this.I = arrayElements;
        this.I.setParent(this);
    }

    public void insertElement(Expression expression) {
        this.I.insertElement(expression);
    }

    public Expression get(int n) {
        return (Expression)this.I.get(n);
    }

    public ArrayList getElements() {
        return this.I.getElements();
    }

    @Override
    public void setContext(Symbol symbol, Symbol symbol2) {
        this.theContext = symbol;
        this.scope = symbol2;
        this.I.setContext(symbol, symbol2);
        this.dataType = this.I.dataType;
    }

    @Override
    public DbValue evaluate() throws ExecFormulaFailedException {
        fArray fArray2 = null;
        int n = this.I.size();
        switch (this.dataType) {
            case 1: {
                fArray2 = new fIntArray(n);
                break;
            }
            case 2: {
                fArray2 = new fNumArray(n);
                break;
            }
            case 3: {
                fArray2 = new fCurArray(n);
                break;
            }
            case 5: {
                fArray2 = new fStrArray(n);
                break;
            }
            case 6: {
                fArray2 = new fDateArray(n);
                break;
            }
            case 7: {
                fArray2 = new fTimeArray(n);
                break;
            }
            case 8: {
                fArray2 = new fDateTimeArray(n);
                break;
            }
            case 4: {
                fArray2 = new fBoolArray(n);
            }
        }
        for (int i = 0; i < n; ++i) {
            fArray2.value[i] = this.I.get(i).evaluate();
        }
        return fArray2;
    }

    @Override
    public String toString(boolean bl) {
        return "[" + this.I.toString(bl) + "]";
    }

    @Override
    public String createJavaCode() {
        return "";
    }
}

