/*
 * Decompiled with CFR 0.152.
 */
package jet.formula.syntaxtree;

import jet.connect.DbValue;
import jet.formula.formulaExecutor.ExecFormulaFailedException;
import jet.formula.syntaxtree.ConstantExpression;
import jet.formula.syntaxtree.FormulaSymbol;
import jet.formula.syntaxtree.NonterminalSymbol;
import jet.formula.syntaxtree.Symbol;

public class SpecialVariable
extends NonterminalSymbol {
    public static final int FORMULA = 0;
    public static final int DBFIELD = 1;
    public static final int PARAMETER = 2;
    public static final int MEASURE = 3;
    public static final int CTF = 4;
    private ConstantExpression SEDU;

    public SpecialVariable(String string) {
        this.symbolType = 14;
        this.name = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setMember(ConstantExpression constantExpression) {
        this.SEDU = constantExpression;
    }

    public ConstantExpression getMember() {
        return this.SEDU;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setDatatype(int n) {
        this.dataType = n;
    }

    @Override
    public void setContext(Symbol symbol, Symbol symbol2) {
        this.theContext = symbol;
        this.scope = symbol2;
        ((FormulaSymbol)symbol).addSpecialVariable(this);
    }

    @Override
    public DbValue evaluate() throws ExecFormulaFailedException {
        DbValue dbValue = null;
        FormulaSymbol formulaSymbol = (FormulaSymbol)this.theContext;
        switch (this.type) {
            case 0: {
                FormulaSymbol formulaSymbol2 = formulaSymbol.getReferencedFormula(this.name);
                dbValue = formulaSymbol2.evaluate();
                break;
            }
            case 1: {
                dbValue = formulaSymbol.getDBField(this.name);
                break;
            }
            case 2: {
                dbValue = formulaSymbol.getParameter(this.name);
            }
        }
        return dbValue;
    }

    @Override
    public String toString(boolean bl) {
        return "@\"" + this.name + "\"";
    }

    @Override
    public String createJavaCode() {
        return "";
    }

    public Object clone() {
        SpecialVariable specialVariable = new SpecialVariable(this.name);
        specialVariable.setDatatype(this.dataType);
        specialVariable.setType(this.type);
        if (this.theContext != null) {
            specialVariable.setContext(this.theContext, this.scope);
        }
        specialVariable.SEDU = this.SEDU;
        return specialVariable;
    }
}

