/*
 * Decompiled with CFR 0.152.
 */
package jet.formula.syntaxtree;

import jet.connect.DbBigInt;
import jet.connect.DbBit;
import jet.connect.DbDouble;
import jet.connect.DbValue;
import jet.formula.fCurrency;
import jet.formula.formulaExecutor.ExecFormulaFailedException;
import jet.formula.syntaxtree.Expression;
import jet.formula.syntaxtree.Operator;
import jet.formula.syntaxtree.Symbol;

public class UnaryExpression
extends Expression {
    protected int operatorID;
    protected Expression expOne;

    @Override
    public int getOperator() {
        return this.operatorID;
    }

    public UnaryExpression(Expression expression, int n) {
        super(1);
        this.operatorID = n;
        this.expOne = expression;
        this.expOne.setParent(this);
        this.dataType = this.expOne.getDataType();
    }

    @Override
    public Expression getOperand() {
        return this.expOne;
    }

    @Override
    public void setContext(Symbol symbol, Symbol symbol2) {
        super.setContext(symbol, symbol2);
        this.expOne.setContext(symbol, symbol2);
        this.dataType = this.operatorID == 2 ? 4 : this.expOne.dataType;
    }

    @Override
    public DbValue evaluate() throws ExecFormulaFailedException {
        this.theDbValue = this.expOne.evaluate();
        switch (this.operatorID) {
            case 1: {
                if (this.theDbValue instanceof DbBigInt) {
                    ((DbBigInt)this.theDbValue).value = -((DbBigInt)this.theDbValue).value;
                    break;
                }
                if (this.theDbValue instanceof DbDouble) {
                    ((DbDouble)this.theDbValue).value = -((DbDouble)this.theDbValue).value;
                    break;
                }
                if (!(this.theDbValue instanceof fCurrency)) break;
                ((fCurrency)this.theDbValue).value = ((fCurrency)this.theDbValue).value.negate();
                break;
            }
            case 2: {
                ((DbBit)this.theDbValue).value = !((DbBit)this.theDbValue).value;
            }
        }
        return this.theDbValue;
    }

    @Override
    public String toString(boolean bl) {
        String string = "";
        if (bl && this.canBePushDown) {
            string = this.replacedName;
        } else {
            String string2 = this.expOne.toString(bl);
            if (this.expOne.getType() != 0 && this.expOne.getType() != 7 && this.expOne.getType() != 9) {
                string2 = "(" + string2 + ")";
            }
            string = Operator.operIDToString(this.operatorID) + string2;
        }
        return string;
    }

    @Override
    public String createJavaCode() {
        return "";
    }
}

