/*
 * Decompiled with CFR 0.152.
 */
package jet.formula.syntaxtree;

import java.util.ArrayList;
import jet.connect.DbValue;
import jet.formula.DataTypeDef;
import jet.formula.formulaExecutor.ExecFormulaFailedException;
import jet.formula.syntaxtree.NonterminalSymbol;
import jet.formula.syntaxtree.Symbol;
import jet.formula.syntaxtree.Variable;

public class VariableList
extends NonterminalSymbol {
    private ArrayList I = new ArrayList();

    public VariableList() {
        this.symbolType = 9;
    }

    public void addVariable(Symbol symbol) {
        if (((Variable)symbol).isGlobal()) {
            this.globalVars.put(symbol.getName(), symbol);
        }
        this.I.add(symbol);
        symbol.setParent(this);
    }

    public ArrayList getVariables() {
        return this.I;
    }

    @Override
    public void setContext(Symbol symbol, Symbol symbol2) {
        super.setContext(symbol, symbol2);
        int n = this.I.size();
        Variable variable = null;
        for (int i = 0; i < n; ++i) {
            variable = (Variable)this.I.get(i);
            variable.setContext(symbol, symbol2);
        }
        this.dataType = variable.dataType;
    }

    @Override
    public String toString(boolean bl) {
        String string = "";
        Variable variable = null;
        int n = this.I.size();
        String string2 = null;
        String string3 = "";
        String string4 = "";
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            string4 = "";
            variable = (Variable)this.I.get(i);
            n2 = variable.getDataType();
            if (DataTypeDef.isArray(n2)) {
                n2 -= 11;
                string3 = "[]";
            } else if (DataTypeDef.isRange(n2)) {
                n2 -= 22;
                string3 = " range ";
            } else {
                string3 = "";
            }
            string2 = DataTypeDef.toString(n2);
            string2 = string2.toLowerCase();
            string2 = string2.substring(1, string2.length() - 1);
            string2 = string2 + string3;
            string4 = string4 + string2 + " " + variable.toString(bl);
            if (variable.isGlobal()) {
                string4 = " global " + string4;
            }
            if (variable.getRightValue() != null) {
                string4 = string4 + " = " + variable.getRightValue().toString(bl);
            }
            string = string + string4;
            string = i < n - 1 ? string + ";" : string + "";
        }
        return string;
    }

    @Override
    public DbValue evaluate() throws ExecFormulaFailedException {
        Variable variable = null;
        int n = this.I.size();
        for (int i = 0; i < n; ++i) {
            variable = (Variable)this.I.get(i);
            if (variable.getRightValue() != null) {
                variable.setValue(variable.getRightValue().evaluate());
            }
            if (!variable.isGlobal()) continue;
            String string = variable.getName();
            Variable variable2 = (Variable)this.theContext.getVariable(string);
            variable2.setValue(variable.evaluate());
        }
        variable = (Variable)this.I.get(n - 1);
        return variable.evaluate();
    }

    @Override
    public String createJavaCode() {
        String string = "";
        Variable variable = null;
        int n = this.I.size();
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            variable = (Variable)this.I.get(i);
            string2 = DataTypeDef.typeClass[variable.getDataType()];
            string = string + string2 + " " + variable.toString(false) + " = new " + string2 + "();";
            if (variable.getRightValue() == null) continue;
            string = string + "\n" + variable.getName() + ".set( " + variable.getRightValue().createJavaCode() + ");";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

