/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.resstore.OutOfSpaceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jet.JRStopEngineException;
import jet.datastream.Communicator;
import jet.export.ExportAuxInfo;
import jet.ie.PJFAux;
import jet.ie.RSTExporter;
import jet.ie.RSTWriteTool;
import jet.ie.VersionException;
import jet.util.FileUtil;

public abstract class AbstractRSTExporter
implements RSTExporter {
    public static final byte[] PJF_TAG = PJFAux.PJF_TAG;
    public static final int PJF_VER_NO = 264448;
    public static final long UDTRevNo = 1311768467294899695L;
    public static final int UDTVerNo = 4386;
    public static final String SUF_STRING = ".rst";
    public static final String WST_SUF = ".wst";
    protected String _fileName;
    protected Hashtable _communicators = new Hashtable();
    protected Vector allNLSManagers = new Vector();
    protected Hashtable mainNLSManagerIndices = new Hashtable();
    protected List allNLSMaps = new ArrayList();
    protected String _catalogPath;
    protected Map _mapInfo;
    protected Map _attachInfo;
    protected boolean _isZipRst = false;
    protected RSTWriteTool rstTool = new RSTWriteTool();
    protected ExportAuxInfo auxInfo;

    public AbstractRSTExporter(ExportAuxInfo exportAuxInfo) {
        this.auxInfo = exportAuxInfo;
    }

    @Override
    public abstract void setCommunicators(String var1, String var2, Communicator var3) throws VersionException;

    @Override
    public void setFileName(String string) throws VersionException {
        this._fileName = string.endsWith(SUF_STRING) || string.endsWith(WST_SUF) ? string : string + SUF_STRING;
    }

    @Override
    public void setReportInfos(Map map) {
        this._mapInfo = map;
    }

    @Override
    public void setReportAttachInfos(Map map) {
        this._attachInfo = map;
    }

    @Override
    public void setCatalogPath(String string) {
        this._catalogPath = string;
    }

    @Override
    public void zipRST(boolean bl) {
        this._isZipRst = bl;
    }

    @Override
    public void clear() {
        this._communicators.clear();
        this._communicators = null;
        this.allNLSManagers.clear();
        this.allNLSManagers = null;
        this.mainNLSManagerIndices.clear();
        this.mainNLSManagerIndices = null;
        this.allNLSMaps.clear();
        this.allNLSMaps = null;
        this._mapInfo.clear();
        this._mapInfo = null;
        this._attachInfo.clear();
        this._attachInfo = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipFile(String string) throws IOException, OutOfSpaceException {
        File file;
        File file2 = this.auxInfo.getDiskStore().createTempFile("jrst", ".temp");
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        try {
            file = new File(string);
            ZipEntry zipEntry = new ZipEntry(file.getName());
            long l = file.length();
            byte[] byArray = new byte[(int)l];
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                l = fileInputStream.read(byArray);
            }
            finally {
                fileInputStream.close();
            }
            zipEntry.setSize(l);
            zipEntry.setComment(file.getName());
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byArray, 0, (int)l);
            zipOutputStream.closeEntry();
            this.auxInfo.getDiskStore().delete(file);
        }
        finally {
            zipOutputStream.close();
            fileOutputStream.close();
            this.auxInfo.getDiskStore().fileUpdated(file2);
        }
        file = this.auxInfo.getDiskStore().createFile(string);
        FileUtil.copy(file2, file);
        this.auxInfo.getDiskStore().fileUpdated(file);
        this.auxInfo.getDiskStore().delete(file2);
    }

    @Override
    public abstract void saveRSTFile() throws VersionException, JRStopEngineException;

    protected void addNLSManagers(String string, Collection arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        this.mainNLSManagerIndices.put(string, new int[]{this.allNLSManagers.size(), arrayList.size()});
        this.allNLSManagers.addAll(arrayList);
    }
}

