/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import jet.connect.DbBuffer;
import jet.connect.DbColDesc;
import jet.connect.DbRecordModel;
import jet.connect.Groupable;
import jet.connect.NDbBuffer;
import jet.dataengine.util.DSLog;
import jet.ie.ResultSetAdapterDbBuffer;
import jet.util.RAFile;

public class LoadCQR2ResultSet {
    public static final String BLOB_FILE_EXTENSION = ".col";
    public static final String DESCRIPTION_FILE_EXTENSION = ".desc";
    private static final boolean Read = true;
    private final DSLog SEDU = DSLog.getDSLog(this.getClass().getName());

    public ResultSet loadCQR(String[] stringArray) throws IOException {
        this.SEDU.debug("load cqr");
        ArrayList arrayList = new ArrayList();
        if (stringArray.length > 0) {
            String string = stringArray[0];
            RAFile rAFile = new RAFile(string + DESCRIPTION_FILE_EXTENSION, "r");
            this.SEDU.debug("data file:" + string);
            File file = new File(string);
            this.SEDU.debug("desc file:" + string + DESCRIPTION_FILE_EXTENSION);
            DbRecordModel dbRecordModel = this.Read(rAFile);
            int n = rAFile.readInt();
            Hashtable hashtable = this.SEDU(string, dbRecordModel);
            DbBuffer dbBuffer = this.append(file, dbRecordModel, hashtable, n);
            ResultSetAdapterDbBuffer resultSetAdapterDbBuffer = new ResultSetAdapterDbBuffer(dbBuffer, arrayList);
            resultSetAdapterDbBuffer.setBufferType(true);
            this.SEDU.debug("load cqr over");
            rAFile.close();
            return resultSetAdapterDbBuffer;
        }
        return null;
    }

    private DbRecordModel Read(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        DbRecordModel dbRecordModel = null;
        if (n != 0) {
            DbColDesc[] dbColDescArray = new DbColDesc[n];
            for (int i = 0; i < dbColDescArray.length; ++i) {
                dbColDescArray[i] = new DbColDesc(dataInput.readUTF(), dataInput.readInt(), dataInput.readInt(), dataInput.readInt(), dataInput.readInt());
                dbColDescArray[i].setFlag(dataInput.readInt());
                dbColDescArray[i].setEncodingName(dataInput.readUTF());
            }
            dbRecordModel = new DbRecordModel(dbColDescArray, (Groupable)null);
        }
        return dbRecordModel;
    }

    private Hashtable SEDU(String string, DbRecordModel dbRecordModel) {
        Hashtable<DbColDesc, RAFile> hashtable = new Hashtable<DbColDesc, RAFile>();
        try {
            DbColDesc[] dbColDescArray = dbRecordModel.getColDescs();
            for (int i = 0; i < dbColDescArray.length; ++i) {
                if (dbColDescArray[i].getSqlType() != -1 && dbColDescArray[i].getSqlType() != -4 && dbColDescArray[i].getSqlType() != 2005 && dbColDescArray[i].getSqlType() != 2004 && !dbColDescArray[i].isArray()) continue;
                String string2 = string + BLOB_FILE_EXTENSION + i;
                RAFile rAFile = new RAFile(string2, "r");
                hashtable.put(dbColDescArray[i], rAFile);
                this.SEDU.debug(" Col Name: " + dbColDescArray[i].getColName() + " Col Idx: " + i + " File Name: " + string2 + " File Length: " + rAFile.length());
            }
        }
        catch (IOException iOException) {
            String string3 = iOException.getMessage();
            this.SEDU.debug("CAT_CQR_EXCP_3.occur error:" + (string3 != null ? string3 : ""));
        }
        return hashtable;
    }

    private DbBuffer append(File file, DbRecordModel dbRecordModel, Hashtable hashtable, int n) throws IOException {
        NDbBuffer nDbBuffer = new NDbBuffer(dbRecordModel, file, hashtable, n);
        nDbBuffer.Read();
        return nDbBuffer;
    }
}

