/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import java.io.UTFDataFormatException;
import jet.connect.DbBuffer;
import jet.connect.DbColDesc;

public class PJFAux {
    public static final byte[] PJF_TAG = new byte[]{80, 74, 70};
    public static final String DEFAULT_ENCODING = "8859_1";
    public static final int BooleanSize = 1;
    public static final int ByteSize = 1;
    public static final int UnsignedByteSize = 1;
    public static final int ShortSize = 2;
    public static final int UnsignedShortSize = 2;
    public static final int IntSize = 4;
    public static final int LongSize = 8;
    public static final int FloatSize = 4;
    public static final int DoubleSize = 8;
    public static final int OffsetSize = 8;
    public static final int UTCSize = 8;
    public static final int NanosSize = 4;
    public static final int BufferSize = 4096;
    public static final int NOSECURITY = 0;
    public static final int HasCLS = 1;
    public static final int HasPLS = 2;
    public static final int HasRLS = 4;
    static String spaces = "                                                        ";

    public static int UTFSize(String string) throws UTFDataFormatException {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        return n2 + 2;
    }

    public static boolean isBlobCol(int n) {
        switch (n) {
            case -4: 
            case -1: {
                return true;
            }
        }
        return false;
    }

    public static int getColLength(DbColDesc dbColDesc) {
        int n = dbColDesc.getSqlType();
        switch (n) {
            case -3: 
            case -2: 
            case 1: 
            case 12: {
                return 2 + dbColDesc.getPrecision();
            }
            case 2: 
            case 3: {
                dbColDesc.bigDecimalLength = DbBuffer.decimalNeedBytes(dbColDesc);
                return 2 + dbColDesc.bigDecimalLength;
            }
            case -7: {
                return 1;
            }
            case -6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return 8;
            }
            case 7: {
                return 4;
            }
            case 6: 
            case 8: {
                return 8;
            }
            case -4: 
            case -1: {
                return 8;
            }
            case 91: 
            case 92: {
                return 8;
            }
            case 93: {
                return 12;
            }
        }
        throw new RuntimeException("cannot support SQL type:" + n);
    }

    public static String indent(int n) {
        return spaces.substring(0, n * 4);
    }
}

