/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jet.dataengine.api.group.pls.PLSObj;
import jet.dataengine.api.group.pls.PLSProcessor;
import jet.export.ExportAuxInfo;
import jet.ie.AbstractRSDLoader;
import jet.ie.CLSInfo;
import jet.ie.IndexInfos;
import jet.ie.RSDTools;
import jet.ie.VersionException;
import jet.ie.io.PJFDataInput;
import jet.reportset.JetRptReportSet;
import jet.universe.JetUUniverse;
import jet.util.FileUtil;
import jet.util.JFieldValueNLSManager;
import jet.util.JRInterruptedException;
import jet.util.NLSResourceBundleManager;
import jet.util.RAFInputStream;
import jet.util.RAFile;

public class PRSDLoadControler
extends AbstractRSDLoader {
    public static final String DATASETSTATE = "dataSetState";
    public static final String DATAPERMTAB = "dataPermTab";
    public static final String RECORDINDEXS = "recordIndex";
    private static final String I = "resource";
    public static final String NLSRESOURCE = "NLSResource";
    private Hashtable LoadNoCache;
    private Hashtable SEDU;
    private Hashtable Z;
    private Hashtable add;
    private Map append;
    private Map clear;
    private String close;
    public Map _datasetMapping;
    protected IndexInfos _indexInfo;
    protected File _file;
    private String containsKey;
    private Map copy;

    public PRSDLoadControler(String string, ExportAuxInfo exportAuxInfo) {
        super(exportAuxInfo);
        this._file = new File(string);
        this._rsdTools = new RSDTools(this._file.getParent(), exportAuxInfo);
        this._fileName = string;
        this._reportSet = new Hashtable();
        this._rsdTools.setCompression(this._isZip, this.bufferSize);
        this.copy = new Hashtable();
    }

    @Override
    public synchronized void openFile() throws VersionException {
        try {
            this._raf = new RAFile(this._fileName, "r");
            this._in = new PJFDataInput(new RAFInputStream(this._raf));
            this.loadHeader();
            this._in.setVersion(this._versionNumber);
            this._rsdTools.setCompression(this._isZip, this.bufferSize);
            long l = this._raf.readLong();
            this._datasetMapping = this._rsdTools.loadMapInfoForString(this._raf);
            this._raf.seek(l);
            this.addressTable = this.readAddressTable();
            this._reportNames = this.getReportNames();
            this.jrReportSet = new JetRptReportSet[this._reportNames.length];
            this.reportSetAddressTable = this.readSubBlockAddressTableH("ReportSets");
            this.Z = this.readSubBlockAddressTableH(DATAPERMTAB);
            this.add = this.readSubBlockAddressTableH(RECORDINDEXS);
            this.append = this.I("ResultSets");
            this._raf.seek((Long)this.addressTable.get(I));
            this.containsKey = this._raf.readUTF();
            if (this._versionNumber < 132944 || this._versionNumber > 132944 && this._versionNumber < 133120) {
                this.copy = this.I(NLSRESOURCE);
            }
            this._raf.seek((Long)this.addressTable.get(DATASETSTATE));
            this.clear = this._rsdTools.loadMapInfoForInteger(this._raf);
            this._raf.seek((Long)this.addressTable.get("Universe"));
            this.close = this._file.getParent() + File.separator + this._raf.readUTF();
            this._precisions = this.getPrecisions();
            this._clsInfos = this.getClsInfos();
            this._permissions = this.getPermissions();
            this._indexInfo = this.LoadNoCache();
            this._parameter = this.getParameters();
            this._rptInfos = this.loadRptInfo();
            this._dataSetInfo = this.loadDataSetInfo();
            if (this._versionNumber >= 131841) {
                this._parameterFormValue = this.readParameterFormValue();
                this._parameterFormNames = this.readParameterFormNames();
            }
            if (this._versionNumber >= 131888 || this._versionNumber == 131845) {
                this._locale = this.readLocale();
            }
            if (this._versionNumber >= 133120) {
                this.metaNLS = this.readMetaNLS();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407315, (Throwable)fileNotFoundException);
            }
            throw new VersionException(407315, new Object[]{this._fileName}, (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407303, (Throwable)iOException);
            }
            throw new VersionException(407303, (Throwable)iOException);
        }
    }

    private Map I(String string) throws VersionException {
        Map map = new Hashtable();
        try {
            this._raf.seek((Long)this.addressTable.get(string));
            long l = this._raf.readLong();
            this._raf.seek(l);
            map = this._rsdTools.loadMapInfoForString(this._raf);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407319, (Throwable)iOException);
            }
            throw new VersionException(407323, (Throwable)iOException);
        }
        return map;
    }

    public synchronized ResultSet getResultSet(int n, String string) throws VersionException {
        String string2 = this._rsdTools.getKey(n, string);
        String string3 = "";
        while (this._datasetMapping.containsKey(string2)) {
            string2 = (String)this._datasetMapping.get(string2);
        }
        string3 = string2;
        String string4 = this._rsdTools.tempPath + File.separator + (String)this.append.get(string3);
        if (string4 != null && string4.length() > 0) {
            try {
                RAFile rAFile = new RAFile(string4, "r");
                PJFDataInput pJFDataInput = new PJFDataInput(new RAFInputStream(rAFile));
                return this._rsdTools.loadResultSet(pJFDataInput, this._versionNumber, this._flag);
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2407304, (Throwable)jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2407304, (Throwable)exception);
                }
                throw new VersionException(407304, (Throwable)exception);
            }
        }
        throw new VersionException(407304);
    }

    @Override
    public synchronized JetUUniverse getUniverse() throws VersionException {
        if (this._universe != null) {
            return this._universe;
        }
        try {
            this._universe = JetUUniverse.LoadNoCache(this.close);
            this._universe.setFullFileName(new File(this.close));
            if (this._locale != null) {
                if (this._versionNumber == 132944 || this._versionNumber >= 133120) {
                    this._raf.seek((Long)this.addressTable.get("Universe"));
                    this._raf.readUTF();
                    JFieldValueNLSManager[] jFieldValueNLSManagerArray = this._rsdTools.loadCatalogLevelNLS(this._in, new File(this.close).getParent() + File.separator, this.NLSFiles);
                    if (jFieldValueNLSManagerArray != null) {
                        this._universe.getNLSManager(this._locale).putContents(jFieldValueNLSManagerArray[0]);
                    }
                } else {
                    String string = new File(this.close).getParent() + File.separator;
                    Iterator iterator = this.copy.values().iterator();
                    while (iterator.hasNext()) {
                        String string2 = this._file.getParent() + File.separator + (String)iterator.next();
                        Map<String, List<File>> map = NLSResourceBundleManager.getNLSResourcePrefixToFileMapping(new File(string2), this._locale);
                        for (List<File> list : map.values()) {
                            for (int i = 0; i < list.size(); ++i) {
                                File file = list.get(i);
                                if (!file.exists()) continue;
                                File file2 = new File(string + file.getName());
                                this.auxInfo.getDiskStore().fileUpdated(file2);
                                FileUtil.copy(file, file2);
                                this.auxInfo.getDiskStore().fileUpdated(file2);
                                this.NLSFiles.add(file2.getAbsolutePath());
                                if (!JRLog.isTrace(6)) continue;
                                JRLog.trace(6, "A nls property file " + file2.getName() + " is copied to the catalog folder.");
                            }
                        }
                    }
                }
            }
            return this._universe;
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407305, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407305, (Throwable)exception);
            }
            throw new VersionException(407305, (Throwable)exception);
        }
    }

    public synchronized int getDataSetStatus(int n, String string) throws VersionException {
        try {
            String string2 = this._rsdTools.getKey(n, string);
            return (Integer)this.clear.get(string2);
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407307, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407307, (Throwable)exception);
            }
            throw new VersionException(407307, (Throwable)exception);
        }
    }

    public synchronized PLSObj getDataPermTab(int n, String string) throws VersionException {
        if (this.LoadNoCache == null) {
            this.NLSFiles();
        }
        String string2 = this._rsdTools.getKey(n, string);
        return (PLSObj)this.LoadNoCache.get(string2);
    }

    public synchronized PLSObj getRecordIndexs(int n, String string) throws VersionException {
        if (this.SEDU == null) {
            this.SEDU();
        }
        String string2 = this._rsdTools.getKey(n, string);
        return (PLSObj)this.SEDU.get(string2);
    }

    @Override
    public synchronized JetRptReportSet getReportSet(int n) throws VersionException {
        if (this.jrReportSet != null) {
            if (this.jrReportSet[n] == null) {
                this.jrReportSet[n] = this.getReportSet(n, false);
                this.jrReportSet[n].setCached(true);
            }
            this.jrReportSet[n].refer();
            String string = new File(this.close).getParent();
            this.jrReportSet[n].setPath(string);
            this.jrReportSet[n].setFullFileName(string + File.separator + this.jrReportSet[n].getInstName());
            return this.jrReportSet[n];
        }
        return null;
    }

    @Override
    public synchronized CLSInfo getCLSInfos(int n, String string) {
        if (this._clsInfos == null) {
            return null;
        }
        String string2 = this._rsdTools.getKey(n, string);
        String string3 = "";
        while (this._datasetMapping.containsKey(string2)) {
            string2 = (String)this._datasetMapping.get(string2);
        }
        string3 = string2;
        return (CLSInfo)((Hashtable)this._clsInfos.getSrc()).get(string3);
    }

    private IndexInfos LoadNoCache() throws VersionException {
        Long l = (Long)this.addressTable.get("IndexInfo");
        try {
            this._raf.seek(l);
            IndexInfos indexInfos = new IndexInfos();
            indexInfos.setInfos(this._rsdTools.loadIdxInfoForVrctor(this._raf));
            return indexInfos;
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407318, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407318, (Throwable)exception);
            }
            throw new VersionException(407322, (Throwable)exception);
        }
    }

    public synchronized IndexInfos getIndexInfo() throws VersionException {
        return this._indexInfo;
    }

    @Override
    public synchronized String[][] getBindInfo(int n, String string) throws VersionException {
        Long l = (Long)this.addressTable.get("BindInfo");
        try {
            this._raf.seek(l);
            Hashtable hashtable = this._rsdTools.loadBindInfo(this._raf);
            String string2 = this._rsdTools.getKey(n, string);
            String string3 = "";
            while (this._datasetMapping.containsKey(string2)) {
                string2 = (String)this._datasetMapping.get(string2);
            }
            string3 = string2;
            return (String[][])hashtable.get(string3);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407314, (Throwable)iOException);
            }
            throw new VersionException(407314, (Throwable)iOException);
        }
    }

    private void NLSFiles() throws VersionException {
        try {
            Enumeration enumeration = this.Z.keys();
            this.LoadNoCache = new Hashtable();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this._raf.seek((Long)this.Z.get(string));
                this.LoadNoCache.put(string, PLSProcessor.load(this._raf, this.auxInfo.getDiskStore()));
            }
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407316, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407316, (Throwable)exception);
            }
            throw new VersionException(407320, (Throwable)exception);
        }
    }

    private void SEDU() throws VersionException {
        try {
            this.SEDU = new Hashtable();
            Enumeration enumeration = this.add.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this._raf.seek((Long)this.add.get(string));
                this.SEDU.put(string, PLSProcessor.load(this._raf, this.auxInfo.getDiskStore()));
            }
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407317, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407317, (Throwable)exception);
            }
            throw new VersionException(407321, (Throwable)exception);
        }
    }

    @Override
    protected void loadHeader() throws VersionException {
        try {
            this._flag = this._raf.readUTF();
            if (!this._flag.equals("DHTML Result With PLS")) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2407315);
                }
                throw new VersionException(407319);
            }
            this._versionNumber = this._raf.readInt();
            long l = this._raf.readLong();
            String string = this._raf.readUTF();
            if (this._versionNumber >= 131329) {
                this._isZip = this._raf.readBoolean();
                this._id = this._raf.readUTF();
            } else {
                this._isZip = false;
            }
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407302, (Throwable)iOException);
            }
            throw new VersionException(407302, (Throwable)iOException);
        }
    }

    @Override
    public synchronized void clear() throws IOException {
        this._rsdTools = null;
        this._reportNames = null;
        this._universe = null;
        if (this.addressTable != null) {
            this.addressTable.clear();
            this.addressTable = null;
        }
        if (this.reportSetAddressTable != null) {
            this.reportSetAddressTable.clear();
            this.reportSetAddressTable = null;
        }
        if (this.append != null) {
            this.append.clear();
            this.append = null;
        }
        this.close = null;
        if (this._permissions != null) {
            this._permissions.clear();
        }
        if (this._precisions != null) {
            this._precisions.clear();
        }
        if (this._clsInfos != null) {
            this._clsInfos.clear();
        }
        if (this.clear != null) {
            this.clear.clear();
        }
        if (this._datasetMapping != null) {
            this._datasetMapping.clear();
        }
        if (this.add != null) {
            this.add.clear();
        }
        if (this.Z != null) {
            this.Z.clear();
        }
        if (this.LoadNoCache != null) {
            this.LoadNoCache.clear();
        }
        if (this.SEDU != null) {
            this.SEDU.clear();
        }
        if (this.nlsApplyParam != null) {
            this.nlsApplyParam = null;
        }
        if (this.metaNLS != null) {
            this.metaNLS = null;
        }
        if (this.NLSFiles != null) {
            for (int i = 0; i < this.NLSFiles.size(); ++i) {
                String string = (String)this.NLSFiles.get(i);
                File file = new File(string);
                if (!file.exists()) continue;
                this.auxInfo.getDiskStore().delete(file);
            }
            this.NLSFiles.clear();
            this.NLSFiles = null;
        }
        if (this._raf != null) {
            this._raf.close();
        }
    }
}

