/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.group.pls.JGroupTreePLS;
import jet.dataengine.api.group.pls.PLSProcessor;
import jet.export.ExportAuxInfo;
import jet.ie.AbstractRSDExporter;
import jet.ie.IndexInfos;
import jet.ie.RSDResourceTools;
import jet.ie.RSDTools;
import jet.ie.VersionException;
import jet.ie.io.FileBlockOutputStream;
import jet.ie.io.PJFDataOutput;
import jet.reportset.JetRptReportSet;
import jet.util.JRInterruptedException;
import jet.util.RAFile;

public class PRSDSaveControler
extends AbstractRSDExporter {
    public static final String FLAG = "DHTML Result With PLS";
    public static final String DATASETSTATE = "dataSetState";
    public static final String DATAPERMTAB = "dataPermTab";
    public static final String RECORDINDEXS = "recordIndex";
    public static final String RESOURCE = "resource";
    public static final String NLSRESOURCE = "NLSResource";
    private Hashtable GetResFromRptPath;
    private Hashtable GetResFromUniPath;
    private Hashtable I;
    public Hashtable _datasetMapping;
    protected IndexInfos _indexInfos;
    protected String _uniPath;
    protected String _realPath;

    public PRSDSaveControler(String string, ExportAuxInfo exportAuxInfo) {
        super(exportAuxInfo);
        File file = new File(string);
        this._rsdTools = new RSDTools(file.getParent(), exportAuxInfo);
        this._fileName = string;
        this.GetResFromRptPath = new Hashtable();
        this.GetResFromUniPath = new Hashtable();
        this.I = new Hashtable();
        this._datasetMapping = new Hashtable();
    }

    @Override
    public void write() throws VersionException, JRStopEngineException {
        long l = System.currentTimeMillis();
        if (this._reportNames == null || this._universe == null || this._rptInfos == null || this._dataSetInfos == null || this._rptReportSet == null || this._resultSets == null) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407201);
            }
            throw new VersionException(407201);
        }
        this._realPath = this._fileName.substring(0, this._fileName.lastIndexOf(File.separator));
        this._uniPath = this._realPath + File.separator + new SecureRandom().nextInt();
        new File(this._uniPath).mkdir();
        File file = new File(this._fileName);
        if (file.exists()) {
            this.auxInfo.getDiskStore().delete(file);
        }
        if (this._rsdTools == null) {
            this._rsdTools = new RSDTools(file.getParent(), this.auxInfo);
        }
        this._rsdTools.setCompression(this._isZip, this.bufferSize);
        try {
            file = this.auxInfo.getDiskStore().createFile(file.getAbsolutePath());
            this.rafFile = new RAFile(file, "rw");
            this.raf = new PJFDataOutput(new FileBlockOutputStream(this.rafFile));
            long l2 = this.raf.getPosition();
            this.raf.writeUTF(FLAG);
            this.raf.writeInt(133120);
            this.raf.writeLong(System.currentTimeMillis());
            this.raf.writeUTF("Copyright (c) 1998, Jinfonet Software, Inc.  All rights reserved.");
            this.raf.writeBoolean(this._isZip);
            this.raf.writeUTF(this._id);
            Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
            long l3 = this.raf.getPosition();
            this.raf.writeLong(0L);
            this._rsdTools.saveMapInfoForString(this.raf, this._datasetMapping);
            hashtable.put("ReportNames", new Long(this.saveReportNames()));
            hashtable.put("Universe", new Long(this.saveUniverse()));
            hashtable.put("ReportInfos", new Long(this.saveRptInfos()));
            hashtable.put("DatasetInfos", new Long(this.saveDataSetInfos()));
            hashtable.put("BindInfo", new Long(this.saveBindInfo()));
            hashtable.put("ReportSets", new Long(this.saveReportSets()));
            hashtable.put("ResultSets", new Long(this.saveResultSets()));
            hashtable.put("Parameters", new Long(this.saveParameter()));
            hashtable.put("IndexInfo", new Long(this.saveIndexInfo()));
            hashtable.put("Precision", new Long(this.savePrecision()));
            hashtable.put("Permission", new Long(this.savePermisions()));
            hashtable.put("CLSInfo", new Long(this.saveCLSInfos()));
            hashtable.put(DATASETSTATE, new Long(this.saveDataSetStatus()));
            hashtable.put(DATAPERMTAB, new Long(this.GetResFromRptPath()));
            hashtable.put(RECORDINDEXS, new Long(this.GetResFromUniPath()));
            hashtable.put(RESOURCE, new Long(this.I()));
            hashtable.put("ParamFormValue", new Long(this.saveParameterFormValue()));
            hashtable.put("ParamFormNames", new Long(this.saveParameterFormNames()));
            hashtable.put("Locale", new Long(this.saveLocale()));
            hashtable.put("MetaNLS", new Long(this.saveMetaNLS()));
            long l4 = this.writeAddressTableH(hashtable);
            String string = String.valueOf(this.raf.getPosition() - l2);
            JRLog.trace(5, 2407227, string);
            this.raf.seek(l3);
            this.raf.writeLong(l4);
            long l5 = System.currentTimeMillis();
            String string2 = String.valueOf(l5 - l);
            JRLog.trace(5, 2407228, string2);
            this.auxInfo.getDiskStore().fileUpdated(file);
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 0x24BB22, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 0x24BB22, (Throwable)exception);
            }
            throw new VersionException(407202, (Throwable)exception);
        }
    }

    @Override
    public long saveUniverse() throws VersionException {
        try {
            long l = System.currentTimeMillis();
            long l2 = this.raf.getPosition();
            String string = this._uniPath + File.separator + this._universe.getFileName();
            File file = new File(string);
            this.auxInfo.getDiskStore().fileUpdated(file);
            this._universe.SaveTo(file);
            this.auxInfo.getDiskStore().fileUpdated(file);
            this.raf.writeUTF(this._uniPath.substring(this._uniPath.lastIndexOf(File.separator)) + File.separator + file.getName());
            boolean bl = true;
            if (this.nlsApplyParam != null && this.nlsApplyParam.getNLSModel() == 2) {
                bl = false;
            }
            this._rsdTools.writeCatalogLevelNLS(this.raf, this.nlsManager, this.locale, bl);
            String string2 = String.valueOf(this.raf.getPosition() - l2);
            JRLog.trace(5, 2407229, string2);
            long l3 = System.currentTimeMillis();
            String string3 = String.valueOf(l3 - l);
            JRLog.trace(5, 2407230, string3);
            return l2;
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 0x24BB24, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 0x24BB24, (Throwable)exception);
            }
            throw new VersionException(407204, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long saveResultSets() throws VersionException {
        try {
            Object object;
            long l = System.currentTimeMillis();
            long l2 = this.raf.getPosition();
            this.raf.writeLong(0L);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            Enumeration enumeration = this._resultSets.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                File file = this._rsdTools.getTempFile("resultSet" + string);
                RAFile rAFile = new RAFile(file, "rw");
                object = new PJFDataOutput(new FileBlockOutputStream(rAFile));
                try {
                    ResultSet resultSet = (ResultSet)this._resultSets.get(string);
                    this._rsdTools.writeResultSet((PJFDataOutput)object, resultSet);
                }
                finally {
                    ((FilterOutputStream)object).close();
                    this.auxInfo.getDiskStore().fileUpdated(file);
                }
                hashtable.put(string, file.getName());
            }
            long l3 = this.raf.getPosition();
            this._rsdTools.saveMapInfoForString(this.raf, hashtable);
            long l4 = this.raf.getPosition();
            this.raf.seek(l2);
            this.raf.writeLong(l3);
            this.raf.seek(l4);
            object = String.valueOf(this.raf.getPosition() - l2);
            JRLog.trace(5, 2407231, object);
            long l5 = System.currentTimeMillis();
            String string = String.valueOf(l5 - l);
            JRLog.trace(5, 2407232, string);
            return l2;
        }
        catch (SQLException sQLException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 0x24BB2B, (Throwable)sQLException);
            }
            throw new VersionException(407211, (Throwable)sQLException);
        }
        catch (DSException dSException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407210, (Throwable)dSException);
            }
            throw new VersionException(407210, (Throwable)dSException);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407209, (Throwable)iOException);
            }
            throw new VersionException(407209, (Throwable)iOException);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, outOfSpaceException);
            }
            throw new VersionException(outOfSpaceException);
        }
    }

    protected long saveDataSetStatus() throws VersionException {
        try {
            long l = this.raf.getPosition();
            this._rsdTools.saveMapInfoForInteger(this.raf, this.GetResFromRptPath);
            return l;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407208, (Throwable)iOException);
            }
            throw new VersionException(407208, (Throwable)iOException);
        }
    }

    private long GetResFromRptPath() throws VersionException {
        try {
            long l = System.currentTimeMillis();
            long l2 = this.raf.getPosition();
            this.raf.writeLong(0L);
            Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
            Enumeration enumeration = this.GetResFromUniPath.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                JGroupTreePLS jGroupTreePLS = (JGroupTreePLS)this.GetResFromUniPath.get(string);
                hashtable.put(string, new Long(this.raf.getPosition()));
                PLSProcessor.applyAndSave(this.raf, jGroupTreePLS);
            }
            long l3 = this.writeAddressTableH(hashtable);
            long l4 = this.raf.getPosition();
            this.raf.seek(l2);
            this.raf.writeLong(l3);
            this.raf.seek(l4);
            String string = String.valueOf(this.raf.getPosition() - l2);
            JRLog.trace(5, 2407233, string);
            long l5 = System.currentTimeMillis();
            String string2 = String.valueOf(l5 - l);
            JRLog.trace(5, 0x24BB42, string2);
            return l2;
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407208, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407208, (Throwable)exception);
            }
            throw new VersionException(407208, (Throwable)exception);
        }
    }

    private long GetResFromUniPath() throws VersionException {
        try {
            long l = this.raf.getPosition();
            long l2 = System.currentTimeMillis();
            this.raf.writeLong(0L);
            Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
            Enumeration enumeration = this.I.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                JGroupTreePLS jGroupTreePLS = (JGroupTreePLS)this.I.get(string);
                hashtable.put(string, new Long(this.raf.getPosition()));
                PLSProcessor.applyAndSave(this.raf, jGroupTreePLS, this._id);
            }
            long l3 = this.writeAddressTableH(hashtable);
            long l4 = this.raf.getPosition();
            this.raf.seek(l);
            this.raf.writeLong(l3);
            this.raf.seek(l4);
            String string = String.valueOf(this.raf.getPosition() - l);
            JRLog.trace(5, 2407235, string);
            long l5 = System.currentTimeMillis();
            String string2 = String.valueOf(l5 - l2);
            JRLog.trace(5, 0x24BB44, string2);
            return l;
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407208, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407208, (Throwable)exception);
            }
            throw new VersionException(407208, (Throwable)exception);
        }
    }

    private long I() throws IOException, OutOfSpaceException {
        long l = this.raf.getPosition();
        Collection collection = this._rptReportSet.values();
        JetRptReportSet[] jetRptReportSetArray = new JetRptReportSet[collection.size()];
        collection.toArray(jetRptReportSetArray);
        String[] stringArray = RSDResourceTools.GetResFromUniPath(this._universe.getFilePath(), jetRptReportSetArray);
        if (stringArray != null) {
            this.raf.writeUTF(this._uniPath);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = this._uniPath + File.separator + stringArray[i].substring(stringArray[i].lastIndexOf(File.separator) + 1);
                this._rsdTools.copyFile(stringArray[i], string);
            }
        }
        return l;
    }

    private long SEDU() throws VersionException {
        try {
            long l = this.raf.getPosition();
            this.raf.writeLong(0L);
            Enumeration enumeration = this._rptReportSet.elements();
            String string = "";
            String string2 = "";
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            while (enumeration.hasMoreElements()) {
                String string3;
                JetRptReportSet jetRptReportSet = (JetRptReportSet)enumeration.nextElement();
                String[] stringArray = RSDResourceTools.GetResFromRptPath(jetRptReportSet);
                if (stringArray == null || stringArray.length <= 0) continue;
                String string4 = stringArray[0].substring(0, stringArray[0].lastIndexOf(File.separator));
                if (!hashtable.containsValue(string4)) {
                    hashtable.put(jetRptReportSet.getInstName(), string4);
                    string2 = String.valueOf(new SecureRandom().nextInt());
                    string = this._realPath + File.separator + string2;
                    File file = new File(string);
                    file.mkdir();
                    for (int i = 0; i < stringArray.length; ++i) {
                        string3 = string + File.separator + stringArray[i].substring(stringArray[i].lastIndexOf(File.separator) + 1);
                        this._rsdTools.copyFile(stringArray[i], string3);
                    }
                } else {
                    for (int i = 0; i < stringArray.length; ++i) {
                        string3 = string + File.separator + stringArray[i].substring(stringArray[i].lastIndexOf(File.separator) + 1);
                        if (new File(string3).exists()) continue;
                        this._rsdTools.copyFile(stringArray[i], string3);
                    }
                }
                hashtable2.put(jetRptReportSet.getInstName(), string2);
            }
            long l2 = this.raf.getPosition();
            this._rsdTools.saveMapInfoForString(this.raf, hashtable2);
            long l3 = this.raf.getPosition();
            this.raf.seek(l);
            this.raf.writeLong(l2);
            this.raf.seek(l3);
            return l;
        }
        catch (JRInterruptedException jRInterruptedException) {
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            throw new VersionException(exception);
        }
    }

    public void setDataSetStatus(int n, String string, int n2) {
        String string2 = this._rsdTools.getKey(n, string);
        this.GetResFromRptPath.put(string2, new Integer(n2));
    }

    public void setDataPermTab(int n, String string, int n2, String string2, JGroupTreePLS jGroupTreePLS) {
        String string3 = this._rsdTools.getKey(n2, string2);
        String string4 = this._rsdTools.getKey(n, string);
        this._datasetMapping.put(string4, string3);
        this.GetResFromUniPath.put(string4, jGroupTreePLS);
    }

    public void setRecordIndexs(int n, String string, int n2, String string2, JGroupTreePLS jGroupTreePLS) {
        String string3 = this._rsdTools.getKey(n2, string2);
        String string4 = this._rsdTools.getKey(n, string);
        this._datasetMapping.put(string4, string3);
        this.I.put(string4, jGroupTreePLS);
    }

    public void setIndexInfo(IndexInfos indexInfos) {
        this._indexInfos = indexInfos;
    }

    @Override
    public long saveIndexInfo() throws VersionException {
        try {
            long l = this.raf.getPosition();
            this._rsdTools.saveIdxInfoForVrctor(this.raf, this._indexInfos.getInfos());
            return l;
        }
        catch (IOException iOException) {
            throw new VersionException(iOException);
        }
    }

    @Override
    public void clear() throws IOException, VersionException {
        if (this._rptReportSet != null) {
            this._rptReportSet = null;
        }
        if (this._resultSets != null) {
            this._resultSets.clear();
            this._resultSets = null;
        }
        if (this._reportNames != null) {
            this._reportNames = null;
        }
        if (this._parameter != null) {
            this._parameter.clear();
            this._parameter = null;
        }
        if (this._rptInfos != null) {
            this._rptInfos = null;
        }
        if (this._rptReportSet != null) {
            this._rptReportSet = null;
        }
        if (this._bindInfo != null) {
            this._bindInfo = null;
        }
        if (this._rsdTools != null) {
            this._rsdTools = null;
        }
        if (this._dataSetInfos != null) {
            this._dataSetInfos = null;
        }
        if (this._permissions != null) {
            this._permissions = null;
        }
        if (this._precisions != null) {
            this._precisions = null;
        }
        if (this._CLSInfos != null) {
            this._CLSInfos = null;
        }
        if (this.nlsManager != null) {
            this.nlsManager = null;
        }
        if (this.nlsApplyParam != null) {
            this.nlsApplyParam = null;
        }
        if (this.rafFile != null) {
            this.rafFile.close();
        }
        if (this.raf != null) {
            this.raf.close();
            try {
                this.auxInfo.getDiskStore().fileUpdated(new File(this._fileName));
            }
            catch (IOException iOException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, iOException);
                }
                throw new VersionException(iOException);
            }
            catch (OutOfSpaceException outOfSpaceException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, outOfSpaceException);
                }
                throw new VersionException(outOfSpaceException);
            }
        }
    }
}

