/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.dataservice.relational.ResultSetAdapterRelationData;
import java.sql.ResultSet;
import java.sql.SQLException;
import jet.dataengine.api.DSException;
import jet.ie.FileBasedResultSet;

public class RSBasedResultSet
extends ResultSetAdapterRelationData {
    protected ResultSet basedRS;
    protected int[] recordIDs;
    protected long recordCount;
    protected int row = 0;

    public RSBasedResultSet(ResultSet resultSet) throws DSException {
        if (!(resultSet instanceof FileBasedResultSet)) {
            throw new DSException("FileBasedResultSet is aceptable for RSBasedResultSet!");
        }
        FileBasedResultSet fileBasedResultSet = (FileBasedResultSet)resultSet;
        super.init(fileBasedResultSet.getBasedRelationData());
        this.recordCount = fileBasedResultSet.getRecordCount();
        int[] nArray = new int[(int)this.recordCount];
        for (long i = 0L; i < this.recordCount; ++i) {
            nArray[(int)i] = (int)(i + 1L);
        }
        this.basedRS = resultSet;
        this.recordIDs = nArray;
    }

    public RSBasedResultSet(ResultSet resultSet, int[] nArray) throws DSException {
        if (!(resultSet instanceof FileBasedResultSet)) {
            throw new DSException("FileBasedResultSet is aceptable for RSBasedResultSet!");
        }
        super.init(((FileBasedResultSet)resultSet).getBasedRelationData());
        this.basedRS = resultSet;
        this.recordIDs = nArray;
        this.recordCount = nArray.length;
    }

    protected int arrayID2RowID(int n) {
        return n + 1;
    }

    protected int rowID2ArrayID(int n) {
        return n - 1;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        if (this.recordCount == 0L) {
            return false;
        }
        if (n < 0) {
            throw new SQLException("Negative row number is not not supported: " + n);
        }
        if ((long)n > this.recordCount) {
            return false;
        }
        int n2 = this.rowID2ArrayID(n);
        long l = this.recordIDs[n2];
        try {
            this.relation.setPosition(l);
        }
        catch (DSException dSException) {
            throw new SQLException(dSException.getMessage());
        }
        this.row = n;
        return true;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.recordCount == 0L) {
            return false;
        }
        if ((long)this.row >= this.recordCount) {
            return false;
        }
        ++this.row;
        int n = this.rowID2ArrayID(this.row);
        long l = this.recordIDs[n];
        try {
            this.relation.setPosition(l);
        }
        catch (DSException dSException) {
            throw new SQLException(dSException.getMessage());
        }
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        return this.row;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean first() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean last() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean previous() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean relative(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

