/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import jet.export.ExportAuxInfo;
import jet.ie.AbstractRSDLoader;
import jet.ie.RSDImages;
import jet.ie.RSDIndexInfo;
import jet.ie.RSDNlsManager;
import jet.ie.RSDRptInfo;
import jet.ie.RSDTools;
import jet.ie.RSTLoadControler;
import jet.ie.UpgradeToV8RsdUtil;
import jet.ie.V7ResultSetReader;
import jet.ie.VersionException;
import jet.ie.io.PJFDataInput;
import jet.reportset.JetRptReportSet;
import jet.universe.JetUUniverse;
import jet.util.JFieldValueNLSManager;
import jet.util.JRInterruptedException;
import jet.util.RAFInputStream;
import jet.util.RAFile;
import jet.util.image.ImageResourceCenter;
import jet.util.image.ImageTable;

public class RSDLoadControler
extends AbstractRSDLoader {
    public static final String REPORT_PANELS = "Report panel";
    public static final String DBBUFFERS = "DbBuffers";
    public static final String CQRS = "CQRS";
    public static final String FmlImage = "FmlImage";
    public static final String IMAGE = "Image";
    public static final String NLSMANAGER = "NlsManager";
    private long SEDU;
    private String add = "";
    private boolean append;
    protected Hashtable resultSetAddressTable;
    protected Hashtable dbBufferAddressTable;
    protected Vector _indexInfo;
    protected RSDNlsManager _nls;
    private int clear = 0;
    private String close;

    public RSDLoadControler(String string, ExportAuxInfo exportAuxInfo) {
        super(exportAuxInfo);
        this._fileName = string;
        this.close = this._fileName + "_" + System.identityHashCode(this);
        this._reportSet = new Hashtable();
        File file = new File(string);
        this._rsdTools = new RSDTools(file.getParent(), this.auxInfo);
        this._rsdTools.setCompression(this._isZip, this.bufferSize);
    }

    @Override
    public synchronized void openFile() throws VersionException {
        try {
            this._raf = new RAFile(this._fileName, "r");
            this._in = new PJFDataInput(new RAFInputStream(this._raf));
            this.loadHeader();
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 2407320);
                JRLog.trace(4, 2407321, this._fileName);
                JRLog.trace(4, 2407322, new Integer(this._versionNumber));
            }
            this._in.setVersion(this._versionNumber);
            boolean bl = this.append = this._versionNumber < 131073;
            if (this._rsdTools == null) {
                File file = new File(this._fileName);
                this._rsdTools = new RSDTools(file.getParent(), this.auxInfo);
            }
            this._rsdTools.setCompression(this._isZip, this.bufferSize);
            if (this._versionNumber < 131073) {
                int n = this._raf.readInt();
                this._reportNames = new String[n];
                for (int i = 0; i < n; ++i) {
                    this._reportNames[i] = this._raf.readUTF() + ".cls";
                }
                this._raf.seek(this._raf.readLong());
                this.addressTable = this.readAddressTable();
                this.SEDU = this._raf.getPosition();
                this.getRSTLoadControler();
                this.reportPanelAddressTable = this._clsInfos(REPORT_PANELS);
                this.dbBufferAddressTable = this._clsInfos(DBBUFFERS);
                ArrayList<String> arrayList = new ArrayList<String>();
                int n2 = this._reportNames.length;
                this.jrReportSet = new JetRptReportSet[n2];
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(i, this._reportNames[i]);
                    this.jrReportSet[i] = this.getReportSet(i, true);
                    this._reportSet.put(new Integer(i), this.jrReportSet[i]);
                }
                if (this._versionNumber > 65549) {
                    Hashtable hashtable = this._rsdTools.readCQRsAddressTable(this.addressTable, CQRS, this._raf);
                    this.rstReader = new V7ResultSetReader(hashtable, arrayList, this._rsdTools, this._raf, this._versionNumber, this._flag);
                } else {
                    this.rstReader = new V7ResultSetReader(this.dbBufferAddressTable, arrayList, this._rsdTools, this._raf, this._versionNumber, this._flag);
                }
                this._upgradeTool = new UpgradeToV8RsdUtil(this._reportNames, this.jrReportSet, this.rstReader);
            } else {
                this._raf.seek(this._raf.readLong());
                this.addressTable = this.readAddressTable();
                if (this._versionNumber < 131329) {
                    this.SEDU = this._raf.getPosition();
                    this.getRSTLoadControler();
                }
                this._reportNames = this.getReportNames();
                this.jrReportSet = new JetRptReportSet[this._reportNames.length];
                this.reportSetAddressTable = this.readSubBlockAddressTableH("ReportSets");
                this.resultSetAddressTable = this.readSubBlockAddressTableH("ResultSets");
                this._parameter = this.getParameters();
                this._rptInfos = this.loadRptInfo();
                this._dataSetInfo = this.loadDataSetInfo();
                if (this._versionNumber >= 131329) {
                    if (this._versionNumber < 132944 || this._versionNumber > 132944 && this._versionNumber < 133120) {
                        this._nls = this.getNlsManagers();
                    }
                    this._precisions = this.getPrecisions();
                    this._clsInfos = this.getClsInfos();
                    this._permissions = this.getPermissions();
                    this._indexInfo = this.getIndexInfo();
                    this.readChangeByFMLImg();
                }
                if (this._versionNumber >= 131841) {
                    this._parameterFormValue = this.readParameterFormValue();
                    this._parameterFormNames = this.readParameterFormNames();
                }
                if (this._versionNumber >= 131888 || this._versionNumber == 131845) {
                    this._locale = this.readLocale();
                }
                if (this._versionNumber >= 133120) {
                    this.metaNLS = this.readMetaNLS();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407315, (Throwable)fileNotFoundException);
            }
            throw new VersionException(407315, new Object[]{this._fileName}, (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407303, (Throwable)iOException);
            }
            throw new VersionException(407303, (Throwable)iOException);
        }
    }

    public synchronized ResultSet getResultSet(int n, String string) throws VersionException {
        ResultSet resultSet;
        String string2 = "######  resultSet: index :: " + n + "  dataSetName :: " + string;
        JRLog.trace(5, string2);
        long l = System.currentTimeMillis();
        if (this._versionNumber < 131073) {
            return this._upgradeTool.getResultSet(n, string);
        }
        String string3 = this._rsdTools.getKey(n, string);
        Long l2 = (Long)this.resultSetAddressTable.get(string3);
        if (l2 == null) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407311);
            }
            throw new VersionException(407311);
        }
        try {
            this._raf.seek(l2);
            resultSet = this._rsdTools.loadResultSet(this._raf, this._versionNumber, this._flag);
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407304, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407304, (Throwable)exception);
            }
            throw new VersionException(407304, (Throwable)exception);
        }
        long l3 = System.currentTimeMillis();
        String string4 = "######## load resultSet cast time :: " + (l3 - l);
        JRLog.trace(5, string4);
        return resultSet;
    }

    @Override
    public synchronized JetUUniverse getUniverse() throws VersionException {
        if (this._universe != null) {
            return this._universe;
        }
        if (this._versionNumber < 131073) {
            try {
                long l = (Long)this.reportPanelAddressTable.get(new Integer(0));
                this._raf.seek(l);
                this._raf.readInt();
                ArrayList arrayList = this._rsdTools.loadSelfContainPanelToReportSet(this._in);
                this._universe = (JetUUniverse)arrayList.get(1);
                return this._universe;
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2407305, (Throwable)jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2407305, (Throwable)exception);
                }
                throw new VersionException(407305, (Throwable)exception);
            }
        }
        Long l = (Long)this.addressTable.get("Universe");
        try {
            JFieldValueNLSManager[] jFieldValueNLSManagerArray;
            long l2 = System.currentTimeMillis();
            this._raf.seek(l);
            this._universe = this._rsdTools.loadUniverse(this._in, this._rsdTools.getTempPath());
            if (this._versionNumber == 132944 || this._versionNumber >= 133120) {
                jFieldValueNLSManagerArray = this._rsdTools.loadCatalogLevelNLS(this._in, this._rsdTools.getTempPath(), this.NLSFiles);
                if (jFieldValueNLSManagerArray != null && this._locale != null) {
                    this._universe.getNLSManager(this._locale).putContents(jFieldValueNLSManagerArray[0]);
                }
            } else {
                jFieldValueNLSManagerArray = this.SEDU();
                if (jFieldValueNLSManagerArray != null && this._locale != null) {
                    JFieldValueNLSManager jFieldValueNLSManager = this._universe.getNLSManager(this._locale);
                    for (int i = 0; i < jFieldValueNLSManagerArray.length; ++i) {
                        if (jFieldValueNLSManagerArray[i] == null) continue;
                        jFieldValueNLSManager.putContents(jFieldValueNLSManagerArray[i]);
                    }
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, jFieldValueNLSManagerArray.length + " nls managers are merged with the catalog nls manager.");
                    }
                }
            }
            long l3 = System.currentTimeMillis();
            String string = "#######  load Universe cast time :: " + (l3 - l2);
            JRLog.trace(5, string);
            return this._universe;
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407305, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407305, (Throwable)exception);
            }
            throw new VersionException(407305, (Throwable)exception);
        }
    }

    public synchronized RSTLoadControler getRSTLoadControler() throws VersionException, IOException {
        if (this._versionNumber < 131329) {
            this._rstLoader = new RSTLoadControler(this.NLSFiles(), this.auxInfo);
            this._rstLoader.openFile();
        }
        return this._rstLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String NLSFiles() throws VersionException {
        try {
            this.add = this._rsdTools.getTempFileName();
            File file = this.auxInfo.getDiskStore().createFile(this.add);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                this._raf.seek(this.SEDU);
                byte[] byArray = new byte[4096];
                long l = this._raf.length() - this.SEDU;
                long l2 = l / 4096L;
                for (long i = 0L; i < l2; ++i) {
                    this._raf.readFully(byArray);
                    fileOutputStream.write(byArray);
                }
                int n = (int)(l % 4096L);
                this._raf.read(byArray, 0, n);
                fileOutputStream.write(byArray, 0, n);
            }
            finally {
                fileOutputStream.close();
                this.auxInfo.getDiskStore().fileUpdated(file);
            }
            file.deleteOnExit();
            return this.add;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407308, (Throwable)iOException);
            }
            throw new VersionException(407308, (Throwable)iOException);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, outOfSpaceException);
            }
            throw new VersionException(outOfSpaceException);
        }
    }

    public synchronized Vector getIndexInfo() throws VersionException {
        if (this._indexInfo == null) {
            Long l = (Long)this.addressTable.get("IndexInfo");
            try {
                this._raf.seek(l);
                RSDIndexInfo rSDIndexInfo = new RSDIndexInfo();
                rSDIndexInfo.load(this._raf);
                return (Vector)rSDIndexInfo.getSrc();
            }
            catch (IOException iOException) {
                throw new VersionException(iOException);
            }
        }
        return this._indexInfo;
    }

    public synchronized int getIndex(int n, String string, String string2, String string3, String string4) throws VersionException {
        int n2 = -1;
        if (this._versionNumber < 131073) {
            for (int i = 0; i < this._reportNames.length; ++i) {
                if (!this._reportNames[i].equals(string4)) continue;
                return i;
            }
        } else if (this._indexInfo != null) {
            for (int i = 0; i < this._indexInfo.size(); ++i) {
                RSDRptInfo rSDRptInfo = (RSDRptInfo)this._indexInfo.get(i);
                if (!rSDRptInfo.hasMappingRptSet(n, string, string2, string3)) continue;
                return rSDRptInfo.getSIndex();
            }
        }
        if (n2 == -1) {
            throw new VersionException(new Exception("Subreport set index not found!!!"));
        }
        return n2;
    }

    public synchronized Hashtable getImages() throws VersionException {
        Hashtable hashtable = new Hashtable();
        if (this._versionNumber < 131073) {
            return hashtable;
        }
        Long l = (Long)this.addressTable.get(IMAGE);
        try {
            this._raf.seek(l);
            RSDImages rSDImages = new RSDImages(this._isZip, this._versionNumber);
            rSDImages.load(this._raf);
            hashtable = (Hashtable)rSDImages.getSrc();
            return hashtable;
        }
        catch (IOException iOException) {
            throw new VersionException(iOException);
        }
    }

    protected RSDNlsManager getNlsManagers() throws VersionException {
        try {
            Long l = (Long)this.addressTable.get(NLSMANAGER);
            this._raf.seek(l);
            RSDNlsManager rSDNlsManager = new RSDNlsManager();
            rSDNlsManager.load(this._raf);
            return rSDNlsManager;
        }
        catch (IOException iOException) {
            throw new VersionException(iOException);
        }
    }

    private synchronized JFieldValueNLSManager[] SEDU() throws VersionException {
        if (this._versionNumber >= 131329) {
            if (this._nls != null) {
                return this._nls.getNLSManagers();
            }
            return null;
        }
        return this._rstLoader.getNLSManagers();
    }

    protected void readChangeByFMLImg() throws VersionException {
        Long l = (Long)this.addressTable.get(FmlImage);
        try {
            this._raf.seek(l);
            ImageTable imageTable = new ImageTable();
            imageTable.loadFrom(this._in);
            ImageResourceCenter.registerImageResources(this.close, imageTable);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Register image resource when loading rsd file.");
                JRLog.trace(6, "The register id is " + this.close + ".");
            }
            ++this.clear;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407318, (Throwable)iOException);
            }
            throw new VersionException(407318, (Throwable)iOException);
        }
    }

    private Hashtable _clsInfos(String string) throws VersionException {
        try {
            Long l = (Long)this.addressTable.get(string);
            if (l == null) {
                return null;
            }
            long l2 = l;
            this._raf.seek(l2);
            long l3 = this._raf.readLong();
            this._raf.seek(l3);
            int n = this._raf.readInt();
            Hashtable<Integer, Long> hashtable = new Hashtable<Integer, Long>(n);
            for (int i = 0; i < n; ++i) {
                hashtable.put(new Integer(i), new Long(this._raf.readLong()));
            }
            return hashtable;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407303, (Throwable)iOException);
            }
            throw new VersionException(407303, (Throwable)iOException);
        }
    }

    @Override
    protected void loadHeader() throws VersionException {
        try {
            this._flag = this._raf.readUTF();
            if (!this._flag.equals("DHTML Result version")) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2407301);
                }
                throw new VersionException(407301);
            }
            this._versionNumber = this._raf.readInt();
            long l = this._raf.readLong();
            String string = this._raf.readUTF();
            if (this._versionNumber >= 131329) {
                this._isZip = this._raf.readBoolean();
                this._id = this._raf.readUTF();
            } else {
                this._isZip = false;
            }
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407302, (Throwable)iOException);
            }
            throw new VersionException(407302, (Throwable)iOException);
        }
    }

    @Override
    public synchronized void clear() throws IOException, OutOfSpaceException {
        int n;
        block21: {
            File file;
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 2407323);
            }
            this._rsdTools = null;
            this._reportNames = null;
            this._universe = null;
            for (n = 0; this.jrReportSet != null && n < this.jrReportSet.length; ++n) {
                if (this.jrReportSet[n] == null) continue;
                this.jrReportSet[n].setCached(false);
                if (this.jrReportSet[n].getRefCount() > 0) continue;
                this.jrReportSet[n].free();
            }
            this.jrReportSet = null;
            if (this.addressTable != null) {
                this.addressTable.clear();
                this.addressTable = null;
            }
            if (this.reportPanelAddressTable != null) {
                this.reportPanelAddressTable.clear();
                this.reportPanelAddressTable = null;
            }
            if (this.dbBufferAddressTable != null) {
                this.dbBufferAddressTable.clear();
                this.dbBufferAddressTable = null;
            }
            if (this.reportSetAddressTable != null) {
                this.reportSetAddressTable.clear();
                this.reportSetAddressTable = null;
            }
            if (this.resultSetAddressTable != null) {
                this.resultSetAddressTable.clear();
                this.resultSetAddressTable = null;
            }
            if (this._indexInfo != null) {
                this._indexInfo.clear();
                this._indexInfo = null;
            }
            if (this._permissions != null) {
                this._permissions.clear();
            }
            if (this._nls != null) {
                this._nls.clear();
            }
            if (this._precisions != null) {
                this._precisions.clear();
            }
            if (this._clsInfos != null) {
                this._clsInfos.clear();
            }
            if (this.add != null && !this.add.equals("") && (file = new File(this.add)).exists()) {
                this.auxInfo.getDiskStore().delete(file);
            }
            if (this._rstLoader != null) {
                try {
                    this._rstLoader.clear();
                }
                catch (VersionException versionException) {
                    if (!JRLog.isError(2)) break block21;
                    JRLog.error(2, 2407316, (Throwable)versionException);
                }
            }
        }
        this._dataSetInfo();
        if (this.NLSFiles != null) {
            for (n = 0; n < this.NLSFiles.size(); ++n) {
                String string = (String)this.NLSFiles.get(n);
                File file = new File(string);
                if (!file.exists()) continue;
                this.auxInfo.getDiskStore().delete(file);
            }
            this.NLSFiles.clear();
            this.NLSFiles = null;
        }
        if (this.nlsApplyParam != null) {
            this.nlsApplyParam = null;
        }
        if (this.metaNLS != null) {
            this.metaNLS = null;
        }
        if (this._raf != null) {
            this._raf.close();
        }
    }

    private void _dataSetInfo() {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Unregister image resource for " + this.clear + " times when clearing rsd loading.");
            JRLog.trace(6, "The registering id is " + this.close + ".");
        }
        for (int i = 0; i < this.clear; ++i) {
            ImageResourceCenter.unregisterImageResources(this.close);
        }
    }

    public String getRegisteredImageResourcesID() {
        return this.close;
    }
}

