/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetImgProperty;
import jet.controls.JetImgVector;
import jet.controls.JetProperty;
import jet.naming.PropertyNames;
import jet.report.JetRptDBField;
import jet.report.JetRptField;
import jet.report.JetRptMap;
import jet.report.JetRptParameterField;
import jet.report.JetRptPicture;
import jet.reportset.JetRptReportSet;
import jet.util.FileUtil;
import jet.util.NLSResourceBundle;
import jet.util.WildcardMatcher;
import jet.util.image.ImageResourceUtil;

public class RSDResourceTools {
    private static final FileFilter DefaultImagePath = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return false;
            }
            String string = file.getName().toLowerCase();
            if (string.endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".bmp") || string.endsWith(".png")) {
                int n = ImageResourceUtil.getImageType(file);
                return n != -100 && n != 2;
            }
            return false;
        }
    };

    public static String[] GetResFromUniPath(String string, JetRptReportSet[] jetRptReportSetArray) {
        boolean bl = true;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < jetRptReportSetArray.length; ++i) {
            bl = bl && RSDResourceTools.FromURL(string, jetRptReportSetArray[i], vector);
        }
        if (!bl) {
            File[] fileArray = new File(string).listFiles(DefaultImagePath);
            for (int i = 0; i < fileArray.length; ++i) {
                if (vector.contains(fileArray[i].getAbsolutePath())) continue;
                vector.add(fileArray[i].getAbsolutePath());
            }
        }
        return RSDResourceTools.SEDU(vector);
    }

    public static String[] GetResFromRptPath(JetRptReportSet jetRptReportSet) {
        String string = jetRptReportSet.getFullFileName();
        if (string == null) {
            return null;
        }
        File file = new File(string).getParentFile();
        String string2 = new File(string).getName();
        string2 = RSDResourceTools.PROPS_FILE_EXTENSION(string2);
        List list = RSDResourceTools.DefaultImagePath(file, string2, jetRptReportSet);
        List list2 = RSDResourceTools.FILENAME_CONCAT_CHAR(file, jetRptReportSet);
        for (int i = 0; i < list2.size(); ++i) {
            if (list.contains(list2.get(i))) continue;
            list.add(list2.get(i));
        }
        return RSDResourceTools.SEDU(list);
    }

    private static List DefaultImagePath(File file, String string, JetRptReportSet jetRptReportSet) {
        String string2 = string + NLSResourceBundle.FILENAME_CONCAT_CHAR + "*" + NLSResourceBundle.PROPS_FILE_EXTENSION;
        WildcardMatcher wildcardMatcher = new WildcardMatcher(string2, false, 2);
        String[] stringArray = file.list(wildcardMatcher);
        Vector<String> vector = new Vector<String>(stringArray.length, 1);
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(new File(file, stringArray[i]).getAbsolutePath());
        }
        File file2 = new File(file, string + NLSResourceBundle.PROPS_FILE_EXTENSION);
        if (file2.exists()) {
            vector.add(file2.getAbsolutePath());
        }
        return vector;
    }

    private static List FILENAME_CONCAT_CHAR(File file, JetRptReportSet jetRptReportSet) {
        Iterator iterator = jetRptReportSet.getNamingTable().values().iterator();
        Vector<String> vector = new Vector<String>();
        while (iterator.hasNext()) {
            String string;
            Object v = iterator.next();
            if (!(v instanceof JetRptDBField) && !(v instanceof JetRptParameterField) || (string = (String)((JetRptField)v).getPropertyByName("DataMappingFile").getObject()).trim().length() == 0) continue;
            String string2 = string + NLSResourceBundle.FILENAME_CONCAT_CHAR + "*" + NLSResourceBundle.PROPS_FILE_EXTENSION;
            WildcardMatcher wildcardMatcher = new WildcardMatcher(string2, false, 2);
            String[] stringArray = file.list(wildcardMatcher);
            for (int i = 0; i < stringArray.length; ++i) {
                if (vector.contains(stringArray[i])) continue;
                vector.add(new File(file, stringArray[i]).getAbsolutePath());
            }
        }
        return vector;
    }

    private static boolean FromURL(String string, JetRptReportSet jetRptReportSet, List list) {
        boolean bl = true;
        for (Object v : jetRptReportSet.getNamingTable().values()) {
            Object object;
            JetProperty jetProperty;
            Object object2;
            if (v instanceof JetRptPicture) {
                object2 = (JetRptPicture)v;
                if (((JetRptPicture)object2).isEmbed()) continue;
                if (((JetRptPicture)object2).bFPictureName) {
                    bl = false;
                    continue;
                }
                RSDResourceTools.I(string, ((JetRptPicture)object2).sNPictureName, list);
                continue;
            }
            if (v instanceof JetRptMap) {
                object2 = (JetRptMap)v;
                if (((JetRptMap)object2).isData.get() || ((JetRptMap)object2).bEmbed.get()) continue;
                if (((JetRptMap)object2).src.isChangeByOther()) {
                    bl = false;
                    continue;
                }
                RSDResourceTools.ImagePathVector(string, ((JetRptMap)object2).src, list);
                continue;
            }
            if (!(v instanceof JetRptField)) continue;
            object2 = ((JetRptField)v).getJetRptMode().getCurrentRender();
            if (object2.getRenderType() == 1) {
                jetProperty = (JetImgVector)object2.getRenderPropertyByName(PropertyNames.getDefinitionName(PropertyNames.ImagePathVector));
                if (((JetImgVector)jetProperty).isEmbed()) continue;
                object = ((JetImgVector)jetProperty).getImgNameList();
                for (int i = 0; i < object.size(); ++i) {
                    String string2 = new File(string, (String)object.get(i)).getAbsolutePath();
                    if (list.contains(string2)) continue;
                    list.add(string2);
                }
                JetImgProperty jetImgProperty = (JetImgProperty)object2.getRenderPropertyByName(PropertyNames.getDefinitionName(PropertyNames.DefaultImagePath));
                RSDResourceTools.ImagePathVector(string, jetImgProperty, list);
                continue;
            }
            if (object2.getRenderType() != 3 && object2.getRenderType() != 10 || !((JetBoolean)(jetProperty = (JetBoolean)object2.getRenderPropertyByName(PropertyNames.getDefinitionName(PropertyNames.FromURL)))).get()) continue;
            object = (JetImgProperty)object2.getRenderPropertyByName(PropertyNames.getDefinitionName(PropertyNames.Src));
            RSDResourceTools.ImagePathVector(string, (JetImgProperty)object, list);
        }
        return bl;
    }

    private static void I(String string, String string2, List list) {
        if (string2.length() == 0) {
            return;
        }
        if (FileUtil.isFileFormat(string2)) {
            String string3 = FileUtil.getFilePath(string, string2);
            if (string3.equals(string2)) {
                return;
            }
            if (list.contains(string3)) {
                return;
            }
            list.add(string3);
        }
    }

    private static void ImagePathVector(String string, JetImgProperty jetImgProperty, List list) {
        if (jetImgProperty.isEmbed()) {
            return;
        }
        String string2 = jetImgProperty.get();
        if (FileUtil.isFileFormat(string2)) {
            String string3 = FileUtil.getFilePath(string, string2);
            if (string2.equals(string3)) {
                return;
            }
            if (!list.contains(string3)) {
                list.add(string3);
            }
        }
    }

    private static String PROPS_FILE_EXTENSION(String string) {
        if ((string = string.toLowerCase()).endsWith(".cls")) {
            return string.substring(0, string.length() - ".cls".length());
        }
        if (string.endsWith(".rpt")) {
            return string.substring(0, string.length() - ".rpt".length());
        }
        return string;
    }

    private static String[] SEDU(List list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = String.valueOf(list.get(i));
        }
        return stringArray;
    }
}

