/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.export.ExportAuxInfo;
import jet.ie.AbstractRSDExporter;
import jet.ie.RSDImages;
import jet.ie.RSDIndexInfo;
import jet.ie.RSDTools;
import jet.ie.VersionException;
import jet.ie.io.FileBlockOutputStream;
import jet.ie.io.PJFDataOutput;
import jet.util.JRInterruptedException;
import jet.util.RAFile;
import jet.util.image.ImageTable;

public class RSDSaveControler
extends AbstractRSDExporter {
    public static final String FLAG = "DHTML Result version";
    public static final String FMLIMAGE = "FmlImage";
    public static final String IMAGE = "Image";
    public static final String NLSMANAGER = "NlsManager";
    private Vector I = new Vector();
    protected Hashtable _changeByFMLImg = new Hashtable();
    protected Hashtable _images = new Hashtable();

    public RSDSaveControler(String string, ExportAuxInfo exportAuxInfo) {
        super(exportAuxInfo);
        this.setFileName(string);
        File file = new File(string);
        this.bufferSize = 4096;
        this._rsdTools = new RSDTools(file.getParent(), this.auxInfo);
    }

    @Override
    public void write() throws VersionException, JRStopEngineException {
        long l = System.currentTimeMillis();
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 2407215);
            JRLog.trace(4, 2407237, this._fileName);
            JRLog.trace(4, 2407240, new Integer(133120));
        }
        if (this._reportNames == null || this._universe == null || this._rptInfos == null || this._dataSetInfos == null || this._rptReportSet == null || this._resultSets == null) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407201);
            }
            throw new VersionException(407201);
        }
        File file = new File(this._fileName);
        if (file.exists()) {
            this.auxInfo.getDiskStore().delete(file);
        }
        if (this._rsdTools == null) {
            this._rsdTools = new RSDTools(file.getParent(), this.auxInfo);
        }
        this._rsdTools.setCompression(this._isZip, this.bufferSize);
        try {
            file = this.auxInfo.getDiskStore().createFile(this._fileName);
            this.rafFile = new RAFile(file, "rw");
            this.raf = new PJFDataOutput(new FileBlockOutputStream(this.rafFile));
            long l2 = this.raf.getPosition();
            this.raf.writeUTF(FLAG);
            this.raf.writeInt(133120);
            this.raf.writeLong(System.currentTimeMillis());
            this.raf.writeUTF("Copyright (c) 1998, Jinfonet Software, Inc.  All rights reserved.");
            this.raf.writeBoolean(this._isZip);
            this.raf.writeUTF(this._id);
            Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
            long l3 = this.raf.getPosition();
            this.raf.writeLong(0L);
            hashtable.put("ReportNames", new Long(this.saveReportNames()));
            hashtable.put("Universe", new Long(this.saveUniverse()));
            hashtable.put("ReportInfos", new Long(this.saveRptInfos()));
            hashtable.put("DatasetInfos", new Long(this.saveDataSetInfos()));
            hashtable.put("BindInfo", new Long(this.saveBindInfo()));
            hashtable.put("ReportSets", new Long(this.saveReportSets()));
            hashtable.put("ResultSets", new Long(this.saveResultSets()));
            hashtable.put("Parameters", new Long(this.saveParameter()));
            hashtable.put(IMAGE, new Long(this.saveImages()));
            hashtable.put("IndexInfo", new Long(this.saveIndexInfo()));
            hashtable.put("Precision", new Long(this.savePrecision()));
            hashtable.put("Permission", new Long(this.savePermisions()));
            hashtable.put("CLSInfo", new Long(this.saveCLSInfos()));
            hashtable.put(FMLIMAGE, new Long(this.saveChangeByFMLImg()));
            hashtable.put("ParamFormValue", new Long(this.saveParameterFormValue()));
            hashtable.put("ParamFormNames", new Long(this.saveParameterFormNames()));
            hashtable.put("Locale", new Long(this.saveLocale()));
            hashtable.put("MetaNLS", new Long(this.saveMetaNLS()));
            long l4 = this.writeAddressTableH(hashtable);
            JRLog.trace(5, 2407227, new Long(this.raf.getPosition() - l2));
            this.raf.seek(l3);
            this.raf.writeLong(l4);
            JRLog.trace(5, 2407227, new Long(this.raf.getPosition() - l2));
            long l5 = System.currentTimeMillis();
            JRLog.trace(5, 2407228, new Long(l5 - l));
            this.auxInfo.getDiskStore().fileUpdated(file);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 0x24BB22, (Throwable)iOException);
            }
            throw new VersionException(407202, (Throwable)iOException);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, outOfSpaceException);
            }
            throw new VersionException(outOfSpaceException);
        }
    }

    @Override
    protected long saveUniverse() throws VersionException {
        try {
            long l = System.currentTimeMillis();
            long l2 = this.raf.getPosition();
            this._rsdTools.writeUniverse(this.raf, this._universe);
            boolean bl = true;
            if (this.nlsApplyParam != null && this.nlsApplyParam.getNLSModel() == 2) {
                bl = false;
            }
            this._rsdTools.writeCatalogLevelNLS(this.raf, this.nlsManager, this.locale, bl);
            JRLog.trace(5, 2407229, new Long(this.raf.getPosition() - l2));
            long l3 = System.currentTimeMillis();
            JRLog.trace(5, 2407230, new Long(l3 - l));
            return l2;
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 0x24BB24, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 0x24BB24, (Throwable)exception);
            }
            throw new VersionException(407204, (Throwable)exception);
        }
    }

    @Override
    protected long saveResultSets() throws VersionException {
        try {
            long l = System.currentTimeMillis();
            long l2 = this.raf.getPosition();
            Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
            this.raf.writeLong(0L);
            Enumeration enumeration = this._resultSets.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                ResultSet resultSet = (ResultSet)this._resultSets.get(string);
                hashtable.put(string, new Long(this.raf.getPosition()));
                this._rsdTools.writeResultSet(this.raf, resultSet);
            }
            long l3 = this.writeAddressTableH(hashtable);
            long l4 = this.raf.getPosition();
            this.raf.seek(l2);
            this.raf.writeLong(l3);
            this.raf.seek(l4);
            JRLog.trace(5, 2407231, new Long(this.raf.getPosition() - l2));
            long l5 = System.currentTimeMillis();
            JRLog.trace(5, 2407232, new Long(l5 - l));
            return l2;
        }
        catch (SQLException sQLException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 0x24BB2B, (Throwable)sQLException);
            }
            throw new VersionException(407211, (Throwable)sQLException);
        }
        catch (DSException dSException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407210, (Throwable)dSException);
            }
            throw new VersionException(407210, (Throwable)dSException);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407209, (Throwable)iOException);
            }
            throw new VersionException(407209, (Throwable)iOException);
        }
    }

    public void setIndexInfo(Vector vector) {
        this.I = vector;
    }

    public void setImages(Hashtable hashtable) {
        this._images = hashtable;
    }

    public void setChangeByFMLImgList(String string, String string2, List list) {
        String string3 = string.length() + string + string2.length() + string2;
        if (list != null) {
            this._changeByFMLImg.put(string3, list);
        }
    }

    public long saveImages() throws VersionException {
        try {
            long l = System.currentTimeMillis();
            long l2 = this.raf.getPosition();
            RSDImages rSDImages = new RSDImages(this._isZip, 133120);
            rSDImages.setSrc(this._images);
            rSDImages.manage();
            rSDImages.save(this.raf);
            JRLog.trace(5, 2407238, new Long(this.raf.getPosition() - l2));
            long l3 = System.currentTimeMillis();
            JRLog.trace(5, 2407239, new Long(l3 - l));
            return l2;
        }
        catch (IOException iOException) {
            throw new VersionException(iOException);
        }
    }

    public long saveChangeByFMLImg() throws VersionException {
        try {
            long l = this.raf.getPosition();
            Vector<String> vector = new Vector<String>();
            Iterator iterator = this._changeByFMLImg.values().iterator();
            while (iterator.hasNext()) {
                vector.addAll((Collection)iterator.next());
            }
            ImageTable imageTable = new ImageTable(this._universe.getFilePath(), vector);
            imageTable.storeTo(this.raf);
            return l;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407214, (Throwable)iOException);
            }
            throw new VersionException(407214, (Throwable)iOException);
        }
    }

    @Override
    public long saveIndexInfo() throws VersionException {
        try {
            long l = this.raf.getPosition();
            RSDIndexInfo rSDIndexInfo = new RSDIndexInfo();
            rSDIndexInfo.setSrc(this.I);
            rSDIndexInfo.save(this.raf);
            return l;
        }
        catch (IOException iOException) {
            throw new VersionException(iOException);
        }
    }

    @Override
    public void clear() throws IOException, VersionException {
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 2407241);
        }
        if (this._rptReportSet != null) {
            this._rptReportSet = null;
        }
        if (this._resultSets != null) {
            this._resultSets.clear();
            this._resultSets = null;
        }
        if (this._reportNames != null) {
            this._reportNames = null;
        }
        if (this._parameter != null) {
            this._parameter.clear();
            this._parameter = null;
        }
        if (this._rptInfos != null) {
            this._rptInfos = null;
        }
        if (this._rptReportSet != null) {
            this._rptReportSet = null;
        }
        if (this._bindInfo != null) {
            this._bindInfo = null;
        }
        if (this._rsdTools != null) {
            this._rsdTools = null;
        }
        if (this._dataSetInfos != null) {
            this._dataSetInfos = null;
        }
        if (this.nlsManager != null) {
            this.nlsManager = null;
        }
        if (this._permissions != null) {
            this._permissions = null;
        }
        if (this._precisions != null) {
            this._precisions = null;
        }
        if (this._CLSInfos != null) {
            this._CLSInfos = null;
        }
        if (this._changeByFMLImg != null) {
            this._changeByFMLImg = null;
        }
        if (this.nlsApplyParam != null) {
            this.nlsApplyParam = null;
        }
        if (this.rafFile != null) {
            this.rafFile.close();
        }
        if (this.raf != null) {
            this.raf.close();
        }
        try {
            this.auxInfo.getDiskStore().fileUpdated(new File(this._fileName));
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, iOException);
            }
            throw new VersionException(iOException);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, outOfSpaceException);
            }
            throw new VersionException(outOfSpaceException);
        }
    }
}

