/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.relational.Attribute;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.RelationMetaData;
import com.jinfonet.dataservice.relational.RelationOption;
import com.jinfonet.dataservice.relational.ResultSetAdapterRelationData;
import com.jinfonet.dataservice.relational.swap.RelationPool;
import com.jinfonet.datatypes.JinfonetArray;
import com.jinfonet.datatypes.JinfonetBlob;
import com.jinfonet.datatypes.JinfonetClob;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import jet.connect.DbBuffer;
import jet.connect.DbColDesc;
import jet.connect.DbRecordModel;
import jet.connect.Groupable;
import jet.connect.NDbBuffer;
import jet.connect.NDbPage;
import jet.connect.Record;
import jet.controls.JetObject;
import jet.controls.JetRootable;
import jet.dataengine.api.DSException;
import jet.export.ExportAuxInfo;
import jet.ie.Buffered4ReadRsd;
import jet.ie.Buffered4WriteRsd;
import jet.ie.FileBasedResultSet;
import jet.ie.ParameterConvertor;
import jet.ie.RSDRptInfo;
import jet.ie.ResultSetAdapterDbBuffer;
import jet.ie.VersionException;
import jet.ie.VersionRecord;
import jet.ie.ZipToolkit;
import jet.ie.io.PJFDataInput;
import jet.ie.io.PJFDataOutput;
import jet.jetc.JetCReader;
import jet.jetc.JetCWriter;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.report.JetRptDataSource;
import jet.report.JetRptObject;
import jet.report.JetRptReportPanel;
import jet.reportset.JetRptReportSet;
import jet.universe.JetUUniverse;
import jet.universe.exception.FMLFileException;
import jet.universe.exception.UniverseFileException;
import jet.upgrade.JUpgradeException;
import jet.upgrade.UpgradeUtil;
import jet.upgrade.kit.V7XObjectUtil;
import jet.util.JFieldValueNLSManager;
import jet.util.NLSResourceBundleManager;
import jet.util.RAFile;
import jet.util.RandomInputable;
import jet.util.VersionControlable;

public class RSDTools {
    protected String tempPath;
    private Random LoadNoCache;
    private boolean SEDU = false;
    private int SaveTo;
    private ExportAuxInfo add;

    public RSDTools(String string, ExportAuxInfo exportAuxInfo) {
        this.tempPath = string;
        this.LoadNoCache = new SecureRandom();
        this.add = exportAuxInfo;
    }

    public void setCompression(boolean bl) {
        this.setCompression(bl, 4096);
    }

    public void setCompression(boolean bl, int n) {
        this.SEDU = bl;
        this.SaveTo = n;
    }

    public void writeReportSet(OutputStream outputStream, JetRptReportSet jetRptReportSet) throws WriteFailureException {
        JetCWriter jetCWriter = new JetCWriter();
        jetCWriter.write((JetObject)jetRptReportSet, outputStream, jetRptReportSet.getInstName());
    }

    public JetRptReportSet loadRptReportSet(InputStream inputStream) throws ReadFailureException, IOException {
        JetObject jetObject = this.LoadNoCache(inputStream);
        return (JetRptReportSet)jetObject;
    }

    private JetObject LoadNoCache(InputStream inputStream) throws ReadFailureException {
        JetCReader jetCReader = new JetCReader();
        jetCReader.setEditable();
        JetObject jetObject = jetCReader.read(inputStream);
        if (jetObject instanceof JetRootable) {
            jetObject.createNamingSystem();
        }
        JetObject.afterNewTree(jetObject);
        return jetObject;
    }

    public ArrayList loadSelfContainPanelToReportSet(InputStream inputStream) throws ReadFailureException, JUpgradeException, IOException {
        JetRptReportPanel jetRptReportPanel = (JetRptReportPanel)this.LoadNoCache(inputStream);
        JetRptDataSource jetRptDataSource = V7XObjectUtil.getDataSource(jetRptReportPanel);
        JetUUniverse jetUUniverse = V7XObjectUtil.getBindUniverse(jetRptDataSource);
        JetRptObject jetRptObject = UpgradeUtil.upgradeRpt(jetRptReportPanel, jetUUniverse, 6);
        ArrayList<JetObject> arrayList = new ArrayList<JetObject>(2);
        arrayList.add(jetRptObject);
        arrayList.add(jetUUniverse);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUniverse(PJFDataOutput pJFDataOutput, JetUUniverse jetUUniverse) throws FMLFileException, WriteFailureException, IOException, OutOfSpaceException {
        RSDTools rSDTools = this;
        synchronized (rSDTools) {
            pJFDataOutput.writeUTF(jetUUniverse.getFileName());
            String string = this.getTempFileName() + ".cat";
            File file = new File(string);
            this.add.getDiskStore().fileUpdated(file);
            jetUUniverse.SaveTo(file);
            this.add.getDiskStore().fileUpdated(file);
            if (this.SEDU) {
                this.close(pJFDataOutput, string);
            } else {
                this.appendRecord(pJFDataOutput, string);
            }
            this.add.getDiskStore().delete(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JetUUniverse loadUniverse(PJFDataInput pJFDataInput, String string) throws IOException, ReadFailureException, UniverseFileException, OutOfSpaceException {
        RSDTools rSDTools = this;
        synchronized (rSDTools) {
            Object object;
            String string2 = null;
            if (pJFDataInput.getVersion() == 132944 || pJFDataInput.getVersion() >= 133120) {
                object = pJFDataInput.readUTF();
                string2 = string + (String)object;
            } else {
                string2 = string + this.LoadNoCache.nextInt() + ".cat";
            }
            object = this.add.getDiskStore().createFile(string2);
            if (this.SEDU) {
                this.createFile(pJFDataInput, (File)object);
            } else {
                this.createRecord(pJFDataInput, (File)object);
            }
            JetUUniverse jetUUniverse = JetUUniverse.LoadNoCache(string2);
            this.add.getDiskStore().delete((File)object);
            return jetUUniverse;
        }
    }

    public void writeCatalogLevelNLS(PJFDataOutput pJFDataOutput, JFieldValueNLSManager jFieldValueNLSManager, Locale locale, boolean bl) throws IOException, OutOfSpaceException {
        if (jFieldValueNLSManager == null || locale == null || !bl) {
            pJFDataOutput.writeBoolean(false);
            if (JRLog.isTrace(6)) {
                if (!bl) {
                    JRLog.trace(6, "The nls is not enabled.");
                }
                JRLog.trace(6, "No catalog level nls to save.");
            }
        } else {
            pJFDataOutput.writeBoolean(true);
            String string = jFieldValueNLSManager.getBaseFolderStr();
            Map<String, List<File>> map = NLSResourceBundleManager.getNLSResourcePrefixToFileMapping(new File(string), locale);
            for (String object2 : map.keySet()) {
                jFieldValueNLSManager.removeFieldValueBundleUsePrefix(object2);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            JFieldValueNLSManager.writeFieldValueNLSManager(new JFieldValueNLSManager[]{jFieldValueNLSManager}, byteArrayOutputStream);
            pJFDataOutput.writeInt(byteArrayOutputStream.size());
            pJFDataOutput.write(byteArrayOutputStream.toByteArray());
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "The nls manager is saved.");
            }
            for (List<File> list : map.values()) {
                for (int i = 0; i < list.size(); ++i) {
                    File file = list.get(i);
                    if (!file.exists()) continue;
                    pJFDataOutput.writeBoolean(true);
                    pJFDataOutput.writeUTF(file.getName());
                    if (this.SEDU) {
                        ZipToolkit.zip(pJFDataOutput, file, this.getTempFileName() + ".temp", this.add.getDiskStore());
                    } else {
                        this.booleanValue(pJFDataOutput, file);
                    }
                    if (!JRLog.isTrace(6)) continue;
                    JRLog.trace(6, "A nls property file " + file.getName() + " is saved.");
                }
            }
            pJFDataOutput.writeBoolean(false);
        }
    }

    public JFieldValueNLSManager[] loadCatalogLevelNLS(PJFDataInput pJFDataInput, String string, List list) throws FileNotFoundException, IOException, ClassNotFoundException, OutOfSpaceException {
        if (pJFDataInput.readBoolean()) {
            byte[] byArray = new byte[pJFDataInput.readInt()];
            pJFDataInput.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            JFieldValueNLSManager[] jFieldValueNLSManagerArray = JFieldValueNLSManager.readFieldValueNLSManager(byteArrayInputStream);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "The nls manager is loaded.");
            }
            while (pJFDataInput.readBoolean()) {
                String string2 = pJFDataInput.readUTF();
                String string3 = string + string2;
                File file = this.add.getDiskStore().createFile(string3);
                if (this.SEDU) {
                    ZipToolkit.unzip(pJFDataInput, file, this.getTempFileName() + ".temp", this.add.getDiskStore());
                } else {
                    this.createRecord(pJFDataInput, file);
                }
                this.add.getDiskStore().fileUpdated(file);
                list.add(file.getAbsolutePath());
                if (!JRLog.isTrace(6)) continue;
                JRLog.trace(6, "A nls property file " + file.getName() + " is extracted.");
            }
            return jFieldValueNLSManagerArray;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "No catalog level nls is loaded.");
        }
        return null;
    }

    public void writeResultSet(PJFDataOutput pJFDataOutput, ResultSet resultSet) throws IOException, DSException, SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Buffered4WriteRsd buffered4WriteRsd = new Buffered4WriteRsd(pJFDataOutput, this.SEDU);
        int n = resultSetMetaData.getColumnCount();
        long l = 0L;
        pJFDataOutput.writeShort(n);
        JAttribute[] jAttributeArray = new JAttribute[n];
        for (int i = 0; i < n; ++i) {
            int n2 = resultSetMetaData.getColumnType(i + 1);
            pJFDataOutput.writeInt(n2);
            String string = resultSetMetaData.getColumnName(i + 1);
            if (string == null) {
                string = "";
            }
            pJFDataOutput.writeUTF(string);
            int n3 = resultSetMetaData.getPrecision(i + 1);
            pJFDataOutput.writeInt(n3);
            short s = (short)resultSetMetaData.getScale(i + 1);
            pJFDataOutput.writeShort(s);
            short s2 = (short)resultSetMetaData.isNullable(i + 1);
            pJFDataOutput.writeShort(s2);
            short s3 = (short)(i + 1);
            pJFDataOutput.writeShort(s3);
            boolean bl = resultSetMetaData.isCurrency(i + 1);
            pJFDataOutput.writeBoolean(bl);
            jAttributeArray[i] = new Attribute(string, Types.sqlTypeToType(n2), n3, s, n3, s2, bl);
        }
        long l2 = pJFDataOutput.getPosition();
        pJFDataOutput.writeLong(0L);
        RelationMetaData relationMetaData = new RelationMetaData(jAttributeArray);
        VersionRecord versionRecord = new VersionRecord(relationMetaData);
        while (resultSet.next()) {
            int n4 = 0;
            ++l;
            block21: for (int i = 1; i <= n; ++i) {
                switch (resultSetMetaData.getColumnType(i)) {
                    case 2003: {
                        Array array = resultSet.getArray(i);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(2003);
                            continue block21;
                        }
                        versionRecord.putArray(new JinfonetArray(array));
                        continue block21;
                    }
                    case 2: 
                    case 3: {
                        BigDecimal bigDecimal = resultSet.getBigDecimal(i);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(3);
                            continue block21;
                        }
                        versionRecord.putBigDecimal(bigDecimal);
                        continue block21;
                    }
                    case 2004: {
                        Blob blob = resultSet.getBlob(i);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(2004);
                            continue block21;
                        }
                        versionRecord.putBlob(new JinfonetBlob(blob));
                        continue block21;
                    }
                    case -7: 
                    case 16: {
                        boolean bl = resultSet.getBoolean(i);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(-7);
                            continue block21;
                        }
                        versionRecord.putBoolean(bl);
                        continue block21;
                    }
                    case -6: {
                        byte by = resultSet.getByte(i);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(-6);
                            continue block21;
                        }
                        versionRecord.putByte(by);
                        continue block21;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        byte[] byArray = resultSet.getBytes(i);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(-2);
                            continue block21;
                        }
                        versionRecord.putBytes(byArray);
                        continue block21;
                    }
                    case 2005: {
                        Clob clob = resultSet.getClob(i);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(2005);
                            continue block21;
                        }
                        versionRecord.putClob(new JinfonetClob(clob));
                        continue block21;
                    }
                    case 91: {
                        Date date = resultSet.getDate(i);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(91);
                            continue block21;
                        }
                        versionRecord.putDate(new JinfonetDate(date.getTime()));
                        continue block21;
                    }
                    case 6: 
                    case 8: {
                        double d = resultSet.getDouble(i);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(8);
                            continue block21;
                        }
                        versionRecord.putDouble(d);
                        continue block21;
                    }
                    case 7: {
                        float f = resultSet.getFloat(i);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(6);
                            continue block21;
                        }
                        versionRecord.putFloat(f);
                        continue block21;
                    }
                    case 4: {
                        int n5 = resultSet.getInt(i);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(4);
                            continue block21;
                        }
                        versionRecord.putInt(n5);
                        continue block21;
                    }
                    case -5: {
                        long l3 = resultSet.getLong(i);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(-5);
                            continue block21;
                        }
                        versionRecord.putLong(l3);
                        continue block21;
                    }
                    case 0: {
                        versionRecord.putNull(0);
                        continue block21;
                    }
                    case 5: {
                        short s = resultSet.getShort(i);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(5);
                            continue block21;
                        }
                        versionRecord.putLong(s);
                        continue block21;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        String string = resultSet.getString(i);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(12);
                            continue block21;
                        }
                        versionRecord.putString(string);
                        continue block21;
                    }
                    case 92: {
                        Time time2 = resultSet.getTime(i);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(92);
                            continue block21;
                        }
                        versionRecord.putTime(new JinfonetTime(time2.getTime()));
                        continue block21;
                    }
                    case 93: {
                        Timestamp timestamp = resultSet.getTimestamp(i);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(93);
                            continue block21;
                        }
                        versionRecord.putTimeStamp(new JinfonetTimeStamp(timestamp.getTime()));
                        continue block21;
                    }
                    default: {
                        String string = "colName = " + resultSetMetaData.getColumnName(i) + ";type = " + resultSetMetaData.getColumnType(i);
                        throw new UnsupportedOperationException(string);
                    }
                }
            }
            n4 = versionRecord.getRecordSize();
            buffered4WriteRsd.putInt(n4);
            buffered4WriteRsd.putBytes(versionRecord.getRecordData(), n4);
            versionRecord.reset();
        }
        buffered4WriteRsd.finish();
        long l4 = pJFDataOutput.getPosition();
        pJFDataOutput.seek(l2);
        pJFDataOutput.writeLong(l);
        pJFDataOutput.seek(l4);
    }

    public ResultSet loadResultSet(DataInput dataInput, int n, String string) throws IOException, DSException, OutOfSpaceException {
        if (n >= 131073) {
            if (string.equals("DHTML Result With PLS")) {
                return new FileBasedResultSet(dataInput, this.SEDU, n);
            }
            IRelationData iRelationData = this.SEDU(dataInput, n);
            ResultSetAdapterRelationDataCanClose resultSetAdapterRelationDataCanClose = new ResultSetAdapterRelationDataCanClose(iRelationData);
            return resultSetAdapterRelationDataCanClose;
        }
        return this.SaveTo(dataInput);
    }

    private IRelationData SEDU(DataInput dataInput, int n) throws IOException, DSException {
        int n2 = dataInput.readShort();
        int[] nArray = new int[n2 + 1];
        JAttribute[] jAttributeArray = new JAttribute[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i + 1] = dataInput.readInt();
            int n3 = Types.sqlTypeToType(nArray[i + 1]);
            String string = dataInput.readUTF();
            if (string.equals("")) {
                string = "NULL";
            }
            int n4 = dataInput.readInt();
            short s = dataInput.readShort();
            short s2 = dataInput.readShort();
            short s3 = dataInput.readShort();
            boolean bl = dataInput.readBoolean();
            jAttributeArray[i] = new Attribute(string, n3, n4, s, n4, s2, bl);
        }
        RelationMetaData relationMetaData = new RelationMetaData(jAttributeArray);
        RelationOption relationOption = new RelationOption();
        relationOption.setDiskStore(this.add.getDiskStore());
        RelationPool relationPool = new RelationPool(null, relationMetaData, relationOption);
        VersionRecord versionRecord = new VersionRecord(relationMetaData, n, nArray);
        long l = dataInput.readLong();
        if (n >= 131329) {
            byte[] byArray = versionRecord.getRecordData();
            Buffered4ReadRsd buffered4ReadRsd = new Buffered4ReadRsd(dataInput, this.SEDU);
            int n5 = 0;
            while ((long)n5 < l) {
                int n6 = buffered4ReadRsd.readInt();
                versionRecord.setDataLength(n6);
                if (byArray.length < n6) {
                    versionRecord.resetRecordSize(n6);
                    byArray = versionRecord.getRecordData();
                }
                buffered4ReadRsd.stuffData(byArray, n6);
                relationPool.appendRecord(versionRecord);
                ++n5;
            }
            relationPool.appendFinished();
            return relationPool;
        }
        dataInput.readInt();
        byte[] byArray = versionRecord.getRecordData();
        int n7 = 0;
        while ((long)n7 < l) {
            int n8 = dataInput.readInt();
            versionRecord.setDataLength(n8);
            if (byArray.length < n8) {
                versionRecord.resetRecordSize(n8);
                byArray = versionRecord.getRecordData();
            }
            dataInput.readFully(byArray, 0, n8);
            relationPool.appendRecord(versionRecord);
            ++n7;
        }
        relationPool.appendFinished();
        return relationPool;
    }

    private ResultSet SaveTo(DataInput dataInput) throws IOException, OutOfSpaceException {
        ArrayList arrayList = new ArrayList();
        DbRecordModel dbRecordModel = this.add(dataInput);
        String string = this.getTempFileName();
        Hashtable hashtable = this.afterNewTree(dataInput, dbRecordModel, string, arrayList);
        dataInput.readInt();
        DbBuffer dbBuffer = this.append(dataInput, dbRecordModel, hashtable);
        ResultSetAdapterDbBuffer resultSetAdapterDbBuffer = new ResultSetAdapterDbBuffer(dbBuffer, arrayList);
        return resultSetAdapterDbBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbRecordModel add(DataInput dataInput) throws IOException {
        DbColDesc[] dbColDescArray;
        int n = dataInput.readInt();
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PJFDataInput pJFDataInput = new PJFDataInput(byteArrayInputStream);
        try {
            dbColDescArray = this.addRecord(pJFDataInput);
        }
        finally {
            pJFDataInput.close();
        }
        DbRecordModel dbRecordModel = new DbRecordModel(dbColDescArray, (Groupable)null);
        return dbRecordModel;
    }

    private DbColDesc[] addRecord(PJFDataInput pJFDataInput) throws IOException {
        int n = pJFDataInput.readShort();
        if (pJFDataInput instanceof VersionControlable) {
            int n2 = pJFDataInput.getVersion();
            int n3 = n2 >= 11 || n2 == 0 ? pJFDataInput.readInt() : (int)pJFDataInput.readShort();
        }
        DbColDesc[] dbColDescArray = new DbColDesc[n];
        for (int i = 0; i < n; ++i) {
            int n4;
            short s = pJFDataInput.readShort();
            String string = pJFDataInput.readUTF();
            if (string.equals("")) {
                string = "NULL";
            }
            int n5 = (n4 = pJFDataInput.getVersion()) >= 131097 || n4 == 0 ? pJFDataInput.readInt() : (int)pJFDataInput.readShort();
            short s2 = pJFDataInput.readShort();
            short s3 = pJFDataInput.readShort();
            short s4 = pJFDataInput.readShort();
            int n6 = pJFDataInput.readInt();
            String string2 = pJFDataInput.readUTF();
            pJFDataInput.readBoolean();
            dbColDescArray[i] = new DbColDesc(string, s, n5, s2, s3);
            dbColDescArray[i].setFlag(n6);
            dbColDescArray[i].setEncodingName(string2);
        }
        pJFDataInput.readShort();
        pJFDataInput.readInt();
        pJFDataInput.readInt();
        return dbColDescArray;
    }

    private Hashtable afterNewTree(DataInput dataInput, DbRecordModel dbRecordModel, String string, ArrayList arrayList) throws IOException, OutOfSpaceException {
        Hashtable<DbColDesc, RAFile> hashtable = new Hashtable<DbColDesc, RAFile>();
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInput.readInt();
            String string2 = string + ".col" + n2;
            File file = this.add.getDiskStore().createFile(string2);
            RAFile rAFile = new RAFile(file, "rw");
            int n3 = dataInput.readInt();
            this.appendFinished(dataInput, n3, rAFile);
            this.add.getDiskStore().fileUpdated(file);
            DbColDesc dbColDesc = dbRecordModel.getColDesc(n2);
            rAFile.seek(0L);
            hashtable.put(dbColDesc, rAFile);
            arrayList.add(string2);
        }
        return hashtable;
    }

    private DbBuffer append(DataInput dataInput, DbRecordModel dbRecordModel, Hashtable hashtable) throws IOException {
        NDbPage nDbPage;
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        NDbBuffer nDbBuffer = new NDbBuffer(dbRecordModel, hashtable, n2);
        nDbBuffer.initFile();
        nDbBuffer.setNeedWaitFetch(false);
        nDbBuffer.setRecPerPage(n2);
        int n3 = n / n2;
        for (int i = 0; i < n3; ++i) {
            nDbPage = null;
            Record record = nDbBuffer.getRecordModel().createRecord();
            nDbPage = new NDbPage(nDbBuffer, i);
            nDbPage.read(dataInput);
            for (int j = 0; j < n2; ++j) {
                nDbPage.refreshRecord(j, record, false);
                nDbBuffer.addRecord(record);
            }
        }
        if (n % n2 > 0) {
            Record record = nDbBuffer.getRecordModel().createRecord();
            nDbPage = null;
            nDbPage = new NDbPage(nDbBuffer, n3);
            nDbPage.read(dataInput);
            for (int i = 0; i < nDbBuffer.getRealRowNumberByRowNumber(n % n2); ++i) {
                nDbPage.refreshRecord(i, record, false);
                nDbBuffer.addRecord(record);
            }
        }
        nDbBuffer.finish();
        return nDbBuffer;
    }

    private void appendFinished(DataInput dataInput, int n, DataOutput dataOutput) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        for (n2 = n / 4096; n2 > 0; --n2) {
            dataInput.readFully(byArray);
            dataOutput.write(byArray);
        }
        n2 = n % 4096;
        dataInput.readFully(byArray, 0, n2);
        dataOutput.write(byArray, 0, n2);
    }

    public void writeReportNames(DataOutput dataOutput, String[] stringArray) throws IOException {
        int n = stringArray.length;
        dataOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dataOutput.writeUTF(stringArray[i]);
        }
    }

    public String[] loadReportNames(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = dataInput.readUTF();
        }
        return stringArray;
    }

    public void writeRptInfo(DataOutput dataOutput, Hashtable hashtable) throws IOException {
        dataOutput.writeInt(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            dataOutput.writeInt(n);
            this.saveMapInfoForVector(dataOutput, (Map)hashtable.get(n));
        }
    }

    public Hashtable loadRptInfo(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        Hashtable<Integer, Map> hashtable = new Hashtable<Integer, Map>(n);
        for (int i = 0; i < n; ++i) {
            Integer n2 = new Integer(dataInput.readInt());
            Map map = this.loadMapInfoForVector(dataInput);
            hashtable.put(n2, map);
        }
        return hashtable;
    }

    public void writeDataSetInfo(DataOutput dataOutput, Hashtable hashtable) throws IOException {
        dataOutput.writeInt(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            dataOutput.writeInt(n);
            Vector vector = (Vector)hashtable.get(n);
            dataOutput.writeInt(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                dataOutput.writeUTF((String)vector.elementAt(i));
            }
        }
    }

    public Hashtable loadDataSetInfo(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        Hashtable hashtable = new Hashtable(n);
        for (int i = 0; i < n; ++i) {
            Integer n2 = new Integer(dataInput.readInt());
            int n3 = dataInput.readInt();
            Vector<String> vector = new Vector<String>();
            for (int j = 0; j < n3; ++j) {
                vector.add(dataInput.readUTF());
            }
            hashtable.put(n2, vector);
        }
        return hashtable;
    }

    public void writeParameter(DataOutput dataOutput, Map map) throws IOException {
        this.saveMapInfoForStrings(dataOutput, map);
    }

    public Map loadparameter(DataInput dataInput, int n) throws IOException, VersionException {
        if (n < 131073) {
            try {
                String string = this.getTempFileName() + ".prm";
                File file = new File(string);
                this.createTempFile(dataInput, string);
                HashMap hashMap = new ParameterConvertor().prepareFileValues(string);
                this.add.getDiskStore().delete(file);
                return hashMap;
            }
            catch (IOException iOException) {
                throw new VersionException(iOException);
            }
            catch (OutOfSpaceException outOfSpaceException) {
                throw new VersionException(outOfSpaceException);
            }
        }
        if (n < 131585) {
            return this.loadMapInfoForString(dataInput);
        }
        return this.loadMapInfoForStrings(dataInput);
    }

    protected void writeBindInfo(DataOutput dataOutput, Hashtable hashtable) throws VersionException {
        try {
            Set set = hashtable.keySet();
            dataOutput.writeInt(set.size());
            for (String string : set) {
                dataOutput.writeUTF(string);
                String[][] stringArray = (String[][])hashtable.get(string);
                int n = stringArray.length;
                dataOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    String[] stringArray2 = stringArray[i];
                    int n2 = stringArray2.length;
                    dataOutput.writeInt(n2);
                    for (int j = 0; j < n2; ++j) {
                        dataOutput.writeUTF(stringArray2[j]);
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new VersionException(407207, (Throwable)iOException);
        }
    }

    public Hashtable loadBindInfo(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        Hashtable<String, String[][]> hashtable = new Hashtable<String, String[][]>(n);
        for (int i = 0; i < n; ++i) {
            String string = dataInput.readUTF();
            int n2 = dataInput.readInt();
            String[][] stringArrayArray = new String[n2][];
            for (int j = 0; j < n2; ++j) {
                int n3 = dataInput.readInt();
                String[] stringArray = new String[n3];
                for (int k = 0; k < n3; ++k) {
                    stringArray[k] = dataInput.readUTF();
                }
                stringArrayArray[j] = stringArray;
            }
            hashtable.put(string, stringArrayArray);
        }
        return hashtable;
    }

    private void appendRecord(DataOutput dataOutput, String string) throws IOException {
        File file = new File(string);
        this.booleanValue(dataOutput, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void booleanValue(DataOutput dataOutput, File file) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        try {
            byte[] byArray = new byte[4096];
            long l = file.length();
            dataOutput.writeLong(l);
            for (long i = l / 4096L; i > 0L; --i) {
                dataInputStream.readFully(byArray);
                dataOutput.write(byArray);
            }
            int n = (int)(l % 4096L);
            dataInputStream.readFully(byArray, 0, n);
            dataOutput.write(byArray, 0, n);
        }
        finally {
            dataInputStream.close();
        }
    }

    public static void writeStream(OutputStream outputStream, InputStream inputStream, long l) throws IOException {
        if (l == -1L) {
            l = Long.MAX_VALUE;
        }
        byte[] byArray = new byte[4096];
        while (l > 0L) {
            int n;
            int n2 = 4096;
            if ((long)n2 > l) {
                n2 = (int)l;
            }
            if ((n = inputStream.read(byArray, 0, n2)) == -1) {
                return;
            }
            outputStream.write(byArray, 0, n);
            l -= (long)n;
        }
    }

    private void close(PJFDataOutput pJFDataOutput, String string) throws IOException, OutOfSpaceException {
        File file = new File(string);
        ZipToolkit.zip(pJFDataOutput, file, this.getTempFileName() + ".temp", this.add.getDiskStore());
    }

    private void createFile(PJFDataInput pJFDataInput, File file) throws IOException, OutOfSpaceException {
        ZipToolkit.unzip(pJFDataInput, file, this.getTempFileName() + ".temp", this.add.getDiskStore());
    }

    private InputStream createNamingSystem(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        byte[] byArray = new byte[4096];
        for (long i = (long)(n / 4096); i > 0L; --i) {
            dataInput.readFully(byArray);
            byteArrayOutputStream.write(byArray);
        }
        int n2 = n % 4096;
        dataInput.readFully(byArray, 0, n2);
        byteArrayOutputStream.write(byArray, 0, n2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.close();
        return byteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRecord(PJFDataInput pJFDataInput, File file) throws IOException, OutOfSpaceException {
        this.add.getDiskStore().fileUpdated(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            int n;
            byte[] byArray = new byte[4096];
            if (pJFDataInput.getVersion() < 131329) {
                int n2 = pJFDataInput.readInt();
                for (long i = (long)(n2 / 4096); i > 0L; --i) {
                    pJFDataInput.readFully(byArray);
                    fileOutputStream.write(byArray);
                }
                n = n2 % 4096;
            } else {
                long l = pJFDataInput.readLong();
                for (long i = l / 4096L; i > 0L; --i) {
                    pJFDataInput.readFully(byArray);
                    fileOutputStream.write(byArray);
                }
                n = (int)(l % 4096L);
            }
            pJFDataInput.readFully(byArray, 0, n);
            fileOutputStream.write(byArray, 0, n);
        }
        finally {
            fileOutputStream.close();
            this.add.getDiskStore().fileUpdated(file);
        }
    }

    String getTempFileName() {
        return this.getTempPath() + this.LoadNoCache.nextInt();
    }

    public String getTempPath() {
        String string = this.tempPath;
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    public File getTempFile(String string) throws OutOfSpaceException, IOException {
        if (!string.equals("")) {
            File file = File.createTempFile(string, ".temp", new File(this.tempPath));
            return this.add.getDiskStore().createFile(file.getAbsolutePath());
        }
        File file = File.createTempFile(String.valueOf(this.LoadNoCache.nextInt()), ".temp", new File(this.tempPath));
        return this.add.getDiskStore().createFile(file.getAbsolutePath());
    }

    public void saveMapInfoForVector(DataOutput dataOutput, Map map) throws IOException {
        Set set = map.keySet();
        dataOutput.writeInt(set.size());
        for (String string : set) {
            dataOutput.writeUTF(string);
            Vector vector = (Vector)map.get(string);
            int n = vector.size();
            dataOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                dataOutput.writeUTF((String)vector.get(i));
            }
        }
    }

    public Map loadMapInfoForVector(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        HashMap hashMap = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            String string = dataInput.readUTF();
            int n2 = dataInput.readInt();
            Vector<String> vector = new Vector<String>(n2);
            for (int j = 0; j < n2; ++j) {
                vector.add(dataInput.readUTF());
            }
            hashMap.put(string, vector);
        }
        return hashMap;
    }

    public void saveMapInfoForString(DataOutput dataOutput, Map map) throws IOException {
        Set set = map.keySet();
        dataOutput.writeInt(set.size());
        for (String string : set) {
            dataOutput.writeUTF(string);
            dataOutput.writeUTF((String)map.get(string));
        }
    }

    public void saveMapInfoForStrings(DataOutput dataOutput, Map map) throws IOException {
        Set set = map.keySet();
        dataOutput.writeInt(set.size());
        for (String string : set) {
            String[] stringArray = (String[])map.get(string);
            dataOutput.writeUTF(string);
            dataOutput.writeInt(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                dataOutput.writeUTF(stringArray[i]);
            }
        }
    }

    public void saveMapInfoForInteger(DataOutput dataOutput, Map map) throws IOException {
        Set set = map.keySet();
        dataOutput.writeInt(set.size());
        for (String string : set) {
            dataOutput.writeUTF(string);
            dataOutput.writeInt((Integer)map.get(string));
        }
    }

    public Map loadMapInfoForString(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        HashMap<String, String> hashMap = new HashMap<String, String>(n);
        for (int i = 0; i < n; ++i) {
            hashMap.put(dataInput.readUTF(), dataInput.readUTF());
        }
        return hashMap;
    }

    public Map loadMapInfoForStrings(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>(n);
        for (int i = 0; i < n; ++i) {
            String string = dataInput.readUTF();
            int n2 = dataInput.readInt();
            String[] stringArray = new String[n2];
            for (int j = 0; j < n2; ++j) {
                stringArray[j] = dataInput.readUTF();
            }
            hashMap.put(string, stringArray);
        }
        return hashMap;
    }

    public Map loadMapInfoForInteger(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(n);
        for (int i = 0; i < n; ++i) {
            hashMap.put(dataInput.readUTF(), new Integer(dataInput.readInt()));
        }
        return hashMap;
    }

    public String getKey(int n, String string) {
        return n + string + string.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTempFile(DataInput dataInput, String string) throws IOException, FileNotFoundException, OutOfSpaceException {
        int n = dataInput.readInt();
        if (n > 0) {
            File file = this.add.getDiskStore().createFile(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            try {
                this.appendFinished(dataInput, n, dataOutputStream);
            }
            finally {
                dataOutputStream.close();
                fileOutputStream.close();
                this.add.getDiskStore().fileUpdated(file);
            }
        }
    }

    public Hashtable readCQRsAddressTable(Hashtable hashtable, String string, RandomInputable randomInputable) throws IOException {
        Long l = (Long)hashtable.get(string);
        randomInputable.seek(l);
        long l2 = randomInputable.readLong();
        randomInputable.seek(l2);
        randomInputable.getPosition();
        int n = randomInputable.readInt();
        Hashtable hashtable2 = new Hashtable(n);
        for (int i = 0; i < n; ++i) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            String string2 = randomInputable.readUTF();
            long l3 = randomInputable.readLong();
            randomInputable.seek(l3);
            int n2 = randomInputable.readInt();
            for (int j = 0; j < n2; ++j) {
                arrayList.add(new Long(randomInputable.readLong()));
            }
            hashtable2.put(string2, arrayList);
        }
        return hashtable2;
    }

    public String[] loadCQRFiles(Hashtable hashtable, RandomInputable randomInputable, String string) throws IOException, OutOfSpaceException {
        String string2 = this.getTempFileName();
        ArrayList arrayList = (ArrayList)hashtable.get(string.substring(0, string.lastIndexOf(".")));
        int n = arrayList.size();
        String[] stringArray = new String[n];
        int n2 = 2;
        for (int i = 0; i < n; ++i) {
            randomInputable.seek((Long)arrayList.get(i));
            String string3 = randomInputable.readUTF();
            String string4 = string2 + string3;
            File file = this.add.getDiskStore().createFile(string4);
            RAFile rAFile = new RAFile(file, "rw");
            long l = randomInputable.readLong();
            byte[] byArray = new byte[4096];
            for (long j = l / 4096L; j > 0L; --j) {
                randomInputable.readFully(byArray);
                rAFile.write(byArray);
            }
            int n3 = (int)l % 4096;
            randomInputable.readFully(byArray, 0, n3);
            rAFile.write(byArray, 0, n3);
            this.add.getDiskStore().fileUpdated(file);
            if (string3.equals("")) {
                stringArray[0] = string4;
                continue;
            }
            if (string3.equals(".desc")) {
                stringArray[1] = string4;
                continue;
            }
            stringArray[n2] = string4;
            ++n2;
        }
        return stringArray;
    }

    public void writePrecision(DataOutputStream dataOutputStream, Hashtable hashtable) throws VersionException {
        try {
            Enumeration enumeration = hashtable.keys();
            dataOutputStream.writeInt(hashtable.size());
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeBoolean((Boolean)hashtable.get(string));
            }
        }
        catch (IOException iOException) {
            throw new VersionException(iOException);
        }
    }

    public Hashtable readPrecision(DataInput dataInput) throws VersionException {
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        try {
            int n = dataInput.readInt();
            for (int i = 0; i < n; ++i) {
                String string = dataInput.readUTF();
                boolean bl = dataInput.readBoolean();
                hashtable.put(string, new Boolean(bl));
            }
            return hashtable;
        }
        catch (IOException iOException) {
            throw new VersionException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSerializable(DataOutput dataOutput, Serializable serializable) throws IOException {
        if (serializable == null) {
            dataOutput.writeBoolean(false);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            try {
                objectOutputStream.writeObject(serializable);
            }
            finally {
                objectOutputStream.close();
            }
            dataOutput.writeBoolean(true);
            dataOutput.writeInt(byteArrayOutputStream.size());
            dataOutput.write(byteArrayOutputStream.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readSerializable(DataInput dataInput) throws IOException, ClassNotFoundException {
        Object object = null;
        boolean bl = dataInput.readBoolean();
        if (bl) {
            int n = dataInput.readInt();
            byte[] byArray = new byte[n];
            dataInput.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                object = objectInputStream.readObject();
            }
            finally {
                objectInputStream.close();
            }
        }
        return object;
    }

    public void saveIdxInfoForVrctor(DataOutputStream dataOutputStream, Vector vector) throws VersionException {
        try {
            if (vector == null) {
                dataOutputStream.writeBoolean(true);
                return;
            }
            dataOutputStream.writeBoolean(false);
            dataOutputStream.writeInt(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                RSDRptInfo rSDRptInfo = (RSDRptInfo)vector.get(i);
                dataOutputStream.writeInt(rSDRptInfo.getPIndex());
                dataOutputStream.writeUTF(rSDRptInfo.getViewName());
                dataOutputStream.writeUTF(rSDRptInfo.getRptName());
                dataOutputStream.writeUTF(rSDRptInfo.getId());
                dataOutputStream.writeInt(rSDRptInfo.getSIndex());
            }
        }
        catch (IOException iOException) {
            throw new VersionException(iOException);
        }
    }

    public Vector loadIdxInfoForVrctor(DataInput dataInput) throws VersionException {
        try {
            boolean bl = dataInput.readBoolean();
            if (bl) {
                Object var2_3 = null;
                return null;
            }
            Vector<RSDRptInfo> vector = new Vector<RSDRptInfo>();
            int n = dataInput.readInt();
            for (int i = 0; i < n; ++i) {
                int n2 = dataInput.readInt();
                String string = dataInput.readUTF();
                String string2 = dataInput.readUTF();
                String string3 = dataInput.readUTF();
                int n3 = dataInput.readInt();
                RSDRptInfo rSDRptInfo = new RSDRptInfo(n2, string, string2, string3, n3);
                vector.add(rSDRptInfo);
            }
            return vector;
        }
        catch (IOException iOException) {
            throw new VersionException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String string, String string2) throws IOException, OutOfSpaceException {
        File file = new File(string);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                File file2 = this.add.getDiskStore().createFile(string2);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                try {
                    byte[] byArray = new byte[1024];
                    while (fileInputStream.read(byArray) != -1) {
                        fileOutputStream.write(byArray);
                    }
                }
                finally {
                    fileOutputStream.close();
                    this.add.getDiskStore().fileUpdated(file2);
                }
            }
            finally {
                fileInputStream.close();
            }
        }
    }

    class ResultSetAdapterRelationDataCanClose
    extends ResultSetAdapterRelationData {
        IRelationData relationData;

        public ResultSetAdapterRelationDataCanClose(IRelationData iRelationData) throws DSException {
            super(iRelationData);
            this.relationData = iRelationData;
        }

        @Override
        public void close() throws SQLException {
            super.close();
            try {
                this.relationData.close();
            }
            catch (DSException dSException) {
                throw new SQLException(dSException.getMessage());
            }
        }
    }
}

