/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import jet.datastream.Communicator;
import jet.export.ExportAuxInfo;
import jet.ie.AbstractRSTExporter;
import jet.ie.ConvertToJCommunicator;
import jet.ie.RSTBlockWriter;
import jet.ie.RSTWriteTool;
import jet.ie.VersionException;
import jet.ie.io.FileBlockOutputStream;
import jet.ie.io.PJFDataOutput;
import jet.rptengine.JCommunicator;
import jet.security.PageFilter;
import jet.util.JRInterruptedException;
import jet.util.RAFile;

public class RSTBlockSaveController
extends AbstractRSTExporter {
    private boolean SEDU = false;
    private PJFDataOutput addNLSManagers = null;
    private RAFile append;
    private long close;
    private Hashtable createFile = new Hashtable();
    private boolean delete = true;
    private File error;

    public RSTBlockSaveController(String string, ExportAuxInfo exportAuxInfo) throws VersionException {
        super(exportAuxInfo);
        this.setFileName(string);
    }

    public RSTBlockSaveController(ExportAuxInfo exportAuxInfo) {
        super(exportAuxInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setFileName(String string) throws VersionException {
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, this + ": set file name of block RST file: " + string);
        }
        super.setFileName(string);
        if (this.SEDU) throw new RuntimeException("The rst filename has been set!");
        try {
            this.error = new File(this._fileName);
            if (this.error.exists()) {
                this.auxInfo.getDiskStore().delete(this.error);
            }
            this.error = this.auxInfo.getDiskStore().createFile(this._fileName);
            this.append = new RAFile(this.error, "rw");
            this.addNLSManagers = new PJFDataOutput(new FileBlockOutputStream(this.append));
            this.addNLSManagers.write(PJF_TAG);
            this.PJF_TAG(this.addNLSManagers);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, iOException);
            }
        }
        catch (OutOfSpaceException outOfSpaceException) {
            if (!JRLog.isError(2)) throw new VersionException(outOfSpaceException);
            JRLog.error(2, outOfSpaceException);
            throw new VersionException(outOfSpaceException);
        }
        this.SEDU = true;
    }

    @Override
    public void setReportInfos(Map map) {
        super.setReportInfos(map);
        if (this._mapInfo != null) {
            try {
                RSTWriteTool.writeMapInfo(this._mapInfo, this.addNLSManagers);
            }
            catch (IOException iOException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, iOException);
                }
            }
        } else if (JRLog.isError(2)) {
            JRLog.error(2, 2407001);
        }
    }

    @Override
    public void setReportAttachInfos(Map map) {
        block5: {
            super.setReportAttachInfos(map);
            try {
                if (this._attachInfo != null) {
                    RSTWriteTool.writeMapInfo(this._attachInfo, this.addNLSManagers);
                } else if (JRLog.isError(2)) {
                    JRLog.error(2, 2407001);
                }
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block5;
                JRLog.error(2, 2407005);
            }
        }
    }

    @Override
    public void zipRST(boolean bl) {
        block2: {
            super.zipRST(bl);
            try {
                this.addNLSManagers.writeBoolean(this._isZipRst);
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block2;
                JRLog.error(2, 2407005);
            }
        }
    }

    @Override
    public synchronized void setCommunicators(String string, String string2, Communicator communicator) throws VersionException {
        try {
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, this + ": begin write Communicator of block RST file: " + communicator);
            }
            if (communicator.isBeStopping()) {
                if (JRLog.isTrace(4)) {
                    JRLog.trace(4, "comm is stop when write communicator" + communicator);
                }
                throw new JRInterruptedException();
            }
            if (this.delete) {
                this.close = this.addNLSManagers.getPosition();
                this.addNLSManagers.writeLong(0L);
                this.delete = false;
            }
            String string3 = string.length() + string + string2.length() + string2;
            this.createFile.put(string3, new Long(this.addNLSManagers.getPosition()));
            JCommunicator jCommunicator = communicator instanceof PageFilter ? new ConvertToJCommunicator((PageFilter)communicator) : (JCommunicator)communicator;
            RSTBlockWriter rSTBlockWriter = new RSTBlockWriter(jCommunicator, this._isZipRst, this.allNLSManagers, this.allNLSMaps);
            rSTBlockWriter.setCatalogPath(this._catalogPath);
            long l = this.addNLSManagers.getPosition();
            this.addNLSManagers.writeLong(0L);
            rSTBlockWriter.write(this.addNLSManagers);
            long l2 = this.addNLSManagers.getPosition();
            long l3 = l2 - l - 4L;
            this.addNLSManagers.seek(l);
            this.addNLSManagers.writeLong(l3);
            this.addNLSManagers.seek(l2);
            this.addNLSManagers(string3, jCommunicator.getfieldNlsManagers());
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, this + ": end write Communicator of block RST file: " + communicator);
            }
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407004, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407004, (Throwable)exception);
            }
            throw new VersionException(407004, (Throwable)exception);
        }
    }

    @Override
    public void saveRSTFile() throws VersionException {
        try {
            long l = this.addNLSManagers.getPosition();
            this.addNLSManagers.writeInt(this.createFile.size());
            Enumeration enumeration = this.createFile.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                long l2 = (Long)this.createFile.get(string);
                this.addNLSManagers.writeUTF(string);
                this.addNLSManagers.writeLong(l2);
            }
            long l3 = this.addNLSManagers.getPosition();
            this.addNLSManagers.seek(this.close);
            this.addNLSManagers.writeLong(l);
            this.addNLSManagers.seek(l3);
            RSTWriteTool.writeNLSManagers(this.addNLSManagers, this.allNLSManagers, this.mainNLSManagerIndices);
            RSTWriteTool.writeNLSMaps(this.addNLSManagers, this.allNLSMaps);
            this.append.close();
            this.addNLSManagers.close();
            this.auxInfo.getDiskStore().fileUpdated(this.error);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, this + ": Finished save block RST file.");
            }
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407002);
            }
            throw new VersionException(407002, (Throwable)iOException);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, outOfSpaceException);
            }
            throw new VersionException(outOfSpaceException);
        }
    }

    private void PJF_TAG(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(264448);
        dataOutput.writeLong(1311768467294899695L);
        dataOutput.writeInt(4386);
    }
}

