/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import jet.datastream.Communicator;
import jet.export.ExportAuxInfo;
import jet.ie.PJFAux;
import jet.ie.PJFCommunicator;
import jet.ie.RSTBlockReader;
import jet.ie.RSTNLSMap;
import jet.ie.VersionException;
import jet.ie.io.PJFDataInput;
import jet.ie.io.RAStreamInput;
import jet.log.JRLogger;
import jet.util.JFieldValueNLSManager;
import jet.util.JRInterruptedException;
import jet.util.RAFInputStream;
import jet.util.RAFile;
import jet.util.RandomInputable;
import jet.util.image.ImageResourceCenter;
import jet.util.nls.INLSMap;

public class RSTLoadControler {
    public static final String NOREPORTSET = "noReportSet";
    private byte[] PJF_TAG = new byte[3];
    private int SEDU;
    private long add;
    private int append;
    private boolean available;
    private final String clear;
    private String close;
    private final RandomInputable createFile;
    private PJFDataInput createTempFile;
    private final ArrayList delete;
    private final Hashtable endsWith;
    private Map entries;
    private Map equals;
    private Hashtable error;
    private JFieldValueNLSManager[] exists;
    private Hashtable fileUpdated = new Hashtable();
    private INLSMap[] get;
    private Hashtable getAbsolutePath;
    private boolean getBaseFolderStr;
    private static JRLogger getDiskStore = JRLogger.getLogger(RSTLoadControler.class.getName());
    private Hashtable getInputStream = new Hashtable();
    private boolean getLogger = false;
    private ExportAuxInfo getName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSTLoadControler(String string, ExportAuxInfo exportAuxInfo) throws IOException {
        this.getName = exportAuxInfo;
        this.clear = string;
        if (string.endsWith(".wst")) {
            this.getLogger = true;
        }
        this.close = this.clear;
        this.delete = new ArrayList();
        this.endsWith = new Hashtable();
        this.getAbsolutePath = new Hashtable();
        this.getBaseFolderStr = false;
        boolean bl = false;
        FileInputStream fileInputStream = new FileInputStream(this.clear);
        try {
            if (fileInputStream.read() == 80 && fileInputStream.read() == 75) {
                bl = true;
            }
        }
        finally {
            fileInputStream.close();
        }
        if (bl) {
            ZipFile zipFile = new ZipFile(this.clear);
            ZipEntry zipEntry = zipFile.entries().nextElement();
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            long l = inputStream.available();
            this.createFile = new RAStreamInput(inputStream, l, this.getName.getDiskStore());
        } else {
            this.createFile = new RAFile(string, "r");
        }
        this.PJF_TAG();
    }

    private void PJF_TAG() throws IOException {
        try {
            this.createTempFile = new PJFDataInput(new RAFInputStream(this.createFile));
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407119, (Throwable)iOException);
            }
            throw iOException;
        }
    }

    public RSTLoadControler(RandomInputable randomInputable, ExportAuxInfo exportAuxInfo) throws IOException {
        this.getName = exportAuxInfo;
        this.clear = null;
        this.close = String.valueOf(randomInputable.hashCode());
        this.delete = new ArrayList();
        this.endsWith = new Hashtable();
        this.getAbsolutePath = new Hashtable();
        this.createFile = randomInputable;
        this.PJF_TAG();
        this.getBaseFolderStr = false;
    }

    public RSTLoadControler(InputStream inputStream, boolean bl, ExportAuxInfo exportAuxInfo) throws VersionException, IOException {
        this.getName = exportAuxInfo;
        this.clear = null;
        this.delete = new ArrayList();
        this.endsWith = new Hashtable();
        this.getAbsolutePath = new Hashtable();
        this.getBaseFolderStr = false;
        if (inputStream != null) {
            if (bl) {
                ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream));
                this.createFile = new RAStreamInput(zipInputStream, -1L, this.getName.getDiskStore());
                this.close = String.valueOf(this.createFile.hashCode());
            } else {
                this.createFile = new RAStreamInput(inputStream, inputStream.available(), this.getName.getDiskStore());
                this.close = String.valueOf(this.createFile.hashCode());
            }
        } else {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407121);
            }
            throw new VersionException(407121);
        }
        this.PJF_TAG();
    }

    public void openFile() throws VersionException {
        try {
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 0x433EE3);
                JRLog.trace(4, 0x433EE4, this.clear);
                JRLog.trace(4, 4407013, new Integer(this.SEDU));
            }
            this.createFile.read(this.PJF_TAG);
            if (!Arrays.equals(this.PJF_TAG, PJFAux.PJF_TAG)) {
                throw new VersionException(407101);
            }
            this.createTempFile(this.createFile);
            this.createTempFile.setVersion(this.SEDU);
            if (this.SEDU >= 262145) {
                this.entries = this.delete(this.createFile);
                this.equals = this.delete(this.createFile);
                long l = this.createFile.readLong();
                this.createFile.seek(l);
                this.error = this.endsWith(this.createFile);
                this.exists = this.add(this.createFile);
                this.fileUpdated = this.SEDU(this.createFile);
                if (this.SEDU >= 264448) {
                    this.get = this.append();
                }
            } else {
                this.entries = new HashMap();
                this.entries.put(NOREPORTSET, new Vector());
                this.equals = new HashMap();
            }
            this.getBaseFolderStr = true;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407122);
            }
            throw new VersionException(407122, (Throwable)iOException);
        }
    }

    private Hashtable SEDU(RandomInputable randomInputable) throws IOException {
        Hashtable<String, int[]> hashtable = new Hashtable<String, int[]>();
        if (this.SEDU < 262912) {
            int n = randomInputable.readInt();
            int n2 = 0;
            while (n2 < n) {
                String string = randomInputable.readUTF();
                hashtable.put(string, new int[]{n2++, 1});
            }
        } else {
            int n = randomInputable.readInt();
            for (int i = 0; i < n; ++i) {
                String string = randomInputable.readUTF();
                int n3 = randomInputable.readInt();
                int n4 = randomInputable.readInt();
                hashtable.put(string, new int[]{n3, n4});
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "The indices of the NLS managers for the main communicators is loaded.");
        }
        return hashtable;
    }

    private JFieldValueNLSManager[] add(RandomInputable randomInputable) throws VersionException {
        try {
            byte[] byArray = new byte[randomInputable.readInt()];
            randomInputable.read(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            JFieldValueNLSManager[] jFieldValueNLSManagerArray = JFieldValueNLSManager.readFieldValueNLSManager(byteArrayInputStream);
            return jFieldValueNLSManagerArray;
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407107, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407107);
            }
            throw new VersionException(407107, (Throwable)exception);
        }
    }

    private INLSMap[] append() throws VersionException {
        try {
            int n = this.createFile.readInt();
            INLSMap[] iNLSMapArray = new INLSMap[n];
            for (int i = 0; i < n; ++i) {
                long l = this.createFile.getPosition();
                iNLSMapArray[i] = RSTNLSMap.loadFromRST(this.createTempFile);
                long l2 = this.createFile.getPosition() - l;
                if (!JRLog.isTrace(6)) continue;
                JRLog.trace(6, "The INLSMap object of index " + i + " is read. Size in bytes: " + l2);
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, n + " INLSMap objects are read.");
            }
            return iNLSMapArray;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "Read NLS maps error.");
            }
            throw new VersionException(iOException);
        }
    }

    private List available(RandomInputable randomInputable) throws VersionException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            int n = randomInputable.readInt();
            for (int i = 0; i < n; ++i) {
                String string = randomInputable.readUTF();
                arrayList.add(string);
            }
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407107);
            }
            throw new VersionException(407107, (Throwable)iOException);
        }
        return arrayList;
    }

    public int readVersionNumber() throws VersionException {
        if (!this.getBaseFolderStr) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407120);
            }
            throw new VersionException(407120);
        }
        return this.SEDU;
    }

    public Map getReportInfos() throws VersionException {
        if (!this.getBaseFolderStr) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407120);
            }
            throw new VersionException(407120);
        }
        return this.entries;
    }

    public Map getReportAttachInfo() throws VersionException {
        if (!this.getBaseFolderStr) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407120);
            }
            throw new VersionException(407120);
        }
        return this.equals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Communicator getCommunicator(String string, String string2) throws VersionException {
        if (!this.getBaseFolderStr) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407120);
            }
            throw new VersionException(407120);
        }
        try {
            if (this.SEDU >= 262145) {
                RSTBlockReader rSTBlockReader;
                String string3 = string.length() + string + string2.length() + string2;
                Long l = (Long)this.error.get(string3);
                if (l == null) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2407105);
                    }
                    throw new VersionException(407105);
                }
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "Going to read a main communicator from rst.");
                    JRLog.trace(6, "The base registered image resources id is " + this.close);
                }
                this.createFile.seek(l);
                if (this.SEDU < 262176) {
                    int n = this.createFile.readInt();
                    File file = this.getName.getDiskStore().createTempFile("comm", ".temp");
                    this.delete.add(file);
                    this.endsWith.put(string3, file.getAbsolutePath());
                    byte[] byArray = new byte[4096];
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    try {
                        int n2;
                        for (n2 = n / 4096; n2 > 0; --n2) {
                            this.createFile.read(byArray);
                            fileOutputStream.write(byArray);
                        }
                        n2 = n % 4096;
                        this.createFile.read(byArray, 0, n2);
                        fileOutputStream.write(byArray, 0, n2);
                    }
                    finally {
                        fileOutputStream.close();
                        this.getName.getDiskStore().fileUpdated(file);
                    }
                    rSTBlockReader = new RSTBlockReader(new RAFile(file, "r"), this.createTempFile, this.SEDU, this.available, this.close, this.getInputStream, this.getLogger, this.exists, this.get);
                } else {
                    long l2 = this.createFile.readLong();
                    rSTBlockReader = new RSTBlockReader(this.createFile, this.createTempFile, this.SEDU, this.available, this.close, this.getInputStream, this.getLogger, this.exists, this.get);
                    rSTBlockReader.setBlockStartPoint(l);
                }
                PJFCommunicator pJFCommunicator = new PJFCommunicator(rSTBlockReader);
                this.getAbsolutePath.put(string3, pJFCommunicator);
                this.clear(pJFCommunicator, string3);
                return pJFCommunicator;
            }
            this.createFile.seek(0L);
            long l = this.createFile.length();
            File file = this.getName.getDiskStore().createTempFile("comm", ".temp");
            this.delete.add(file);
            this.endsWith.put(NOREPORTSET, file.getAbsolutePath());
            byte[] byArray = new byte[4096];
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                for (long i = l / 4096L; i > 0L; --i) {
                    this.createFile.read(byArray);
                    fileOutputStream.write(byArray);
                }
                int n = (int)(l % 4096L);
                this.createFile.read(byArray, 0, n);
                fileOutputStream.write(byArray, 0, n);
            }
            finally {
                fileOutputStream.close();
                this.getName.getDiskStore().fileUpdated(file);
            }
            RSTBlockReader rSTBlockReader = new RSTBlockReader(new RAFile(file, "r"), this.createTempFile, this.SEDU, this.available, this.close, this.getInputStream, this.getLogger, this.exists, this.get);
            rSTBlockReader.setBlockStartPoint(0L);
            PJFCommunicator pJFCommunicator = new PJFCommunicator(rSTBlockReader);
            this.getAbsolutePath.put(NOREPORTSET, pJFCommunicator);
            return pJFCommunicator;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407106);
            }
            throw new VersionException(407106, (Throwable)iOException);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, outOfSpaceException);
            }
            throw new VersionException(outOfSpaceException);
        }
    }

    private void clear(PJFCommunicator pJFCommunicator, String string) {
        JFieldValueNLSManager[] jFieldValueNLSManagerArray = this.close(string);
        int n = jFieldValueNLSManagerArray.length;
        if (n > 0) {
            Hashtable<String, JFieldValueNLSManager> hashtable = new Hashtable<String, JFieldValueNLSManager>();
            if (this.SEDU < 262912) {
                if (jFieldValueNLSManagerArray[0] != null) {
                    hashtable.put("FVNLS", jFieldValueNLSManagerArray[0]);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (jFieldValueNLSManagerArray[i] == null) continue;
                    hashtable.put(jFieldValueNLSManagerArray[i].getBaseFolderStr(), jFieldValueNLSManagerArray[i]);
                }
            }
            pJFCommunicator.setfFieldNlsManagerMap(hashtable);
        }
    }

    private JFieldValueNLSManager[] close(String string) {
        int[] nArray = (int[])this.fileUpdated.get(string);
        if (nArray == null) {
            return new JFieldValueNLSManager[0];
        }
        int n = nArray[0];
        int n2 = nArray[1];
        JFieldValueNLSManager[] jFieldValueNLSManagerArray = new JFieldValueNLSManager[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            if (n3 < 0 || n3 >= this.exists.length) continue;
            jFieldValueNLSManagerArray[i] = this.exists[n + i];
        }
        return jFieldValueNLSManagerArray;
    }

    public JFieldValueNLSManager[] getNLSManagers() throws VersionException {
        if (!this.getBaseFolderStr) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407120);
            }
            throw new VersionException(407120);
        }
        if (this.SEDU >= 262145) {
            return this.exists;
        }
        return null;
    }

    public void clear() throws VersionException {
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4407014);
        }
        try {
            if (this.clear != null && this.createFile != null) {
                this.createFile.close();
            }
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407116, (Throwable)iOException);
            }
            throw new VersionException(407116, (Throwable)iOException);
        }
        if (this.entries != null) {
            this.entries.clear();
            this.entries = null;
        }
        if (this.equals != null) {
            this.equals.clear();
            this.equals = null;
        }
        if (this.error != null) {
            this.error.clear();
            this.error = null;
        }
        if (this.get != null) {
            this.get = null;
        }
        if (this.getAbsolutePath != null) {
            Enumeration enumeration = this.getAbsolutePath.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                ((PJFCommunicator)this.getAbsolutePath.get(string)).close();
            }
            this.getAbsolutePath.clear();
            this.getAbsolutePath = null;
        }
        if (this.delete != null) {
            for (int i = 0; i < this.delete.size(); ++i) {
                File file = (File)this.delete.get(i);
                if (file == null || !file.exists()) continue;
                this.getName.getDiskStore().delete(file);
            }
        }
        this.createFile();
    }

    private void createFile() {
        Enumeration enumeration = this.getInputStream.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = (Integer)this.getInputStream.get(string);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Unregister image resource for " + n + " times when clearing rst loading.");
                JRLog.trace(6, "The registering id is " + string);
            }
            for (int i = 0; i < n; ++i) {
                ImageResourceCenter.unregisterImageResources(string);
            }
        }
    }

    public void delTempFileByReport(String string, String string2) {
        if (string.equals(NOREPORTSET)) {
            String string3 = NOREPORTSET;
            File file = new File((String)this.endsWith.get(string3));
            PJFCommunicator pJFCommunicator = (PJFCommunicator)this.getAbsolutePath.get(string3);
            pJFCommunicator.close();
            if (file.exists()) {
                this.getName.getDiskStore().delete(file);
            }
        } else {
            String string4 = string.length() + string + string2.length() + string2;
            File file = new File((String)this.endsWith.get(string4));
            PJFCommunicator pJFCommunicator = (PJFCommunicator)this.getAbsolutePath.get(string4);
            pJFCommunicator.close();
            if (file.exists()) {
                this.getName.getDiskStore().delete(file);
            }
        }
    }

    private void createTempFile(DataInput dataInput) throws VersionException {
        try {
            this.SEDU = dataInput.readInt();
            if (this.SEDU == 262146) {
                this.SEDU = 262145;
            }
            this.add = dataInput.readLong();
            this.append = dataInput.readInt();
            if (this.SEDU >= 262176) {
                this.available = dataInput.readBoolean();
            }
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407102, (Throwable)iOException);
            }
            throw new VersionException(407102, (Throwable)iOException);
        }
    }

    private Map delete(DataInput dataInput) throws VersionException {
        try {
            HashMap hashMap = new HashMap();
            int n = dataInput.readInt();
            if (n != 0) {
                for (int i = 0; i < n; ++i) {
                    int n2 = dataInput.readInt();
                    String string = dataInput.readUTF();
                    Vector<String[]> vector = new Vector<String[]>();
                    for (int j = 0; j < n2; ++j) {
                        int n3 = dataInput.readInt();
                        String[] stringArray = new String[n3];
                        for (int k = 0; k < n3; ++k) {
                            stringArray[k] = dataInput.readUTF();
                        }
                        vector.add(stringArray);
                    }
                    hashMap.put(string, vector);
                }
            }
            return hashMap;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407103, (Throwable)iOException);
            }
            throw new VersionException(407103, (Throwable)iOException);
        }
    }

    private Hashtable endsWith(DataInput dataInput) throws VersionException {
        try {
            int n = dataInput.readInt();
            Hashtable<String, Long> hashtable = new Hashtable<String, Long>(n);
            for (int i = 0; i < n; ++i) {
                String string = dataInput.readUTF();
                long l = dataInput.readLong();
                hashtable.put(string, new Long(l));
            }
            return hashtable;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407104, (Throwable)iOException);
            }
            throw new VersionException(407104, (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(String string) throws IOException, VersionException {
        try {
            File file = this.getName.getDiskStore().createFile(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                byte[] byArray = new byte[4096];
                long l = this.createFile.length();
                for (long i = l / 4096L; i > 0L; --i) {
                    this.createFile.readFully(byArray);
                    fileOutputStream.write(byArray);
                }
                int n = (int)(l % 4096L);
                this.createFile.readFully(byArray, 0, n);
                fileOutputStream.write(byArray, 0, n);
            }
            finally {
                fileOutputStream.close();
                this.getName.getDiskStore().fileUpdated(file);
            }
        }
        catch (OutOfSpaceException outOfSpaceException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, outOfSpaceException);
            }
            throw new VersionException(outOfSpaceException);
        }
    }
}

