/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import jet.connect.DbArray;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.JRecordModel;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.util.DSLog;
import jet.ie.Buffered4ReadRst;
import jet.ie.DBBufferConstantValues;
import jet.ie.RSTDbBuffer;
import jet.ie.RSTDbBufferCursor;
import jet.ie.RecordDataTool;
import jet.ie.RstRecordModel;
import jet.util.DbValueable;
import jet.util.RandomInputable;

public class RSTRecord
implements JRecord {
    private static DSLog SEDU = DSLog.getDSLog(RSTRecord.class.getName());
    private final RSTDbBufferCursor abs;
    private final DbValue[] add;
    private final DbValue[] append;
    private DbValue[] bNull;
    private RSTDbBuffer clear;
    private Record close;
    private JRecordModel columnCount;
    private int debug = 0;
    private RecordDataTool desc;
    public RandomInputable in;
    private int equalsIgnoreCase;
    private byte[] get;
    private int getArray = 1024;
    private int getBigDecimal;
    private boolean getBlob;
    private long[] getBoolean;
    private long getByte;
    private int getBytes;
    private int getCell;
    private HashMap getClob;
    private boolean getColDesc = false;
    private int getColDescs = 262176;
    private ArrayList getColIndex = new ArrayList();
    private Buffered4ReadRst getColName = null;

    public RSTRecord(RSTDbBufferCursor rSTDbBufferCursor, RSTDbBuffer rSTDbBuffer, DBBufferConstantValues dBBufferConstantValues) {
        int n;
        this.abs = rSTDbBufferCursor;
        DbColDesc[] dbColDescArray = rSTDbBuffer.getColDescs();
        RecordModelInfo recordModelInfo = new RecordModelInfo(dbColDescArray);
        this.add = new DbValue[dbColDescArray.length];
        for (n = 0; n < dbColDescArray.length; ++n) {
            this.add[n] = DbValue.makeDbValue(dbColDescArray[n]);
        }
        this.append = new DbValue[dbColDescArray.length];
        for (n = 0; n < dbColDescArray.length; ++n) {
            this.append[n] = DbValue.makeDbValue(dbColDescArray[n]);
        }
        this.clear = rSTDbBuffer;
        this.bNull = dBBufferConstantValues.values;
        this.getBigDecimal = rSTDbBuffer.getRecordCount();
        this.getBlob = true;
        this.columnCount = new RstRecordModel(recordModelInfo);
        this.columnCount.setGroupable(rSTDbBuffer.getRecordModel().getGroupable());
        this.close = new RSTRecord(recordModelInfo);
        for (n = 0; n < dbColDescArray.length; ++n) {
            if (dbColDescArray[n].isConstant()) {
                this.add[n].set(dBBufferConstantValues.values[n]);
                continue;
            }
            this.add[n] = this.close.getCell(n);
        }
    }

    public RSTRecord(RSTDbBufferCursor rSTDbBufferCursor, RecordModelInfo recordModelInfo, RandomInputable randomInputable, int n, long l, HashMap hashMap, int n2, boolean bl) {
        int n3;
        this.abs = rSTDbBufferCursor;
        this.getBlob = false;
        this.getBigDecimal = n;
        this.getClob = hashMap;
        this.in = randomInputable;
        this.getColDescs = n2;
        this.getBoolean = new long[this.getArray];
        try {
            this.getColName = new Buffered4ReadRst(this.in, l, bl);
        }
        catch (IOException iOException) {
            SEDU.debug(" occur error ." + iOException.getMessage());
            throw new RuntimeException(iOException.getMessage());
        }
        this.columnCount = rSTDbBufferCursor.getRecordModel();
        DbColDesc[] dbColDescArray = this.columnCount.getColDescs();
        this.add = new DbValue[dbColDescArray.length];
        for (n3 = 0; n3 < dbColDescArray.length; ++n3) {
            this.add[n3] = DbValue.makeDbValue(dbColDescArray[n3]);
            if (!dbColDescArray[n3].isConstant()) continue;
            this.add[n3].setValue((DbValue)hashMap.get(dbColDescArray[n3]));
        }
        this.append = new DbValue[dbColDescArray.length];
        for (n3 = 0; n3 < dbColDescArray.length; ++n3) {
            this.append[n3] = DbValue.makeDbValue(dbColDescArray[n3]);
        }
        this.desc = new RecordDataTool(recordModelInfo);
        this.get = this.desc.getRecordData();
        try {
            this.getByte = l;
            this.SEDU(1);
        }
        catch (IOException iOException) {
            SEDU.debug(" occur error ." + iOException.getMessage());
            throw new RuntimeException(iOException.getMessage());
        }
    }

    private RSTRecord(RecordModelInfo recordModelInfo) {
        int n;
        DbColDesc[] dbColDescArray = recordModelInfo.getColDescs();
        this.add = new DbValue[dbColDescArray.length];
        for (n = 0; n < dbColDescArray.length; ++n) {
            this.add[n] = DbValue.makeDbValue(dbColDescArray[n]);
        }
        this.append = new DbValue[dbColDescArray.length];
        for (n = 0; n < dbColDescArray.length; ++n) {
            this.append[n] = DbValue.makeDbValue(dbColDescArray[n]);
        }
        this.columnCount = new RstRecordModel(recordModelInfo);
        this.abs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SEDU(int n) throws IOException {
        RandomInputable randomInputable = this.in;
        synchronized (randomInputable) {
            if (this.getColDescs < 262176) {
                this.getBytes = n;
                long l = this.getByte + (long)(4 * (n - 1));
                this.in.seek(l);
                if (n + this.getArray > this.getBigDecimal) {
                    int n2 = this.getBigDecimal - n;
                    this.getCell = this.getBigDecimal;
                    for (int i = 0; i <= n2; ++i) {
                        this.getBoolean[i] = (long)this.in.readInt() + this.getByte;
                    }
                } else {
                    this.getCell = n + this.getArray - 1;
                    for (int i = 0; i < this.getArray; ++i) {
                        this.getBoolean[i] = (long)this.in.readInt() + this.getByte;
                    }
                }
            } else if (this.getColDescs >= 262176) {
                this.getColIndex.clear();
                this.getBytes = n;
                long l = this.getByte + (long)(12 * (n - 1));
                this.in.seek(l);
                if (n + this.getArray > this.getBigDecimal) {
                    int n3 = this.getBigDecimal - n;
                    this.getCell = this.getBigDecimal;
                    for (int i = 0; i <= n3; ++i) {
                        this.getBoolean[i] = this.in.readLong();
                        this.getColIndex.add(new Integer(this.in.readInt()));
                    }
                } else {
                    this.getCell = n + this.getArray - 1;
                    for (int i = 0; i < this.getArray; ++i) {
                        this.getBoolean[i] = this.in.readLong();
                        this.getColIndex.add(new Integer(this.in.readInt()));
                    }
                }
            }
        }
    }

    private long abs(int n) throws IOException {
        if (this.append(n)) {
            this.SEDU(n);
        }
        int n2 = n - this.getBytes;
        return this.getBoolean[n2];
    }

    private int add(int n) {
        int n2 = n - this.getBytes;
        Integer n3 = (Integer)this.getColIndex.get(n2);
        return n3;
    }

    private boolean append(int n) {
        return n < this.getBytes || n > this.getCell;
    }

    @Override
    public void setPosition(int n) {
        this.setRecordIndex(n);
    }

    @Override
    public void setRecordIndex(int n) {
        int n2 = n >= 0 ? n : this.getBigDecimal - Math.abs(n) + 1;
        this.debug = n2;
    }

    @Override
    public int getPosition() {
        if (this.getBlob) {
            if (this.debug == 0) {
                return 0;
            }
            return this.debug - 1;
        }
        return this.debug;
    }

    @Override
    public DbValue getCell(int n) {
        return this.add[n];
    }

    @Override
    public DbValue getCell(DbColDesc dbColDesc) {
        if (dbColDesc.getColIndex() == -1) {
            String string = dbColDesc.getColName();
            dbColDesc.setColIndex(this.columnCount.indexOfCell(string));
        }
        return this.getCell(dbColDesc.getColIndex());
    }

    @Override
    public DbValue[] getValueArray() {
        return this.add;
    }

    @Override
    public DbValue getCell(String string) {
        int n = this.bNull(string);
        return this.getCell(n);
    }

    private int bNull(String string) {
        for (int i = 0; i < this.add.length; ++i) {
            String string2 = this.add[i].getColDesc().getColName();
            if (string2 == null && string == null) {
                return 0;
            }
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int columnCount() {
        return this.add.length;
    }

    @Override
    public JRecordModel getRecordModel() {
        return this.columnCount;
    }

    @Override
    public JDbBufferCursor getDependCursor() {
        return this.abs;
    }

    @Override
    public void refresh() {
        this.refresh(false);
    }

    private void clear(int n, DbValue dbValue, int n2) throws DSException {
        if (this.desc.isNull(n2)) {
            dbValue.setNull();
            return;
        }
        if (dbValue.desc.isArray()) {
            Array array = this.desc.getArray(n2);
            ((DbArray)dbValue).set(array);
            return;
        }
        switch (n) {
            case 5: {
                ((DbSmallInt)dbValue).set(this.desc.getShort(n2));
                break;
            }
            case -6: {
                ((DbTinyInt)dbValue).set(this.desc.getByte(n2));
                break;
            }
            case 4: {
                ((DbInteger)dbValue).set(this.desc.getInt(n2));
                break;
            }
            case -5: {
                ((DbBigInt)dbValue).set(this.desc.getLong(n2));
                break;
            }
            case 6: {
                if (this.getColDescs >= 262912) {
                    ((DbDouble)dbValue).set(this.desc.getDouble(n2));
                    break;
                }
                ((DbDouble)dbValue).set(this.desc.getFloat(n2));
                break;
            }
            case 7: {
                ((DbReal)dbValue).set(this.desc.getFloat(n2));
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = this.desc.getBigDecimal(n2);
                if (bigDecimal == null) {
                    ((DbDecimal)dbValue).bNull = true;
                    break;
                }
                ((DbDecimal)dbValue).set(bigDecimal);
                break;
            }
            case 8: {
                ((DbDouble)dbValue).set(this.desc.getDouble(n2));
                break;
            }
            case -7: {
                ((DbBit)dbValue).set(this.desc.getBoolean(n2));
                break;
            }
            case 91: {
                ((DbDate)dbValue).set(this.desc.getDate(n2).getTime());
                break;
            }
            case 92: {
                ((DbTime)dbValue).set(this.desc.getTime(n2).getTime());
                break;
            }
            case 93: {
                ((DbTimestamp)dbValue).set(this.desc.getTimeStamp(n2).getTime());
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                ((DbChar)dbValue).set(this.desc.getString(n2));
                break;
            }
            case 2005: {
                Clob clob = this.desc.getClob(n2);
                if (clob == null) {
                    ((DbChar)dbValue).bNull = true;
                    break;
                }
                ((DbChar)dbValue).set(clob.getSubString(1L, (int)clob.length()));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                ((DbBinary)dbValue).set(this.desc.getBytes(n2));
                break;
            }
            case 2004: {
                Blob blob = this.desc.getBlob(n2);
                if (blob == null) {
                    ((DbBinary)dbValue).bNull = true;
                    break;
                }
                ((DbBinary)dbValue).set(blob.getBytes(1L, (int)blob.length()));
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(boolean bl) {
        if (this.getBlob) {
            this.close.setRecordIndex(this.getPosition());
            this.clear.refreshRecord(this.close, bl);
        } else {
            if (this.getPosition() == 0) {
                for (int i = 0; i < this.add.length; ++i) {
                    this.add[i].setNull();
                    this.getColDesc = true;
                }
                return;
            }
            if (this.getColDesc) {
                this.debug();
                this.getColDesc = false;
            }
            Object object = this.in;
            synchronized (object) {
                if (this.getColDescs < 262176) {
                    try {
                        this.in.seek(this.abs(this.getPosition()));
                        this.equalsIgnoreCase = this.in.readInt();
                    }
                    catch (IOException iOException) {
                        SEDU.debug("when refresh record occur error:" + iOException.getMessage() + ". index:" + this.getPosition());
                        throw new RuntimeException(iOException.getMessage());
                    }
                    this.desc.setDataLength(this.equalsIgnoreCase);
                    if (this.get.length < this.equalsIgnoreCase) {
                        this.desc.resetRecordSize(this.equalsIgnoreCase);
                        this.get = this.desc.getRecordData();
                    }
                    try {
                        this.in.readFully(this.get, 0, this.equalsIgnoreCase);
                    }
                    catch (IOException iOException) {
                        SEDU.debug("when refresh record occur error:" + iOException.getMessage() + ". index:" + this.getPosition());
                        throw new RuntimeException(iOException.getMessage());
                    }
                }
                if (this.getColDescs >= 262176) {
                    long l = -1L;
                    int n = -1;
                    try {
                        l = this.abs(this.getPosition());
                        n = this.add(this.getPosition());
                        this.equalsIgnoreCase = this.getColName.getRecordDataSize(l, n);
                    }
                    catch (IOException iOException) {
                        SEDU.debug("when refresh record occur error:" + iOException.getMessage() + ". index:" + this.getPosition());
                        throw new RuntimeException(iOException.getMessage());
                    }
                    this.desc.setDataLength(this.equalsIgnoreCase);
                    if (this.get.length < this.equalsIgnoreCase) {
                        this.desc.resetRecordSize(this.equalsIgnoreCase);
                        this.get = this.desc.getRecordData();
                    }
                    try {
                        this.getColName.stuffRecordData(this.get, n, this.equalsIgnoreCase, l);
                    }
                    catch (IOException iOException) {
                        SEDU.debug("when refresh record occur error:" + iOException.getMessage() + ". index:" + this.getPosition());
                        throw new RuntimeException(iOException.getMessage());
                    }
                }
                for (int i = 0; i < this.add.length; ++i) {
                    try {
                        int n = this.add[i].getColDesc().sqlType;
                        if (this.add[i].getColDesc().isConstant()) continue;
                        this.clear(n, this.add[i], i + 1);
                        continue;
                    }
                    catch (DSException dSException) {
                        SEDU.debug("when refresh record occur error:" + dSException.getMessage() + ". index:" + this.getPosition());
                        throw new RuntimeException(dSException.getMessage());
                    }
                }
            }
            if (!bl && this.add.length > 0) {
                object = this.getDependCursor().getRecordModel().getGroupable();
                if (object != null) {
                    if (this.add[0].isNull()) {
                        object.getValuesByRecordNumber(this);
                    } else {
                        object.getValues(((DbInteger)this.add[0]).value, this);
                    }
                } else {
                    SEDU.warn(6104);
                }
            }
        }
    }

    private void debug() {
        DbColDesc[] dbColDescArray = this.columnCount.getColDescs();
        for (int i = 0; i < dbColDescArray.length; ++i) {
            if (!dbColDescArray[i].isConstant()) continue;
            this.add[i].setValue((DbValue)this.getClob.get(dbColDescArray[i]));
        }
    }

    @Override
    public void refresh(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh(DbColDesc dbColDesc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(DbColDesc dbColDesc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRecordIndex() {
        return this.debug;
    }

    @Override
    public int size() {
        return this.columnCount();
    }

    @Override
    public DbValueable getValue(int n) {
        return this.getCell(n);
    }

    @Override
    public DbValueable getValue(String string) {
        return this.getCell(string);
    }

    @Override
    public int indexOfCell(String string) {
        return this.columnCount.indexOfCell(string);
    }

    public DbValue[] getConstantValue() {
        if (this.getBlob) {
            return this.bNull;
        }
        return null;
    }

    @Override
    public void setRowID(int n) throws DSException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRowID() throws DSException {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.getBoolean = null;
        this.get = null;
        if (this.getBlob && this.clear != null) {
            try {
                this.clear.close();
            }
            catch (SQLException sQLException) {
                SEDU.debug("when close db occur error:" + sQLException.getMessage());
            }
            this.bNull = null;
        }
        this.desc.close();
        if (this.getClob != null) {
            this.getClob.clear();
            this.getClob = null;
        }
    }
}

