/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.ARelation;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.relational.swap.RelationPool;
import java.io.IOException;
import jet.dataengine.api.DSException;
import jet.ie.IRecordReader;
import jet.ie.SelfIncreaseRelation;

public class SelfIncreaseRelationPool
extends RelationPool {
    protected IRecordReader reader;
    protected long recordCount;
    protected long recordsAdded;

    public SelfIncreaseRelationPool(String string, JRelationMetaData jRelationMetaData, IRecordReader iRecordReader) throws DSException {
        super(string, jRelationMetaData);
        this.reader = iRecordReader;
        this.recordCount = iRecordReader.getRecordCount();
    }

    @Override
    public ARelation createRelation() throws DSException {
        return new SelfIncreaseRelation(this.getName(), this);
    }

    @Override
    public boolean appendRecord(ITuple iTuple) throws DSException {
        return false;
    }

    public long getRecordsRead() {
        return this.recordsAdded;
    }

    public void readRecord(long l) throws IOException, DSException {
        if (this.recordsAdded >= this.recordCount) {
            return;
        }
        int n = 0;
        while ((long)n < l) {
            ITuple iTuple = this.reader.readRecord();
            if (iTuple != null) {
                super.appendRecord(iTuple);
                ++this.recordsAdded;
                if (this.recordsAdded >= this.recordCount) {
                    super.appendFinished();
                    break;
                }
            }
            ++n;
        }
    }
}

