/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.Record;
import com.jinfonet.datatypes.JinfonetBlobBaseBytes;
import com.jinfonet.datatypes.JinfonetClobBaseString;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import com.jinfonet.util.JRLog;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import jet.dataengine.api.DSException;
import jet.dataengine8.util.JBoolean;
import jet.dataengine8.util.dataswap.ArrayTool;

public class VersionRecord
extends Record {
    private static final int SEDU = 255;
    private static final long abs = 255L;
    private int append = 0;
    private int array2Bytes = 0;
    private final int arraycopy;
    private final int bytes2Array;
    private byte[] dataLength = null;
    private boolean doubleToRawLongBits = false;
    private JRelationMetaData error = null;
    private int findColumn = 0;
    private int[] floatToIntBits = null;
    private int[] getAttribute = null;
    private int getBigDecimal = 0;
    private int[] getBlob;
    private int getBoolean;

    public VersionRecord(JRelationMetaData jRelationMetaData) throws DSException {
        this(jRelationMetaData, 133120, null);
    }

    public VersionRecord(JRelationMetaData jRelationMetaData, int n, int[] nArray) throws DSException {
        this.getBoolean = n;
        this.getBlob = nArray;
        this.arraycopy = jRelationMetaData.getColumnCount();
        this.append = this.bytes2Array = this.arraycopy << 2;
        this.floatToIntBits = new int[this.arraycopy + 1];
        this.getAttribute = new int[this.arraycopy + 1];
        for (int i = 1; i <= this.arraycopy; ++i) {
            this.floatToIntBits[i] = jRelationMetaData.getColumnType(i);
            JAttribute jAttribute = jRelationMetaData.getAttribute(i);
            this.getAttribute[i] = this.SEDU(jAttribute.isReadOnly(), this.floatToIntBits[i]);
            if (n < 132096 && nArray[i] == 6) {
                this.getBigDecimal += Types.swapDataLength(6) + 4;
                continue;
            }
            this.getBigDecimal += Types.swapDataLength(this.floatToIntBits[i]) + 4;
        }
        this.dataLength = new byte[this.getBigDecimal];
    }

    private int SEDU(boolean bl, int n) {
        if (bl) {
            return 0;
        }
        int n2 = Types.dataLength(n);
        return n2;
    }

    public byte[] getRecordData() {
        return this.dataLength;
    }

    public int getRecordSize() {
        return this.append;
    }

    public void resetRecordSize(int n) {
        this.dataLength = new byte[n];
    }

    public void setDataLength(int n) {
        this.findColumn = n;
        this.reset();
    }

    public void setRecord(byte[] byArray) {
        if (this.dataLength.length < byArray.length) {
            byte[] byArray2 = new byte[byArray.length];
            this.dataLength = byArray2;
        }
        System.arraycopy(byArray, 0, this.dataLength, 0, byArray.length);
    }

    @Override
    public void putByte(byte by) {
        this.findColumn(1);
        this.floatToIntBits(this.array2Bytes++, this.append);
        this.getColumnCount(-6);
        this.dataLength[this.append++] = by;
    }

    public byte getByte(String string) throws DSException {
        return this.getByte(this.error.findColumn(string));
    }

    @Override
    public byte getByte(int n) {
        return this.abs(-6, n);
    }

    private byte abs(int n, int n2) {
        this.getDataTypeName(n, n2);
        int n3 = this.getAttribute(n2);
        this.doubleToRawLongBits = this.getClass(n2);
        if (this.doubleToRawLongBits) {
            return 0;
        }
        return this.dataLength[n3 + 1];
    }

    @Override
    public void putBoolean(boolean bl) {
        this.findColumn(1);
        this.floatToIntBits(this.array2Bytes++, this.append);
        this.getColumnCount(-7);
        this.dataLength[this.append++] = bl ? (byte)1 : 0;
    }

    public boolean getBoolean(String string) throws DSException {
        return this.getByte(this.error.findColumn(string)) == 1;
    }

    @Override
    public boolean getBoolean(int n) {
        return this.abs(-7, n) == 1;
    }

    @Override
    public void putShort(short s) {
        this.findColumn(2);
        this.floatToIntBits(this.array2Bytes++, this.append);
        this.getColumnCount(5);
        this.dataLength[this.append++] = (byte)s;
        this.dataLength[this.append++] = (byte)(s >> 8);
    }

    public short getShort(String string) throws DSException {
        return this.getShort(this.error.findColumn(string));
    }

    @Override
    public short getShort(int n) {
        this.getDataTypeName(5, n);
        int n2 = this.getAttribute(n);
        this.doubleToRawLongBits = this.getClass(n);
        if (this.doubleToRawLongBits) {
            return 0;
        }
        return (short)(this.dataLength[n2 + 2] << 8 | this.dataLength[n2 + 1] & 0xFF);
    }

    @Override
    public void putInt(int n) {
        this.findColumn(4);
        this.floatToIntBits(this.array2Bytes++, this.append);
        this.getColumnCount(4);
        this.dataLength[this.append++] = (byte)n;
        this.dataLength[this.append++] = (byte)(n >> 8);
        this.dataLength[this.append++] = (byte)(n >> 16);
        this.dataLength[this.append++] = (byte)(n >> 24);
    }

    public int getInt(String string) throws DSException {
        return this.getInt(this.error.findColumn(string));
    }

    @Override
    public int getInt(int n) {
        this.getDataTypeName(4, n);
        int n2 = this.getAttribute(n);
        this.doubleToRawLongBits = this.getClass(n);
        if (this.doubleToRawLongBits) {
            return 0;
        }
        return this.dataLength[n2 + 4] << 24 | (this.dataLength[n2 + 3] & 0xFF) << 16 | (this.dataLength[n2 + 2] & 0xFF) << 8 | this.dataLength[n2 + 1] & 0xFF;
    }

    @Override
    public void putFloat(float f) {
        this.findColumn(4);
        this.floatToIntBits(this.array2Bytes++, this.append);
        this.getColumnCount(6);
        int n = Float.floatToIntBits(f);
        this.dataLength[this.append++] = (byte)n;
        this.dataLength[this.append++] = (byte)(n >> 8);
        this.dataLength[this.append++] = (byte)(n >> 16);
        this.dataLength[this.append++] = (byte)(n >> 24);
    }

    public float getFloat(String string) throws DSException {
        return this.getFloat(this.error.findColumn(string));
    }

    @Override
    public float getFloat(int n) {
        this.getDataTypeName(6, n);
        this.doubleToRawLongBits = this.getClass(n);
        if (this.doubleToRawLongBits) {
            return 0.0f;
        }
        int n2 = this.getAttribute(n);
        return Float.intBitsToFloat(this.dataLength[n2 + 4] << 24 | (this.dataLength[n2 + 3] & 0xFF) << 16 | (this.dataLength[n2 + 2] & 0xFF) << 8 | this.dataLength[n2 + 1] & 0xFF);
    }

    @Override
    public void putLong(long l) {
        this.findColumn(8);
        this.floatToIntBits(this.array2Bytes++, this.append);
        this.getColumnCount(-5);
        this.dataLength[this.append++] = (byte)l;
        this.dataLength[this.append++] = (byte)(l >> 8);
        this.dataLength[this.append++] = (byte)(l >> 16);
        this.dataLength[this.append++] = (byte)(l >> 24);
        this.dataLength[this.append++] = (byte)(l >> 32);
        this.dataLength[this.append++] = (byte)(l >> 40);
        this.dataLength[this.append++] = (byte)(l >> 48);
        this.dataLength[this.append++] = (byte)(l >> 56);
    }

    private final void append(long l, int n) {
        this.findColumn(8);
        this.floatToIntBits(this.array2Bytes++, this.append);
        this.getColumnCount(n);
        this.dataLength[this.append++] = (byte)l;
        this.dataLength[this.append++] = (byte)(l >> 8);
        this.dataLength[this.append++] = (byte)(l >> 16);
        this.dataLength[this.append++] = (byte)(l >> 24);
        this.dataLength[this.append++] = (byte)(l >> 32);
        this.dataLength[this.append++] = (byte)(l >> 40);
        this.dataLength[this.append++] = (byte)(l >> 48);
        this.dataLength[this.append++] = (byte)(l >> 56);
    }

    public long getLong(String string) throws DSException {
        return this.getLong(this.error.findColumn(string));
    }

    @Override
    public long getLong(int n) {
        return this.array2Bytes(-5, n);
    }

    private long array2Bytes(int n, int n2) {
        this.getDataTypeName(n, n2);
        this.doubleToRawLongBits = this.getClass(n2);
        if (this.doubleToRawLongBits) {
            return 0L;
        }
        int n3 = this.getAttribute(n2);
        return (long)this.dataLength[n3 + 8] << 56 | ((long)this.dataLength[n3 + 7] & 0xFFL) << 48 | ((long)this.dataLength[n3 + 6] & 0xFFL) << 40 | ((long)this.dataLength[n3 + 5] & 0xFFL) << 32 | ((long)this.dataLength[n3 + 4] & 0xFFL) << 24 | ((long)this.dataLength[n3 + 3] & 0xFFL) << 16 | ((long)this.dataLength[n3 + 2] & 0xFFL) << 8 | (long)this.dataLength[n3 + 1] & 0xFFL;
    }

    @Override
    public void putDouble(double d) {
        long l = Double.doubleToRawLongBits(d);
        this.append(l, 8);
    }

    public double getDouble(String string) throws DSException {
        return this.getDouble(this.error.findColumn(string));
    }

    @Override
    public double getDouble(int n) {
        double d = 0.0;
        d = this.getBoolean < 132096 && this.getBlob[n] == 6 ? (double)this.getFloat(n) : Double.longBitsToDouble(this.array2Bytes(8, n));
        return d;
    }

    @Override
    public void putBigDecimal(BigDecimal bigDecimal) {
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray.length;
        this.findColumn(n + 4);
        this.floatToIntBits(this.array2Bytes++, this.append);
        this.getColumnCount(3);
        int n2 = bigDecimal.scale();
        this.dataLength[this.append++] = (byte)n2;
        this.dataLength[this.append++] = (byte)(n2 >> 8);
        this.dataLength[this.append++] = (byte)(n2 >> 16);
        this.dataLength[this.append++] = (byte)(n2 >> 24);
        for (int i = 0; i < n; ++i) {
            this.dataLength[this.append++] = byArray[i];
        }
    }

    public BigDecimal getBigDecimal(String string) throws DSException {
        return this.getBigDecimal(this.error.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) {
        this.getDataTypeName(3, n);
        this.doubleToRawLongBits = this.getClass(n);
        if (this.doubleToRawLongBits) {
            return null;
        }
        int n2 = this.getAttribute(n);
        int n3 = this.getColumnType(n2, n);
        int n4 = this.dataLength[n2 + 4] << 24 | (this.dataLength[n2 + 3] & 0xFF) << 16 | (this.dataLength[n2 + 2] & 0xFF) << 8 | this.dataLength[n2 + 1] & 0xFF;
        byte[] byArray = new byte[n3 - 4];
        int n5 = 0;
        int n6 = n2 + 5;
        while (n5 < byArray.length) {
            byArray[n5] = this.dataLength[n6];
            ++n5;
            ++n6;
        }
        return new BigDecimal(new BigInteger(byArray), n4);
    }

    @Override
    public void putDate(Date date) {
        this.append(date.getTime(), 91);
    }

    public void putDate(long l) {
        this.append(l, 91);
    }

    public Date getDate(String string) throws DSException {
        return this.getDate(this.error.findColumn(string));
    }

    @Override
    public Date getDate(int n) {
        return new JinfonetDate(this.array2Bytes(91, n));
    }

    @Override
    public void putTimeStamp(Timestamp timestamp) {
        this.append(timestamp.getTime(), 93);
    }

    public void putTimeStamp(long l) {
        this.append(l, 93);
    }

    public Timestamp getTimeStamp(String string) throws DSException {
        return this.getTimeStamp(this.error.findColumn(string));
    }

    @Override
    public Timestamp getTimeStamp(int n) {
        return new JinfonetTimeStamp(this.array2Bytes(93, n));
    }

    @Override
    public void putTime(Time time2) {
        this.append(time2.getTime(), 92);
    }

    public void putTime(long l) {
        this.append(l, 92);
    }

    public Time getTime(String string) throws DSException {
        return this.getTime(this.error.findColumn(string));
    }

    @Override
    public Time getTime(int n) {
        return new JinfonetTime(this.array2Bytes(92, n));
    }

    @Override
    public void putString(String string) {
        byte[] byArray;
        block3: {
            byArray = null;
            if (string != null) {
                try {
                    byArray = string.getBytes("utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (!JRLog.isError(2)) break block3;
                    JRLog.error(2, unsupportedEncodingException);
                }
            }
        }
        this.dataLength(byArray, 12);
    }

    public String getString(String string) throws DSException {
        return this.getString(this.error.findColumn(string));
    }

    @Override
    public String getString(int n) {
        byte[] byArray = this.doubleToRawLongBits(12, n);
        try {
            return byArray == null ? null : new String(byArray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, unsupportedEncodingException);
            }
            return byArray == null ? null : new String(byArray);
        }
    }

    @Override
    public void putBlob(Blob blob) throws DSException {
        if (blob == null) {
            this.putNull(-2);
            return;
        }
        byte[] byArray = blob.getBytes(1L, (int)blob.length());
        this.putBytes(byArray);
    }

    public Blob getBlob(String string) throws DSException {
        return this.getBlob(this.error.findColumn(string));
    }

    @Override
    public Blob getBlob(int n) throws DSException {
        this.getDataTypeName(2004, n);
        this.doubleToRawLongBits = this.getClass(n);
        if (this.doubleToRawLongBits) {
            return null;
        }
        byte[] byArray = this.arraycopy(n);
        return new JinfonetBlobBaseBytes(byArray);
    }

    private byte[] arraycopy(int n) {
        int n2 = this.getAttribute(n);
        int n3 = this.getColumnType(n2, n);
        if (n3 < 0) {
            this.getColumnType(n2, n);
        }
        this.doubleToRawLongBits = this.getClass(n);
        if (this.doubleToRawLongBits) {
            return null;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.dataLength, n2 + 1, byArray, 0, n3);
        return byArray;
    }

    @Override
    public void putClob(Clob clob) throws DSException {
        if (clob == null) {
            this.putNull(12);
            return;
        }
        this.putString(clob.getSubString(1L, (int)clob.length()));
    }

    public Clob getClob(String string) throws DSException {
        return this.getClob(this.error.findColumn(string));
    }

    @Override
    public Clob getClob(int n) throws DSException {
        this.getDataTypeName(2005, n);
        this.doubleToRawLongBits = this.getClass(n);
        if (this.doubleToRawLongBits) {
            return null;
        }
        String string = this.bytes2Array(n);
        return new JinfonetClobBaseString(string);
    }

    private String bytes2Array(int n) {
        byte[] byArray = this.doubleToRawLongBits(2005, n);
        try {
            return byArray == null ? null : new String(byArray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, unsupportedEncodingException);
            }
            return byArray == null ? null : new String(byArray);
        }
    }

    @Override
    public void putBytes(byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.findColumn(byArray.length);
        this.floatToIntBits(this.array2Bytes++, this.append);
        this.getColumnCount(-2);
        for (int i = 0; i < byArray.length; ++i) {
            this.dataLength[this.append++] = byArray[i];
        }
    }

    private void dataLength(byte[] byArray, int n) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.findColumn(byArray.length);
        this.floatToIntBits(this.array2Bytes++, this.append);
        this.getColumnCount(n);
        for (int i = 0; i < byArray.length; ++i) {
            this.dataLength[this.append++] = byArray[i];
        }
    }

    public byte[] getBytes(String string) throws DSException {
        return this.getBytes(this.error.findColumn(string));
    }

    @Override
    public byte[] getBytes(int n) {
        return this.doubleToRawLongBits(-2, n);
    }

    private byte[] doubleToRawLongBits(int n, int n2) {
        this.getDataTypeName(n, n2);
        this.doubleToRawLongBits = this.getClass(n2);
        if (this.doubleToRawLongBits) {
            return null;
        }
        int n3 = this.getAttribute(n2);
        int n4 = this.getColumnType(n3, n2);
        byte[] byArray = new byte[n4];
        System.arraycopy(this.dataLength, n3 + 1, byArray, 0, n4);
        return byArray;
    }

    @Override
    public JRelationMetaData getMetaData() {
        return this.error;
    }

    @Override
    public int putRecord() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.array2Bytes = 0;
        this.append = this.bytes2Array;
        this.doubleToRawLongBits = false;
    }

    @Override
    public void init(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putNull(int n) {
        this.findColumn(0);
        this.floatToIntBits(this.array2Bytes++, -this.append);
        this.getColumnCount(n);
        this.append += this.getAttribute[this.array2Bytes];
    }

    @Override
    public boolean wasNull() {
        return this.doubleToRawLongBits;
    }

    private int error(int n) {
        if (n <= 500) {
            return (int)(2.0f * (float)n);
        }
        if (n <= 1000) {
            return (int)(1.5f * (float)n);
        }
        return (int)(1.2f * (float)n);
    }

    private void findColumn(int n) {
        if (this.dataLength.length <= this.append + n) {
            byte[] byArray = new byte[this.error(this.append + n)];
            System.arraycopy(this.dataLength, 0, byArray, 0, this.dataLength.length);
            this.dataLength = byArray;
        }
    }

    private void floatToIntBits(int n, int n2) {
        int n3 = n << 2;
        this.dataLength[n3] = (byte)n2;
        this.dataLength[n3 + 1] = (byte)(n2 >> 8);
        this.dataLength[n3 + 2] = (byte)(n2 >> 16);
        this.dataLength[n3 + 3] = (byte)(n2 >> 24);
    }

    private int getAttribute(int n) {
        if (n < 1 || n > this.arraycopy) {
            throw new IllegalStateException("columnIndex " + n + " Out of range , current range is :" + this.arraycopy);
        }
        int n2 = n - 1 << 2;
        int n3 = this.dataLength[n2 + 3] << 24 | (this.dataLength[n2 + 2] & 0xFF) << 16 | (this.dataLength[n2 + 1] & 0xFF) << 8 | this.dataLength[n2] & 0xFF;
        return Math.abs(n3);
    }

    private boolean getClass(int n) {
        if (n < 1 || n > this.arraycopy) {
            throw new IllegalStateException("columnIndex " + n + " Out of range , current range is :" + this.arraycopy);
        }
        int n2 = n - 1 << 2;
        return this.dataLength[n2 + 3] < 0;
    }

    private void getColumnCount(int n) {
        this.dataLength[this.append++] = (byte)n;
    }

    private int getColumnType(int n, int n2) {
        if (n2 == this.arraycopy) {
            return this.findColumn - n - 1;
        }
        return Math.abs(this.getAttribute(n2 + 1)) - n - 1;
    }

    public int dataType(String string) throws DSException {
        return this.error.getColumnType(this.error.findColumn(string));
    }

    @Override
    public int dataType(int n) throws DSException {
        return this.error.getColumnType(n);
    }

    @Override
    public Object getObject(int n) throws DSException {
        int n2 = this.error.getColumnType(n);
        switch (n2) {
            case -6: {
                return new Byte(this.getByte(n));
            }
            case -7: {
                return new JBoolean(this.getBoolean(n));
            }
            case 5: {
                return new Short(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case 6: {
                return new Float(this.getFloat(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 3: {
                return this.getBigDecimal(n);
            }
            case 12: {
                return this.getString(n);
            }
            case 2004: {
                return this.getBlob(n);
            }
            case 2005: {
                return this.getClob(n);
            }
            case -2: {
                return this.getBytes(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 93: {
                return this.getTimeStamp(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 0x7FFFFFFF: {
                return this.getRelationData(n);
            }
        }
        throw new DSException(5859, new String[]{this.error.getClass().getName() + " Unkonw dataType in getObject(). ColumnIndex: " + n + "; data type: " + n2});
    }

    public Object getObject(String string) throws DSException {
        return this.getObject(this.error.findColumn(string));
    }

    @Override
    public boolean isNull(int n) {
        int n2 = this.getAttribute(n);
        return this.getColumnType(n2, n) == 0;
    }

    private void getDataTypeName(int n, int n2) {
        if (n2 < 1 || n2 > this.arraycopy) {
            throw new IllegalStateException("columnIndex " + n2 + " Out of range , current range is :" + this.arraycopy);
        }
        if (n != this.floatToIntBits[n2]) {
            throw new IllegalStateException("violation data type. indicate " + Types.getDataTypeName(n) + ", but " + Types.getDataTypeName(this.floatToIntBits[n2]));
        }
    }

    @Override
    public void close() throws DSException {
        this.dataLength = null;
        this.floatToIntBits = null;
    }

    @Override
    public void putArray(Array array) throws DSException {
        byte[] byArray = ArrayTool.array2Bytes(array);
        this.dataLength(byArray, 2003);
    }

    @Override
    public Array getArray(int n) throws DSException {
        byte[] byArray = this.doubleToRawLongBits(2003, n);
        return byArray == null ? null : ArrayTool.bytes2Array(byArray);
    }

    @Override
    public void pubRelationData(IRelationData iRelationData) throws DSException {
        throw new UnsupportedOperationException();
    }
}

