/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.image.encoder.ImageEncoder;
import com.jinfonet.util.JRLog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Vector;
import jet.connect.DbArray;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbBuffer;
import jet.connect.DbChar;
import jet.connect.DbDateTime;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.controls.JetCustomerProperty;
import jet.controls.JetEnumeration;
import jet.controls.JetImgProperty;
import jet.controls.JetImgVector;
import jet.controls.JetMappingTable;
import jet.ie.PJFAux;
import jet.ie.io.PJFDataOutput;
import jet.report.JetRptPicture;
import jet.util.Propertiable;
import jet.util.image.ImageProvider;
import jet.util.image.ImageResource;

public class WriterTool {
    private static final Component SEDU = new Component(){};

    public static final void writePropDecl(Short s, Propertiable propertiable, DataOutput dataOutput, ImageProvider imageProvider) throws IOException {
        int n = propertiable.getPropType();
        if (n == 0) {
            dataOutput.writeShort(n);
            return;
        }
        Object object = propertiable.getObject();
        if (n == 3 && object != null) {
            if (object instanceof String) {
                n = 6;
            } else if (object instanceof Integer) {
                n = 5;
            } else if (object instanceof Boolean) {
                n = 1;
            } else if (object instanceof Color) {
                n = 2;
            } else if (object instanceof Image) {
                n = 7;
            } else {
                dataOutput.writeShort(0);
                return;
            }
        }
        dataOutput.writeShort(n);
        dataOutput.writeShort(s.shortValue());
        boolean bl = propertiable.isChangeByOther() || propertiable.isChagneByFmtt() || propertiable.isChangeByBL();
        dataOutput.writeBoolean(bl);
        if (bl) {
            object = WriterTool.decimalNeedBytes(propertiable);
            if (object == null) {
                dataOutput.writeBoolean(true);
            } else {
                dataOutput.writeBoolean(false);
                dataOutput.writeUTF((String)object);
            }
            if (propertiable.getNormalObject() == null) {
                dataOutput.writeInt(0);
            } else {
                byte[] byArray = WriterTool.close(propertiable.getNormalObject());
                dataOutput.writeInt(byArray.length);
                dataOutput.write(byArray);
            }
            return;
        }
        if (object == null) {
            dataOutput.writeBoolean(true);
        } else {
            dataOutput.writeBoolean(false);
            switch (n) {
                case 12: {
                    List<ImageResource> list = imageProvider.getImageResources((JetImgVector)propertiable);
                    int n2 = list.size();
                    dataOutput.writeInt(n2);
                    for (int i = 0; i < n2; ++i) {
                        ImageResource imageResource = list.get(i);
                        if (imageResource.getImage() == null) {
                            dataOutput.writeInt(0);
                            continue;
                        }
                        byte[] byArray = WriterTool.booleanValue(imageResource.getImage(), imageResource.getImageType());
                        dataOutput.writeInt(byArray.length);
                        dataOutput.write(byArray);
                    }
                    break;
                }
                case 1: {
                    dataOutput.writeBoolean((Boolean)object);
                    break;
                }
                case 2: {
                    dataOutput.writeInt(((Color)object).getRGB());
                    break;
                }
                case 3: {
                    dataOutput.writeInt(((JetEnumeration)propertiable).intValue());
                    break;
                }
                case 4: 
                case 5: {
                    dataOutput.writeInt(((Number)object).intValue());
                    break;
                }
                case 15: {
                    byte[] byArray = ((String)object).getBytes("Unicode");
                    dataOutput.writeInt(byArray.length);
                    dataOutput.write(byArray);
                    break;
                }
                case 6: {
                    dataOutput.writeUTF((String)object);
                    break;
                }
                case 11: {
                    dataOutput.writeDouble(((Number)object).doubleValue());
                    break;
                }
                case 7: {
                    ImageResource imageResource = imageProvider.getImageResource((JetImgProperty)propertiable);
                    String string = ((JetImgProperty)propertiable).get();
                    if (string == null || string.length() == 0) {
                        dataOutput.writeInt(0);
                    } else {
                        dataOutput.writeInt(string.length());
                        dataOutput.writeUTF(string);
                    }
                    byte[] byArray = WriterTool.booleanValue(imageResource.getImage(), imageResource.getImageType());
                    dataOutput.writeInt(byArray.length);
                    dataOutput.write(byArray);
                    break;
                }
                case 8: 
                case 13: {
                    byte[] byArray = ((JetCustomerProperty)propertiable).toByteArray();
                    dataOutput.writeInt(byArray.length);
                    dataOutput.write(byArray);
                    break;
                }
                case 9: {
                    Vector vector = (Vector)object;
                    int n3 = vector.size();
                    dataOutput.writeInt(n3);
                    for (int i = 0; i < n3; ++i) {
                        dataOutput.writeUTF((String)vector.elementAt(i));
                    }
                    break;
                }
                case 14: {
                    byte[] byArray = ((JetMappingTable)propertiable).toByteArray();
                    dataOutput.writeInt(byArray.length);
                    dataOutput.write(byArray);
                    break;
                }
            }
        }
    }

    public static final void writePrimUnit(Short s, boolean bl, int n, String string, DataOutput dataOutput, int n2) throws IOException {
        int n3 = n2;
        dataOutput.writeShort(n3);
        dataOutput.writeShort(s.shortValue());
        dataOutput.writeBoolean(bl);
        if (bl) {
            WriterTool.SEDU(dataOutput, new Integer(n), string);
            return;
        }
        dataOutput.writeBoolean(false);
        dataOutput.writeInt(n);
    }

    public static final void writePrimBool(Short s, boolean bl, boolean bl2, String string, DataOutput dataOutput) throws IOException {
        int n = 1;
        dataOutput.writeShort(n);
        dataOutput.writeShort(s.shortValue());
        dataOutput.writeBoolean(bl);
        if (bl) {
            WriterTool.SEDU(dataOutput, bl2, string);
            return;
        }
        dataOutput.writeBoolean(false);
        dataOutput.writeBoolean(bl2);
    }

    public static final void writePrimString(Short s, boolean bl, String string, String string2, DataOutput dataOutput) throws IOException {
        int n = 6;
        dataOutput.writeShort(n);
        dataOutput.writeShort(s.shortValue());
        dataOutput.writeBoolean(bl);
        if (bl) {
            WriterTool.SEDU(dataOutput, string, string2);
            return;
        }
        if (string == null) {
            dataOutput.writeBoolean(true);
        } else {
            dataOutput.writeBoolean(false);
            dataOutput.writeUTF(string);
        }
    }

    public static final void writePrimImage(Short s, boolean bl, String string, String string2, DataOutput dataOutput, JetRptPicture jetRptPicture, boolean bl2, ImageProvider imageProvider) throws IOException {
        int n = 7;
        dataOutput.writeShort(n);
        dataOutput.writeShort(s.shortValue());
        dataOutput.writeBoolean(bl);
        if (bl) {
            WriterTool.SEDU(dataOutput, string, string2);
            return;
        }
        if (string == null || bl2) {
            dataOutput.writeBoolean(true);
        } else {
            dataOutput.writeBoolean(false);
            try {
                if (string.length() == 0) {
                    dataOutput.writeInt(0);
                } else {
                    dataOutput.writeInt(string.length());
                    dataOutput.writeUTF(string);
                }
                ImageResource imageResource = imageProvider.getImageResource(jetRptPicture, null);
                byte[] byArray = WriterTool.booleanValue(imageResource.getImage(), 4);
                dataOutput.writeInt(byArray.length);
                dataOutput.write(byArray);
            }
            catch (IOException iOException) {
                dataOutput.writeInt(0);
            }
        }
    }

    public static final void writePrimColor(Short s, boolean bl, Color color, String string, DataOutput dataOutput) throws IOException {
        int n = 2;
        dataOutput.writeShort(n);
        dataOutput.writeShort(s.shortValue());
        dataOutput.writeBoolean(bl);
        if (bl) {
            WriterTool.SEDU(dataOutput, color, string);
            return;
        }
        if (color == null) {
            dataOutput.writeBoolean(true);
        } else {
            dataOutput.writeBoolean(false);
            dataOutput.writeInt(color.getRGB());
        }
    }

    public static final void writePrimIgnore(DataOutput dataOutput) throws IOException {
        int n = 0;
        dataOutput.writeShort(n);
    }

    private static final void SEDU(DataOutput dataOutput, Object object, String string) throws IOException {
        if (string == null) {
            dataOutput.writeBoolean(true);
        } else {
            dataOutput.writeBoolean(false);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append("\u0007");
            stringBuffer.append("\u0007");
            stringBuffer.append("\u0007");
            stringBuffer.append("\u0007");
            dataOutput.writeUTF(stringBuffer.toString());
            byte[] byArray = WriterTool.close(object);
            dataOutput.writeInt(byArray.length);
            dataOutput.write(byArray);
        }
    }

    public static final void writeDbValue(DbValue dbValue, PJFDataOutput pJFDataOutput) throws IOException {
        boolean bl = dbValue.isNull();
        pJFDataOutput.writeByte(bl ? 1 : 0);
        if (bl) {
            int n = dbValue.getColDesc().getPrecision();
            byte[] byArray = new byte[n >= 0x7FFFFFFD ? 2 : PJFAux.getColLength(dbValue.getColDesc())];
            pJFDataOutput.write(byArray);
            return;
        }
        if (dbValue.getColDesc().isArray()) {
            WriterTool.writeArray(dbValue, pJFDataOutput);
            return;
        }
        int n = dbValue.getSqlType();
        switch (n) {
            case 5: {
                pJFDataOutput.writeShort(((DbSmallInt)dbValue).get());
                break;
            }
            case -6: {
                pJFDataOutput.writeByte(((DbTinyInt)dbValue).get());
                break;
            }
            case 4: {
                pJFDataOutput.writeInt(((DbInteger)dbValue).get());
                break;
            }
            case 91: 
            case 92: {
                pJFDataOutput.writeLong(((DbDateTime)dbValue).get());
                break;
            }
            case -5: {
                pJFDataOutput.writeLong(((DbBigInt)dbValue).get());
                break;
            }
            case 7: {
                pJFDataOutput.writeFloat(((DbReal)dbValue).get());
                break;
            }
            case 2: 
            case 3: {
                pJFDataOutput.writeBigDecimal(((DbDecimal)dbValue).get(), dbValue.getScale(), DbBuffer.decimalNeedBytes(dbValue.getColDesc()));
                break;
            }
            case 6: 
            case 8: {
                pJFDataOutput.writeDouble(((DbDouble)dbValue).get());
                break;
            }
            case -7: {
                pJFDataOutput.writeBoolean(((DbBit)dbValue).get());
                break;
            }
            case 93: {
                pJFDataOutput.writeLong(((DbTimestamp)dbValue).get());
                pJFDataOutput.writeInt(((DbTimestamp)dbValue).getNanos());
                break;
            }
            case 1: 
            case 12: {
                pJFDataOutput.writeVariantBinary(((DbChar)dbValue).getRaw());
                break;
            }
            case -1: {
                pJFDataOutput.writeVariantBinary(((DbChar)dbValue).getRaw());
                break;
            }
            case -3: {
                pJFDataOutput.writeFixedBinary(((DbBinary)dbValue).get(), dbValue.getPrecision());
                break;
            }
            case -4: {
                pJFDataOutput.writeVariantBinary(((DbBinary)dbValue).get());
            }
        }
    }

    public static final void writeArray(DbValue dbValue, PJFDataOutput pJFDataOutput) throws IOException {
        int n = dbValue.getSqlType();
        switch (n) {
            case -7: {
                boolean[] blArray = (boolean[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(blArray.length);
                for (int i = 0; i < blArray.length; ++i) {
                    pJFDataOutput.writeBoolean(blArray[i]);
                }
                break;
            }
            case -6: {
                byte[] byArray = (byte[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(byArray.length);
                for (int i = 0; i < byArray.length; ++i) {
                    pJFDataOutput.writeByte(byArray[i]);
                }
                break;
            }
            case 5: {
                short[] sArray = (short[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(sArray.length);
                for (int i = 0; i < sArray.length; ++i) {
                    pJFDataOutput.writeShort(sArray[i]);
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    pJFDataOutput.writeInt(nArray[i]);
                }
                break;
            }
            case -5: 
            case 91: 
            case 92: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(lArray.length);
                for (int i = 0; i < lArray.length; ++i) {
                    pJFDataOutput.writeLong(lArray[i]);
                }
                break;
            }
            case 93: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                int[] nArray = ((DbArray)dbValue).getNanos();
                pJFDataOutput.writeInt(lArray.length);
                for (int i = 0; i < lArray.length; ++i) {
                    pJFDataOutput.writeLong(lArray[i]);
                    pJFDataOutput.writeInt(nArray[i]);
                }
                break;
            }
            case 7: {
                float[] fArray2 = (float[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(fArray2.length);
                for (int i = 0; i < fArray2.length; ++i) {
                    pJFDataOutput.writeFloat(fArray2[i]);
                }
                break;
            }
            case 6: 
            case 8: {
                double[] dArray = (double[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(dArray.length);
                for (int i = 0; i < dArray.length; ++i) {
                    pJFDataOutput.writeDouble(dArray[i]);
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(bigDecimalArray.length);
                for (int i = 0; i < bigDecimalArray.length; ++i) {
                    pJFDataOutput.writeUTF(bigDecimalArray[i].toString());
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                String[] stringArray = (String[])((DbArray)dbValue).getValue();
                pJFDataOutput.writeInt(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    pJFDataOutput.writeUTF(stringArray[i]);
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] append(Image image) throws IOException {
        ImageEncoder imageEncoder = new ImageEncoder();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            int n = imageEncoder.encode(image, dataOutputStream);
        }
        finally {
            dataOutputStream.close();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    private static final byte[] booleanValue(Image image, int n) throws IOException {
        if (image != null) {
            jet.export.util.ImageEncoder imageEncoder = new jet.export.util.ImageEncoder();
            switch (n) {
                case 4: {
                    return imageEncoder.renderImageToGif(image);
                }
                case 3: {
                    return imageEncoder.renderImageToPNG(image);
                }
                case 0: 
                case 1: {
                    return imageEncoder.renderImageToJpeg(image);
                }
            }
            return WriterTool.append(image);
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] close(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            try {
                boolean bl = object == null;
                objectOutputStream.writeBoolean(bl);
                if (!bl) {
                    objectOutputStream.writeObject(object);
                }
            }
            finally {
                objectOutputStream.close();
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6200000, (Throwable)iOException);
            }
            return new byte[0];
        }
    }

    private static String decimalNeedBytes(Propertiable propertiable) {
        StringBuffer stringBuffer = new StringBuffer();
        if (propertiable.isChangeByOther()) {
            stringBuffer.append(propertiable.getObject());
        } else {
            stringBuffer.append("");
        }
        stringBuffer.append("\u0007");
        if (propertiable.isChangeByBL()) {
            stringBuffer.append(propertiable.getChangeByBL());
        } else {
            stringBuffer.append("");
        }
        stringBuffer.append("\u0007");
        if (propertiable.isChagneByFmtt()) {
            stringBuffer.append(propertiable.getChangeByFmtt());
        } else {
            stringBuffer.append("");
        }
        stringBuffer.append("\u0007");
        if (propertiable.isSetRuntimeChgBy()) {
            stringBuffer.append(propertiable.getRuntimeChangeBy());
        } else {
            stringBuffer.append("");
        }
        return stringBuffer.toString();
    }
}

