/*
 * Decompiled with CFR 0.152.
 */
package jet.ie.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import jet.util.VersionControlable;

public class PJFDataInput
extends DataInputStream
implements VersionControlable {
    int version = 0;

    public PJFDataInput(InputStream inputStream) {
        super(inputStream);
    }

    public long readUTC() throws IOException {
        return this.readLong();
    }

    public Date readDate() throws IOException {
        long l = this.readLong();
        Date date = new Date();
        date.setTime(l);
        return date;
    }

    public BigDecimal readBigDecimal(int n) throws IOException {
        short s = this.readShort();
        byte[] byArray = new byte[s];
        this.read(byArray, 0, s);
        return new BigDecimal(new BigInteger(byArray), n);
    }

    public BigInteger readBigInteger(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.read(byArray, 0, n);
        return new BigInteger(byArray);
    }

    public long readOffset() throws IOException {
        return this.readLong();
    }

    public String readFixedString(int n, String string) throws IOException {
        short s = this.readShort();
        if (s > n) {
            throw new IOException("bad data in readFixedString:" + s + ">" + n);
        }
        byte[] byArray = new byte[s];
        this.readFully(byArray, 0, s);
        String string2 = new String(byArray, string);
        this.skipBytes(n - s);
        return string2;
    }

    public String readVariantString(String string) throws IOException {
        int n = this.readInt();
        byte[] byArray = new byte[n];
        this.readFully(byArray, 0, n);
        return new String(byArray, string);
    }

    public byte[] readVariantBinary() throws IOException {
        int n = this.readInt();
        byte[] byArray = new byte[n];
        this.readFully(byArray, 0, n);
        return byArray;
    }

    @Override
    public void setVersion(int n) {
        this.version = n;
    }

    @Override
    public int getMajorVersion() {
        return this.version >> 16;
    }

    @Override
    public int getMinorVersion() {
        return this.version & 0xFFFF;
    }

    @Override
    public int getVersion() {
        return this.version;
    }
}

