/*
 * Decompiled with CFR 0.152.
 */
package jet.ie.io;

import com.jinfonet.resstore.DiskStore;
import com.jinfonet.resstore.OutOfSpaceException;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import jet.util.IntVector;
import jet.util.RandomInputable;

public abstract class RACacheInput
implements RandomInputable {
    protected int pos;
    protected byte[] buf;
    protected int bufSize;
    protected int readyOff = 0;
    protected int readyLen = -1;
    protected int length = -1;
    protected File cacheName;
    protected RandomAccessFile cache;
    protected IntVector cacheTable;
    protected static final int DEFBUFSIZE = 40960;
    protected static final int MAJORVER = 1;
    protected static final int MINORVER = 3;
    protected int retryInterval = 200;
    protected DiskStore diskStore;

    public RACacheInput(DiskStore diskStore, int n) throws IOException, OutOfSpaceException {
        this.diskStore = diskStore;
        this.bufSize = n;
        this.cacheName = diskStore.createTempFile("raf", ".temp");
        this.cache = new RandomAccessFile(this.cacheName, "rw");
        this.buf = new byte[n];
        this.cacheTable = new IntVector(2);
        this.readyOff = 0;
        this.readyLen = -1;
        this.pos = 0;
        this.length = -1;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.cache != null) {
            this.cache.close();
            this.diskStore.delete(this.cacheName);
        }
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.pos < this.readyOff || this.pos >= this.readyOff + this.readyLen) {
            this.append(this.pos);
        }
        if (this.pos >= this.length) {
            System.err.println("pos >= length:" + this.pos + "," + this.length);
            return -1;
        }
        int n = this.cache != null ? this.buf[this.pos - this.readyOff] & 0xFF : this.buf[this.pos] & 0xFF;
        ++this.pos;
        return n;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (this.pos < this.readyOff || this.pos >= this.readyOff + this.readyLen) {
            this.append(this.pos);
        }
        if (this.readyLen == 0) {
            return -1;
        }
        int n5 = 0;
        while ((n4 = Math.min(n2 - n5, this.readyLen - (n3 = this.pos - this.readyOff))) > 0) {
            if (this.cache != null) {
                System.arraycopy(this.buf, n3, byArray, n + n5, n4);
            } else {
                System.arraycopy(this.buf, this.pos, byArray, n + n5, n4);
            }
            n5 += n4;
            this.pos += n4;
            this.append(this.pos);
        }
        return n5;
    }

    @Override
    public synchronized int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public synchronized void saveTo(String string) throws IOException {
        try {
            File file = this.diskStore.createFile(string);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            this.SEDU();
            if (this.cache == null) {
                randomAccessFile.write(this.buf, 0, this.buf.length);
            } else {
                byte[] byArray = new byte[40960];
                this.cache.seek(0L);
                int n = 0;
                while ((n = this.cache.read(byArray, 0, 40960)) > 0) {
                    randomAccessFile.write(byArray, 0, n);
                }
            }
            randomAccessFile.close();
            this.diskStore.fileUpdated(file);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new IOException(outOfSpaceException);
        }
    }

    @Override
    public synchronized void seek(long l) throws IOException {
        this.pos = (int)l;
    }

    @Override
    public synchronized long getPosition() throws IOException {
        return this.pos;
    }

    @Override
    public abstract long length() throws IOException;

    private void SEDU() throws IOException {
        if (this.length < 0) {
            this.length();
        }
        if (this.length == 0) {
            return;
        }
        this.append(0);
        while (this.cacheTable.elementAt(1) < this.length - 1) {
            this.append(this.cacheTable.elementAt(1) + 1);
        }
    }

    private void append(int n) throws IOException {
        int n2;
        if (this.length < 0) {
            this.length();
        }
        if (this.readyOff == (n2 = n / this.bufSize * this.bufSize) && this.readyLen >= 0) {
            return;
        }
        this.readyOff = n2;
        if (this.length == 0) {
            this.readyLen = 0;
            return;
        }
        if (this.arraycopy(this.readyOff)) {
            this.readyLen = Math.min(this.bufSize, this.length - this.readyOff);
            if (this.readyLen < 0) {
                this.readyLen = 0;
            }
            if (this.cache != null) {
                this.cache.seek(this.readyOff);
                if (this.readyLen > this.cache.read(this.buf, 0, this.readyLen)) {
                    throw new IOException("Bad cache file");
                }
            }
            return;
        }
        int n3 = Math.min(this.bufSize, this.length - this.readyOff);
        this.getDataFromInputStream(n3);
    }

    protected abstract void getDataFromInputStream(int var1) throws IOException;

    protected final void addData(int n, int n2) throws IOException {
        int n3;
        int n4 = n;
        int n5 = n + n2 - 1;
        int n6 = this.cacheTable.size();
        int n7 = n4;
        int n8 = -1;
        boolean bl = true;
        for (n3 = 0; n3 < n6; n3 += 2) {
            if (this.cacheTable.elementAt(n3) <= n4 && this.cacheTable.elementAt(n3 + 1) >= n4) {
                bl = false;
                n7 = this.cacheTable.elementAt(n3);
                n8 = this.cacheTable.elementAt(n3 + 1);
                break;
            }
            if (n5 < this.cacheTable.elementAt(n3)) break;
        }
        if (bl) {
            this.cacheTable.insertElementAt(n4, n3);
            this.cacheTable.insertElementAt(n5 + 1, n3 + 1);
            n6 += 2;
        }
        for (int i = n3 + 2; i < n6 && n5 + 1 >= this.cacheTable.elementAt(n3 + 2); i += 2) {
            n8 = this.cacheTable.elementAt(n3 + 3);
            this.cacheTable.removeElementAt(n3 + 3);
            this.cacheTable.removeElementAt(n3 + 2);
            i += 2;
        }
        this.cacheTable.setElementAt(Math.min(n4, n7), n3);
        this.cacheTable.setElementAt(Math.max(n5 + 1, n8), n3 + 1);
    }

    private boolean arraycopy(int n) throws IOException {
        for (int i = 0; i < this.cacheTable.size(); i += 2) {
            if (this.cacheTable.elementAt(i) > n || n >= this.cacheTable.elementAt(i + 1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = this.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public final synchronized int skipBytes(int n) throws IOException {
        this.pos += n;
        return n;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    @Override
    public final char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    @Override
    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    @Override
    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        throw new RuntimeException("Unsupported mehtod");
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

