/*
 * Decompiled with CFR 0.152.
 */
package jet.ie.io;

import com.jinfonet.resstore.DiskStore;
import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jet.cs.CSUtil;
import jet.ie.io.RAStreamInput;
import jet.net2.ConnectionListener;
import jet.net2.URL;
import jet.net2.www.protocol.http.HttpURLConnection;
import jet.util.IntVector;
import jet.util.RandomInputable;

public class RAHTTPInput
implements RandomInputable,
Runnable,
ConnectionListener {
    int pos;
    byte[] buf;
    URL url;
    int bufSize;
    int readyOff = 0;
    int readyLen = -1;
    int length = -1;
    File cacheName;
    RandomAccessFile cache;
    IntVector cacheTable;
    private static final int SEDU = 40960;
    private static final int addConnectionListener = 1;
    private static final int append = 3;
    private int arraycopy = 200;
    private static final String charAt = "Range";
    private static final String close = "Content-Range";
    private static final String communicate = "Host";
    private static final String convertEscapes = "Accept";
    private static final String createFile = "User-Agent";
    private static final String createTempFile = "Connection";
    private static final String delete = "Cookie";
    private static final String disconnect = "GET";
    private static final String elementAt = "jrs.cmd";
    private static final String error = "jrs.handshake";
    private String fileUpdated = null;
    private int get;
    private boolean getContentLength = false;
    private URLConnection getHeaderField = null;
    private boolean getHeaderFieldInt;
    private URL getHost;
    private static final String getInputStream = "JRS-HANDSHAKE-INTERVAL";
    private DiskStore getNextEntry;

    public RAHTTPInput(java.net.URL uRL, DiskStore diskStore) throws OutOfSpaceException, IOException {
        this(uRL, 40960, diskStore);
    }

    public RAHTTPInput(java.net.URL uRL, String string, int n, DiskStore diskStore) throws OutOfSpaceException, IOException {
        this(uRL, diskStore);
        this.fileUpdated = string;
        this.get = n;
        HttpURLConnection.addConnectionListener(this);
        try {
            this.getHost = new URL(uRL.getProtocol() + "://" + uRL.getHost() + ":" + uRL.getPort() + "/?" + elementAt + "=" + error);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        this.getHeaderFieldInt = true;
    }

    public RAHTTPInput(java.net.URL uRL, int n, DiskStore diskStore) throws OutOfSpaceException, IOException {
        this.url = new URL(uRL);
        this.getNextEntry = diskStore;
        this.bufSize = n;
        this.cacheName = this.getNextEntry.createTempFile("raf", ".temp");
        this.cache = new RandomAccessFile(this.cacheName, "rw");
        this.buf = new byte[n];
        this.cacheTable = new IntVector(2);
        this.readyOff = 0;
        this.readyLen = -1;
        this.pos = 0;
        this.length = -1;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.cache != null) {
            this.cache.close();
            this.getNextEntry.delete(this.cacheName);
        }
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HttpURLConnection.removeConnectionListener(this);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.pos < this.readyOff || this.pos >= this.readyOff + this.readyLen) {
            this.addConnectionListener(this.pos);
        }
        if (this.pos >= this.length) {
            return -1;
        }
        int n = this.cache != null ? this.buf[this.pos - this.readyOff] & 0xFF : this.buf[this.pos] & 0xFF;
        ++this.pos;
        return n;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (this.pos < this.readyOff || this.pos >= this.readyOff + this.readyLen) {
            this.addConnectionListener(this.pos);
        }
        if (this.readyLen == 0) {
            return -1;
        }
        int n5 = 0;
        while ((n4 = Math.min(n2 - n5, this.readyLen - (n3 = this.pos - this.readyOff))) > 0) {
            if (this.cache != null) {
                System.arraycopy(this.buf, n3, byArray, n + n5, n4);
            } else {
                System.arraycopy(this.buf, this.pos, byArray, n + n5, n4);
            }
            n5 += n4;
            this.pos += n4;
            this.addConnectionListener(this.pos);
        }
        return n5;
    }

    @Override
    public synchronized int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public synchronized void saveTo(String string) throws IOException {
        try {
            File file = this.getNextEntry.createFile(string);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            this.SEDU();
            if (this.cache == null) {
                randomAccessFile.write(this.buf, 0, this.buf.length);
            } else {
                byte[] byArray = new byte[40960];
                this.cache.seek(0L);
                int n = 0;
                while ((n = this.cache.read(byArray, 0, 40960)) > 0) {
                    randomAccessFile.write(byArray, 0, n);
                }
            }
            randomAccessFile.close();
            this.getNextEntry.fileUpdated(file);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new IOException(outOfSpaceException);
        }
    }

    @Override
    public synchronized void seek(long l) throws IOException {
        this.pos = (int)l;
    }

    @Override
    public synchronized long getPosition() throws IOException {
        return this.pos;
    }

    @Override
    public synchronized long length() throws IOException {
        if (this.length >= 0) {
            return this.length;
        }
        URLConnection uRLConnection = this.communicate(this.url, charAt, "bytes=0-0");
        int n = uRLConnection.getContentLength();
        DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
        switch (RAHTTPInput.getResponseCode(uRLConnection)) {
            case 200: {
                this.length = n;
                if (this.cache != null) {
                    int n2;
                    this.cache.seek(0L);
                    int n3 = n / this.bufSize;
                    for (n2 = 0; n2 < n3; ++n2) {
                        dataInputStream.readFully(this.buf, 0, this.bufSize);
                        this.cache.write(this.buf, 0, this.bufSize);
                    }
                    n2 = n % this.bufSize;
                    if (n2 > 0) {
                        dataInputStream.readFully(this.buf, 0, n2);
                        this.cache.write(this.buf, 0, n2);
                    }
                } else {
                    this.buf = new byte[this.length];
                    dataInputStream.readFully(this.buf, 0, this.length);
                }
                this.append(0, this.length);
                this.disconnect(uRLConnection);
                break;
            }
            case 206: {
                String string = uRLConnection.getHeaderField(close);
                try {
                    this.length = Integer.parseInt(string.substring(string.indexOf(47) + 1));
                }
                catch (Throwable throwable) {
                    throw new ProtocolException("Unknown Range field:" + string);
                }
                if (this.cache == null) {
                    this.buf = new byte[this.length];
                }
                this.disconnect(uRLConnection);
                break;
            }
            default: {
                this.disconnect(uRLConnection);
                throw new ProtocolException(this.buf(uRLConnection));
            }
        }
        return this.length;
    }

    private void SEDU() throws IOException {
        if (this.length < 0) {
            this.length();
        }
        if (this.length == 0) {
            return;
        }
        this.addConnectionListener(0);
        while (this.cacheTable.elementAt(1) < this.length - 1) {
            this.addConnectionListener(this.cacheTable.elementAt(1) + 1);
        }
    }

    private void addConnectionListener(int n) throws IOException {
        int n2;
        if (this.length < 0) {
            this.length();
        }
        if (this.readyOff == (n2 = n / this.bufSize * this.bufSize) && this.readyLen >= 0) {
            return;
        }
        this.readyOff = n2;
        if (this.length == 0) {
            this.readyLen = 0;
            return;
        }
        if (this.arraycopy(this.readyOff)) {
            this.readyLen = Math.min(this.bufSize, this.length - this.readyOff);
            if (this.readyLen < 0) {
                this.readyLen = 0;
            }
            if (this.cache != null) {
                this.cache.seek(this.readyOff);
                if (this.readyLen > this.cache.read(this.buf, 0, this.readyLen)) {
                    throw new IOException("Bad cache file");
                }
            }
            return;
        }
        int n3 = Math.min(this.bufSize, this.length - this.readyOff);
        URLConnection uRLConnection = this.communicate(this.url, charAt, "bytes=" + this.readyOff + "-" + (this.readyOff + n3 - 1));
        switch (RAHTTPInput.getResponseCode(uRLConnection)) {
            case 206: {
                int n4;
                String string = uRLConnection.getHeaderField(close);
                try {
                    n4 = Integer.parseInt(string.substring(string.indexOf(47) + 1));
                }
                catch (Throwable throwable) {
                    this.disconnect(uRLConnection);
                    throw new ProtocolException("Unknown Range field:" + string);
                }
                if (n4 != this.length) {
                    this.disconnect(uRLConnection);
                    throw new ProtocolException("File length changed, old " + this.length + " new " + n4);
                }
                int n5 = uRLConnection.getContentLength();
                if (n5 != n3) {
                    this.disconnect(uRLConnection);
                    throw new ProtocolException("Unmatching length for data, wants " + n3 + ", server returns " + n5);
                }
                DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
                if (this.cache != null) {
                    dataInputStream.readFully(this.buf, 0, n5);
                    this.cache.seek(this.readyOff);
                    this.cache.write(this.buf, 0, n5);
                } else {
                    dataInputStream.readFully(this.buf, this.readyOff, n5);
                }
                this.readyLen = n5;
                this.append(this.readyOff, n5);
                this.disconnect(uRLConnection);
                break;
            }
            default: {
                this.disconnect(uRLConnection);
                throw new ProtocolException(this.buf(uRLConnection));
            }
        }
    }

    private void append(int n, int n2) throws IOException {
        int n3;
        int n4 = n;
        int n5 = n + n2 - 1;
        int n6 = this.cacheTable.size();
        int n7 = n4;
        int n8 = -1;
        boolean bl = true;
        for (n3 = 0; n3 < n6; n3 += 2) {
            if (this.cacheTable.elementAt(n3) <= n4 && this.cacheTable.elementAt(n3 + 1) >= n4) {
                bl = false;
                n7 = this.cacheTable.elementAt(n3);
                n8 = this.cacheTable.elementAt(n3 + 1);
                break;
            }
            if (n5 < this.cacheTable.elementAt(n3)) break;
        }
        if (bl) {
            this.cacheTable.insertElementAt(n4, n3);
            this.cacheTable.insertElementAt(n5 + 1, n3 + 1);
            n6 += 2;
        }
        for (int i = n3 + 2; i < n6 && n5 + 1 >= this.cacheTable.elementAt(n3 + 2); i += 2) {
            n8 = this.cacheTable.elementAt(n3 + 3);
            this.cacheTable.removeElementAt(n3 + 3);
            this.cacheTable.removeElementAt(n3 + 2);
            i += 2;
        }
        this.cacheTable.setElementAt(Math.min(n4, n7), n3);
        this.cacheTable.setElementAt(Math.max(n5 + 1, n8), n3 + 1);
    }

    private boolean arraycopy(int n) throws IOException {
        for (int i = 0; i < this.cacheTable.size(); i += 2) {
            if (this.cacheTable.elementAt(i) > n || n >= this.cacheTable.elementAt(i + 1)) continue;
            return true;
        }
        return false;
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof java.net.HttpURLConnection) {
            ((java.net.HttpURLConnection)uRLConnection).setRequestMethod(disconnect);
        }
        String string = uRL.getHost();
        if (uRL.getPort() != 80) {
            string = string + ":" + uRL.getPort();
        }
        uRLConnection.setRequestProperty(convertEscapes, "application/x_jreport");
        uRLConnection.setRequestProperty(createFile, "JRptClient/1.3");
        if (!this.getContentLength && this.fileUpdated != null) {
            uRLConnection.setRequestProperty(delete, this.fileUpdated);
        }
        return uRLConnection;
    }

    protected void disconnect(URLConnection uRLConnection) {
        block2: {
            try {
                InputStream inputStream = uRLConnection.getInputStream();
                inputStream.close();
            }
            catch (Throwable throwable) {
                if (!JRLog.isError(2)) break block2;
                JRLog.error(2, throwable);
            }
        }
    }

    private String buf(URLConnection uRLConnection) {
        try {
            int n;
            String string = "Error from server: " + RAHTTPInput.getResponseCode(uRLConnection) + ":" + RAHTTPInput.getResponseMessage(uRLConnection);
            String string2 = uRLConnection.getHeaderField("JRS-MESSAGE");
            if (string2 != null) {
                string = string + ", extra information: " + CSUtil.convertEscapes(string2);
            }
            if ((n = uRLConnection.getContentLength()) > 0) {
                byte[] byArray = new byte[n];
                DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
                dataInputStream.readFully(byArray, 0, n);
                return string + "\n" + new String(byArray);
            }
            return string;
        }
        catch (IOException iOException) {
            return "No detailed information since cannot parse error information";
        }
    }

    public InputStream getInputStream() throws IOException {
        URLConnection uRLConnection = this.communicate(this.url, null);
        return uRLConnection.getInputStream();
    }

    public RandomInputable getRandomInputable() throws IOException {
        if (this.read() == 80 && this.read() == 75) {
            InputStream inputStream = this.getInputStream();
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            long l = zipEntry.getSize();
            this.close();
            return new RAStreamInput(zipInputStream, l, this.getNextEntry);
        }
        this.seek(0L);
        return this;
    }

    protected URLConnection communicate(URL uRL, String string, String string2) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(string, string2);
        return this.communicate(uRL, hashtable);
    }

    protected URLConnection communicate(URL uRL, Hashtable hashtable) throws IOException {
        int n;
        URLConnection uRLConnection;
        while (true) {
            uRLConnection = this.openConnection(uRL);
            if (hashtable != null) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    uRLConnection.setRequestProperty(string, "" + hashtable.get(string));
                }
            }
            if ((n = RAHTTPInput.getResponseCode(uRLConnection)) != 202) break;
            this.disconnect(uRLConnection);
            try {
                this.wait(this.arraycopy);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        switch (n) {
            case 200: 
            case 206: {
                break;
            }
            default: {
                throw new ProtocolException(this.buf(uRLConnection));
            }
        }
        return uRLConnection;
    }

    public static int getResponseCode(URLConnection uRLConnection) throws IOException {
        if (uRLConnection instanceof java.net.HttpURLConnection) {
            return ((java.net.HttpURLConnection)uRLConnection).getResponseCode();
        }
        try {
            String string = uRLConnection.getHeaderField(0);
            if (string == null) {
                return -1;
            }
            int n = string.indexOf(32);
            while (string.charAt(n) == ' ') {
                ++n;
            }
            int n2 = Integer.parseInt(string.substring(n, n + 3));
            return n2;
        }
        catch (Throwable throwable) {
            if (JRLog.isError(2)) {
                JRLog.error(2, throwable);
            }
            return -1;
        }
    }

    public static String getResponseMessage(URLConnection uRLConnection) throws IOException {
        if (uRLConnection instanceof java.net.HttpURLConnection) {
            return ((java.net.HttpURLConnection)uRLConnection).getResponseMessage();
        }
        try {
            String string = uRLConnection.getHeaderField(0);
            if (string == null) {
                return "Null, no message";
            }
            int n = string.indexOf(32);
            while (string.charAt(n) == ' ') {
                ++n;
            }
            return string.substring(n + 4).trim();
        }
        catch (Throwable throwable) {
            if (JRLog.isError(2)) {
                JRLog.error(2, throwable);
            }
            return null;
        }
    }

    public void logout() {
        this.getHeaderFieldInt = false;
    }

    @Override
    public void unauthorized(URLConnection uRLConnection) {
        this.getContentLength = true;
        this.getHeaderField = uRLConnection;
    }

    @Override
    public boolean isUnauthorized(URLConnection uRLConnection) {
        return this.getHeaderField == uRLConnection && this.getHeaderField != null;
    }

    @Override
    public void authorized(URLConnection uRLConnection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.getHeaderFieldInt) {
            Object object;
            try {
                object = this;
                synchronized (object) {
                    this.wait(this.get);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.fileUpdated == null) continue;
            try {
                object = this.communicate(this.getHost, getInputStream, "" + this.get);
                this.get = ((URLConnection)object).getHeaderFieldInt(getInputStream, this.get);
                this.disconnect((URLConnection)object);
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = this.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public final synchronized int skipBytes(int n) throws IOException {
        this.pos += n;
        return n;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    @Override
    public final char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    @Override
    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    @Override
    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        throw new RuntimeException("Unsupported mehtod");
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

