/*
 * Decompiled with CFR 0.152.
 */
package jet.jetc;

import guitools.Encoding;
import guitools.toolkit.Unit;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Map;
import jet.JResource;
import jet.controls.BytedProperty;
import jet.controls.Integerable;
import jet.controls.JetContainable;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetReference;
import jet.controls.JetRootable;
import jet.controls.JetString;
import jet.controls.JetUnitNumber;
import jet.controls.JetVector;
import jet.export.xml.LoadXSDException;
import jet.export.xml.XMLToObject;
import jet.jetc.BinaryJetC;
import jet.jetc.InvalidJetCFileFormatException;
import jet.jetc.InvalidJetCVersionException;
import jet.jetc.InvalidPropertyValueException;
import jet.jetc.ReadFailureException;
import jet.log.JRLogger;
import jet.report.JRObjectTemplate;
import jet.report.JetRptArea;
import jet.report.JetRptBreakContainer;
import jet.report.JetRptCTAggInfo;
import jet.report.JetRptChart2DCoordinatepaper;
import jet.report.JetRptChartCoordinatepaper;
import jet.report.JetRptDataSource;
import jet.report.JetRptGeometryObject;
import jet.report.JetRptObject;
import jet.report.JetRptParamLink;
import jet.report.JetRptSubLink;
import jet.report.JetRptSubReport;
import jet.report.JetRptTable;
import jet.report.chart.JetRptChartLabel;
import jet.report.chart.JetRptChartLegend;
import jet.report.chart.JetRptChartPaper;
import jet.report.paragraph.build.JetRptParagraph;
import jet.reportset.JetRptReportSet;
import jet.udos.JBrowserTmpl;
import jet.udos.JHyperLinkTmpl;
import jet.udos.JRotatorTemplate;
import jet.util.LinkPar;
import jet.util.convertRTF;
import timer.Clocker;

public class JetCReader {
    private int BL_DELIM;
    private int ENCODING;
    private int SEDU;
    private String[] add;
    private int anchor;
    private static final int append = 20;
    private int arraycopy = 0;
    private String available = null;
    private String cache = null;
    private int close = 0;
    private boolean convert = false;
    private static JRLogger convertPixelToUnit = JRLogger.getLogger(JetCReader.class.getName());
    private boolean convertUnitToPixel = false;
    private static final int endsWith = 256;

    public JetCReader() {
    }

    public JetCReader(String string) {
        this.available = string;
    }

    public JetCReader(String string, boolean bl) {
        this.available = string;
        this.convertUnitToPixel = bl;
    }

    public JetCReader(boolean bl) {
        this.convert = bl;
    }

    public void setEditable() {
        this.convertUnitToPixel = true;
    }

    public byte[] getFormula(String string) throws ReadFailureException {
        return (byte[])this.read(string, false, true);
    }

    public String getUniverseName(String string) throws ReadFailureException {
        return (String)this.read(string, true, false);
    }

    public String getUniverseName(DataInputStream dataInputStream) throws ReadFailureException {
        this.available = null;
        return (String)this.read(dataInputStream, true, false);
    }

    public JetObject read(String string) throws ReadFailureException {
        return (JetObject)this.read(string, false, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object read(String string, boolean bl, boolean bl2) throws ReadFailureException {
        Object object;
        this.append("fileName != null", string != null);
        this.available = string;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            object = this.read(fileInputStream, bl, bl2);
            if (fileInputStream == null) return object;
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                String string2 = JResource.getMessage("JET_1", (Object)string);
                if (convertPixelToUnit.isFatalEnabled()) {
                    convertPixelToUnit.fatal(string2, fileNotFoundException);
                }
                throw new ReadFailureException(200030, (Object[])new String[]{string2}, (Throwable)fileNotFoundException);
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new ReadFailureException(200031, (Object[])new String[]{JResource.getMessage("JET_2", (Object)string)}, (Throwable)iOException);
                }
            }
        }
        try {
            ((InputStream)fileInputStream).close();
            return object;
        }
        catch (IOException iOException) {
            throw new ReadFailureException(200031, (Object[])new String[]{JResource.getMessage("JET_2", (Object)string)}, (Throwable)iOException);
        }
    }

    public JetObject read(DataInputStream dataInputStream) throws ReadFailureException {
        return (JetObject)this.read(dataInputStream, false, false);
    }

    public JetObject read(InputStream inputStream) throws ReadFailureException {
        return (JetObject)this.read(inputStream, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object read(InputStream inputStream, boolean bl, boolean bl2) throws ReadFailureException {
        Clocker clocker = new Clocker();
        clocker.reset();
        this.append("is != null", inputStream != null);
        JetObject jetObject = null;
        if (this.available != null && (this.available.endsWith(".cls.xml") || this.available.endsWith(".cat.xml"))) {
            JetCReader jetCReader = this;
            synchronized (jetCReader) {
                try {
                    jetObject = XMLToObject.toObject(this.available);
                    this.setEditable();
                }
                catch (LoadXSDException loadXSDException) {
                    throw new ReadFailureException(200022, (Object[])new String[]{loadXSDException.getMessage()}, (Throwable)loadXSDException);
                }
            }
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string = this.available == null ? "" : this.available + ": ";
        JetCReader jetCReader = this;
        synchronized (jetCReader) {
            try {
                this.readHeader(dataInputStream);
                if (bl) {
                    if (this.arraycopy < 7) {
                        return null;
                    }
                    return this.add(dataInputStream, true);
                }
                if (bl2) {
                    if (this.arraycopy < 9) {
                        return null;
                    }
                    return this.SEDU(dataInputStream);
                }
                this.BL_DELIM(dataInputStream);
                jetObject = this.ENCODING(dataInputStream);
                byte[] byArray = this.anchor((byte)5, dataInputStream);
                if (byArray != null) {
                    String string2 = this.cache != null ? new String(byArray, this.cache) : new String(byArray);
                    JetProperty jetProperty = jetObject.nameToProperty("CatalogName");
                    if (jetProperty != null) {
                        jetProperty.set(string2);
                    }
                }
            }
            catch (IOException iOException) {
                if (convertPixelToUnit.isFatalEnabled()) {
                    convertPixelToUnit.fatal(string, iOException);
                }
                throw new ReadFailureException(200032, (Object[])new String[]{string, iOException.getClass().getName(), iOException.getMessage()}, (Throwable)iOException);
            }
            catch (InvalidJetCVersionException invalidJetCVersionException) {
                if (convertPixelToUnit.isFatalEnabled()) {
                    convertPixelToUnit.fatal(string, invalidJetCVersionException);
                }
                throw new ReadFailureException(200033, (Object[])new String[]{string, invalidJetCVersionException.getClass().getName(), invalidJetCVersionException.getMessage()}, (Throwable)invalidJetCVersionException);
            }
            catch (InvalidJetCFileFormatException invalidJetCFileFormatException) {
                if (convertPixelToUnit.isFatalEnabled()) {
                    convertPixelToUnit.fatal(string, invalidJetCFileFormatException);
                }
                throw new ReadFailureException(200034, (Object[])new String[]{string, invalidJetCFileFormatException.getClass().getName(), invalidJetCFileFormatException.getMessage()}, (Throwable)invalidJetCFileFormatException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (convertPixelToUnit.isFatalEnabled()) {
                    convertPixelToUnit.fatal(string, classNotFoundException);
                }
                throw new ReadFailureException(200035, (Object[])new String[]{string, classNotFoundException.getClass().getName(), classNotFoundException.getMessage()}, (Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                if (convertPixelToUnit.isFatalEnabled()) {
                    convertPixelToUnit.fatal(string, instantiationException);
                }
                throw new ReadFailureException(200036, (Object[])new String[]{string, instantiationException.getClass().getName(), instantiationException.getMessage()}, (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                if (convertPixelToUnit.isFatalEnabled()) {
                    convertPixelToUnit.fatal(string, illegalAccessException);
                }
                throw new ReadFailureException(200037, (Object[])new String[]{string, illegalAccessException.getClass().getName(), illegalAccessException.getMessage()}, (Throwable)illegalAccessException);
            }
            catch (InvalidPropertyValueException invalidPropertyValueException) {
                if (convertPixelToUnit.isFatalEnabled()) {
                    convertPixelToUnit.fatal(string, invalidPropertyValueException);
                }
                throw new ReadFailureException(200038, (Object[])new String[]{string, invalidPropertyValueException.getClass().getName(), invalidPropertyValueException.getMessage()}, (Throwable)invalidPropertyValueException);
            }
        }
        clocker.output("Load " + (this.available != null ? this.available : ""));
        if (jetObject instanceof JetRootable) {
            ((JetRootable)((Object)jetObject)).setVersion(this.arraycopy);
            if (jetObject instanceof JetRptReportSet) {
                ((JetRptReportSet)jetObject).setInnerType(this.close);
            }
        }
        return jetObject;
    }

    public int getVersion() {
        return this.arraycopy;
    }

    public int getBuildNumber() {
        return this.anchor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readHeader(String string) throws IOException, InvalidJetCVersionException, InvalidJetCFileFormatException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            this.readHeader(dataInputStream);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                finally {
                    fileInputStream = null;
                }
            }
        }
    }

    public void readHeader(DataInputStream dataInputStream) throws IOException, InvalidJetCVersionException, InvalidJetCFileFormatException {
        int n = dataInputStream.readInt();
        if ((long)n != -87098658L) {
            throw new InvalidJetCFileFormatException(200039);
        }
        this.arraycopy = dataInputStream.readInt();
        if (!BinaryJetC.isCompatibleJetC(this.arraycopy)) {
            throw new InvalidJetCVersionException(200040, (Object[])new String[]{String.valueOf(this.arraycopy >> 16), String.valueOf(this.arraycopy & 0xFFFF)}, null);
        }
        this.ENCODING = dataInputStream.readInt();
        this.BL_DELIM = dataInputStream.readInt();
        this.ENCODING -= this.BL_DELIM * 4;
        this.SEDU = dataInputStream.readInt();
        dataInputStream.readInt();
        this.anchor = dataInputStream.readInt();
        this.close = dataInputStream.readInt();
    }

    private void BL_DELIM(DataInputStream dataInputStream) throws IOException, UnsupportedEncodingException {
        String[] stringArray = null;
        byte[] byArray = new byte[this.BL_DELIM * 4];
        byte[] byArray2 = new byte[this.ENCODING];
        stringArray = new String[this.BL_DELIM];
        dataInputStream.readFully(byArray);
        dataInputStream.readFully(byArray2);
        int n = 0;
        int n2 = 0;
        byte[] byArray3 = new byte[256];
        for (int i = 0; i < this.BL_DELIM; ++i) {
            int n3 = byArray[n2++];
            n3 <<= 8;
            n3 |= byArray[n2++] & 0xFF;
            n3 <<= 8;
            n3 |= byArray[n2++] & 0xFF;
            n3 <<= 8;
            if (byArray3.length < (n3 |= byArray[n2++] & 0xFF)) {
                byArray3 = new byte[n3];
            }
            System.arraycopy(byArray2, n, byArray3, 0, n3);
            if (this.arraycopy < 65536) {
                stringArray[i] = new String(byArray3, 0, n3);
            } else if (i > 0) {
                stringArray[i] = new String(byArray3, 0, n3, this.cache);
            } else if (this.arraycopy >= 65540) {
                stringArray[i] = this.cache = BinaryJetC.ENCODING;
            } else {
                stringArray[i] = this.cache = new String(byArray3, 0, n3);
                this.cache = Encoding.getEncoding();
            }
            n += n3;
        }
        this.add = stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JetObject ENCODING(DataInputStream dataInputStream) throws IOException, UnsupportedEncodingException, InvalidJetCFileFormatException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvalidPropertyValueException {
        JetObject[] jetObjectArray = new JetObject[20];
        int n = 0;
        int n2 = 20;
        byte[] byArray = new byte[this.SEDU];
        int n3 = 1;
        dataInputStream.readFully(byArray);
        Hashtable<String, Integer> hashtable = null;
        if (byArray[0] != 0) {
            throw new InvalidJetCFileFormatException(200041);
        }
        boolean bl = this.arraycopy < 65553;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            block10: do {
                int n4;
                int n5;
                int n6 = byArray[n3++];
                n6 <<= 8;
                n6 |= byArray[n3++] & 0xFF;
                n6 <<= 8;
                n6 |= byArray[n3++] & 0xFF;
                n6 <<= 8;
                n6 |= byArray[n3++] & 0xFF;
                int n7 = byArray[n3++];
                n7 <<= 8;
                n7 |= byArray[n3++] & 0xFF;
                n7 <<= 8;
                n7 |= byArray[n3++] & 0xFF;
                n7 <<= 8;
                JetObject jetObject = (JetObject)Class.forName(this.add[n == 0 ? (n7 |= byArray[n3++] & 0xFF) : n6]).newInstance();
                boolean bl4 = bl2 = bl && jetObject instanceof JetRptArea;
                if (this.convertUnitToPixel) {
                    jetObject.setEditable();
                }
                if (this.arraycopy <= 65549 && jetObject instanceof JetRptSubReport) {
                    ((JetRptSubReport)jetObject).cache.set(false);
                }
                if (this.arraycopy < 65568) {
                    Hashtable<String, String> hashtable2 = new Hashtable<String, String>(4);
                    if (jetObject instanceof JetRptChartCoordinatepaper) {
                        hashtable2.put("AxisYFontFace", "Default");
                        hashtable2.put("AxisZFontFace", "Default");
                        hashtable2.put("AxisXFontFace", "Default");
                        hashtable2.put("HintFontFace", "Default");
                    } else if (jetObject instanceof JetRptChart2DCoordinatepaper) {
                        hashtable2.put("AxisXFontFace", "Default");
                        hashtable2.put("AxisY1FontFace", "Default");
                        hashtable2.put("AxisY2FontFace", "Default");
                        hashtable2.put("HintFontFace", "Default");
                    } else if (jetObject instanceof JetRptChartPaper) {
                        hashtable2.put("AxisXLabelTextFontName", "Default");
                        hashtable2.put("AxisYLabelTextFontName", "Default");
                        hashtable2.put("AxisY2LabelTextFontName", "Default");
                        hashtable2.put("AxisZLabelTextFontName", "Default");
                        hashtable2.put("HintTextFontName", "Dialog");
                    } else if (jetObject instanceof JetRptChartLabel || jetObject instanceof JetRptChartLegend) {
                        hashtable2.put("LabelTextFontName", "Default");
                    } else if (jetObject instanceof JetRptParagraph) {
                        hashtable2.put("FontFace", "TimesRoman");
                    } else if (jetObject instanceof JBrowserTmpl) {
                        hashtable2 = new Hashtable(1);
                        hashtable2.put("fontFace", "Default");
                    } else if (jetObject instanceof JHyperLinkTmpl) {
                        hashtable2.put("fontFace", "Dialog");
                    } else if (jetObject instanceof JRotatorTemplate) {
                        hashtable2.put("FontFace", "Dialog");
                    } else if (jetObject instanceof JRObjectTemplate) {
                        n5 = ((JRObjectTemplate)jetObject).getObjectType();
                        if (n5 != 4096) {
                            hashtable2.put("FontFace", "Default");
                        } else {
                            hashtable2 = null;
                        }
                    } else {
                        hashtable2.put("FontFace", "Default");
                    }
                    if (hashtable2 != null) {
                        JetCReader.arraycopy(hashtable2, jetObject);
                    }
                    hashtable2 = null;
                }
                if (n == 0) {
                    if (jetObject instanceof JetRootable) {
                        jetObject.setInstName(this.add[n6]);
                    }
                    if (this.add[n7].equals("jet.report.JetRptReportPanel")) {
                        boolean bl5 = this.arraycopy < 65543;
                        boolean bl6 = bl5 = this.convertUnitToPixel && bl5;
                        if (bl5) {
                            hashtable = new Hashtable<String, Integer>();
                        }
                    }
                } else {
                    jetObject.setInstName(this.add[n7]);
                    ((JetContainable)((Object)jetObjectArray[n - 1])).add(jetObject);
                }
                if (hashtable != null) {
                    String string = jetObject.getInstName();
                    Object v = hashtable.get(string);
                    n4 = v != null ? (Integer)v + 1 : 0;
                    hashtable.put(string, n4);
                }
                if (n >= n2) {
                    JetObject[] jetObjectArray2 = new JetObject[n2 + 20];
                    System.arraycopy(jetObjectArray, 0, jetObjectArray2, 0, n2);
                    n2 += 20;
                    jetObjectArray = jetObjectArray2;
                }
                jetObjectArray[n++] = jetObject;
                block11: while (true) {
                    switch (byArray[n3++]) {
                        case 1: {
                            int n8;
                            n7 = byArray[n3++];
                            n7 <<= 8;
                            n7 |= byArray[n3++] & 0xFF;
                            n7 <<= 8;
                            n7 |= byArray[n3++] & 0xFF;
                            n7 <<= 8;
                            n6 = (n7 |= byArray[n3++] & 0xFF) / 9;
                            n7 = 0;
                            while (true) {
                                if (n7 >= n6) continue block11;
                                n8 = byArray[n3++];
                                n8 <<= 8;
                                n8 |= byArray[n3++] & 0xFF;
                                n8 <<= 8;
                                n8 |= byArray[n3++] & 0xFF;
                                n8 <<= 8;
                                int n9 = n3++;
                                JetProperty jetProperty = null;
                                String string = this.add[n8 |= byArray[n9] & 0xFF];
                                jetProperty = string.equals("TOCAnchor") ? ((JetRptObject)jetObject).anchor : jetObject.nameToProperty(string);
                                boolean bl7 = bl3 = bl2 && string.equals("Link");
                                if (jetProperty == null && this.convert) {
                                    jetProperty = new JetString(jetObject, this.add[n8]);
                                }
                                n8 = byArray[n3 + 1];
                                n8 <<= 8;
                                n8 |= byArray[n3 + 2] & 0xFF;
                                n8 <<= 8;
                                n8 |= byArray[n3 + 3] & 0xFF;
                                n8 <<= 8;
                                n8 |= byArray[n3 + 4] & 0xFF;
                                if (byArray[n3] == 12) {
                                    if (jetProperty.isEnableAutoValue()) {
                                        jetProperty.setAsAutoValue(true);
                                    }
                                } else if (byArray[n3] == 4) {
                                    if (this.arraycopy < 65539) {
                                        if (jetProperty != null && (string.equals("FontSize") || string.equals("BorderSize") || string.equals("LabelWidth"))) {
                                            n8 = Unit.convertPixelToUnit(n8);
                                        } else if (jetProperty != null && jetProperty instanceof JetUnitNumber) {
                                            if (this.arraycopy <= 65537) {
                                                n8 = (int)Math.round((double)n8 * 5760.0 / 120.0);
                                            } else if (this.arraycopy <= 65540) {
                                                n8 = (int)Math.round((double)n8 * 5760.0 / 65535.0);
                                            }
                                        }
                                    } else if (this.arraycopy <= 65540 && jetProperty != null && jetProperty instanceof JetUnitNumber) {
                                        n8 = (int)Math.round((double)n8 * 5760.0 / 65535.0);
                                    }
                                    if (jetProperty != null) {
                                        if (jetProperty instanceof JetVector) {
                                            ((JetVector)jetProperty).set(String.valueOf(n8));
                                        } else {
                                            ((Integerable)((Object)jetProperty)).setInt(n8);
                                        }
                                    } else if (jetObject instanceof JRObjectTemplate) {
                                        ((JRObjectTemplate)jetObject).setInt(string, n8, this.arraycopy);
                                    } else if (jetObject instanceof JetRptBreakContainer) {
                                        ((JetRptBreakContainer)jetObject).setInt(string, n8, this.arraycopy);
                                    } else if (jetObject instanceof JetRptParamLink) {
                                        ((JetRptParamLink)jetObject).setInt(string, n8);
                                    } else if (jetObject instanceof JetRptCTAggInfo) {
                                        ((JetRptCTAggInfo)jetObject).setInt(string, n8);
                                    }
                                } else if (byArray[n3] == 5) {
                                    float f = Float.intBitsToFloat(n8);
                                    if (jetProperty instanceof JetUnitNumber) {
                                        ((JetUnitNumber)jetProperty).set(Unit.convertUnitToPixel(f));
                                    } else {
                                        ((JetNumber)jetProperty).set(f);
                                    }
                                } else if (jetProperty instanceof JetReference) {
                                    if (byArray[n3] == 2) {
                                        ((JetReference)jetProperty).setReference(null);
                                    } else {
                                        if (byArray[n3] != 1) throw new InvalidPropertyValueException(200029, (Object[])new String[]{jetProperty.getName(), this.add[n8]}, null);
                                        ((JetReference)jetProperty).set(this.add[n8]);
                                    }
                                } else if (byArray[n3] == 3) {
                                    if (bl3) {
                                        jetProperty.setUnitValue("1:<0><" + this.add[n8].trim().toUpperCase() + LinkPar.BL_DELIM + ">");
                                    } else if (jetProperty != null) {
                                        jetProperty.loadFullChangeBy(this.add[n8]);
                                    } else if (jetObject instanceof JRObjectTemplate) {
                                        ((JRObjectTemplate)jetObject).setChangeBy(string, this.add[n8]);
                                    } else if (jetObject instanceof JetRptBreakContainer) {
                                        ((JetRptBreakContainer)jetObject).setChangeBy(string, this.add[n8]);
                                    }
                                } else if (jetProperty != null && this.arraycopy < 65539 && (string.equals("LineWidth") || string.equals("BorderWidth"))) {
                                    n4 = Unit.convertPixelToUnit(Integer.parseInt(this.add[n8]));
                                    ((JetUnitNumber)jetProperty).setUnitValue(n4);
                                } else if (this.arraycopy < 65539 && (string.equals("LineWidth") || string.equals("BorderWidth"))) {
                                    n4 = Integer.parseInt(this.add[n8]);
                                    if (jetObject instanceof JRObjectTemplate) {
                                        ((JRObjectTemplate)jetObject).setInt(string, n4, this.arraycopy);
                                    }
                                } else if (jetProperty != null) {
                                    if (bl3) {
                                        jetProperty.setUnitValue("1:<-1><" + LinkPar.BL_DELIM + ">" + this.add[n8]);
                                    } else {
                                        if (this.arraycopy == 65545 && jetProperty.getName().equals("RTFProperty")) {
                                            this.add[n8] = convertRTF.convert(this.add[n8]);
                                        }
                                        jetProperty.setUnitValue(this.add[n8]);
                                    }
                                } else if (string.endsWith("_by")) {
                                    string = string.substring(0, string.length() - 3);
                                    if (jetObject instanceof JRObjectTemplate) {
                                        ((JRObjectTemplate)jetObject).setChangeBy(string, this.add[n8]);
                                    } else if (jetObject instanceof JetRptBreakContainer) {
                                        ((JetRptBreakContainer)jetObject).setChangeBy(string, this.add[n8]);
                                    }
                                } else if (!string.equals("TopAttach") && !string.equals("BottomAttach")) {
                                    if (jetObject instanceof JRObjectTemplate) {
                                        ((JRObjectTemplate)jetObject).setPrimUnit(string, this.add[n8]);
                                    } else if (jetObject instanceof JetRptBreakContainer) {
                                        ((JetRptBreakContainer)jetObject).setPrimUnit(string, this.add[n8]);
                                    } else if (jetObject instanceof JetRptDataSource) {
                                        ((JetRptDataSource)jetObject).setPrimUnit(string, this.add[n8]);
                                    } else if (jetObject instanceof JetRptSubLink) {
                                        ((JetRptSubLink)jetObject).setPrimUnit(string, this.add[n8]);
                                    } else if (jetObject instanceof JetRptCTAggInfo) {
                                        ((JetRptCTAggInfo)jetObject).setPrimUnit(string, this.add[n8]);
                                    }
                                } else if (jetObject instanceof JetRptGeometryObject) {
                                    ((JetRptGeometryObject)jetObject).setTempName(string, this.add[n8]);
                                } else if (jetObject instanceof JetRptTable) {
                                    ((JetRptTable)jetObject).setTempName(string, this.add[n8]);
                                }
                                n3 += 5;
                                ++n7;
                            }
                        }
                        case 10: 
                        case 11: {
                            byte by = byArray[n3 - 1];
                            n3 += 4;
                            n6 = byArray[n3++];
                            n6 <<= 8;
                            n6 |= byArray[n3++] & 0xFF;
                            n6 <<= 8;
                            n6 |= byArray[n3++] & 0xFF;
                            n6 <<= 8;
                            JetProperty jetProperty = jetObject.nameToProperty(this.add[n6 |= byArray[n3++] & 0xFF]);
                            if (jetProperty != null) {
                                long l = byArray[n3++];
                                l <<= 8;
                                l |= (long)(byArray[n3++] & 0xFF);
                                l <<= 8;
                                l |= (long)(byArray[n3++] & 0xFF);
                                l <<= 8;
                                l |= (long)(byArray[n3++] & 0xFF);
                                l <<= 8;
                                l |= (long)(byArray[n3++] & 0xFF);
                                l <<= 8;
                                l |= (long)(byArray[n3++] & 0xFF);
                                l <<= 8;
                                l |= (long)(byArray[n3++] & 0xFF);
                                l <<= 8;
                                l |= (long)(byArray[n3++] & 0xFF);
                                if (by == 10) {
                                    if (jetProperty instanceof JetUnitNumber) {
                                        ((JetUnitNumber)jetProperty).set(Unit.convertUnitToPixel(l));
                                        continue block11;
                                    }
                                    ((JetNumber)jetProperty).set(l);
                                    continue block11;
                                }
                                if (jetProperty instanceof JetUnitNumber) {
                                    ((JetUnitNumber)jetProperty).set(Unit.convertUnitToPixel(Double.longBitsToDouble(l)));
                                    continue block11;
                                }
                                ((JetNumber)jetProperty).set(Double.longBitsToDouble(l));
                                continue block11;
                            }
                            n3 += 8;
                            continue block11;
                        }
                        case 6: {
                            n7 = byArray[n3++];
                            n7 <<= 8;
                            n7 |= byArray[n3++] & 0xFF;
                            n7 <<= 8;
                            n7 |= byArray[n3++] & 0xFF;
                            n7 <<= 8;
                            n7 |= byArray[n3++] & 0xFF;
                            n6 = byArray[n3++];
                            n6 <<= 8;
                            n6 |= byArray[n3++] & 0xFF;
                            n6 <<= 8;
                            n6 |= byArray[n3++] & 0xFF;
                            n6 <<= 8;
                            int n10 = n3++;
                            byte[] byArray2 = new byte[n7 -= 4];
                            System.arraycopy(byArray, n3, byArray2, 0, n7);
                            n3 += n7;
                            JetProperty jetProperty = jetObject.nameToProperty(this.add[n6 |= byArray[n10] & 0xFF]);
                            if (!(jetProperty instanceof BytedProperty)) continue block11;
                            ((BytedProperty)((Object)jetProperty)).setByteArray(byArray2);
                            continue block11;
                        }
                        case 2: {
                            break block11;
                        }
                        case 3: {
                            int n8;
                            n7 = byArray[n3++];
                            n7 <<= 8;
                            n7 |= byArray[n3++] & 0xFF;
                            n7 <<= 8;
                            n7 |= byArray[n3++] & 0xFF;
                            n7 <<= 8;
                            if ((n6 = (n7 |= byArray[n3++] & 0xFF) / 8) <= 0) continue block11;
                            Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
                            for (n5 = 0; n5 < n6; ++n5) {
                                n7 = byArray[n3++];
                                n7 <<= 8;
                                n7 |= byArray[n3++] & 0xFF;
                                n7 <<= 8;
                                n7 |= byArray[n3++] & 0xFF;
                                n7 <<= 8;
                                n7 |= byArray[n3++] & 0xFF;
                                n8 = byArray[n3++];
                                n8 <<= 8;
                                n8 |= byArray[n3++] & 0xFF;
                                n8 <<= 8;
                                n8 |= byArray[n3++] & 0xFF;
                                n8 <<= 8;
                                hashtable3.put(this.add[n7], n8 |= byArray[n3++] & 0xFF);
                            }
                            ((JetRootable)((Object)jetObject)).setNamingCount(hashtable == null ? hashtable3 : hashtable);
                            continue block11;
                        }
                        case -1: {
                            if (--n <= 0) continue block10;
                            jetObject = jetObjectArray[n - 1];
                            continue block11;
                        }
                        default: {
                            int n8 = byArray[n3++];
                            n8 <<= 8;
                            n8 |= byArray[n3++] & 0xFF;
                            n8 <<= 8;
                            n8 |= byArray[n3++] & 0xFF;
                            n8 <<= 8;
                            n3 += (n8 |= byArray[n3++] & 0xFF);
                            continue block11;
                        }
                    }
                    break;
                }
            } while (n > 0);
            return jetObjectArray[0];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (!convertPixelToUnit.isFatalEnabled()) throw new InvalidJetCFileFormatException(200042, (Throwable)arrayIndexOutOfBoundsException);
            convertPixelToUnit.fatal("", arrayIndexOutOfBoundsException);
            throw new InvalidJetCFileFormatException(200042, (Throwable)arrayIndexOutOfBoundsException);
        }
    }

    private byte[] SEDU(DataInputStream dataInputStream) throws IOException {
        dataInputStream.skip(this.BL_DELIM * 4 + this.ENCODING + this.SEDU);
        return this.anchor((byte)7, dataInputStream);
    }

    private String add(DataInputStream dataInputStream, boolean bl) throws IOException {
        byte[] byArray;
        int n = this.BL_DELIM * 4 + this.ENCODING + this.SEDU;
        if (this.arraycopy >= 65536) {
            byArray = new byte[4];
            dataInputStream.readFully(byArray);
            int n2 = byArray[0];
            n2 <<= 8;
            n2 |= byArray[1] & 0xFF;
            n2 <<= 8;
            n2 |= byArray[2] & 0xFF;
            n2 <<= 8;
            n2 |= byArray[3] & 0xFF;
            dataInputStream.skip(this.BL_DELIM * 4 - 4);
            byArray = new byte[n2];
            dataInputStream.readFully(byArray);
            this.cache = this.arraycopy >= 65540 ? BinaryJetC.ENCODING : Encoding.getEncoding();
            n -= this.BL_DELIM * 4 + n2;
        }
        dataInputStream.skip(n);
        byArray = this.anchor((byte)5, dataInputStream);
        if (byArray != null) {
            if (this.cache != null) {
                return new String(byArray, this.cache);
            }
            return new String(byArray);
        }
        return null;
    }

    private byte[] anchor(byte by, DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[5];
        while (dataInputStream.available() > 0) {
            dataInputStream.readFully(byArray);
            int n = byArray[1];
            n <<= 8;
            n |= byArray[2] & 0xFF;
            n <<= 8;
            n |= byArray[3] & 0xFF;
            n <<= 8;
            n |= byArray[4] & 0xFF;
            n -= 4;
            if (byArray[0] == by) {
                byArray = new byte[n];
                dataInputStream.readFully(byArray);
                return byArray;
            }
            dataInputStream.skip(n);
        }
        return null;
    }

    private void append(String string, boolean bl) {
        if (!bl) {
            // empty if block
        }
    }

    private static void arraycopy(Hashtable hashtable, JetObject jetObject) {
        for (Map.Entry entry : hashtable.entrySet()) {
            JetProperty jetProperty = jetObject.nameToProperty((String)entry.getKey());
            if (jetProperty == null) continue;
            jetProperty.set((String)entry.getValue());
        }
    }
}

