/*
 * Decompiled with CFR 0.152.
 */
package jet.jetc;

import com.jinfonet.resstore.DiskStore;
import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Locale;
import jet.Env;
import jet.JResource;
import jet.controls.JetObject;
import jet.controls.JetRootable;
import jet.convertrpt.CrystalConverter;
import jet.export.xml.LoadXSDException;
import jet.export.xml.XMLToObject;
import jet.export.xml.XSDToObject;
import jet.jetc.BinaryJetC;
import jet.jetc.InvalidJetCVersionException;
import jet.jetc.JetCParser;
import jet.jetc.JetCReader;
import jet.jetc.JetCWriter;
import jet.jetc.JetObjBinaryWriter;
import jet.jetc.JetObjXMLWriter;
import jet.jetc.ParseException;
import jet.jetc.ReadFailureException;
import jet.jetc.ReportTextureWriter;
import jet.jetc.WriteFailureException;
import jet.jetc.b2t;
import jet.universe.JetUUniverse;
import jet.util.EnginePerformance;

public class LoaderNoCache {
    protected boolean isCacheable = false;
    String jetcfile = "";
    File fjetc;
    static EnginePerformance manager;
    String path = "";
    int version;
    boolean bEditable = true;
    public static final int INPUTSTREAM_CAT = 1;
    public static final int INPUTSTREAM_CATXML = 2;
    public static final int INPUTSTREAM_CATXSD = 3;
    public static final int INPUTSTREAM_CLS = 6;
    public static final int INPUTSTREAM_RPT = 7;
    public static final int INPUTSTREAM_CLSXML = 9;
    public static final int INPUTSTREAM_WLSD = 10;

    public LoaderNoCache() {
    }

    public LoaderNoCache(String string) {
        this.jetcfile = string;
        this.fjetc = new File(this.jetcfile);
    }

    public LoaderNoCache(String string, String string2) {
        this.path = string;
        this.jetcfile = string2;
        if (this.path != null && this.path.length() != 0 && !this.path.equals(File.separator)) {
            this.jetcfile = this.path + (this.path.endsWith(File.separator) ? "" : File.separator) + this.jetcfile;
        }
        this.fjetc = new File(this.jetcfile);
    }

    public boolean getEditable() {
        return this.bEditable;
    }

    public void setEditable(boolean bl) {
        this.bEditable = bl;
    }

    public String getFileName() {
        return this.jetcfile;
    }

    public int getVersion() {
        return this.version;
    }

    public static boolean isReportName(String string) {
        return (string = string.toLowerCase()).endsWith(".cls".toLowerCase()) || string.endsWith(".rpt".toLowerCase());
    }

    public JetObject loadObject() throws ReadFailureException {
        return this.loadObject(false);
    }

    public JetObject loadNoInit() throws ReadFailureException {
        return this.loadObject(false);
    }

    public JetObject loadNoInit(Locale locale) throws ReadFailureException {
        return this.loadObject(false, locale);
    }

    public JetObject loadNoInit(Locale locale, String string) throws ReadFailureException {
        return this.loadObject(false, locale, string);
    }

    public JetObject load() throws ReadFailureException {
        return this.loadObject(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JetObject loadObject(boolean bl) throws ReadFailureException {
        JetObject jetObject;
        if (this.jetcfile.equals("")) {
            return null;
        }
        if (this.jetcfile.toLowerCase().endsWith(".rpt")) {
            return this.SEDU(this.jetcfile, bl);
        }
        FileInputStream fileInputStream = null;
        try {
            JetObject jetObject2;
            fileInputStream = new FileInputStream(this.jetcfile);
            jetObject = jetObject2 = this.loadObject((InputStream)fileInputStream, bl);
            if (fileInputStream == null) return jetObject;
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new ReadFailureException(200049, (Object[])new String[]{JResource.getMessage("JET_1", (Object)this.jetcfile)}, (Throwable)fileNotFoundException);
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new ReadFailureException(200050, (Object[])new String[]{JResource.getMessage("JET_8", (Object)this.jetcfile)}, (Throwable)iOException);
                }
            }
        }
        try {
            fileInputStream.close();
            return jetObject;
        }
        catch (IOException iOException) {
            throw new ReadFailureException(200050, (Object[])new String[]{JResource.getMessage("JET_8", (Object)this.jetcfile)}, (Throwable)iOException);
        }
    }

    public JetObject loadObject(boolean bl, Locale locale) throws ReadFailureException {
        return this.loadObject(bl, locale, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JetObject loadObject(boolean bl, Locale locale, String string) throws ReadFailureException {
        JetObject jetObject;
        if (this.jetcfile.equals("")) {
            return null;
        }
        if (this.jetcfile.toLowerCase().endsWith(".rpt")) {
            return this.SEDU(this.jetcfile, bl);
        }
        FileInputStream fileInputStream = null;
        try {
            JetObject jetObject2;
            fileInputStream = new FileInputStream(this.jetcfile);
            jetObject = jetObject2 = this.loadObject(fileInputStream, bl, locale, string);
            if (fileInputStream == null) return jetObject;
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new ReadFailureException(200049, (Object[])new String[]{JResource.getMessage("JET_1", (Object)this.jetcfile)}, (Throwable)fileNotFoundException);
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new ReadFailureException(200050, (Object[])new String[]{JResource.getMessage("JET_8", (Object)this.jetcfile)}, (Throwable)iOException);
                }
            }
        }
        try {
            fileInputStream.close();
            return jetObject;
        }
        catch (IOException iOException) {
            throw new ReadFailureException(200050, (Object[])new String[]{JResource.getMessage("JET_8", (Object)this.jetcfile)}, (Throwable)iOException);
        }
    }

    public JetObject loadObject(InputStream inputStream, boolean bl) throws ReadFailureException {
        Object object;
        if (this.isCacheable && manager != null && this.fjetc != null && !((String)(object = this.fjetc.getName().toLowerCase())).endsWith(".lc") && !((String)object).endsWith(".va")) {
            return manager.loadObject(this.fjetc, inputStream, bl);
        }
        object = null;
        JetCReader jetCReader = null;
        if (this.jetcfile != null && (this.jetcfile.toLowerCase().endsWith(".csd") || this.jetcfile.toLowerCase().endsWith(".cls.xml") || this.jetcfile.toLowerCase().endsWith(".cat.xml") || this.jetcfile.toLowerCase().endsWith(".wsld"))) {
            try {
                object = this.jetcfile.toLowerCase().endsWith(".csd") ? XSDToObject.toObject(this.jetcfile) : XMLToObject.toObject(this.jetcfile);
            }
            catch (LoadXSDException loadXSDException) {
                throw new ReadFailureException(200022, (Object[])new String[]{loadXSDException.getMessage()}, (Throwable)loadXSDException);
            }
            this.append((JetObject)object, bl, false);
        } else {
            jetCReader = new JetCReader(this.fjetc.toString(), this.bEditable);
            object = jetCReader.read(new DataInputStream(inputStream));
            this.version = jetCReader.getVersion();
            this.append((JetObject)object, bl, this.version < 65648);
        }
        return object;
    }

    public JetObject loadObject(InputStream inputStream, boolean bl, Locale locale) throws ReadFailureException {
        return this.loadObject(inputStream, bl, locale, "");
    }

    public JetObject loadObject(InputStream inputStream, boolean bl, Locale locale, String string) throws ReadFailureException {
        Object object;
        if (this.isCacheable && manager != null && this.fjetc != null && !((String)(object = this.fjetc.getName().toLowerCase())).endsWith(".lc") && !((String)object).endsWith(".va")) {
            return manager.loadObject(this.fjetc, inputStream, bl, locale, string);
        }
        object = null;
        JetCReader jetCReader = null;
        if (this.jetcfile != null && (this.jetcfile.toLowerCase().endsWith(".cls.xml") || this.jetcfile.toLowerCase().endsWith(".cat.xml") || this.jetcfile.toLowerCase().endsWith(".wsld"))) {
            try {
                object = XMLToObject.toObject(this.jetcfile);
            }
            catch (LoadXSDException loadXSDException) {
                throw new ReadFailureException(200022, (Object[])new String[]{loadXSDException.getMessage()}, (Throwable)loadXSDException);
            }
            this.append((JetObject)object, bl, false);
        } else {
            jetCReader = new JetCReader(this.fjetc.toString(), this.bEditable);
            object = jetCReader.read(new DataInputStream(inputStream));
            this.version = jetCReader.getVersion();
            this.append((JetObject)object, bl, this.version < 65648);
        }
        return object;
    }

    public JetObject LoadFromText(String string) throws ReadFailureException {
        return this.SEDU(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JetObject SEDU(String string, boolean bl) throws ReadFailureException {
        JetObject jetObject;
        FilterInputStream filterInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            this.version = 65540;
            bufferedReader = new BufferedReader(new FileReader(string));
            try {
                string2 = bufferedReader.readLine();
            }
            finally {
                bufferedReader.close();
                bufferedReader = null;
            }
            if (string2 == null) {
                throw new ReadFailureException(new EOFException());
            }
            if (!(string2 = string2.trim()).startsWith("class")) {
                try {
                    this.version = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    boolean bl2 = CrystalConverter.isCrystalRpt(string, stringBuffer);
                    if (bl2) {
                        throw new ReadFailureException(200053, (Object[])new String[]{JResource.getMessage("RPT_CRY", new Object[]{string})}, (Throwable)numberFormatException);
                    }
                    if (stringBuffer.length() > 0) {
                        throw new ReadFailureException(200051, (Object[])new String[]{stringBuffer + ""}, (Throwable)numberFormatException);
                    }
                    throw new ReadFailureException(200052, (Object[])new String[]{JResource.getMessage("RPT_23", new Object[]{string})}, (Throwable)numberFormatException);
                }
            }
            filterInputStream = new DataInputStream(new FileInputStream(string));
            if (!BinaryJetC.isCompatibleJetC(this.version)) {
                InvalidJetCVersionException invalidJetCVersionException = new InvalidJetCVersionException(200040, (Object[])new String[]{String.valueOf(this.version >> 16), String.valueOf(this.version & 0xFFFF)}, null);
                if (JRLog.isError(1)) {
                    JRLog.error(1, string, (Throwable)invalidJetCVersionException);
                }
                throw new ReadFailureException(200034, (Object[])new String[]{string, invalidJetCVersionException.getClass().getName(), invalidJetCVersionException.getMessage()}, (Throwable)invalidJetCVersionException);
            }
            if (this.version > 65540) {
                ((DataInputStream)filterInputStream).readLine();
            }
            JetObject jetObject2 = new JetCParser(filterInputStream).parse(this.version);
            filterInputStream.close();
            filterInputStream = null;
            this.append(jetObject2, bl, false);
            jetObject = jetObject2;
        }
        catch (ParseException parseException) {
            try {
                throw new ReadFailureException(200054, (Object[])new String[]{string, parseException.getMessage()}, (Throwable)parseException);
                catch (IOException iOException) {
                    throw new ReadFailureException(200055, (Object[])new String[]{string, iOException.getMessage()}, (Throwable)iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ReadFailureException(200056, (Object[])new String[]{string + JResource.getMessage("JET_10") + " " + classNotFoundException.getMessage()}, (Throwable)classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    throw new ReadFailureException(200057, (Object[])new String[]{string + JResource.getMessage("JET_11") + " " + instantiationException.getMessage()}, (Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ReadFailureException(200058, (Object[])new String[]{string + JResource.getMessage("JET_12") + " " + illegalAccessException.getMessage()}, (Throwable)illegalAccessException);
                }
                catch (NullPointerException nullPointerException) {
                    throw new ReadFailureException(200085, (Object[])new String[]{string}, (Throwable)nullPointerException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (filterInputStream == null) throw throwable;
                    filterInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new ReadFailureException(200055, (Object[])new String[]{string, iOException.getMessage()}, (Throwable)iOException);
                }
            }
        }
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (filterInputStream == null) return jetObject;
            filterInputStream.close();
            return jetObject;
        }
        catch (IOException iOException) {
            throw new ReadFailureException(200055, (Object[])new String[]{string, iOException.getMessage()}, (Throwable)iOException);
        }
    }

    public JetObject loadReport(InputStream inputStream, boolean bl, Locale locale) throws ReadFailureException {
        String string;
        if (this.isCacheable && manager != null && this.fjetc != null && !(string = this.fjetc.getName().toLowerCase()).endsWith(".lc") && !string.endsWith(".va")) {
            return manager.loadObject(this.fjetc, inputStream, bl, locale);
        }
        return this.loadObject(inputStream, bl);
    }

    public JetObject loadObject(InputStream inputStream, int n) throws ReadFailureException {
        return this.loadObject(inputStream, true, n);
    }

    public JetObject loadObject(InputStream inputStream, boolean bl, int n) throws ReadFailureException {
        this.fjetc = null;
        JetObject jetObject = null;
        JetCReader jetCReader = null;
        switch (n) {
            case 1: 
            case 6: {
                jetCReader = new JetCReader();
                if (this.bEditable) {
                    jetCReader.setEditable();
                }
                jetObject = jetCReader.read(new DataInputStream(inputStream));
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                try {
                    jetObject = XMLToObject.toObject(inputStream, n);
                    break;
                }
                catch (LoadXSDException loadXSDException) {
                    throw new ReadFailureException(200087, (Object[])new String[]{loadXSDException.getMessage()}, (Throwable)loadXSDException);
                }
            }
            case 3: {
                try {
                    jetObject = XSDToObject.toObject(inputStream);
                    break;
                }
                catch (LoadXSDException loadXSDException) {
                    throw new ReadFailureException(200088, (Object[])new String[]{loadXSDException.getMessage()}, (Throwable)loadXSDException);
                }
            }
            case 7: {
                jetObject = this.afterNewTree(inputStream);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal input stream type : " + n);
            }
        }
        jetObject = this.append(jetObject, bl, jetCReader != null && jetCReader.getVersion() < 65648);
        return jetObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JetObject afterNewTree(InputStream inputStream) throws ReadFailureException {
        JetObject jetObject;
        this.version = 65540;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            JetObject jetObject2;
            bufferedReader.mark(1);
            String string = bufferedReader.readLine();
            if (string == null) {
                throw new ReadFailureException(new EOFException());
            }
            if (!(string = string.trim()).startsWith("class")) {
                try {
                    this.version = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (!this.bEditable(string, stringBuffer)) {
                        if (stringBuffer.length() > 0) {
                            throw new ReadFailureException(200095, (Object[])new String[]{stringBuffer + ""}, (Throwable)numberFormatException);
                        }
                        throw new ReadFailureException(200096, (Throwable)numberFormatException);
                    }
                    throw new ReadFailureException(200097, (Throwable)numberFormatException);
                }
            }
            if (!BinaryJetC.isCompatibleJetC(this.version)) {
                InvalidJetCVersionException invalidJetCVersionException = new InvalidJetCVersionException(200040, (Object[])new String[]{String.valueOf(this.version >> 16), String.valueOf(this.version & 0xFFFF)}, null);
                if (JRLog.isError(1)) {
                    JRLog.error(1, "", (Throwable)invalidJetCVersionException);
                }
                throw new ReadFailureException(200034, (Object[])new String[]{"", invalidJetCVersionException.getClass().getName(), invalidJetCVersionException.getMessage()}, (Throwable)invalidJetCVersionException);
            }
            if (this.version <= 65540) {
                bufferedReader.reset();
            }
            bufferedReader.mark(0);
            jetObject = jetObject2 = new JetCParser(bufferedReader).parse(this.version);
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (ParseException parseException) {
                throw new ReadFailureException(200089, (Object[])new String[]{parseException.getMessage()}, (Throwable)parseException);
            }
            catch (IOException iOException) {
                throw new ReadFailureException(200090, (Object[])new String[]{iOException.getMessage()}, (Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ReadFailureException(200091, (Object[])new String[]{classNotFoundException.getMessage()}, (Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new ReadFailureException(200092, (Object[])new String[]{instantiationException.getMessage()}, (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ReadFailureException(200093, (Object[])new String[]{illegalAccessException.getMessage()}, (Throwable)illegalAccessException);
            }
            catch (NullPointerException nullPointerException) {
                throw new ReadFailureException(200094, (Throwable)nullPointerException);
            }
        }
        bufferedReader.close();
        return jetObject;
    }

    private JetObject append(JetObject jetObject, boolean bl, boolean bl2) {
        if (jetObject != null && jetObject instanceof JetRootable) {
            ((JetRootable)((Object)jetObject)).refer();
            if (bl2) {
                jetObject.createNamingSystemB();
            } else {
                jetObject.createNamingSystem(true);
            }
            if (bl) {
                if (this.fjetc != null && jetObject instanceof JetUUniverse) {
                    ((JetUUniverse)jetObject).setFullFileName(this.fjetc);
                }
                JetObject.afterNewTree(jetObject);
            }
        }
        return jetObject;
    }

    private boolean bEditable(String string, StringBuffer stringBuffer) {
        boolean bl = false;
        try {
            byte[] byArray = string.getBytes("8859_1");
            byte[] byArray2 = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31, 0};
            bl = true;
            for (int i = 0; bl && i < byArray2.length; ++i) {
                if (byArray2[i] == byArray[i]) continue;
                bl = false;
            }
        }
        catch (IOException iOException) {
            stringBuffer.append(iOException.getMessage());
        }
        if (!bl && stringBuffer.length() == 0) {
            stringBuffer.append(JResource.getMessage("CONVERTCRY_14"));
        }
        return bl;
    }

    public static void saveToText(JetObject jetObject, String string, OutputStream outputStream) throws WriteFailureException {
        b2t.save(jetObject, outputStream, string);
    }

    public static void save(JetObject jetObject, OutputStream outputStream, String string, byte[] byArray) throws WriteFailureException {
        new JetCWriter().write(jetObject, outputStream, string, byArray);
    }

    public static void save(JetObject jetObject, OutputStream outputStream, String string) throws WriteFailureException {
        new JetCWriter().write(jetObject, outputStream, string);
    }

    public static String save(JetObject jetObject, String string, String string2) throws WriteFailureException {
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "[THIS EXCEPTION DOES FOR DEBUG ONLY]", (Throwable)new Exception("Error CALLER"));
        }
        return LoaderNoCache.save(null, jetObject, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String save(DiskStore diskStore, JetObject jetObject, String string, String string2) throws WriteFailureException {
        int n;
        String string3;
        Object object;
        File file = new File(string2);
        int n2 = -1;
        if (JRLog.isTrace(6)) {
            n2 = System.identityHashCode(jetObject);
            JRLog.trace(6, "[JetObject Save Proceduce]Procedure start#HASHCODE=" + n2 + ", To " + file);
        }
        File file2 = null;
        boolean bl = false;
        boolean bl2 = "Enable".equalsIgnoreCase(System.getProperty("JetCXChg"));
        if (file.exists()) {
            if (!file.canWrite()) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "[JetObject Save Proceduce]Procedure Failed#HASHCODE=" + n2 + ", To " + file);
                }
                throw new WriteFailureException(200023, (Object[])new String[]{string2}, null);
            }
            if (!file.getParentFile().canWrite()) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "[JetObject Save Proceduce]Procedure Failed#HASHCODE=" + n2 + ", To " + file);
                }
                throw new WriteFailureException(200023, (Object[])new String[]{string2}, null);
            }
            if (bl2) {
                object = file.getParentFile();
                string3 = Env.getTemporaryPath();
                file2 = string3 == null || string3.trim().isEmpty() ? new File((File)object, file.getName() + ".xchg") : new File(string3, file.getName() + ".xchg");
                if (file.renameTo(file2)) {
                    file = new File(string2);
                    bl = true;
                }
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "[JetObject Save Proceduce]Writing.....");
        }
        object = null;
        string3 = null;
        if (string2.toLowerCase().endsWith(".rpt")) {
            object = new ReportTextureWriter(jetObject);
            string3 = file.getName();
            n = string3.indexOf(".");
            if (n != -1) {
                string3 = string3.substring(0, n);
            }
        } else if (string2.toLowerCase().endsWith(".cls.xml")) {
            object = new JetObjXMLWriter(jetObject, 0);
            string3 = "";
        } else if (string2.toLowerCase().endsWith(".cat.xml")) {
            object = new JetObjXMLWriter(jetObject, 1);
            string3 = "";
        } else if (string2.toLowerCase().endsWith(".wsld")) {
            object = new JetObjXMLWriter(jetObject, 2);
            string3 = "";
        } else {
            object = new JetObjBinaryWriter(jetObject);
            string3 = string;
        }
        n = 0;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            object.writeTo(fileOutputStream, string3);
        }
        catch (WriteFailureException writeFailureException) {
            n = 1;
            throw writeFailureException;
        }
        catch (LoadXSDException loadXSDException) {
            n = 1;
            throw new WriteFailureException(200024, (Object[])new String[]{loadXSDException.getMessage()}, (Throwable)loadXSDException);
        }
        catch (Throwable throwable) {
            n = 1;
            throw new WriteFailureException(200048, (Object[])new String[]{string2, throwable.getMessage()}, throwable);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    fileOutputStream = null;
                }
            }
            try {
                LoaderNoCache.canWrite(n != 0, bl, file, file2, diskStore);
            }
            finally {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "[JetObject Save Proceduce]Procedure Finish#HASHCODE=" + n2 + ", To " + file);
                }
                file = null;
                file2 = null;
            }
        }
        return string2;
    }

    private static void canWrite(boolean bl, boolean bl2, File file, File file2, DiskStore diskStore) throws WriteFailureException {
        if (bl2) {
            if (bl) {
                LoaderNoCache.clearMem(file, file2, diskStore);
            } else if (diskStore != null) {
                boolean bl3 = false;
                try {
                    diskStore.fileUpdated(file);
                    bl3 = true;
                }
                catch (OutOfSpaceException outOfSpaceException) {
                    bl3 = false;
                    throw new WriteFailureException(200048, (Object[])new String[]{file.getAbsolutePath(), "OutOfSpaceException"}, (Throwable)outOfSpaceException);
                }
                catch (IOException iOException) {
                    bl3 = false;
                    throw new WriteFailureException(200048, (Object[])new String[]{file.getAbsolutePath(), "IOException"}, (Throwable)iOException);
                }
                finally {
                    if (bl3) {
                        file2.delete();
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, "[JetObject Save Proceduce]Write success, " + file + " has updated!");
                        }
                    } else {
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, "[JetObject Save Proceduce]Write failed, no enough disk space.");
                        }
                        LoaderNoCache.clearMem(file, file2, diskStore);
                    }
                }
            } else {
                file2.delete();
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "[JetObject Save Proceduce]Write success, " + file + " has updated!");
                }
            }
        } else {
            if (file2 != null) {
                file2.delete();
            }
            if (bl) {
                if (file.delete()) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "[JetObject Save Proceduce]Write failed, no file created");
                    }
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "[JetObject Save Proceduce]Write failed, the file on disk is broken.");
                }
            } else if (diskStore != null) {
                boolean bl4 = false;
                try {
                    diskStore.fileUpdated(file);
                    bl4 = true;
                }
                catch (OutOfSpaceException outOfSpaceException) {
                    bl4 = false;
                    throw new WriteFailureException(200048, (Object[])new String[]{file.getAbsolutePath(), "OutOfSpaceException"}, (Throwable)outOfSpaceException);
                }
                catch (IOException iOException) {
                    bl4 = false;
                    throw new WriteFailureException(200048, (Object[])new String[]{file.getAbsolutePath(), "IOException"}, (Throwable)iOException);
                }
                finally {
                    if (bl4) {
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, "[JetObject Save Proceduce]Write success, " + file + " has created!");
                        }
                    } else {
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, "[JetObject Save Proceduce]Write failed, no enough disk space.");
                        }
                        file.delete();
                    }
                }
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, "[JetObject Save Proceduce]Write success, " + file + " has created!");
            }
        }
    }

    private static void clearMem(File file, File file2, DiskStore diskStore) {
        if (file.delete()) {
            boolean bl = file2.renameTo(file);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "[JetObject Save Proceduce]Write failed, restore it........" + (bl ? "Succcess" : "failed"));
            }
            if (!bl) {
                if (diskStore != null) {
                    diskStore.delete(file2);
                }
                file2.delete();
            }
        } else {
            if (diskStore != null) {
                diskStore.delete(file2);
            }
            file2.delete();
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "[JetObject Save Proceduce]Write failed, can not restore:file in use");
            }
        }
    }

    public static void clearMem() {
        if (manager != null) {
            manager.clearMem();
        }
    }

    public String getFilePath() {
        String string = new File(this.jetcfile).getParent();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }
}

