/*
 * Decompiled with CFR 0.152.
 */
package jet.jetc;

import guitools.Encoding;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import jet.jetc.InvalidJetCFileFormatException;
import jet.jetc.JetRptReportIOException;
import jet.jetc.ReadFailureException;
import jet.util.IntSet;

public class VersionParser {
    public static final int FILE_TYPE_CLS = 0;
    public static final int FILE_TYPE_CLX = 1;
    public static final int FILE_TYPE_XML = 2;
    public static final int FILE_TYPE_RPT = 3;
    public static final int FILE_TYPE_WLS = 4;
    public static final String FILE_TYPE_NAME_CLS = ".CLS";
    public static final String FILE_TYPE_NAME_CLX = ".CLX";
    public static final String FILE_TYPE_NAME_XML = ".CLS.XML";
    public static final String FILE_TYPE_NAME_RPT = ".RPT";
    public static final String FILE_TYPE_NAME_WLS = ".WLS";
    public static final int MAJOR = 0;
    public static final int MINOR = 1;
    public static final int DOT3 = 2;
    public static final int BUILDNUMBER = 3;
    public static final int SERVICEPACK = 4;
    public static final String NAME_MAJOR = "major";
    public static final String NAME_MINOR = "minor";
    public static final String NAME_DOT3 = "dot3";
    public static final String NAME_BUILDNUMBER = "BuildNumber";
    public static final String NAME_SERVICEPACK = "ServicePack";
    private static final String SEDU = "<ReportSet";
    private static final String add = "jet.reportset.JetRptReportSet";
    private static final String arraycopy = "jet.reportset.JetRptReportSet";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int[] getVersionInfo(String string) throws JetRptReportIOException {
        String string2 = string.toUpperCase();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(string));
            if (string2.endsWith(FILE_TYPE_NAME_XML)) {
                int[] nArray = this.SEDU(fileInputStream, 2);
                return nArray;
            }
            if (string2.endsWith(FILE_TYPE_NAME_RPT)) {
                int[] nArray = this.SEDU(fileInputStream, 3);
                return nArray;
            }
            if (string2.endsWith(FILE_TYPE_NAME_CLS) || string2.endsWith(FILE_TYPE_NAME_CLX) || string2.endsWith(FILE_TYPE_NAME_WLS)) {
                int[] nArray = this.SEDU(fileInputStream, 0);
                return nArray;
            }
            int[] nArray = null;
            return nArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ReadFailureException(200078, (Object[])new String[]{string}, (Throwable)fileNotFoundException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    fileInputStream = null;
                }
            }
        }
    }

    private final int[] SEDU(InputStream inputStream, int n) throws JetRptReportIOException {
        if (inputStream == null) {
            throw new ReadFailureException(65537);
        }
        switch (n) {
            case 0: 
            case 1: {
                try {
                    return this.close(inputStream);
                }
                catch (IOException iOException) {
                    throw new ReadFailureException(200079, (Throwable)iOException);
                }
            }
            case 3: {
                try {
                    return this.add(inputStream);
                }
                catch (IOException iOException) {
                    throw new ReadFailureException(200080, (Throwable)iOException);
                }
            }
            case 2: {
                try {
                    return this.arraycopy(inputStream);
                }
                catch (IOException iOException) {
                    throw new ReadFailureException(200081, (Throwable)iOException);
                }
            }
        }
        return null;
    }

    private int[] add(InputStream inputStream) throws IOException {
        int[] nArray = null;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = bufferedReader.readLine();
        while (string != null) {
            if (string.indexOf("jet.reportset.JetRptReportSet") != -1) {
                nArray = new int[5];
                break;
            }
            string = bufferedReader.readLine();
        }
        if (nArray != null) {
            int n = 0;
            IntSet intSet = new IntSet();
            intSet.add(0);
            intSet.add(1);
            intSet.add(2);
            intSet.add(3);
            intSet.add(4);
            while (string != null) {
                String string2;
                if (intSet.contains(0) && (string2 = this.equals(string, NAME_MAJOR)) != null) {
                    nArray[0] = Integer.parseInt(string2);
                    intSet.remove(0);
                    ++n;
                }
                if (intSet.contains(1) && (string2 = this.equals(string, NAME_MINOR)) != null) {
                    nArray[1] = Integer.parseInt(string2);
                    intSet.remove(1);
                    ++n;
                }
                if (intSet.contains(2) && (string2 = this.equals(string, NAME_DOT3)) != null) {
                    nArray[2] = Integer.parseInt(string2);
                    intSet.remove(2);
                    ++n;
                }
                if (intSet.contains(3) && (string2 = this.equals(string, NAME_BUILDNUMBER)) != null) {
                    nArray[3] = Integer.parseInt(string2);
                    intSet.remove(3);
                    ++n;
                }
                if (intSet.contains(4) && (string2 = this.equals(string, NAME_SERVICEPACK)) != null) {
                    nArray[4] = Integer.parseInt(string2);
                    intSet.remove(4);
                    ++n;
                }
                if (n < 4) {
                    string = bufferedReader.readLine();
                    continue;
                }
                intSet = null;
                break;
            }
        }
        bufferedReader.close();
        return nArray;
    }

    private int[] arraycopy(InputStream inputStream) throws IOException {
        int[] nArray = null;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = bufferedReader.readLine();
        while (string != null) {
            if (string.indexOf(SEDU) != -1) {
                nArray = new int[5];
                break;
            }
            string = bufferedReader.readLine();
        }
        if (nArray != null) {
            int n = 0;
            IntSet intSet = new IntSet();
            intSet.add(0);
            intSet.add(1);
            intSet.add(2);
            intSet.add(3);
            intSet.add(4);
            while (string != null) {
                String string2;
                if (intSet.contains(0) && (string2 = this.endsWith(string, NAME_MAJOR)) != null) {
                    nArray[0] = Integer.parseInt(string2);
                    intSet.remove(0);
                    ++n;
                }
                if (intSet.contains(1) && (string2 = this.endsWith(string, NAME_MINOR)) != null) {
                    nArray[1] = Integer.parseInt(string2);
                    intSet.remove(1);
                    ++n;
                }
                if (intSet.contains(2) && (string2 = this.endsWith(string, NAME_DOT3)) != null) {
                    nArray[2] = Integer.parseInt(string2);
                    intSet.remove(2);
                    ++n;
                }
                if (intSet.contains(3) && (string2 = this.endsWith(string, NAME_BUILDNUMBER)) != null) {
                    nArray[3] = Integer.parseInt(string2);
                    intSet.remove(3);
                    ++n;
                }
                if (intSet.contains(4) && (string2 = this.endsWith(string, NAME_SERVICEPACK)) != null) {
                    nArray[4] = Integer.parseInt(string2);
                    intSet.remove(4);
                    ++n;
                }
                if (n < 4) {
                    string = bufferedReader.readLine();
                    continue;
                }
                intSet = null;
                break;
            }
        }
        bufferedReader.close();
        return nArray;
    }

    private int[] close(InputStream inputStream) throws InvalidJetCFileFormatException, IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = 256;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        String string = null;
        dataInputStream.readInt();
        n5 = dataInputStream.readInt();
        n2 = dataInputStream.readInt();
        n3 = dataInputStream.readInt();
        n2 -= n3 * 4;
        n4 = dataInputStream.readInt();
        dataInputStream.readInt();
        dataInputStream.readInt();
        dataInputStream.readInt();
        byte[] byArray = new byte[n3 * 4];
        byte[] byArray2 = new byte[n2];
        dataInputStream.readFully(byArray);
        dataInputStream.readFully(byArray2);
        int n6 = 0;
        int n7 = 0;
        byte[] byArray3 = new byte[256];
        int[] nArray = new int[]{-1, -1, -1, -1, -1};
        String string2 = null;
        int n8 = 0;
        for (int i = 0; i < n3; ++i) {
            int n9 = byArray[n7++];
            n9 <<= 8;
            n9 |= byArray[n7++] & 0xFF;
            n9 <<= 8;
            n9 |= byArray[n7++] & 0xFF;
            n9 <<= 8;
            if (byArray3.length < (n9 |= byArray[n7++] & 0xFF)) {
                byArray3 = new byte[n9];
            }
            System.arraycopy(byArray2, n6, byArray3, 0, n9);
            if (n5 < 65536) {
                string2 = new String(byArray3, 0, n9);
            } else if (i > 0) {
                string2 = new String(byArray3, 0, n9, string);
            } else if (n5 >= 65540) {
                string2 = string = "Unicode";
            } else {
                string2 = string = new String(byArray3, 0, n9);
                string = Encoding.getEncoding();
            }
            if (string2.equals("jet.reportset.JetRptReportSet")) {
                bl = true;
                ++n8;
            }
            if (string2.equals(NAME_MAJOR)) {
                nArray[0] = i;
                ++n8;
            } else if (string2.equals(NAME_MINOR)) {
                nArray[1] = i;
                ++n8;
            } else if (string2.equals(NAME_DOT3)) {
                nArray[2] = i;
                ++n8;
            } else if (string2.equals(NAME_BUILDNUMBER)) {
                nArray[3] = i;
                ++n8;
            } else if (string2.equals(NAME_SERVICEPACK)) {
                nArray[4] = i;
                ++n8;
            }
            if (n8 >= 6) break;
            n6 += n9;
        }
        if (!bl) {
            return null;
        }
        return this.contains(dataInputStream, nArray, n4);
    }

    private int[] contains(DataInputStream dataInputStream, int[] nArray, int n) throws IOException, InvalidJetCFileFormatException {
        int[] nArray2 = new int[5];
        int n2 = 0;
        byte[] byArray = new byte[n];
        int n3 = 1;
        int n4 = 0;
        dataInputStream.readFully(byArray);
        if (byArray[0] != 0) {
            throw new InvalidJetCFileFormatException(200082);
        }
        try {
            do {
                int n5 = byArray[n3++];
                n5 <<= 8;
                n5 |= byArray[n3++] & 0xFF;
                n5 <<= 8;
                n5 |= byArray[n3++] & 0xFF;
                n5 <<= 8;
                n5 |= byArray[n3++] & 0xFF;
                int n6 = byArray[n3++];
                n6 <<= 8;
                n6 |= byArray[n3++] & 0xFF;
                n6 <<= 8;
                n6 |= byArray[n3++] & 0xFF;
                n6 <<= 8;
                n6 |= byArray[n3++] & 0xFF;
                switch (byArray[n3++]) {
                    case 1: {
                        n6 = byArray[n3++];
                        n6 <<= 8;
                        n6 |= byArray[n3++] & 0xFF;
                        n6 <<= 8;
                        n6 |= byArray[n3++] & 0xFF;
                        n6 <<= 8;
                        n5 = (n6 |= byArray[n3++] & 0xFF) / 9;
                        for (n6 = 0; n6 < n5; ++n6) {
                            int n7 = byArray[n3++];
                            n7 <<= 8;
                            n7 |= byArray[n3++] & 0xFF;
                            n7 <<= 8;
                            n7 |= byArray[n3++] & 0xFF;
                            n7 <<= 8;
                            n4 = n7 |= byArray[n3++] & 0xFF;
                            n7 = byArray[n3 + 1];
                            n7 <<= 8;
                            n7 |= byArray[n3 + 2] & 0xFF;
                            n7 <<= 8;
                            n7 |= byArray[n3 + 3] & 0xFF;
                            n7 <<= 8;
                            n7 |= byArray[n3 + 4] & 0xFF;
                            if (n4 == nArray[0]) {
                                nArray2[0] = n7;
                            } else if (n4 == nArray[1]) {
                                nArray2[1] = n7;
                            } else if (n4 == nArray[2]) {
                                nArray2[2] = n7;
                            } else if (n4 == nArray[3]) {
                                nArray2[3] = n7;
                            } else if (n4 == nArray[4]) {
                                nArray2[4] = n7;
                            }
                            n3 += 5;
                        }
                        dataInputStream.close();
                        return nArray2;
                    }
                }
            } while (n2 > 0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InvalidJetCFileFormatException(200083, (Throwable)arrayIndexOutOfBoundsException);
        }
        return null;
    }

    private String endsWith(String string, String string2) {
        int n = string.indexOf(string2);
        if (n != -1) {
            return string.substring(n + string2.length() + 1, string.indexOf("<", n + string2.length()));
        }
        return null;
    }

    private String equals(String string, String string2) {
        int n = string.indexOf(string2);
        if (n != -1) {
            int n2 = string.indexOf("=", n + string2.length());
            return string.substring(n2 + 1, string.indexOf(";", n2)).trim();
        }
        return null;
    }
}

