/*
 * Decompiled with CFR 0.152.
 */
package jet.lc.impl;

import guitools.toolkit.Unit;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.controls.JetUnitNumber;
import jet.lc.LCPrintPage;
import jet.util.HashVector;

public class JetLCPrintPage
extends JetObject
implements LCPrintPage {
    public static final String DEFAULT_PAGE_TYPE = "A4";
    private JetString CHOICE_EDITOR;
    private JetNumber I;
    private JetUnitNumber SEDU;
    private JetUnitNumber add;
    private JetUnitNumber[] asList = new JetUnitNumber[4];
    private static HashVector convertInchToUnit = null;
    private static HashMap deepDup = null;

    public JetLCPrintPage() {
        this.CHOICE_EDITOR = new JetString(this, "PageType", DEFAULT_PAGE_TYPE);
        this.CHOICE_EDITOR.setPropertyChoice(new Vector<String>(Arrays.asList(Unit.getPaperNames())));
        this.CHOICE_EDITOR.setEditorType(JetNumber.CHOICE_EDITOR);
        this.CHOICE_EDITOR.enableAllChangeBys(false);
        this.I = new JetNumber(this, "Orientation", 0);
        this.I.setEditorType(JetNumber.CHOICE_EDITOR);
        Vector<String> vector = new Vector<String>(2);
        vector.add(String.valueOf(1));
        vector.add(String.valueOf(0));
        this.I.setPropertyChoice(vector);
        this.I.enableAllChangeBys(false);
        Dimension dimension = Unit.getUnitPaperSize(Unit.getPaperType(DEFAULT_PAGE_TYPE), 0);
        this.SEDU = new JetUnitNumber(this, "Width", dimension.width);
        this.SEDU.enableAllChangeBys(false);
        this.add = new JetUnitNumber(this, "Height", dimension.height);
        this.add.enableAllChangeBys(false);
        this.asList[0] = new JetUnitNumber(this, "margin-top", Unit.convertInchToUnit(0.5));
        this.asList[1] = new JetUnitNumber(this, "margin-right", Unit.convertInchToUnit(0.5));
        this.asList[2] = new JetUnitNumber(this, "margin-bottom", Unit.convertInchToUnit(0.5));
        this.asList[3] = new JetUnitNumber(this, "margin-left", Unit.convertInchToUnit(0.5));
        this.asList[0].enableAllChangeBys(false);
        this.asList[1].enableAllChangeBys(false);
        this.asList[2].enableAllChangeBys(false);
        this.asList[3].enableAllChangeBys(false);
    }

    @Override
    public JetLCPrintPage deepDup() {
        return (JetLCPrintPage)super.deepDup();
    }

    @Override
    public JetLCPrintPage deepDupWithName() {
        return (JetLCPrintPage)super.deepDupWithName();
    }

    @Override
    public int getPageType() {
        return Unit.getPaperType(this.CHOICE_EDITOR.get());
    }

    @Override
    public String getPageTypeStr() {
        return this.CHOICE_EDITOR.get();
    }

    @Override
    public void setPageTypeStr(String string) {
        this.CHOICE_EDITOR.set(string);
    }

    public void setPageType(int n) {
        this.CHOICE_EDITOR.set(Unit.getPaperName(n));
    }

    @Override
    public int getPageOrient() {
        return this.I.intValue();
    }

    @Override
    public void setPageOrient(int n) {
        this.I.set(n);
    }

    @Override
    public int getWidthInUnit() {
        return this.SEDU.getUnit();
    }

    @Override
    public void setWidthInUnit(int n) {
        this.SEDU.setUnitValue(n);
    }

    @Override
    public int getHeightInUnit() {
        return this.add.getUnit();
    }

    @Override
    public void setHeightInUnit(int n) {
        this.add.setUnitValue(n);
    }

    @Override
    public int[] getMarginsInUnit() {
        return new int[]{this.asList[0].getUnit(), this.asList[1].getUnit(), this.asList[2].getUnit(), this.asList[3].getUnit()};
    }

    @Override
    public void setMarginsInUnit(int[] nArray) {
        int n = nArray.length;
        if (n == 0) {
            throw new IllegalAccessError();
        }
        for (int i = 0; i < 4; ++i) {
            this.asList[i].setUnitValue(nArray[i % n]);
        }
    }

    @Override
    public int getPageWidthInUnit() {
        return this.SEDU.getUnit() - this.asList[1].getUnit() - this.asList[3].getUnit();
    }

    @Override
    public int getPageHeightInUnit() {
        return this.add.getUnit() - this.asList[0].getUnit() - this.asList[2].getUnit();
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (convertInchToUnit != null) {
            return convertInchToUnit;
        }
        convertInchToUnit = new HashVector();
        String string = "Margin";
        Vector<String> vector = new Vector<String>(4);
        vector.add("margin-top");
        vector.add("margin-right");
        vector.add("margin-bottom");
        vector.add("margin-left");
        convertInchToUnit.put(string, vector);
        string = "General";
        vector = new Vector(4);
        vector.add("PageType");
        vector.add("Width");
        vector.add("Height");
        vector.add("Orientation");
        convertInchToUnit.putAt(string, vector, 0);
        return convertInchToUnit;
    }

    @Override
    public String getInstancePrefix() {
        return "LCPrintPage";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getIndecialMap() {
        if (deepDup == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (deepDup == null) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    HashMap hashMap2 = super.getIndecialMap();
                    hashMap.putAll(hashMap2);
                    int n = hashMap2.size();
                    hashMap.put("Orientation", n++);
                    hashMap.put("PageType", n++);
                    hashMap.put("Width", n++);
                    hashMap.put("Height", n++);
                    hashMap.put("margin-top", n++);
                    hashMap.put("margin-right", n++);
                    hashMap.put("margin-bottom", n++);
                    hashMap.put("margin-left", n++);
                    deepDup = hashMap;
                }
            }
        }
        return deepDup;
    }
}

