/*
 * Decompiled with CFR 0.152.
 */
package jet.lc.io;

import com.jinfonet.resstore.DiskStore;
import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jet.BuildEnv;
import jet.Env;
import jet.controls.JetObject;
import jet.jetc.JetCReader;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.lc.LCObject;
import jet.lc.impl.JetLCObject;
import jet.lc.io.LCObjectWriter;
import jet.lc.io.LCVersionNumber;
import jet.lc.io.ULCObjectTask;
import jet.universe.JetUUniverse;
import jet.upgrade.JUpgradeException;
import jet.upgrade.JUpgradeFailtureException;
import jet.upgrade.JUpgradeNotSupportedException;
import jet.upgrade.UpgradeContext;
import jet.upgrade.UpgradeDataContext;
import jet.upgrade.UpgradeResContext;
import jet.upgrade.UpgradeResult;
import jet.upgrade.UpgradeVersion;
import jet.upgrade.impl.DefaultUpgradeTask;
import jet.util.image.ImageProvider;
import jet.util.image.ImageProviderFactory;
import timer.Clocker;

public class LCObjectIO {
    private LCObjectIO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LCObject loadLCObject(File file, JetUUniverse jetUUniverse, ResourceStore resourceStore) throws ReadFailureException, JUpgradeException {
        Object object;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "[LC Load Proceduce]Procedure start#File:" + file);
            JRLog.trace(6, "[LC Load Proceduce]File reading...");
        }
        JetObject jetObject = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            object = new JetCReader();
            ((JetCReader)object).setEditable();
            jetObject = ((JetCReader)object).read(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ReadFailureException(200032, (Object[])new String[]{file.getAbsolutePath(), "FileNotFoundException", fileNotFoundException.getMessage()}, (Throwable)fileNotFoundException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    fileInputStream = null;
                }
            }
        }
        if (!(jetObject instanceof JetLCObject)) {
            object = file.getAbsolutePath();
            throw new ReadFailureException(200034, (Object[])new String[]{file.getAbsolutePath(), "NotLCFileException", (String)object + " doesn't JReport LC File"}, (Throwable)new ClassCastException());
        }
        object = (JetLCObject)jetObject;
        ((JetLCObject)object).refer();
        ((JetObject)object).createNamingSystem(true);
        JetLCObject.afterNewTree((JetObject)object);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "[LC Load Proceduce]Upgrading....");
        }
        object = null;
        try {
            Object object2 = object = LCObjectIO.MAXSUPPORT((JetLCObject)jetObject, jetUUniverse, resourceStore);
            return object2;
        }
        finally {
            if (object != jetObject) {
                ((JetLCObject)jetObject).free();
                if (object != null) {
                    ((JetLCObject)object).refer();
                }
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "[LC Load Proceduce]Procedure Finish#File= " + file + ",LC HASHCODE=" + System.identityHashCode(object));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final JetLCObject MAXSUPPORT(JetLCObject jetLCObject, JetUUniverse jetUUniverse, ResourceStore resourceStore) throws JUpgradeNotSupportedException, JUpgradeFailtureException {
        Object object;
        JetLCObject jetLCObject2 = jetLCObject;
        int n = jetLCObject2.getLCStructureVersion();
        int n2 = jetLCObject2.getLCComponentVersion();
        if (n > 1) {
            String string = LCVersionNumber.stringOfLCVersion(n, n2);
            String string2 = LCVersionNumber.stringOfLCVersion(1, BuildEnv.getBuildNumber());
            throw new JUpgradeNotSupportedException(219001, (Object[])new String[]{string, string2}, null);
        }
        UpgradeVersion upgradeVersion = UpgradeVersion.createUVersion(Integer.MAX_VALUE, 0, n2, 0);
        int n3 = upgradeVersion.compareTo(UpgradeVersion.MAXSUPPORT);
        if (n3 > 0) {
            String string = LCVersionNumber.stringOfLCVersion(n, n2);
            String string3 = LCVersionNumber.stringOfLCVersion(1, BuildEnv.getBuildNumber());
            throw new JUpgradeNotSupportedException(219001, (Object[])new String[]{string, string3}, null);
        }
        if (n3 == 0) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "LC built in same Version, need not upgrade");
            }
            return jetLCObject;
        }
        Clocker clocker = null;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "LC upgrade start, For LC=" + jetLCObject + ", " + upgradeVersion);
            clocker = new Clocker();
        } else if (JRLog.isTrace(4)) {
            JRLog.trace(4, "LC upgrade start, For LC=" + jetLCObject + ", " + upgradeVersion);
        }
        UpgradeDataContext upgradeDataContext = new UpgradeDataContext(jetUUniverse);
        upgradeDataContext.setCurrentIReport(jetLCObject2);
        UpgradeResContext upgradeResContext = new UpgradeResContext();
        ImageProvider imageProvider = null;
        if (jetUUniverse == null) {
            imageProvider = ImageProviderFactory.createDefaultImageProvider(null, resourceStore == null ? null : resourceStore.getMemoryStore());
        } else {
            object = new File(jetUUniverse.getFullFileName());
            imageProvider = ImageProviderFactory.createDefaultImageProvider((File)object, resourceStore == null ? null : resourceStore.getMemoryStore());
        }
        upgradeResContext.setCurrentImageProvider(imageProvider);
        object = new ULCObjectTask(jetLCObject2, upgradeVersion, new UpgradeContext(8, upgradeDataContext, upgradeResContext));
        try {
            jetLCObject2.refer();
            UpgradeResult upgradeResult = ((DefaultUpgradeTask)object).call();
            JetLCObject jetLCObject3 = (JetLCObject)upgradeResult.newObject;
            return jetLCObject3;
        }
        finally {
            jetLCObject2.free();
            object = null;
            imageProvider = null;
            upgradeResContext = null;
            upgradeDataContext = null;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "LC upgrade end; For LC=" + jetLCObject + ",Elapsed:" + clocker.elapsed());
            } else if (JRLog.isTrace(4)) {
                JRLog.trace(4, "LC upgrade end; For LC=" + jetLCObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveLCObject(LCObject lCObject, JetUUniverse jetUUniverse, File file, ResourceStore resourceStore) throws WriteFailureException {
        LCObject lCObject2 = lCObject;
        synchronized (lCObject2) {
            boolean bl;
            boolean bl2;
            File file2;
            block31: {
                Object object;
                File file3;
                LCObjectWriter lCObjectWriter = new LCObjectWriter(lCObject);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "[LC Save Proceduce]Procedure start#LC HASHCODE=" + System.identityHashCode(lCObject) + ", To " + file);
                    JRLog.trace(6, "[LC Save Proceduce]Before saving logic applying...");
                }
                lCObjectWriter.beforeWriting(jetUUniverse, null);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "[LC Save Proceduce]File preparing.....");
                }
                if (!(file3 = file.getParentFile()).exists()) {
                    file3.mkdirs();
                }
                String string = file.getAbsolutePath();
                file2 = null;
                bl2 = false;
                if (file.exists() && (bl = "Enable".equalsIgnoreCase(System.getProperty("JetCXChg"))) && file.renameTo(file2 = (object = Env.getTemporaryPath()) == null || ((String)object).trim().isEmpty() ? new File(file3, file.getName() + ".xchg") : new File((String)object, file.getName() + ".xchg"))) {
                    file = new File(string);
                    bl2 = true;
                }
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "[LC Save Proceduce]File writing.....");
                }
                bl = false;
                object = null;
                try {
                    object = new FileOutputStream(file);
                    lCObjectWriter.writeTo((OutputStream)object, lCObject.getInstNameDirectly());
                    if (object == null) break block31;
                }
                catch (WriteFailureException writeFailureException) {
                    try {
                        bl = true;
                        throw writeFailureException;
                        catch (Throwable throwable) {
                            bl = true;
                            throw new WriteFailureException(200048, (Object[])new String[]{string}, throwable);
                        }
                    }
                    catch (Throwable throwable) {
                        if (object != null) {
                            try {
                                try {
                                    ((FileOutputStream)object).close();
                                }
                                finally {
                                    object = null;
                                }
                            }
                            catch (Throwable throwable2) {
                                object = null;
                                throw throwable2;
                            }
                        }
                        try {
                            LCObjectIO.SEDU(bl, bl2, file, file2, resourceStore == null ? null : resourceStore.getDiskStore());
                            throw throwable;
                        }
                        finally {
                            if (JRLog.isTrace(6)) {
                                JRLog.trace(6, "[LC Save Proceduce]Procedure Finish#LC HASHCODE=" + System.identityHashCode(lCObject) + ", To " + file);
                            }
                            file = null;
                            file2 = null;
                        }
                    }
                }
                try {
                    try {
                        ((FileOutputStream)object).close();
                    }
                    finally {
                        object = null;
                    }
                }
                catch (Throwable throwable) {
                    object = null;
                    throw throwable;
                }
            }
            try {
                LCObjectIO.SEDU(bl, bl2, file, file2, resourceStore == null ? null : resourceStore.getDiskStore());
            }
            finally {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "[LC Save Proceduce]Procedure Finish#LC HASHCODE=" + System.identityHashCode(lCObject) + ", To " + file);
                }
                file = null;
                file2 = null;
            }
            return;
        }
    }

    private static void SEDU(boolean bl, boolean bl2, File file, File file2, DiskStore diskStore) throws WriteFailureException {
        if (bl2) {
            if (bl) {
                LCObjectIO.afterNewTree(file, file2, diskStore);
            } else if (diskStore != null) {
                boolean bl3 = false;
                try {
                    diskStore.fileUpdated(file);
                    bl3 = true;
                }
                catch (OutOfSpaceException outOfSpaceException) {
                    bl3 = false;
                    throw new WriteFailureException(200048, (Object[])new String[]{file.getAbsolutePath(), "OutOfSpaceException"}, (Throwable)outOfSpaceException);
                }
                catch (IOException iOException) {
                    bl3 = false;
                    throw new WriteFailureException(200048, (Object[])new String[]{file.getAbsolutePath(), "IOException"}, (Throwable)iOException);
                }
                finally {
                    if (bl3) {
                        file2.delete();
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, "[LC Save Proceduce]Write success, " + file + " has updated!");
                        }
                    } else {
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, "[LC Save Proceduce]Write failed, no enough disk space.");
                        }
                        LCObjectIO.afterNewTree(file, file2, diskStore);
                    }
                }
            } else {
                file2.delete();
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "[LC Save Proceduce]Write success, " + file + " has updated!");
                }
            }
        } else {
            if (file2 != null) {
                file2.delete();
            }
            if (bl) {
                if (file.delete()) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "[LC Save Proceduce]Write failed, no file created");
                    }
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "[LC Save Proceduce]Write failed, the file on disk is broken.");
                }
            } else if (diskStore != null) {
                boolean bl4 = false;
                try {
                    diskStore.fileUpdated(file);
                    bl4 = true;
                }
                catch (OutOfSpaceException outOfSpaceException) {
                    bl4 = false;
                    throw new WriteFailureException(200048, (Object[])new String[]{file.getAbsolutePath(), "OutOfSpaceException"}, (Throwable)outOfSpaceException);
                }
                catch (IOException iOException) {
                    bl4 = false;
                    throw new WriteFailureException(200048, (Object[])new String[]{file.getAbsolutePath(), "IOException"}, (Throwable)iOException);
                }
                finally {
                    if (bl4) {
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, "[LC Save Proceduce]Write success, " + file + " has created!");
                        }
                    } else {
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, "[LC Save Proceduce]Write failed, no enough disk space.");
                        }
                        file.delete();
                    }
                }
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, "[LC Save Proceduce]Write success, " + file + " has created!");
            }
        }
    }

    private static void afterNewTree(File file, File file2, DiskStore diskStore) {
        if (file.delete()) {
            boolean bl = file2.renameTo(file);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "[LC Save Proceduce]Write failed, restore it........" + (bl ? "Succcess" : "failed"));
            }
            if (!bl) {
                if (diskStore != null) {
                    diskStore.delete(file2);
                }
                file2.delete();
            }
        } else {
            if (diskStore != null) {
                diskStore.delete(file2);
            }
            file2.delete();
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "[LC Save Proceduce]Write failed, can not restore:file in use");
            }
        }
    }
}

