/*
 * Decompiled with CFR 0.152.
 */
package jet.lc.io;

import com.jinfonet.resstore.ResourceStore;
import java.io.IOException;
import java.util.Vector;
import jet.controls.JetObject;
import jet.jetc.JetObjBinaryWriter;
import jet.lc.LCDataSource;
import jet.lc.LCObject;
import jet.lc.io.LCVersionNumber;
import jet.lc.logic.LCLogicFactory;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.universe.JetUUniverse;

public class LCObjectWriter
extends JetObjBinaryWriter {
    LCObjectWriter(LCObject lCObject) {
        super(lCObject);
    }

    @Override
    public void beforeWriting(Object ... objectArray) {
        super.beforeWriting(objectArray);
        if (objectArray == null || objectArray.length < 1 || !(objectArray[0] instanceof JetUUniverse)) {
            throw new IllegalArgumentException("Argument lost: didn't set Universe");
        }
        JetUUniverse jetUUniverse = (JetUUniverse)objectArray[0];
        ResourceStore resourceStore = objectArray.length <= 1 ? null : (ResourceStore)objectArray[1];
        LCLogicFactory.getLCObjectLogic().refreshParamCtrlsInConfiguration(jetUUniverse, (LCObject)this.toSavedObj);
        BasicComponentLogic basicComponentLogic = LCLogicFactory.getBasicComponentLogic();
        LCDataSource lCDataSource = ((LCObject)this.toSavedObj).getContent().getDataSource();
        int n = lCDataSource.getDataSetsCount();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject = (JetObject)((Object)lCDataSource.getDataSetAt(n2));
            Vector vector = jetObject.getRefObjects();
            if (vector == null || vector.size() == 0) {
                basicComponentLogic.remove(jetObject);
                --n;
                continue;
            }
            ++n2;
        }
        LCLogicFactory.getModeRendererLogic().regroupModeContainer(((LCObject)this.toSavedObj).getModeContainer());
        try {
            ((LCObject)this.toSavedObj).getConditionalFormattingManager().compileCfFormula(jetUUniverse, resourceStore);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LCLogicFactory.getLCObjectLogic().getRefreshObjectList((LCObject)this.toSavedObj);
        LCVersionNumber.resetVersionNumber((LCObject)this.toSavedObj);
    }
}

