/*
 * Decompiled with CFR 0.152.
 */
package jet.lc.io;

import com.jinfonet.util.JRLog;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetReference;
import jet.controls.JetReferences;
import jet.ireport.IReport;
import jet.lc.impl.JetLCAidObjects;
import jet.lc.impl.JetLCDataSource;
import jet.lc.impl.JetLCObject;
import jet.lc.io.LCVersionNumber;
import jet.lc.logic.LCLogicFactory;
import jet.report.conditionalFormatting.ConditionalFormattingManager;
import jet.report.conditionalFormatting.JetRptConditionalFormatList;
import jet.report.conditionalFormatting.JetRptConditionalFormatSet;
import jet.report.conditionallink.JetRptConditionalLinkItem;
import jet.report.conditionallink.JetRptConditionalLinkSet;
import jet.report.mode.JetRptMode;
import jet.report.mode.JetRptModeContainer;
import jet.report.mode.actions.JetRptAction;
import jet.report.mode.actions.JetRptActionContainer;
import jet.report.mode.actions.JetRptAtomicAction;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.JetRptDataSet;
import jet.upgrade.JUpgradeFailtureException;
import jet.upgrade.UpgradeContext;
import jet.upgrade.UpgradeVersion;
import jet.upgrade.impl.DefaultUpgradeTask;
import jet.upgrade.kit.UpgradeToolkit;

public class ULCObjectTask
extends DefaultUpgradeTask {
    int lcVer = 0;

    protected ULCObjectTask(JetLCObject jetLCObject, UpgradeVersion upgradeVersion, UpgradeContext upgradeContext) {
        super(jetLCObject, upgradeVersion, upgradeContext);
    }

    @Override
    protected void beforeUpgradeStart() throws JUpgradeFailtureException {
        super.beforeUpgradeStart();
        this.lcVer = ((JetLCObject)this.oldrptObject).getLCStructureVersion();
    }

    @Override
    protected JetObject createNewBasicStructure(List list, List list2) throws JUpgradeFailtureException {
        JetLCObject jetLCObject = (JetLCObject)super.createNewBasicStructure(list, list2);
        LCVersionNumber.resetVersionNumber(jetLCObject);
        return jetLCObject;
    }

    protected void beforeUpgradeEnd(JetObject jetObject, JetLCObject jetLCObject) {
        Object object;
        Object object2;
        jetObject.createNamingSystem(true);
        JetLCObject.afterNewTree(jetObject);
        if (this.lcVer < 1) {
            object2 = LCLogicFactory.getBasicComponentLogic();
            object = jetLCObject.getContent().getDataSource();
            int n = object.getDataSetsCount();
            int n2 = 0;
            while (n2 < n) {
                JetObject jetObject2 = (JetObject)((Object)object.getDataSetAt(n2));
                Vector vector = jetObject2.getRefObjects();
                if (vector == null || vector.size() == 0) {
                    object2.remove(jetObject2);
                    --n;
                    continue;
                }
                ++n2;
            }
            LCLogicFactory.getLCObjectLogic().getRefreshObjectList(jetLCObject);
        }
        object2 = ((JetLCObject)jetObject).getAidObjects();
        object = ((JetLCAidObjects)object2).getConditionalFormattingManager((JetLCObject)jetObject);
        try {
            ((ConditionalFormattingManager)object).compileCfFormula(this.getDataContext().getCurrentUniverse(), this.getResourceContext().getResourceStore());
        }
        catch (IOException iOException) {
            ((ConditionalFormattingManager)object).forceRecompile(true);
        }
    }

    protected void afterCopyProperties(JetLCObject jetLCObject, List list) throws JUpgradeFailtureException {
        if (this.srcVersion.compareTo(UpgradeVersion.V13D5) < 0) {
            UpgradeToolkit.adjustOnParameterValueChangeBeforeV13D5(jetLCObject, this.getDataContext().getCurrentUniverse(), (IReport)((Object)this.oldrptObject));
        }
    }

    protected void afterFillStructure(JetLCObject jetLCObject, Map map, List list, List list2) throws JUpgradeFailtureException {
        jetLCObject.createNamingSystem(true);
        JetLCObject.afterNewTree(jetLCObject);
    }

    @Override
    protected List handleAdditionalObjs(JetObject jetObject, List list) {
        JetLCObject jetLCObject = (JetLCObject)jetObject;
        JetRptModeContainer jetRptModeContainer = jetLCObject.getModeContainer();
        JetRptActionContainer jetRptActionContainer = jetLCObject.getActionContainer();
        JetRptConditionalFormatSet jetRptConditionalFormatSet = jetLCObject.getConditionalFormatSet();
        JetRptConditionalLinkSet jetRptConditionalLinkSet = jetLCObject.getConditionalLinkSet();
        JetLCDataSource jetLCDataSource = jetLCObject.getContent().getDataSource();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject2 = (JetObject)list.get(n2);
            if (jetObject2 instanceof JetRptMode) {
                jetRptModeContainer.add((JetRptMode)jetObject2);
                list.remove(n2);
                --n;
                continue;
            }
            if (jetObject2 instanceof JetRptAction) {
                jetRptActionContainer.add((JetRptAction)jetObject2);
                list.remove(n2);
                --n;
                continue;
            }
            if (jetObject2 instanceof JetRptAtomicAction) {
                jetRptActionContainer.add((JetRptAtomicAction)jetObject2);
                list.remove(n2);
                --n;
                continue;
            }
            if (jetObject2 instanceof JetRptConditionalFormatList) {
                jetRptConditionalFormatSet.add((JetRptConditionalFormatList)jetObject2);
                list.remove(n2);
                --n;
                continue;
            }
            if (jetObject2 instanceof JetRptConditionalLinkItem) {
                jetRptConditionalLinkSet.add((JetRptConditionalLinkItem)jetObject2);
                list.remove(n2);
                --n;
                continue;
            }
            if (jetObject2 instanceof JetRptDataSet) {
                jetLCDataSource.add((JetRptDataSet)jetObject2);
                list.remove(n2);
                --n;
                continue;
            }
            ++n2;
        }
        ObjectLogicFactory.getModeRendererLogic().regroupModeContainer(jetRptModeContainer);
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "[Upgrade Proc] " + list.size() + " additional objects left.");
        }
        return list;
    }

    @Override
    protected List handleOuterReferences(List list, Map map) {
        int n = list.size();
        int n2 = (list = UpgradeToolkit.handleOuterReferences(list, map)).size();
        if (n2 > 0) {
            if (JRLog.isTrace(7)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (JetObject[] jetObjectArray : list) {
                    if (jetObjectArray instanceof JetReference) {
                        stringBuilder.append(jetObjectArray.getName() + "(JetReference of " + jetObjectArray.getParent().getClass() + "):" + jetObjectArray.toUnitString());
                    } else {
                        stringBuilder.append(jetObjectArray.getName() + "(JetReferences of " + jetObjectArray.getParent().getClass() + "):" + jetObjectArray.toUnitString());
                    }
                    stringBuilder.append(",");
                }
                JRLog.trace(7, "[Upgrade Proc] " + (n - n2) + " properties(out-referTo) handed, " + n2 + " properties(out-referTo) left: " + stringBuilder.substring(0, stringBuilder.length() - 1));
            }
            for (Object object : list) {
                JetObject[] jetObjectArray;
                if (object instanceof JetReference) {
                    ((JetProperty)object).set(null);
                    continue;
                }
                for (JetObject jetObject : jetObjectArray = ((JetReferences)object).get()) {
                    ((JetReferences)object).removeReference(jetObject);
                }
            }
        } else if (JRLog.isTrace(7)) {
            JRLog.trace(7, "[Upgrade Proc] " + (n - n2) + " properties(out-referTo) handed, 0 properties(out-referTo) left.");
        }
        return list;
    }
}

