/*
 * Decompiled with CFR 0.152.
 */
package jet.net2.www.http;

import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Cookie {
    private URL SEDU;
    String name;
    String value;
    String domain;
    int[] ports;
    String path;
    long expiration = -1L;
    int version = -1;
    Hashtable avpairs = new Hashtable();
    String cookie;

    public Cookie(String string, String string2, String string3) {
        this.cookie = string;
        this.domain = string2;
        this.path = string3;
        this.addElement();
        String string4 = this.getAttr("Domain");
        if (string4 != null) {
            this.domain = string4;
        }
        this.path = (string4 = this.getAttr("Path")) == null ? "/" : string4;
        string4 = this.getAttr("Port");
        if (string4 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
            int n = stringTokenizer.countTokens();
            this.ports = new int[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                try {
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    this.ports[n2++] = n3;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (n2 >= n) continue;
                int[] nArray = new int[n2];
                System.arraycopy(this.ports, 0, nArray, 0, n2);
                this.ports = nArray;
            }
        }
        if ((string4 = this.getAttr("Max-Age")) != null) {
            try {
                int n = Integer.parseInt(string4) * 1000;
                long l = System.currentTimeMillis();
                this.expiration = n == 0 ? l - 1000L : l + (long)n;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        string4 = this.getAttr("Version");
        try {
            this.version = Integer.parseInt(string4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isExpiration() {
        if (this.expiration == -1L) {
            return false;
        }
        return this.expiration < System.currentTimeMillis();
    }

    private void SEDU(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && string.charAt(n) != '='; ++n) {
        }
        String string2 = string.substring(0, n).trim();
        if (string2.length() == 0) {
            return;
        }
        String string3 = (n < n2 ? string.substring(n + 1, n2) : "").trim();
        int n3 = string3.length();
        if (n3 > 0 && string3.charAt(0) == '\"' && string3.charAt(n3 - 1) == '\"') {
            string3 = string3.substring(1, n3 - 1);
        }
        if (this.name == null) {
            this.name = string2;
            this.value = string3;
        } else {
            this.avpairs.put(string2.toLowerCase(), string3);
        }
    }

    public String getAttr(String string) {
        return (String)this.avpairs.get(string.toLowerCase());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addElement() {
        int n;
        int n2 = this.cookie.length();
        Vector vector = new Vector();
        int n3 = 0;
        block4: for (n = 0; n < n2; ++n) {
            char c = this.cookie.charAt(n);
            switch (c) {
                case '\"': {
                    ++n;
                    while (n < n2 && this.cookie.charAt(n) != '\"') {
                        ++n;
                    }
                    if (n != n2) break;
                    break block4;
                }
                case ';': {
                    this.SEDU(this.cookie.substring(n3, n));
                    n3 = n + 1;
                }
            }
        }
        if (n - n3 > 1) {
            this.SEDU(this.cookie.substring(n3, n));
        }
    }

    public String getCookie() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name).append('=').append(this.value);
        String string2 = this.getAttr("Domain");
        if (string2 != null) {
            stringBuffer.append(";$Domain=").append(string2);
        }
        if ((string = this.getAttr("Path")) != null) {
            stringBuffer.append(";$Path=").append(string);
        }
        String string3 = this.getAttr("Port");
        if (this.ports != null) {
            stringBuffer.append(";$Port=\"").append(string3).append("\"");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Cookie)) {
            return false;
        }
        Cookie cookie = (Cookie)object;
        if (!this.name.equalsIgnoreCase(cookie.name)) {
            return false;
        }
        if (!this.domain.equalsIgnoreCase(cookie.domain)) {
            return false;
        }
        return this.path.equals(cookie.path);
    }

    public String getKey() {
        return this.name.toLowerCase() + "!!!" + this.domain.toLowerCase() + "!!!" + this.path;
    }

    public boolean accept(String string, int n, String string2) {
        if (this.isExpiration()) {
            return false;
        }
        if (!Cookie.isDomainMatch(string, this.domain)) {
            return false;
        }
        if (this.ports != null) {
            int n2;
            int n3 = this.ports.length;
            for (n2 = 0; n2 < n3 && n != this.ports[n2]; ++n2) {
            }
            if (n2 == n3) {
                return false;
            }
        }
        return string2.startsWith(this.path);
    }

    private boolean append(String string, int n, String string2) {
        String string3;
        if (!Cookie.isPathMatch(string2, this.path)) {
            return false;
        }
        if (this.ports != null) {
            int n2;
            for (n2 = 0; n2 < this.ports.length && n != this.ports[n2]; ++n2) {
            }
            if (n2 == this.ports.length) {
                return false;
            }
        }
        if ((string3 = this.getAttr("Domain")) != null) {
            String string4;
            if (string3.indexOf(46, 1) < 0 && !string3.equals(".local")) {
                return false;
            }
            if (!Cookie.isDomainMatch(string, string3)) {
                return false;
            }
            if (!Cookie.isNumericIP(string) && (string4 = string.substring(string3.length())).indexOf(46) >= 0) {
                return false;
            }
        }
        return true;
    }

    public static Vector parseCookieHeader(String string, String string2, int n, String string3) {
        Cookie cookie;
        int n2 = string.length();
        Vector<Cookie> vector = new Vector<Cookie>();
        int n3 = 0;
        int n4 = 0;
        block4: for (n4 = 0; n4 < n2; ++n4) {
            char c = string.charAt(n4);
            switch (c) {
                case '\"': {
                    if (n4 >= n2 - 1) continue block4;
                    ++n4;
                    while (n4 < n2 && string.charAt(n4) != '\"') {
                        ++n4;
                    }
                    continue block4;
                }
                case ';': {
                    Cookie cookie2 = new Cookie(string.substring(n3, n4), string2, string3);
                    if (cookie2.append(string2, n, string3)) {
                        vector.addElement(cookie2);
                    }
                    n3 = n4 + 1;
                }
            }
        }
        if (n4 - n3 > 1 && (cookie = new Cookie(string.substring(n3, n4), string2, string3)).append(string2, n, string3)) {
            vector.addElement(cookie);
        }
        return vector;
    }

    public static int[] parseNumericIP(String string) {
        int[] nArray = new int[4];
        try {
            for (int i = 0; i < 4; ++i) {
                int n = string.length();
                int n2 = string.indexOf(46);
                if (n2 < 0) {
                    n2 = n;
                }
                nArray[i] = Integer.parseInt(string.substring(0, n2));
                if (nArray[i] < 0 || nArray[i] > 255) {
                    return null;
                }
                string = n2 < n ? string.substring(n2 + 1) : "";
            }
            if (string.length() > 0) {
                return null;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return nArray;
    }

    public static boolean isNumericIP(String string) {
        return Cookie.parseNumericIP(string) != null;
    }

    public static boolean isDomainMatch(String string, String string2) {
        int[] nArray = Cookie.parseNumericIP(string);
        int[] nArray2 = Cookie.parseNumericIP(string2);
        if (nArray != null || nArray2 != null) {
            if (nArray != null && nArray2 != null) {
                for (int i = 0; i < 4; ++i) {
                    if (nArray[i] == nArray2[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if ((string = string.toLowerCase()).equals(string2 = string2.toLowerCase())) {
            return true;
        }
        if (string.endsWith(string2) && string2.charAt(0) == '.') {
            return true;
        }
        return string.indexOf(46) < 0 && string2.equals(".local");
    }

    public static boolean isPathMatch(String string, String string2) {
        return string.startsWith(string2);
    }

    public static String getReach(String string) {
        if (Cookie.isNumericIP(string)) {
            return string;
        }
        int n = string.indexOf(46);
        if (n < 0) {
            return string;
        }
        String string2 = string.substring(n);
        if (string2.indexOf(46, 1) > 0) {
            return string2;
        }
        if (string.equalsIgnoreCase(".local")) {
            return string2;
        }
        return string;
    }
}

