/*
 * Decompiled with CFR 0.152.
 */
package jet.net2.www.http;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RelaxedX509TrustManager
implements X509TrustManager {
    private TrustManager SEDU = null;
    private static boolean add = false;
    private static boolean aliases = false;
    private char[] auOnce;
    private String checkClientTrusted = System.getProperty("javax.net.ssl.trustStore");
    private static String close = null;
    private static char[] delete;
    private FileInputStream equals = null;
    private KeyStore exists = null;

    public RelaxedX509TrustManager() throws Exception {
        Properties properties;
        Object object;
        String string = System.getProperty("javax.net.ssl.trustStorePassword");
        if (this.checkClientTrusted == null) {
            this.checkClientTrusted = "";
        }
        this.auOnce = string == null ? "jinfonet".toCharArray() : string.toCharArray();
        if (!this.checkClientTrusted.equals("")) {
            close = this.checkClientTrusted;
            delete = this.auOnce;
        }
        try {
            object = new File(this.checkClientTrusted);
            if (!((File)object).exists()) {
                properties = System.getProperties();
                properties.remove("javax.net.ssl.trustStore");
                properties.remove("javax.net.ssl.trustStorePassword");
                System.setProperties(properties);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            object = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            ((TrustManagerFactory)object).init((KeyStore)null);
            this.SEDU = ((TrustManagerFactory)object).getTrustManagers()[0];
        }
        catch (Exception exception) {
            properties = System.getProperties();
            properties.remove("javax.net.ssl.trustStore");
            properties.remove("javax.net.ssl.trustStorePassword");
            System.setProperties(properties);
            File file = new File(this.checkClientTrusted);
            file.delete();
        }
        if (this.SEDU == null) {
            throw new SSLException("Could not get default TrustManager instance.");
        }
        try {
            this.equals = new FileInputStream(this.checkClientTrusted);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.equals = null;
        }
        try {
            this.exists = KeyStore.getInstance(KeyStore.getDefaultType());
            this.exists.load(this.equals, this.auOnce);
        }
        catch (KeyStoreException keyStoreException) {
            this.exists = null;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        try {
            ((X509TrustManager)this.SEDU).checkClientTrusted(x509CertificateArray, string);
        }
        catch (CertificateException certificateException) {
            Serializable serializable;
            if ("false".equals(System.getProperty("RelaxedX509TrustManager"))) {
                serializable = System.getProperties();
                ((Properties)serializable).remove("RelaxedX509TrustManager");
                System.setProperties((Properties)serializable);
                aliases = false;
                add = false;
            }
            if (aliases) {
                throw new CertificateException();
            }
            if (this.exists == null || x509CertificateArray == null || x509CertificateArray.length == 0) {
                throw new CertificateException();
            }
            if (add) {
                return;
            }
            try {
                serializable = new CertDlg(new Frame(), x509CertificateArray);
                ((Dialog)serializable).setModal(true);
                ((Dialog)serializable).show();
                if (((CertDlg)serializable).auOnce) {
                    add = true;
                }
                if (((CertDlg)serializable).isTrusted) {
                    for (int i = 0; i < x509CertificateArray.length; ++i) {
                        this.exists.setCertificateEntry(((Object)x509CertificateArray[i].getSubjectDN()).toString(), x509CertificateArray[i]);
                    }
                    File file = new File(close.substring(0, close.lastIndexOf(File.separator)));
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(close);
                    this.exists.store(fileOutputStream, delete);
                    fileOutputStream.close();
                    fileOutputStream = null;
                    Properties properties = System.getProperties();
                    properties.put("javax.net.ssl.trustStore", close);
                    properties.put("javax.net.ssl.trustStorePassword", new String(delete));
                    System.setProperties(properties);
                }
                throw new CertificateException();
            }
            catch (Exception exception) {
                throw new CertificateException(exception.getMessage(), exception);
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkClientTrusted(x509CertificateArray, string);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray;
        X509Certificate[] x509CertificateArray2 = x509CertificateArray = ((X509TrustManager)this.SEDU).getAcceptedIssuers();
        if (this.exists != null) {
            try {
                Enumeration<String> enumeration = this.exists.aliases();
                Vector<Certificate> vector = new Vector<Certificate>();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    vector.add(this.exists.getCertificate(string.toString()));
                }
                int n = x509CertificateArray.length + vector.size();
                x509CertificateArray2 = new X509Certificate[n];
                Iterator iterator = vector.iterator();
                for (int i = 0; i < n; ++i) {
                    x509CertificateArray2 = i < x509CertificateArray.length ? x509CertificateArray : (X509Certificate[])iterator.next();
                }
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }
        return x509CertificateArray2;
    }

    class CertDlg
    extends JDialog
    implements ActionListener,
    WindowListener {
        JLabel lblTo;
        JLabel lblTrust;
        JLabel lblExpire;
        JButton btnYES;
        JButton btnNO;
        JButton btnDetail;
        JButton btnOnce;
        boolean auOnce = false;
        boolean isTrusted = false;
        private Frame SEDU;
        private X509Certificate[] access$000;
        private boolean access$102 = false;
        private boolean add = false;

        CertDlg(Frame frame, X509Certificate[] x509CertificateArray) {
            this.access$000 = x509CertificateArray;
            this.SEDU = frame;
            this.SEDU(frame);
            this.access$000();
        }

        private void SEDU(Frame frame) {
            this.setTitle("Sercurity Warning");
            this.getContentPane().setLayout(null);
            this.setResizable(false);
            this.setSize(500, 250);
            this.setLocationRelativeTo(frame);
            JLabel jLabel = new JLabel("The certificate sent by the server is unknown and not trustable!");
            jLabel.setBounds(5, 5, 400, 20);
            JLabel jLabel2 = new JLabel("The certificate is issued to");
            jLabel2.setBounds(5, 30, 150, 20);
            this.lblTo = new JLabel("ISSUED TO");
            this.lblTo.setBounds(155, 30, 160, 20);
            this.lblExpire = new JLabel("The Certificate does not expire and is still valid.");
            this.lblExpire.setBounds(5, 55, 300, 20);
            this.lblTrust = new JLabel("The Certificate is issued by a company that is not trusted.");
            this.lblTrust.setBounds(5, 80, 350, 20);
            JLabel jLabel3 = new JLabel("Do you want to grant this certificate?");
            jLabel3.setBounds(5, 115, 250, 20);
            this.btnOnce = new JButton("Grant Once");
            this.btnOnce.setBounds(5, 145, 110, 25);
            this.btnYES = new JButton("Grant always");
            this.btnYES.setBounds(120, 145, 120, 25);
            this.btnNO = new JButton("Deny");
            this.btnNO.setBounds(245, 145, 70, 25);
            this.btnDetail = new JButton("View Certificate");
            this.btnDetail.setBounds(320, 145, 130, 25);
            this.getContentPane().add(this.btnDetail);
            this.getContentPane().add(this.btnNO);
            this.getContentPane().add(this.btnOnce);
            this.getContentPane().add(this.btnYES);
            this.getContentPane().add(jLabel);
            this.getContentPane().add(jLabel2);
            this.getContentPane().add(jLabel3);
            this.getContentPane().add(this.lblExpire);
            this.getContentPane().add(this.lblTo);
            this.getContentPane().add(this.lblTrust);
        }

        private void access$000() {
            String string = this.access$000[0].getSubjectDN().getName();
            string = string.substring(string.indexOf("CN=") + 3);
            this.lblTo.setText(string.substring(0, string.indexOf(",")));
            try {
                this.access$000[0].checkValidity();
            }
            catch (CertificateExpiredException certificateExpiredException) {
                this.access$102 = true;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                this.add = true;
            }
            if (this.access$102) {
                if (this.add) {
                    this.lblExpire.setText("The Certificate is expired and is not valid.");
                } else {
                    this.lblExpire.setText("The Certificate is expired and is valid.");
                }
            } else if (this.add) {
                this.lblExpire.setText("The Certificate is not expired and is not valid.");
            } else {
                this.lblExpire.setText("The Certificate is not expired and is valid.");
            }
            this.lblTrust.setFont(this.lblTrust.getFont().deriveFont(1));
            this.lblExpire.setFont(this.lblExpire.getFont().deriveFont(1));
            this.btnYES.addActionListener(this);
            this.btnYES.setEnabled(close != null);
            this.btnNO.addActionListener(this);
            this.btnDetail.addActionListener(this);
            this.btnOnce.addActionListener(this);
            this.addWindowListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.btnYES) {
                this.isTrusted = true;
                this.dispose();
            } else if (object == this.btnNO) {
                aliases = true;
                this.dispose();
            } else if (object == this.btnDetail) {
                ViewCert viewCert = new ViewCert(this.SEDU, this.access$000);
            } else if (object == this.btnOnce) {
                this.auOnce = true;
                this.dispose();
            }
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            this.dispose();
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        class ViewCert
        extends JDialog
        implements ActionListener {
            private JPanel SEDU = new JPanel();
            private JPanel add = new JPanel();
            private JPanel addActionListener = new JPanel();
            private JComboBox addItem = new JComboBox();
            private JList addItemListener = new JList();
            private JTextArea addListSelectionListener = new JTextArea();
            private JButton append = new JButton("OK");
            private Frame createEtchedBorder;
            private X509Certificate[] createTitledBorder;
            private final String[] digest = new String[]{"Version", "Serial Number", "Signature Algorithm", "Issuer", "Validity Period", "Subject", "Signature", "Certificate Fingerprint"};
            private int equals = 0;

            ViewCert(Frame frame, X509Certificate[] x509CertificateArray) {
                this.createTitledBorder = x509CertificateArray;
                this.createEtchedBorder = frame;
                this.SEDU(frame);
                this.add();
                this.setModal(true);
                this.show();
            }

            private void SEDU(Frame frame) {
                this.setTitle("Certificate Details");
                this.getContentPane().setLayout(null);
                this.setResizable(true);
                this.setSize(410, 460);
                this.setLocationRelativeTo(frame);
                this.SEDU.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Certificate"));
                this.SEDU.setBounds(10, 10, 380, 60);
                this.SEDU.setLayout(new BorderLayout());
                this.SEDU.add(this.addItem);
                this.add.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Field"));
                this.add.setLayout(new BorderLayout());
                this.add.setBounds(10, 80, 380, 150);
                JScrollPane jScrollPane = new JScrollPane(this.addItemListener);
                this.add.add(jScrollPane);
                this.addItemListener.setSelectionMode(0);
                this.addActionListener.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Value"));
                this.addActionListener.setLayout(new BorderLayout());
                this.addActionListener.setBounds(10, 240, 380, 150);
                JScrollPane jScrollPane2 = new JScrollPane(this.addListSelectionListener);
                this.addActionListener.add(jScrollPane2);
                this.append.setBounds(160, 400, 90, 25);
                this.getContentPane().add(this.SEDU);
                this.getContentPane().add(this.add);
                this.getContentPane().add(this.addActionListener);
                this.getContentPane().add(this.append);
            }

            private void add() {
                for (int i = 0; i < this.createTitledBorder.length; ++i) {
                    String string = this.createTitledBorder[i].getSubjectDN().getName();
                    string = string.substring(string.indexOf("CN=") + 3);
                    this.addItem.addItem(i + 1 + ". " + string.substring(0, string.indexOf(",")));
                }
                this.addItem.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        ViewCert.this.addListSelectionListener();
                    }
                });
                this.addItemListener.setListData(this.digest);
                this.addItemListener.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        ViewCert.this.addItemListener();
                    }
                });
                this.addItemListener.setSelectedIndex(0);
                this.addListSelectionListener();
                this.append.addActionListener(this);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == this.append) {
                    this.dispose();
                }
            }

            private String addActionListener(byte[] byArray, String string) throws Exception {
                MessageDigest messageDigest = MessageDigest.getInstance(string);
                messageDigest.update(byArray);
                byte[] byArray2 = messageDigest.digest();
                return new String(string + ": " + this.addItem(byArray2));
            }

            private String addItem(byte[] byArray) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < byArray.length; ++i) {
                    int n;
                    String string;
                    if (i != 0) {
                        stringBuffer.append(":");
                    }
                    if ((string = Integer.toHexString(n = byArray[i] & 0xFF)).length() == 1) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }

            private void addItemListener() {
                this.addListSelectionListener();
            }

            private void addListSelectionListener() {
                this.equals = this.addItem.getSelectedIndex();
                String string = (String)this.addItemListener.getSelectedValue();
                if (string.equals("Version")) {
                    this.addListSelectionListener.setText(String.valueOf(this.createTitledBorder[this.equals].getVersion()));
                } else if (string.equals("Serial Number")) {
                    this.addListSelectionListener.setText(this.addItem(this.createTitledBorder[this.equals].getSerialNumber().toByteArray()));
                } else if (string.equals("Signature Algorithm")) {
                    this.addListSelectionListener.setText(this.createTitledBorder[this.equals].getSigAlgName());
                } else if (string.equals("Issuer")) {
                    this.addListSelectionListener.setText(this.createTitledBorder[this.equals].getIssuerDN().getName());
                } else if (string.equals("Validity Period")) {
                    this.addListSelectionListener.setText(this.createTitledBorder[this.equals].getNotBefore().toString() + " - " + this.createTitledBorder[this.equals].getNotAfter().toString());
                } else if (string.equals("Subject")) {
                    this.addListSelectionListener.setText(this.createTitledBorder[this.equals].getSubjectDN().getName());
                } else if (string.equals("Signature")) {
                    this.addListSelectionListener.setText(this.addItem(this.createTitledBorder[this.equals].getSignature()));
                } else if (string.equals("Certificate Fingerprint")) {
                    try {
                        this.addListSelectionListener.setText(this.addActionListener(this.createTitledBorder[this.equals].getEncoded(), "MD5") + "\n" + this.addActionListener(this.createTitledBorder[this.equals].getEncoded(), "SHA1"));
                    }
                    catch (Exception exception) {
                        this.addListSelectionListener.setText("Couldn't calculate fingerprints of the certificate.\nReason: " + exception.getMessage());
                    }
                }
            }
        }
    }
}

