/*
 * Decompiled with CFR 0.152.
 */
package jet.parameter.runtime;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.resstore.defaultimpl.DefaultResourceStore;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import jet.ReportEnv;
import jet.dataengine.api.DSException;
import jet.dataservice.api.DataServiceConfig;
import jet.dataservice.api.DataServiceFactory;
import jet.dataservice.api.JDataService;
import jet.exception.InvalidParameterException;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.log.JRLogger;
import jet.parameter.definition.BindColumn;
import jet.parameter.runtime.valuelist.DataServiceValueListFetcher;
import jet.parameter.runtime.valuelist.IValueListFetcher;
import jet.parameter.runtime.valuelist.IValueListFetcherContext;
import jet.universe.JetField;
import jet.universe.JetUDatabase;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUParameter;
import jet.universe.JetUUDSField;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.universe.businesslogic.impl.DataElement;
import toolkit.db.gui.ConnectionsBroker;
import toolkit.db.version2.CallTrace;

public class ParameterRuntime {
    private ParamDesc SEDU;
    private IValueListFetcher add;
    private IValueListFetcherContext addElement;
    private static JRLogger addLowerLevelByQuery = JRLogger.getLogger(ParameterRuntime.class.getName());
    private Vector append;
    private Vector bindQueryToParameter = new Vector();

    public ParameterRuntime(ParamDesc paramDesc) {
        this.SEDU = paramDesc;
    }

    public void createValueListFetcher(JDataService jDataService, CatalogKey catalogKey, IValueListFetcherContext iValueListFetcherContext) {
        if (jDataService == null) {
            if (addLowerLevelByQuery.isErrorEnabled()) {
                addLowerLevelByQuery.error("Can not create DataServiceValueListFetcher: ds = null");
            }
            return;
        }
        this.add = new DataServiceValueListFetcher(this.SEDU, jDataService, catalogKey, iValueListFetcherContext);
        this.addElement = iValueListFetcherContext;
    }

    public void createValueListFetcher(CatalogKey catalogKey, IValueListFetcherContext iValueListFetcherContext) throws DSException {
        String string = ReportEnv.getTemporaryPath();
        JetUUniverse jetUUniverse = iValueListFetcherContext.getUniverse(this.SEDU);
        DefaultResourceStore defaultResourceStore = new DefaultResourceStore(new File(string));
        DataServiceConfig dataServiceConfig = new DataServiceConfig(null, string, jetUUniverse.getInfoBusManager(), defaultResourceStore);
        dataServiceConfig.setInformationBusManager(jetUUniverse.getInfoBusManager());
        dataServiceConfig.setSingleThread(true);
        dataServiceConfig.setCacheZip(false);
        dataServiceConfig.setThreadPriority(5);
        JDataService jDataService = DataServiceFactory.createDataSerivce(dataServiceConfig);
        jDataService.registCatalog(catalogKey, jetUUniverse);
        this.add = new DataServiceValueListFetcher(this.SEDU, jDataService, catalogKey, iValueListFetcherContext);
        this.addElement = iValueListFetcherContext;
    }

    public void setValueListFetcher(IValueListFetcher iValueListFetcher, IValueListFetcherContext iValueListFetcherContext) {
        this.add = iValueListFetcher;
        this.addElement = iValueListFetcherContext;
    }

    public IValueListFetcher getValueListFetcher() {
        return this.add;
    }

    public IValueListFetcherContext getValueListFetcherContext() {
        return this.addElement;
    }

    public String getMappingName(String string, JUnifiedBusinessView jUnifiedBusinessView, Hashtable hashtable) {
        JetRptFormula jetRptFormula;
        String string2 = null;
        DataElement dataElement = (DataElement)jUnifiedBusinessView.getByDisplayName(string);
        if (dataElement != null) {
            string2 = dataElement.getRefMappingName();
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "ParameterRuntime/get mapping name of " + string + " from DataElement: " + string2);
            }
        } else if (hashtable != null && (jetRptFormula = (JetRptFormula)hashtable.get(string)) != null) {
            string2 = jetRptFormula.getName();
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "ParameterRuntime/get mapping name of " + string + " from fly formula: " + string2);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ParameterRuntime/get mapping name of " + string + " : " + string2);
        }
        return string2;
    }

    public boolean loadValueList() throws SQLException, ClassNotFoundException, NamingException, InvalidParameterException, DSException {
        String string;
        Object object;
        Cloneable cloneable;
        Object object22;
        Object object3;
        Object object4;
        Object object5;
        Vector[] vectorArray;
        Object object6;
        Object object7;
        if (this.add == null) {
            if (addLowerLevelByQuery.isWarnEnabled()) {
                addLowerLevelByQuery.warn(this.SEDU.getName() + ": Do not fetch value list because valueListFetcher = null", new CallTrace());
            }
            return false;
        }
        JetUUniverse jetUUniverse = this.addElement.getUniverse(this.SEDU);
        String[] stringArray = null;
        JetUParameter jetUParameter = null;
        if (this.SEDU.isDynamicParam()) {
            object7 = this.SEDU.getBVName();
            object6 = this.SEDU.getDataSource();
            vectorArray = jetUUniverse.getBV((String)object6, (String)object7);
            object5 = this.SEDU.getColumn();
            object4 = vectorArray.getQuery();
            object3 = this.addElement.getReportFormulas(this.SEDU);
            object22 = this.getMappingName((String)object5, (JUnifiedBusinessView)vectorArray, (Hashtable)object3);
            cloneable = this.SEDU.getColumns();
            object = new Vector<String>();
            for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
                string = this.getMappingName((String)((Vector)cloneable).elementAt(i), (JUnifiedBusinessView)vectorArray, (Hashtable)object3);
                ((Vector)object).addElement(string);
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "ParameterRuntime/defineBindColumn: bvName :" + (String)object7 + "; datasource: " + (String)object6 + "; query: " + ((JetUDemandQuery)object4).getResourceName() + "; bind to: " + (String)object5 + "[" + (String)object22 + "] " + "; display columns: " + cloneable + "; mapping name of display columns: " + object);
            }
            this.SEDU.getDefinition().defineBindColumn(((JetUDemandQuery)object4).getResourceName(), (String)object22, (Vector)object);
        } else {
            jetUParameter = (JetUParameter)jetUUniverse.getResourceByName(this.SEDU.getDataSource(), null, this.SEDU.name);
            if (jetUParameter == null) {
                if (addLowerLevelByQuery.isWarnEnabled()) {
                    addLowerLevelByQuery.warn(this.SEDU.getName() + ": Do not fetch value list because up = null", new CallTrace());
                }
                return false;
            }
            object7 = jetUUniverse.getDatabase(this.SEDU.getDataSource());
            object6 = (JetField)((Object)((JetUDatabase)object7).getResourceByName(this.SEDU.getColumn()));
            if (object6 == null) {
                throw new DSException(1151, new Object[]{this.SEDU.getColumn(), this.SEDU.getDataSource()});
            }
            stringArray = object6 instanceof JetUUDSField ? new String[]{} : new String[]{object6.getConnection().getResourceName()};
        }
        object7 = null;
        object6 = this.SEDU.getDefinition().getBindColumn();
        if (object6 == null || ((BindColumn)object6).getQueryName() == null) {
            boolean bl = false;
            object5 = this.addElement.getConnection(this.SEDU, stringArray);
            if (object5 != null) {
                object4 = ((Hashtable)object5).keySet().iterator();
                while (object4.hasNext()) {
                    object3 = (String)object4.next();
                    object22 = (Connection)((Hashtable)object5).get(object3);
                    if (object22 == null) continue;
                    object7 = object22;
                    break;
                }
            }
            if (object7 == null && (object4 = this.addElement.getConnectionInfo(this.SEDU, stringArray)) != null) {
                for (Object object22 : ((Hashtable)object4).keySet()) {
                    cloneable = (Properties)((Hashtable)object4).get(object22);
                    if (cloneable == null) continue;
                    if (((Properties)cloneable).getProperty("jrs.catalog_connection_type").equalsIgnoreCase("JDBC")) {
                        object = (String)((Properties)cloneable).get("jrs.jdbc_url");
                        String string2 = (String)((Properties)cloneable).get("jrs.ds_user");
                        string = (String)((Properties)cloneable).get("jrs.ds_pswd");
                        String string3 = (String)((Properties)cloneable).get("jrs.jdbc_driver");
                        object7 = ConnectionsBroker.getConnection((String)object, string2, string, string3);
                        break;
                    }
                    if (!((Properties)cloneable).getProperty("jrs.catalog_connection_type").equalsIgnoreCase("JNDI")) break;
                    object7 = ConnectionsBroker.getJNDIConnection((String)((Properties)cloneable).get("jrs.jndi_datasource"), (String)((Properties)cloneable).get("jrs.ds_user"), (String)((Properties)cloneable).get("jrs.ds_pswd"));
                    break;
                }
            }
            if (object7 != null) {
                bl = true;
            }
            jetUParameter.bindQueryToParameter(this.SEDU, (Connection)object7);
            if (bl) {
                ConnectionsBroker.freeConnection((Connection)object7);
            }
        }
        if ((object6 = this.SEDU.getDefinition().getBindColumn()) == null) {
            if (addLowerLevelByQuery.isErrorEnabled()) {
                addLowerLevelByQuery.error(this.SEDU.getName() + ": failed binding query to parameter.");
            }
            return false;
        }
        vectorArray = null;
        try {
            vectorArray = this.add.getValueList(this.SEDU);
        }
        catch (Exception exception) {
            if (addLowerLevelByQuery.isDebugEnabled()) {
                addLowerLevelByQuery.debug("Met exception when loading parameter value list: ", exception);
            }
            this.add.endGettingValueList();
            return false;
        }
        this.add.endGettingValueList();
        this.SEDU.setValueList(vectorArray[0], vectorArray[1]);
        return true;
    }

    public void setParamsUsedInQuery(Vector vector) {
        this.append = new Vector();
        for (String string : vector) {
            if (string.equalsIgnoreCase(this.SEDU.name)) {
                if (!addLowerLevelByQuery.isWarnEnabled()) continue;
                addLowerLevelByQuery.warn("Invalid dependency between parameters. Cannot define cascading parameter base on itself: " + string, new CallTrace());
                continue;
            }
            this.append.add(string);
        }
    }

    public Vector getParamsUsedInQuery() {
        return this.append;
    }

    public boolean hasParamsUsedInQuery() {
        return null != this.append && this.append.size() > 0;
    }

    public Vector getLowerLevelsByQuery() {
        return this.bindQueryToParameter;
    }

    public void addLowerLevelByQuery(ParamDesc paramDesc) {
        if (!this.bindQueryToParameter.contains(paramDesc)) {
            this.bindQueryToParameter.add(paramDesc);
        }
    }

    public void cascadeParams(Hashtable hashtable, Hashtable hashtable2, Vector vector) {
        if (null != this.append && this.append.size() != 0) {
            ParamDesc paramDesc = null;
            Enumeration enumeration = this.append.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = string.toUpperCase();
                paramDesc = (ParamDesc)hashtable.get(string2);
                if (!vector.contains(string)) {
                    int n = vector.indexOf(this.SEDU.name);
                    if (n == -1) {
                        n = 0;
                    }
                    vector.insertElementAt(string, n);
                }
                if (hashtable2.get(string2) == null) {
                    hashtable2.put(string2, paramDesc);
                }
                paramDesc.getParameterRuntime().addLowerLevelByQuery(this.SEDU);
                if (paramDesc == null || !paramDesc.getParameterRuntime().hasParamsUsedInQuery()) continue;
                paramDesc.getParameterRuntime().cascadeParams(hashtable, hashtable2, vector);
            }
        }
    }

    public void copyTo(ParameterRuntime parameterRuntime) {
        parameterRuntime.addElement = this.addElement;
        if (this.add != null) {
            parameterRuntime.add = this.add.copy(parameterRuntime.SEDU);
        }
        if (null != this.append) {
            parameterRuntime.setParamsUsedInQuery(this.append);
        }
    }
}

