/*
 * Decompiled with CFR 0.152.
 */
package jet.parameter.runtime.valuelist;

import com.jinfonet.api.objectmanager.CatalogKey;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Hashtable;
import java.util.Properties;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.query.DataDescription;
import jet.dataengine.api.query.DatabaseMetadataInfo;
import jet.dataengine.api.query.JDSQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataservice.api.JDataService;
import jet.dataservice.api.ParameterInfo;
import jet.formula.ParamDesc;
import jet.log.JRLogger;
import jet.parameter.runtime.valuelist.BaseValueListFetcher;
import jet.parameter.runtime.valuelist.IValueListFetcher;
import jet.parameter.runtime.valuelist.IValueListFetcherContext;
import jet.universe.JetUQueriable;

public class DataServiceValueListFetcher
extends BaseValueListFetcher
implements IValueListFetcher {
    private static JRLogger SEDU = JRLogger.getLogger(DataServiceValueListFetcher.class.getName());
    private JDataService closeQuery;
    private CatalogKey create;
    private ParamDesc createDataDescription;
    private JDSQuery createDataSourceQuery = null;
    private int equalsIgnoreCase;

    public DataServiceValueListFetcher(ParamDesc paramDesc, JDataService jDataService, CatalogKey catalogKey, IValueListFetcherContext iValueListFetcherContext) {
        super(iValueListFetcherContext);
        this.createDataDescription = paramDesc;
        this.closeQuery = jDataService;
        this.create = catalogKey;
    }

    protected Hashtable createDataDescription() throws DSException {
        Object object;
        DataDescription dataDescription = null;
        Hashtable<Object, DataDescription> hashtable = new Hashtable<Object, DataDescription>();
        Hashtable hashtable2 = this.context.getConnection(this.createDataDescription, this.connectionNames);
        if (hashtable2 != null) {
            object = hashtable2.keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                Object object2 = (Connection)hashtable2.get(string);
                if (object2 == null) continue;
                dataDescription = DataDescription.create((Connection)object2);
                hashtable.put(string, dataDescription);
            }
        }
        if ((object = this.context.getConnectionInfo(this.createDataDescription, this.connectionNames)) != null) {
            for (Object object2 : ((Hashtable)object).keySet()) {
                Properties properties = (Properties)((Hashtable)object).get(object2);
                if (properties == null) continue;
                if (properties.getProperty("jrs.catalog_connection_type").equalsIgnoreCase("JDBC")) {
                    dataDescription = DataDescription.create((String)properties.get("jrs.jdbc_driver"), (String)properties.get("jrs.jdbc_url"), (String)properties.get("jrs.ds_user"), (String)properties.get("jrs.ds_pswd"));
                } else if (properties.getProperty("jrs.catalog_connection_type").equalsIgnoreCase("JNDI")) {
                    dataDescription = DataDescription.create(properties);
                }
                hashtable.put(object2, dataDescription);
            }
        }
        return hashtable;
    }

    @Override
    protected JDSQuery createQuery(JetUQueriable jetUQueriable) throws DSException {
        this.createDataSourceQuery = this.closeQuery.getQueryFactory().createDataSourceQuery(this.create);
        Hashtable hashtable = this.createDataDescription();
        for (Object object : hashtable.keySet()) {
            DataDescription dataDescription = (DataDescription)hashtable.get(object);
            this.createDataSourceQuery.getDynamicConnections().put(object, dataDescription);
        }
        Hashtable hashtable2 = this.context.getDatabaseMetadataInfo(this.createDataDescription, this.connectionNames);
        for (String string : hashtable2.keySet()) {
            DatabaseMetadataInfo databaseMetadataInfo = (DatabaseMetadataInfo)hashtable2.get(string);
            this.createDataSourceQuery.getDynamicDatabaseMetadataInfos().put(string, databaseMetadataInfo);
        }
        this.equalsIgnoreCase = this.createDataSourceQuery.getQueryId();
        return this.createDataSourceQuery;
    }

    @Override
    protected ResultSet getResultSet(JRawDataQuery jRawDataQuery) throws DSException, JRStopEngineException, ConditionException, IOException {
        ParameterInfo parameterInfo = new ParameterInfo(jRawDataQuery, this.createDataDescription);
        return this.closeQuery.getDataResult(parameterInfo);
    }

    @Override
    public void endGettingValueList() {
        this.closeQuery.closeQuery(this.equalsIgnoreCase);
        this.createDataSourceQuery = null;
    }

    @Override
    public IValueListFetcher copy(ParamDesc paramDesc) {
        DataServiceValueListFetcher dataServiceValueListFetcher = new DataServiceValueListFetcher(paramDesc, this.closeQuery, this.create, this.context);
        return dataServiceValueListFetcher;
    }
}

