/*
 * Decompiled with CFR 0.152.
 */
package jet.parameter.util;

import java.util.Vector;
import jet.parameter.util.Template;

public class ExpressionTemplates {
    private static final String SEDU = "Date".toUpperCase();
    private static final String add = "DateTime".toUpperCase();
    private static final String append = "Time".toUpperCase();
    private static Vector canApplyTo = new Vector();

    public static String[][] getTemplates(String string) {
        Vector<Template> vector = new Vector<Template>();
        String[][] stringArray = new String[2][];
        for (Object object : canApplyTo) {
            if (!((Template)object).canApplyTo(string)) continue;
            vector.add((Template)object);
        }
        stringArray[0] = new String[vector.size()];
        stringArray[1] = new String[vector.size()];
        int n = 0;
        for (Template template : vector) {
            stringArray[0][n] = template.getExpressionName();
            stringArray[1][n] = template.getExpression();
            ++n;
        }
        return stringArray;
    }

    public static void usage() {
        int n;
        String[][] stringArray = ExpressionTemplates.getTemplates(append);
        for (n = 0; n < stringArray[0].length; ++n) {
            System.out.println(stringArray[0][n] + ": " + stringArray[1][n]);
        }
        System.out.println("\n======================");
        stringArray = ExpressionTemplates.getTemplates(SEDU);
        for (n = 0; n < stringArray[0].length; ++n) {
            System.out.println(stringArray[0][n] + ": " + stringArray[1][n]);
        }
        System.out.println("\n======================");
        stringArray = ExpressionTemplates.getTemplates(add);
        for (n = 0; n < stringArray[0].length; ++n) {
            System.out.println(stringArray[0][n] + ": " + stringArray[1][n]);
        }
    }

    static {
        canApplyTo.add(new Template("Last 5 Minutes", "dateadd('n', -5, currenttime())", add, append));
        canApplyTo.add(new Template("Today", "today()", SEDU, add));
        canApplyTo.add(new Template("Tomorrow", "dateadd('d' ,1 , today())", SEDU, add));
        canApplyTo.add(new Template("Yesterday ", "dateadd('d', -1, today())", SEDU, add));
        canApplyTo.add(new Template("One Hour Ago", "dateadd('h', -1, currenttime())", add, append));
        canApplyTo.add(new Template("Twelve Hours Ago", "dateadd('h', -12, currenttime())", add, append));
        canApplyTo.add(new Template("A Week Before Today", "dateadd('d', -7, today())", SEDU, add));
        canApplyTo.add(new Template("First Day Of This Week", "firstdayofweek(today())", SEDU, add));
        canApplyTo.add(new Template("Last Day Of This Week", "dateadd('d', 6, firstdayofweek(today()))", SEDU, add));
        canApplyTo.add(new Template("First Day Of Last Week", "dateadd('d', -7, firstdayofweek(today()))", SEDU, add));
        canApplyTo.add(new Template("Last Day Of Last Week", "dateadd('d', -1, firstdayofweek(today()))", SEDU, add));
        canApplyTo.add(new Template("First Day Of This Month", "firstdayofmonth(today())", SEDU, add));
        canApplyTo.add(new Template("Last Day Of This Month", "dateadd('d', -1, firstdayofmonth(dateadd('m', 1 ,today())))", SEDU, add));
        canApplyTo.add(new Template("First Sunday Of This Month", "firstsundayofmonth(today())", SEDU, add));
        canApplyTo.add(new Template("First Day Of Last Month", "firstdayofmonth(dateadd('d', -1, firstdayofmonth(today())))", SEDU, add));
        canApplyTo.add(new Template("Last Day Of Last Month", "dateadd('d', -1, firstdayofmonth(today()))", SEDU, add));
        canApplyTo.add(new Template("First Day Of This Quarter", "firstdayofquarter(today())", SEDU, add));
        canApplyTo.add(new Template("Last Day Of This Quarter", "dateadd('d', -1, firstdayofquarter(dateadd('q', 1 ,today())))", SEDU, add));
        canApplyTo.add(new Template("First Day Of Last Quarter", "firstdayofquarter(dateadd('d', -1, firstdayofquarter(today())))", SEDU, add));
        canApplyTo.add(new Template("Last Day Of Last Quarter", "dateadd('d', -1, firstdayofquarter(today()))", SEDU, add));
        canApplyTo.add(new Template("First Day Of This Year", "firstdayofyear(today())", SEDU, add));
        canApplyTo.add(new Template("Last Day Of This Year", "dateadd('d', -1, firstdayofyear(dateadd('yyyy', 1 ,today())))", SEDU, add));
        canApplyTo.add(new Template("First Sunday Of This Year", "firstsundayofyear(today())", SEDU, add));
        canApplyTo.add(new Template("First Day Of Last Year", "firstdayofyear(dateadd('d', -1, firstdayofyear(today())))", SEDU, add));
        canApplyTo.add(new Template("Last Day Of Last Year", "dateadd('d', -1, firstdayofyear(today()))", SEDU, add));
        canApplyTo.add(new Template("First Day Of 1st Qtr Of This Year", "firstdayofyear(today())", SEDU, add));
        canApplyTo.add(new Template("First Day Of 2nd Qtr Of This Year", "dateadd('q', 1, firstdayofyear(today()))", SEDU, add));
        canApplyTo.add(new Template("First Day Of 3rd Qtr Of This Year", "dateadd('q', 2, firstdayofyear(today()))", SEDU, add));
        canApplyTo.add(new Template("First Day Of 4th Qtr Of This Year", "dateadd('q', 3, firstdayofyear(today()))", SEDU, add));
        canApplyTo.add(new Template("First Day Of 1st Qtr Of Last Year", "firstdayofyear(dateadd('d', -1, firstdayofyear(today())))", SEDU, add));
        canApplyTo.add(new Template("First Day Of 2nd Qtr Of Last Year", "dateadd('q', 1, firstdayofyear(dateadd('d', -1, firstdayofyear(today()))))", SEDU, add));
        canApplyTo.add(new Template("First Day Of 3rd Qtr Of Last Year", "dateadd('q', 2, firstdayofyear(dateadd('d', -1, firstdayofyear(today()))))", SEDU, add));
        canApplyTo.add(new Template("First Day Of 4th Qtr Of Last Year", "dateadd('q', 3, firstdayofyear(dateadd('d', -1, firstdayofyear(today()))))", SEDU, add));
        canApplyTo.add(new Template("Selected Date in Calendar", "selecteddate()", SEDU, add));
    }
}

