/*
 * Decompiled with CFR 0.152.
 */
package jet.parameter.util;

import java.util.Locale;
import java.util.Vector;
import jet.JResource;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.exception.InvalidParameterException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.DataTypeDef;
import jet.formula.ParamDesc;
import jet.formula.formulaExecutor.ExecFormulaFailedException;
import jet.formula.formulaExecutor.ExternalInfoProvider;
import jet.formula.formulaExecutor.FormulaContainerImpl;
import jet.log.JRLogger;
import jet.parameter.UserInput;
import jet.parameter.runtime.valuelist.item.BooleanValueListItem;
import jet.parameter.runtime.valuelist.item.CurrencyValueListItem;
import jet.parameter.runtime.valuelist.item.DateValueListItem;
import jet.parameter.runtime.valuelist.item.DatetimeValueListItem;
import jet.parameter.runtime.valuelist.item.EvalueatedValueListItem;
import jet.parameter.runtime.valuelist.item.IntegerValueListItem;
import jet.parameter.runtime.valuelist.item.NumberValueListItem;
import jet.parameter.runtime.valuelist.item.StringValueListItem;
import jet.parameter.runtime.valuelist.item.TimeValueListItem;

public class ValueListItemUtil {
    private static JRLogger SEDU = JRLogger.getLogger(ValueListItemUtil.class.getName());

    private static void SEDU(String string, Object[] objectArray) throws InvalidParameterException {
        String string2 = JResource.getMessage(string, objectArray);
        throw new InvalidParameterException(string2);
    }

    public static Locale getLocale(UserInput userInput) {
        if (userInput == null) {
            return null;
        }
        if (userInput instanceof EvalueatedValueListItem) {
            return ((EvalueatedValueListItem)userInput).getLocale();
        }
        return null;
    }

    public static EvalueatedValueListItem toValueListItem(UserInput userInput, String string, FormulaContainerImpl formulaContainerImpl, ExternalInfoProvider externalInfoProvider) throws InvalidParameterException {
        if (null == userInput || !userInput.isExpression()) {
            return null;
        }
        DbValue dbValue = null;
        Object var5_5 = null;
        int n = -1;
        try {
            dbValue = formulaContainerImpl.executeFormulaByExp(userInput.getUserInput(), externalInfoProvider, string);
            n = DataTypeDef.SqlToFml(dbValue.getSqlType(), dbValue.isCurrency());
            boolean bl = DataTypeDef.isAssignableFrom(35, n);
            if (!bl) {
                ValueListItemUtil.SEDU("PARAM_INCOMPATIBLE_TYPE", new Object[]{DataTypeDef.toString(n), userInput.getUserInput(), string});
            }
        }
        catch (ExecFormulaFailedException execFormulaFailedException) {
            SEDU.error("PARAM_EXEC_EXPRESSION_FAIL:", execFormulaFailedException);
            ValueListItemUtil.SEDU("PARAM_EXEC_EXPRESSION_FAIL", new Object[]{userInput.getUserInput()});
        }
        catch (ParseFormulaFailedException parseFormulaFailedException) {
            ValueListItemUtil.SEDU("PARAM_PARSE_EXPRESSION_FAIL", new Object[]{userInput.getUserInput(), parseFormulaFailedException.toString()});
        }
        EvalueatedValueListItem evalueatedValueListItem = ValueListItemUtil.toValueListItem(dbValue);
        evalueatedValueListItem.setUserInput(userInput.getUserInput(), userInput.isExpression(), userInput.getExpressionName(), userInput.getSelectedDate(), ValueListItemUtil.getLocale(userInput));
        return evalueatedValueListItem;
    }

    public static EvalueatedValueListItem toValueListItem(DbValue dbValue) {
        DbValue dbValue2 = null;
        if (dbValue instanceof EvalueatedValueListItem) {
            return (EvalueatedValueListItem)((Object)dbValue);
        }
        DbColDesc dbColDesc = dbValue.getColDesc();
        int n = DataTypeDef.SqlToFml(dbColDesc.getSqlType(), dbColDesc.isCurrency());
        switch (n) {
            case 8: {
                dbValue2 = new DatetimeValueListItem(dbColDesc);
                break;
            }
            case 6: {
                dbValue2 = new DateValueListItem(dbColDesc);
                break;
            }
            case 4: {
                dbValue2 = new BooleanValueListItem(dbColDesc);
                break;
            }
            case 3: {
                dbValue2 = new CurrencyValueListItem(dbColDesc);
                break;
            }
            case 1: {
                dbValue2 = new IntegerValueListItem(dbColDesc);
                break;
            }
            case 2: {
                dbValue2 = new NumberValueListItem(dbColDesc);
                break;
            }
            case 5: {
                dbValue2 = new StringValueListItem(dbColDesc);
                break;
            }
            case 7: {
                dbValue2 = new TimeValueListItem(dbColDesc);
                break;
            }
            default: {
                return null;
            }
        }
        dbValue2.set(dbValue);
        return (EvalueatedValueListItem)((Object)dbValue2);
    }

    public static DbValue toDbValue(EvalueatedValueListItem evalueatedValueListItem) {
        DbValue dbValue = null;
        try {
            dbValue = DbValue.makeDbValue(((DbValue)((Object)evalueatedValueListItem)).getColDesc());
            dbValue.set((DbValue)((Object)evalueatedValueListItem));
        }
        catch (Exception exception) {
            SEDU.error("Cast EvalueatedValueListItem " + evalueatedValueListItem.getClass() + " to DbValue failed: ", exception);
        }
        return dbValue;
    }

    public static String toString(UserInput userInput) {
        return userInput.getUserInput() + ";" + userInput.isExpression() + ";" + userInput.getExpressionName() + ";" + userInput.getSelectedDate();
    }

    public static String format(DbValue dbValue, String string, String string2, Locale locale) {
        ParamDesc paramDesc = new ParamDesc("", string, "", new Vector(), new Vector(), string2, 0, 0, 0, "", new Vector(), new Vector(), "", false);
        return paramDesc.getDisplayValue(dbValue, locale);
    }

    public static boolean equals(DbValue dbValue, DbValue dbValue2) {
        if (dbValue == null || dbValue2 == null) {
            return false;
        }
        boolean bl = dbValue.equals(dbValue2);
        if (!bl) {
            return false;
        }
        EvalueatedValueListItem evalueatedValueListItem = null;
        EvalueatedValueListItem evalueatedValueListItem2 = null;
        if (dbValue instanceof EvalueatedValueListItem) {
            if (dbValue2 instanceof EvalueatedValueListItem) {
                evalueatedValueListItem = (EvalueatedValueListItem)((Object)dbValue);
                evalueatedValueListItem2 = (EvalueatedValueListItem)((Object)dbValue2);
                bl = evalueatedValueListItem.equals(evalueatedValueListItem2);
            } else {
                bl = false;
            }
        } else {
            bl = dbValue2 instanceof EvalueatedValueListItem ? false : false;
        }
        return bl;
    }

    public static boolean contains(Vector vector, DbValue dbValue) {
        if (vector == null) {
            return false;
        }
        if (dbValue == null) {
            return false;
        }
        for (Object e : vector) {
            if (!ValueListItemUtil.equals((DbValue)e, dbValue)) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(Vector vector, DbValue dbValue) {
        if (vector == null) {
            return -1;
        }
        if (dbValue == null) {
            return -1;
        }
        for (int i = 0; i < vector.size(); ++i) {
            DbValue dbValue2 = (DbValue)vector.elementAt(i);
            if (!ValueListItemUtil.equals(dbValue2, dbValue)) continue;
            return i;
        }
        return -1;
    }
}

