/*
 * Decompiled with CFR 0.152.
 */
package jet.parameter.util;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import jet.JResource;
import jet.connect.DbBigInt;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.exception.InvalidParameterException;
import jet.formula.DataType;
import jet.formula.DataTypeDef;
import jet.formula.ParamDesc;
import jet.log.JRLogger;

public class ValueParser {
    private static JRLogger D = JRLogger.getLogger(ValueParser.class.getName());
    private ParamDesc J;
    private String SEDU;

    public ValueParser(ParamDesc paramDesc) {
        this.J = paramDesc;
        this.SEDU = paramDesc.getFormat();
    }

    private Number D(String string, Locale locale) throws InvalidParameterException {
        Number number = null;
        ParsePosition parsePosition = new ParsePosition(0);
        if (this.SEDU != "") {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
            DecimalFormat decimalFormat = new DecimalFormat(this.SEDU, decimalFormatSymbols);
            decimalFormat.setParseBigDecimal(true);
            number = (Number)decimalFormat.parseObject(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                throw new InvalidParameterException(JResource.getMessage("FML_USERFORMAT", new Object[]{string, decimalFormat.toLocalizedPattern()}));
            }
        } else {
            DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(locale);
            DecimalFormat decimalFormat2 = (DecimalFormat)DecimalFormat.getCurrencyInstance(locale);
            decimalFormat.setParseBigDecimal(true);
            decimalFormat2.setParseBigDecimal(true);
            parsePosition = new ParsePosition(0);
            number = decimalFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                parsePosition = new ParsePosition(0);
                number = decimalFormat2.parse(string, parsePosition);
                if (parsePosition.getIndex() != string.length()) {
                    number = null;
                }
            }
            if (number == null) {
                throw new InvalidParameterException(JResource.getMessage("FML_VALIDFORMAT", new Object[]{string, decimalFormat.toLocalizedPattern(), decimalFormat2.toLocalizedPattern()}));
            }
        }
        return number;
    }

    private Number J(String string, Locale locale) throws InvalidParameterException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = null;
        if (this.SEDU != "") {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
            DecimalFormat decimalFormat = new DecimalFormat(this.SEDU, decimalFormatSymbols);
            number = (Number)decimalFormat.parseObject(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                throw new InvalidParameterException(JResource.getMessage("FML_USERFORMAT", new Object[]{string, decimalFormat.toLocalizedPattern()}));
            }
        } else {
            DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(locale);
            parsePosition = new ParsePosition(0);
            decimalFormat.setParseIntegerOnly(true);
            number = decimalFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
                String string2 = decimalFormatSymbols.getDigit() + "" + decimalFormatSymbols.getGroupingSeparator() + "" + decimalFormatSymbols.getDigit() + "" + decimalFormatSymbols.getDigit() + "" + decimalFormatSymbols.getDigit() + "";
                char[] cArray = new char[5];
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = decimalFormatSymbols.getDigit();
                }
                throw new InvalidParameterException(JResource.getMessage("FML_VALIDFORMAT", new String[]{string, string2, String.valueOf(cArray)}));
            }
        }
        return number;
    }

    private Number SEDU(String string, Locale locale) throws InvalidParameterException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = null;
        if (this.SEDU != "") {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
            DecimalFormat decimalFormat = new DecimalFormat(this.SEDU, decimalFormatSymbols);
            number = (Number)decimalFormat.parseObject(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                throw new InvalidParameterException(JResource.getMessage("FML_USERFORMAT", new Object[]{string, decimalFormat.toLocalizedPattern()}));
            }
        } else {
            parsePosition = new ParsePosition(0);
            DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(locale);
            number = decimalFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                throw new InvalidParameterException(JResource.getMessage("FML_VALIDFML", new Object[]{string, decimalFormat.toLocalizedPattern()}));
            }
        }
        return number;
    }

    public String[] parseBooleanFormat(String string) {
        String string2;
        String string3;
        int n = string.indexOf("/");
        if (n != -1) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = string;
            string2 = "false";
        }
        return new String[]{string3, string2};
    }

    private Boolean Z(String string, String[] stringArray, String[] stringArray2) {
        String string2;
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            string2 = stringArray[n];
            if (!string.equalsIgnoreCase(string2)) continue;
            return new Boolean(true);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            string2 = stringArray2[n];
            if (!string.equalsIgnoreCase(string2)) continue;
            return new Boolean(false);
        }
        return null;
    }

    private boolean append(String string, Locale locale) throws InvalidParameterException {
        String string2;
        String string3;
        String[] stringArray;
        boolean bl = true;
        if (this.SEDU != "") {
            stringArray = this.parseBooleanFormat(this.SEDU);
            string3 = stringArray[0];
            string2 = stringArray[1];
        } else {
            string3 = "true";
            string2 = "false";
        }
        stringArray = new String[]{string3, "1"};
        String[] stringArray2 = new String[]{string2, "0"};
        Boolean bl2 = this.Z(string, stringArray, stringArray2);
        if (bl2 == null) {
            if (this.SEDU == "") {
                throw new InvalidParameterException(JResource.getMessage("FML_VALIDFORMAT", new String[]{string, "true", "false"}));
            }
            throw new InvalidParameterException(JResource.getMessage("FML_USERFORMAT", new Object[]{string, "TRUE = \"" + string3 + "\" , FALSE = \"" + string2 + "\""}));
        }
        bl = bl2;
        return bl;
    }

    private void bNull(SimpleDateFormat[] simpleDateFormatArray) {
        for (int i = 0; i < simpleDateFormatArray.length; ++i) {
            simpleDateFormatArray[i] = null;
        }
    }

    private java.util.Date booleanValue(String string, int n, Locale locale, boolean bl) throws InvalidParameterException {
        Object object;
        java.util.Date date = null;
        if (bl && this.SEDU != "") {
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.SEDU, dateFormatSymbols);
            object = new ParsePosition(0);
            date = (java.util.Date)simpleDateFormat.parseObject(string, (ParsePosition)object);
            if (date != null && object.getIndex() != string.length()) {
                date = null;
            }
            if (date == null) {
                String string2 = JResource.getMessage("FML_USERFORMAT", new Object[]{string, simpleDateFormat.toLocalizedPattern()});
                D.fatal(string2, new InvalidParameterException(string2));
                throw new InvalidParameterException(string2);
            }
        } else {
            object = null;
            switch (n) {
                case 6: {
                    object = new SimpleDateFormat[]{(SimpleDateFormat)SimpleDateFormat.getDateInstance(3, locale), (SimpleDateFormat)SimpleDateFormat.getDateInstance(2, locale), (SimpleDateFormat)SimpleDateFormat.getDateInstance(1, locale), (SimpleDateFormat)SimpleDateFormat.getDateInstance(0, locale), new SimpleDateFormat("yyyy-MM-dd z", ParamDesc.defaultLocale)};
                    break;
                }
                case 7: {
                    object = new SimpleDateFormat[]{(SimpleDateFormat)SimpleDateFormat.getTimeInstance(3, locale), (SimpleDateFormat)SimpleDateFormat.getTimeInstance(2, locale), (SimpleDateFormat)SimpleDateFormat.getTimeInstance(1, locale), (SimpleDateFormat)SimpleDateFormat.getTimeInstance(0, locale)};
                    break;
                }
                case 8: {
                    object = new SimpleDateFormat[]{(SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 3, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 2, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 1, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 0, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 3, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 2, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 1, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 0, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 3, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 2, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 1, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 0, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 3, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 2, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 1, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 0, locale), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", ParamDesc.defaultLocale)};
                    if (bl) break;
                    object[16].setTimeZone(TimeZone.getTimeZone("GMT"));
                }
            }
            for (int i = 0; date == null && i < ((SimpleDateFormat[])object).length; ++i) {
                object[i].setLenient(false);
                DateFormatSymbols dateFormatSymbols = object[i].getDateFormatSymbols();
                dateFormatSymbols.setZoneStrings(new String[0][0]);
                object[i].setDateFormatSymbols(dateFormatSymbols);
                ParsePosition parsePosition = new ParsePosition(0);
                date = object[i].parse(string.trim(), parsePosition);
                if (date == null || parsePosition.getIndex() == string.length()) continue;
                date = null;
            }
            if (date == null) {
                String string3 = JResource.getMessage("FML_VALIDFML1", new String[]{string});
                string3 = "Parameter: " + this.J.name + "; locale: " + locale + "\n" + string3;
                for (int i = 0; i < ((SimpleDateFormat[])object).length; ++i) {
                    string3 = string3 + "\n    " + object[i].toLocalizedPattern();
                }
                this.bNull((SimpleDateFormat[])object);
                if (D.isFatalEnabled()) {
                    D.fatal(string3, new InvalidParameterException(string3));
                }
                throw new InvalidParameterException(string3);
            }
            this.bNull((SimpleDateFormat[])object);
        }
        object = null;
        if (D.isDebugEnabled()) {
            D.debug("Parse Date Time Parameter with Format\nValue: " + string + "\nDataType: " + n + "\nLocale: " + locale + "\nReturn: " + date);
        }
        return date;
    }

    public DbValue parseValue(String string, Locale locale, boolean bl) throws InvalidParameterException {
        int n = this.J.getInfo().getDataType();
        this.SEDU = this.J.getFormat();
        if (DataTypeDef.isArray(n)) {
            n -= 11;
        }
        if (n != 5) {
            string = string.trim();
        }
        DbValue dbValue = DataTypeDef.makeData(n);
        dbValue.setColDesc(DataType.toDbColDesc(n, -1, -1));
        if (string.equalsIgnoreCase("") && (n != 5 || n == 5 && this.J.isStringNull)) {
            dbValue.bNull = true;
            return dbValue;
        }
        switch (n) {
            case 3: {
                ((DbDecimal)dbValue).value = (BigDecimal)this.D(string, locale);
                break;
            }
            case 1: {
                ((DbBigInt)dbValue).value = this.J(string, locale).longValue();
                break;
            }
            case 2: {
                ((DbDouble)dbValue).value = this.SEDU(string, locale).doubleValue();
                break;
            }
            case 5: {
                ((DbChar)dbValue).value = string;
                if (!this.J.type.equalsIgnoreCase("Parameters")) break;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n2 = stringTokenizer.countTokens();
                for (int i = 0; i < n2; ++i) {
                    String string2 = stringTokenizer.nextToken().trim();
                    if (string2.startsWith("@")) continue;
                    throw new InvalidParameterException("Invalid parameter value: " + string + ". Parameter name must start with'@' and separate by ','.");
                }
                break;
            }
            case 4: {
                ((DbBit)dbValue).value = this.append(string, locale);
                break;
            }
            case 6: {
                java.util.Date date = null;
                if (!bl) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd z");
                        DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
                        dateFormatSymbols.setZoneStrings(new String[0][0]);
                        simpleDateFormat.setDateFormatSymbols(dateFormatSymbols);
                        date = simpleDateFormat.parse(string);
                    }
                    catch (Exception exception) {
                        date = null;
                    }
                    if (date == null) {
                        try {
                            date = Date.valueOf(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            date = null;
                        }
                    }
                }
                if (date == null) {
                    date = this.booleanValue(string, n, locale, bl);
                }
                ((DbDate)dbValue).value = date.getTime();
                break;
            }
            case 7: {
                Time time2 = null;
                if (!bl) {
                    try {
                        time2 = Time.valueOf(string);
                    }
                    catch (Exception exception) {
                        if (D.isDebugEnabled()) {
                            D.debug("Parse Time Parameter\n" + string + "\n" + exception.getMessage());
                        }
                        time2 = null;
                    }
                }
                if (time2 == null) {
                    time2 = new Time(this.booleanValue(string, n, locale, bl).getTime());
                }
                ((DbTime)dbValue).value = time2.getTime();
                break;
            }
            case 8: {
                Timestamp timestamp = null;
                if (!bl) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                        timestamp = new Timestamp(simpleDateFormat.parse(string).getTime());
                    }
                    catch (Exception exception) {
                        if (D.isDebugEnabled()) {
                            D.debug("Parse Time Parameter\n" + string + "\n" + exception.getMessage());
                        }
                        timestamp = null;
                    }
                }
                if (timestamp == null) {
                    timestamp = new Timestamp(this.booleanValue(string, n, locale, bl).getTime());
                }
                ((DbTimestamp)dbValue).set(timestamp);
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid parameter type " + this.J.type + "!");
            }
        }
        dbValue.bNull = false;
        return dbValue;
    }

    public static String[] splitValue(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "@");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.endsWith(",")) {
                string2 = string2.substring(0, string2.length() - ",".length());
            }
            stringArray[i] = string2;
        }
        return stringArray;
    }
}

