/*
 * Decompiled with CFR 0.152.
 */
package jet.rcdsecurity;

import com.jinfonet.interfaces.query.RecordSecurity;
import com.jinfonet.interfaces.query.RoleInfo;
import com.jinfonet.interfaces.query.SecurityFilterInfo;
import com.jinfonet.interfaces.query.UserInfo;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.JResource;
import jet.controls.JetObject;
import jet.rcdsecurity.JetRoleInfo;
import jet.rcdsecurity.JetSecuContainer;
import jet.rcdsecurity.JetUserInfo;

public class JetRecordSecurity
extends JetSecuContainer
implements RecordSecurity {
    Hashtable userInfos = new Hashtable(6);
    Hashtable roleInfos = new Hashtable(6);

    @Override
    public UserInfo addUserSecu(String string, SecurityFilterInfo securityFilterInfo) {
        JetUserInfo jetUserInfo = (JetUserInfo)this.userInfos.get(string);
        if (jetUserInfo != null) {
            jetUserInfo.addSecuFilterInfo(securityFilterInfo);
        } else {
            jetUserInfo = new JetUserInfo(string, securityFilterInfo);
            this.userInfos.put(string, jetUserInfo);
            this.add(jetUserInfo);
        }
        return jetUserInfo;
    }

    @Override
    public RoleInfo addRoleSecu(String string, SecurityFilterInfo securityFilterInfo) {
        JetRoleInfo jetRoleInfo = (JetRoleInfo)this.roleInfos.get(string);
        if (jetRoleInfo != null) {
            jetRoleInfo.addSecuFilterInfo(securityFilterInfo);
        } else {
            jetRoleInfo = new JetRoleInfo(string, securityFilterInfo);
            this.roleInfos.put(string, jetRoleInfo);
            this.add(jetRoleInfo);
        }
        return jetRoleInfo;
    }

    @Override
    public UserInfo addUser(String string) {
        JetUserInfo jetUserInfo = (JetUserInfo)this.userInfos.get(string);
        if (jetUserInfo == null) {
            jetUserInfo = new JetUserInfo(string);
            this.userInfos.put(string, jetUserInfo);
            this.add(jetUserInfo);
        }
        return jetUserInfo;
    }

    public RoleInfo addRole(String string) {
        JetRoleInfo jetRoleInfo = (JetRoleInfo)this.roleInfos.get(string);
        if (jetRoleInfo == null) {
            jetRoleInfo = new JetRoleInfo(string);
            this.roleInfos.put(string, jetRoleInfo);
            this.add(jetRoleInfo);
        }
        return jetRoleInfo;
    }

    public RoleInfo addRole(String string, SecurityFilterInfo securityFilterInfo) {
        JetRoleInfo jetRoleInfo = (JetRoleInfo)this.roleInfos.get(string);
        if (jetRoleInfo == null) {
            jetRoleInfo = securityFilterInfo == null ? new JetRoleInfo(string) : new JetRoleInfo(string, securityFilterInfo);
            this.roleInfos.put(string, jetRoleInfo);
            this.add(jetRoleInfo);
        } else if (securityFilterInfo != null) {
            jetRoleInfo.addSecuFilterInfo(securityFilterInfo);
        }
        return jetRoleInfo;
    }

    public RoleInfo addRole(String string, String string2, SecurityFilterInfo securityFilterInfo) {
        JetRoleInfo jetRoleInfo = (JetRoleInfo)this.roleInfos.get(string);
        if (jetRoleInfo == null) {
            jetRoleInfo = securityFilterInfo == null ? new JetRoleInfo(string, string2) : new JetRoleInfo(string, string2, securityFilterInfo);
            this.roleInfos.put(string, jetRoleInfo);
            this.add(jetRoleInfo);
        } else {
            jetRoleInfo.addUser(string2);
            if (securityFilterInfo != null) {
                jetRoleInfo.addSecuFilterInfo(securityFilterInfo);
            }
        }
        this.addUserRole(string2, string);
        return jetRoleInfo;
    }

    @Override
    public UserInfo addUserRole(String string, String string2) {
        JetUserInfo jetUserInfo = (JetUserInfo)this.userInfos.get(string);
        if (jetUserInfo == null) {
            jetUserInfo = new JetUserInfo(string);
            jetUserInfo.addRole(string2);
            this.userInfos.put(string, jetUserInfo);
            this.add(jetUserInfo);
        } else {
            jetUserInfo.addRole(string2);
        }
        JetRoleInfo jetRoleInfo = (JetRoleInfo)this.roleInfos.get(string2);
        if (jetRoleInfo == null) {
            jetRoleInfo = new JetRoleInfo(string2);
            jetRoleInfo.addUser(string);
            this.roleInfos.put(string2, jetRoleInfo);
            this.add(jetRoleInfo);
        } else {
            jetRoleInfo.addUser(string);
        }
        return jetUserInfo;
    }

    @Override
    public Vector getSecuByUser(String string) {
        UserInfo userInfo = (UserInfo)this.userInfos.get(string);
        Vector vector = new Vector();
        if (userInfo != null) {
            vector = userInfo.getSecuFilterInfos();
            Vector vector2 = userInfo.getRoles();
            if (vector2.contains(JetUserInfo.ADMINROLE)) {
                vector.clear();
            } else {
                for (int i = 0; i < vector2.size(); ++i) {
                    Vector vector3 = this.getSecuByRole((String)vector2.elementAt(i));
                    if (vector3.size() <= 0) {
                        vector.clear();
                        break;
                    }
                    vector = JetRecordSecurity.merge(vector, vector3);
                }
            }
        }
        return vector;
    }

    static Vector merge(Vector vector, Vector vector2) {
        Vector vector3;
        Vector vector4;
        if (vector.size() >= vector2.size()) {
            vector4 = (Vector)vector.clone();
            vector3 = (Vector)vector2.clone();
        } else {
            vector4 = (Vector)vector2.clone();
            vector3 = (Vector)vector.clone();
        }
        for (int i = 0; i < vector3.size(); ++i) {
            Object e = vector3.elementAt(i);
            if (vector4.contains(e)) continue;
            vector4.add(e);
        }
        return vector4;
    }

    @Override
    public Vector getSecuByRole(String string) {
        RoleInfo roleInfo = (RoleInfo)this.roleInfos.get(string);
        return roleInfo != null ? roleInfo.getSecuFilterInfos() : new Vector(1);
    }

    @Override
    public UserInfo getUserInfo(String string) {
        return (UserInfo)this.userInfos.get(string);
    }

    @Override
    public RoleInfo getRoleInfo(String string) {
        return (RoleInfo)this.roleInfos.get(string);
    }

    @Override
    public boolean isAdmin(String string) {
        boolean bl = this.isSpecifyUser(string) && this.getSecuByUser(string).size() == 0;
        return bl;
    }

    public boolean isSpecifyUser(String string) {
        return this.userInfos.get(string) != null;
    }

    @Override
    public Vector getAdmin() {
        Vector<String> vector = new Vector<String>(6);
        Enumeration enumeration = this.userInfos.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.isAdmin(string)) continue;
            vector.addElement(string);
        }
        return vector;
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.secuFilterInfos.size(); ++i) {
            string = string + "\n" + i + " " + this.secuFilterInfos.elementAt(i);
        }
        return string;
    }

    @Override
    public String getInstancePrefix() {
        return "RecordSecurityInfo";
    }

    @Override
    public String getPrefix() {
        return JResource.getMessage("RecordSecurity");
    }

    @Override
    public void afterInit() {
        super.afterInit();
        Vector vector = this.getChildren();
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < vector.size(); ++i) {
            JetSecuContainer jetSecuContainer;
            Object e = vector.elementAt(i);
            if (e instanceof JetRoleInfo) {
                jetSecuContainer = (JetRoleInfo)e;
                this.roleInfos.put(((JetRoleInfo)jetSecuContainer).getRole(), jetSecuContainer);
                continue;
            }
            if (!(e instanceof JetUserInfo)) continue;
            jetSecuContainer = (JetUserInfo)e;
            this.userInfos.put(((JetUserInfo)jetSecuContainer).getUser(), jetSecuContainer);
        }
    }

    @Override
    public JetObject remove(JetObject jetObject) {
        if (jetObject instanceof JetUserInfo) {
            JetUserInfo jetUserInfo = (JetUserInfo)jetObject;
            this.userInfos.remove(jetUserInfo.getUser());
        } else if (jetObject instanceof JetRoleInfo) {
            JetRoleInfo jetRoleInfo = (JetRoleInfo)jetObject;
            this.roleInfos.remove(jetRoleInfo.getRole());
        }
        return super.remove(jetObject);
    }

    public boolean isEmpty() {
        return !(this.userInfos != null && this.userInfos.size() != 0 || this.roleInfos != null && this.roleInfos.size() != 0);
    }

    public Vector getUserInfosByRole(String string) {
        Vector<UserInfo> vector = new Vector<UserInfo>();
        Enumeration enumeration = this.userInfos.elements();
        while (enumeration.hasMoreElements()) {
            UserInfo userInfo = (UserInfo)enumeration.nextElement();
            if (!((JetUserInfo)userInfo).isRole(string)) continue;
            vector.add(userInfo);
        }
        return vector;
    }
}

